/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.logging;

import com.webobjects.foundation._NSUtilities;
import org.apache.log4j.Level;
import org.slf4j.Logger;

public class Slf4JUtils {
    public static org.slf4j.event.Level toLevel(String level) {
        try {
            return org.slf4j.event.Level.valueOf((String)level.toUpperCase());
        }
        catch (Exception exception) {
            return null;
        }
    }

    public static org.slf4j.event.Level levelForLogger(Logger logger) {
        if (logger == null) {
            return null;
        }
        if (logger.isTraceEnabled()) {
            return org.slf4j.event.Level.TRACE;
        }
        if (logger.isDebugEnabled()) {
            return org.slf4j.event.Level.DEBUG;
        }
        if (logger.isInfoEnabled()) {
            return org.slf4j.event.Level.INFO;
        }
        if (logger.isWarnEnabled()) {
            return org.slf4j.event.Level.WARN;
        }
        if (logger.isErrorEnabled()) {
            return org.slf4j.event.Level.ERROR;
        }
        return null;
    }

    public static boolean isEnabled(org.slf4j.event.Level level, Logger logger) {
        switch (level) {
            case DEBUG: {
                return logger.isDebugEnabled();
            }
            case ERROR: {
                return logger.isErrorEnabled();
            }
            case INFO: {
                return logger.isInfoEnabled();
            }
            case TRACE: {
                return logger.isTraceEnabled();
            }
            case WARN: {
                return logger.isWarnEnabled();
            }
        }
        return false;
    }

    public static void log(org.slf4j.event.Level level, Logger logger, String message, Object ... args) {
        switch (level) {
            case DEBUG: {
                logger.debug(message, args);
                break;
            }
            case ERROR: {
                logger.error(message, args);
                break;
            }
            case INFO: {
                logger.info(message, args);
                break;
            }
            case TRACE: {
                logger.trace(message, args);
                break;
            }
            case WARN: {
                logger.warn(message, args);
            }
        }
    }

    public static void setLevelForLogger(org.slf4j.event.Level newLevel, Logger logger) {
        if (Log4JHelper.canSetLevel()) {
            Log4JHelper.setLevelForLogger(newLevel.name(), logger);
        }
    }

    public static boolean canSetLevel() {
        return Log4JHelper.canSetLevel();
    }

    private static class Log4JHelper {
        private Log4JHelper() {
        }

        public static boolean canSetLevel() {
            return _NSUtilities.classWithName("org.apache.log4j.Logger") != null;
        }

        public static void setLevelForLogger(String newLevel, Logger logger) {
            org.apache.log4j.Logger log4j = org.apache.log4j.Logger.getLogger((String)logger.getName());
            log4j.setLevel(Level.toLevel((String)newLevel));
        }
    }
}

