/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.logging;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import org.slf4j.Logger;
import org.slf4j.event.Level;

public class Slf4JOutputStreamLogger
extends OutputStream {
    private static final int BUFFER_LENGTH = 2048;
    private boolean _didClose = false;
    private ByteBuffer _buffer;
    private Logger _logger;
    private Level _level;

    public Slf4JOutputStreamLogger(Logger log, Level level) {
        if (log == null) {
            throw new IllegalArgumentException("log cannot be null");
        }
        if (level == null) {
            throw new IllegalArgumentException("level cannot be null");
        }
        this._level = level;
        this._logger = log;
        this._buffer = ByteBuffer.allocate(2048);
    }

    @Override
    public void close() {
        this.flush();
        this._didClose = true;
    }

    @Override
    public synchronized void write(int b) throws IOException {
        if (this._didClose) {
            throw new IOException("The stream has already been closed.");
        }
        if (this._buffer.remaining() == 0) {
            int newLength = this._buffer.capacity() + 2048;
            ByteBuffer newBuffer = ByteBuffer.allocate(newLength);
            this._buffer.flip();
            newBuffer.put(this._buffer);
            this._buffer = newBuffer;
        }
        this._buffer.put((byte)b);
    }

    @Override
    public synchronized void flush() {
        this._buffer.flip();
        while (this._buffer.remaining() > 0 && (this._buffer.get(this._buffer.position()) == 13 || this._buffer.get(this._buffer.position()) == 10)) {
            this._buffer.get();
        }
        if (this._buffer.remaining() == 0) {
            return;
        }
        byte[] bytes = new byte[this._buffer.remaining()];
        this._buffer.get(bytes);
        this._buffer.clear();
        String message = new String(bytes).replaceFirst("\n$", "");
        switch (this._level) {
            case DEBUG: {
                this._logger.debug(message);
                break;
            }
            case ERROR: {
                this._logger.error(message);
                break;
            }
            case WARN: {
                this._logger.warn(message);
                break;
            }
            case INFO: {
                this._logger.info(message);
                break;
            }
            case TRACE: {
                this._logger.trace(message);
            }
        }
    }
}

