/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.development.NSProjectBundle;
import com.webobjects.foundation.development.NSProjectLayout;
import com.webobjects.foundation.development.NSResourceType;
import java.io.File;
import java.net.MalformedURLException;
import java.util.LinkedList;
import java.util.List;

public class NSUserDefinedProjectLayout
extends NSProjectLayout {
    private NSDictionary<String, Object> _projectLayoutMappings;

    public NSUserDefinedProjectLayout(File projectFolder, File projectLayoutFile) throws MalformedURLException {
        super(projectFolder);
        NSDictionary resourceTypes;
        this._projectLayoutMappings = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL(projectLayoutFile.toURI().toURL());
        if (this._projectLayoutMappings != null && (resourceTypes = (NSDictionary)this._projectLayoutMappings.objectForKey("ResourceTypes")) != null) {
            for (String extension : resourceTypes.allKeys()) {
                String resourceType = (String)resourceTypes.objectForKey(extension);
                NSProjectBundle.registerResourceTypeForExtension(new NSResourceType(resourceType), extension);
            }
        }
    }

    @Override
    public List<String> relativePathForResourceType(NSResourceType type) {
        List<String> relativePaths = null;
        Object relativePathsObj = this._projectLayoutMappings.objectForKey(type.name());
        if (relativePathsObj instanceof String) {
            relativePaths = new LinkedList<String>();
            relativePaths.add((String)relativePathsObj);
        } else {
            relativePaths = relativePathsObj instanceof List ? (List)relativePathsObj : new LinkedList();
        }
        return relativePaths;
    }
}

