/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation._NSMultiKey;
import com.webobjects.foundation.development.NSBundleFactory;
import com.webobjects.foundation.development.NSLegacyBundle;
import com.webobjects.foundation.development.NSProjectAnalyzer;
import com.webobjects.foundation.development.NSProjectBundle;
import com.webobjects.foundation.development.NSProjectLayout;
import com.webobjects.foundation.properties.NSArrayProperty;
import java.io.File;
import java.util.Iterator;
import java.util.concurrent.ConcurrentHashMap;

public class NSProjectBundleFactory
extends NSBundleFactory {
    private static final NSArrayProperty<String> projectSearchPaths = new NSArrayProperty("NSProjectSearchPath", NSArray.emptyArray());
    public static Boolean _explicitlyEnabled = null;
    private ConcurrentHashMap<_NSMultiKey, _BundlePathResult> _pathResults = new ConcurrentHashMap();

    public static void setEnabled(boolean enabled) {
        _explicitlyEnabled = enabled;
    }

    public static boolean isEnabled() {
        boolean projectBundleEnabled = false;
        Boolean projectBundleExplicitlyEnabled = NSValueUtilities.BooleanValueWithDefault(System.getProperty("NSProjectBundleEnabled"), null);
        projectBundleEnabled = projectBundleExplicitlyEnabled == null ? (_explicitlyEnabled != null ? _explicitlyEnabled : false) : projectBundleExplicitlyEnabled;
        return projectBundleEnabled;
    }

    @Override
    public void bundlesDidLoad() {
        this._pathResults.clear();
    }

    @Override
    public NSBundle bundleForPath(String path, boolean shouldCreateBundle, boolean newIsJar) {
        NSBundle bundle;
        block9: {
            String bundleName;
            Object _projectSearchPaths;
            block13: {
                block12: {
                    block11: {
                        NSBundle existingBundle;
                        String normalizedPath;
                        block10: {
                            bundle = this._bundleForPath(path, shouldCreateBundle, newIsJar);
                            if (bundle != null) break block9;
                            normalizedPath = NSBundle._normalizeExistingBundlePath(path);
                            existingBundle = NSBundle._lookupBundleWithPath(normalizedPath);
                            if (existingBundle == null) break block10;
                            bundle = existingBundle;
                            break block9;
                        }
                        existingBundle = NSBundle._lookupBundleWithPath(NSBundle._cleanNormalizedBundlePath(normalizedPath));
                        if (existingBundle == null) break block11;
                        bundle = existingBundle;
                        break block9;
                    }
                    _projectSearchPaths = projectSearchPaths.value();
                    if (((NSArray)_projectSearchPaths).count() <= 0) break block9;
                    String projectBuildPath = NSProperties.stringForKey("NSProjectBuildPath");
                    bundleName = null;
                    if (projectBuildPath == null) break block12;
                    String normalizedBuildPath = NSPathUtilities.stringByNormalizingPath(projectBuildPath);
                    String normalizedBundlePath = NSPathUtilities.stringByNormalizingPath(path);
                    if (!normalizedBundlePath.startsWith(normalizedBuildPath)) break block13;
                    NSArray<String> buildPathComponents = NSArray.componentsSeparatedByString(normalizedBuildPath, File.separator);
                    NSArray<String> bundlePathComponents = NSArray.componentsSeparatedByString(normalizedBundlePath, File.separator);
                    if (bundlePathComponents.count() > buildPathComponents.count()) {
                        bundleName = bundlePathComponents.objectAtIndex(buildPathComponents.count());
                    }
                    break block13;
                }
                NSArray<String> pathComponents = NSArray.componentsSeparatedByString(path, File.separator);
                for (String pathComponent : pathComponents) {
                    if (!pathComponent.endsWith(".framework") && !pathComponent.endsWith(".woa")) continue;
                    bundleName = pathComponent.substring(0, pathComponent.lastIndexOf(46));
                    break;
                }
            }
            if (bundleName != null) {
                Iterator iterator = ((NSArray)_projectSearchPaths).iterator();
                while (iterator.hasNext()) {
                    String projectSearchPath = (String)iterator.next();
                    File projectPath = new File(projectSearchPath, bundleName);
                    if (!projectPath.exists()) continue;
                    bundle = this._bundleForPath(projectPath.getAbsolutePath(), shouldCreateBundle, newIsJar);
                    break;
                }
            }
        }
        if (bundle != null) {
            NSBundle existingBundle = NSBundle._bundleOrAppForName(bundle.name());
            if (existingBundle != null) {
                bundle = existingBundle;
            } else if (!shouldCreateBundle) {
                bundle = null;
            }
        }
        if (bundle instanceof NSProjectBundle) {
            ((NSProjectBundle)bundle)._bundleLoadedFromPath(path);
        }
        return bundle;
    }

    protected NSBundle _bundleForPath(String path, boolean shouldCreateBundle, boolean newIsJar) {
        _NSMultiKey bundleKey = new _NSMultiKey(path, shouldCreateBundle, newIsJar);
        _BundlePathResult pathResult = this._pathResults.get(bundleKey);
        if (pathResult != null) {
            return pathResult.bundle();
        }
        NSBundle bundle = null;
        NSBundle legacyBundle = null;
        if (newIsJar) {
            bundle = NSLegacyBundle.Factory._jarBundleWithPath(path);
        } else {
            String frameworkPath;
            String frameworkSuffix = ".framework";
            int fwIndex = path.lastIndexOf(frameworkSuffix);
            if (fwIndex > -1 && path.indexOf("WebServerResources") == -1 && path.indexOf(".woa") == -1 && NSLegacyBundle.Factory._pathLooksLikeALegacyBundle(frameworkPath = path.substring(0, fwIndex + frameworkSuffix.length()))) {
                Object _projectSearchPaths = projectSearchPaths.value();
                int i = 0;
                while (i < ((NSArray)_projectSearchPaths).count() && legacyBundle == null) {
                    if (path.startsWith((String)((NSArray)_projectSearchPaths).objectAtIndex(i))) {
                        legacyBundle = NSLegacyBundle.Factory._bundleWithPathShouldCreateIsJar(path, shouldCreateBundle, newIsJar);
                    }
                    ++i;
                }
            }
        }
        if (bundle == null) {
            File projectFolder = new File(path);
            while (bundle == null && projectFolder != null) {
                boolean projectRoot;
                String projectFolderPath = projectFolder.getPath();
                _NSMultiKey projectBundleKey = new _NSMultiKey(projectFolderPath);
                pathResult = this._pathResults.get(projectBundleKey);
                if (pathResult != null) {
                    bundle = pathResult.bundle();
                    projectRoot = pathResult.isProjectRoot();
                } else {
                    NSProjectLayout projectLayout;
                    NSProjectAnalyzer projectAnalyzer = NSProjectAnalyzer.Factory.projectAnalyzerForFolder(projectFolder);
                    Boolean isBundle = projectAnalyzer.isBundle();
                    if (isBundle != null && isBundle.booleanValue() && (projectLayout = projectAnalyzer.projectLayout()) != null) {
                        bundle = legacyBundle != null ? legacyBundle : new NSProjectBundle(projectFolderPath, projectLayout, projectAnalyzer);
                    }
                    projectRoot = projectAnalyzer.isProjectRoot();
                    this._pathResults.put(projectBundleKey, new _BundlePathResult(bundle, projectRoot));
                }
                if (projectRoot) break;
                projectFolder = projectFolder.getParentFile();
            }
        }
        this._pathResults.put(bundleKey, new _BundlePathResult(bundle, true));
        return bundle;
    }

    private static class _BundlePathResult {
        private NSBundle _bundle;
        private boolean _projectRoot;

        public _BundlePathResult(NSBundle bundle, boolean projectRoot) {
            this._bundle = bundle;
            this._projectRoot = projectRoot;
        }

        public NSBundle bundle() {
            return this._bundle;
        }

        public boolean isProjectRoot() {
            return this._projectRoot;
        }
    }
}

