/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.development.NSProjectAnalyzer;
import com.webobjects.foundation.development.NSProjectLayout;
import com.webobjects.foundation.development.NSResourceType;
import com.webobjects.foundation.properties.NSBundleSourceErrorDelegate;
import com.webobjects.foundation.properties.NSBundleSourceFactory;
import com.webobjects.foundation.properties.NSPropertyFileSource;
import java.io.File;
import java.io.FilenameFilter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.jar.JarFile;

public class NSProjectBundle
extends NSBundle {
    protected static final String NONLOCALIZED_LOCALE = "Nonlocalized.lproj";
    protected static final String NONLOCALIZED_LOCALE_PREFIX = "Nonlocalized.lproj" + File.separator;
    private static ConcurrentHashMap<String, NSResourceType> _resourceTypeExtensions = new ConcurrentHashMap();
    private String _projectPath;
    private String _bundleURLPrefix;
    private LinkedHashSet<String> _classpathPaths;
    private NSArray<String> _packageNames;
    private NSArray<String> _classNames;
    private NSProjectLayout _projectLayout;
    private NSProjectAnalyzer _projectAnalyzer;
    private NSDictionary<String, Object> _infoDictionary;

    static {
        _resourceTypeExtensions.put("wo", NSResourceType.Component);
        _resourceTypeExtensions.put("eomodeld", NSResourceType.Model);
        _resourceTypeExtensions.put("d2wmodel", NSResourceType.D2WModel);
        _resourceTypeExtensions.put("gif", NSResourceType.WebServer);
        _resourceTypeExtensions.put("png", NSResourceType.WebServer);
        _resourceTypeExtensions.put("jpg", NSResourceType.WebServer);
        _resourceTypeExtensions.put("jpeg", NSResourceType.WebServer);
        _resourceTypeExtensions.put("tiff", NSResourceType.WebServer);
        _resourceTypeExtensions.put("js", NSResourceType.WebServer);
        _resourceTypeExtensions.put("css", NSResourceType.WebServer);
    }

    public static void registerResourceTypeForExtension(NSResourceType resourceType, String extension) {
        _resourceTypeExtensions.put(extension, resourceType);
    }

    public NSProjectBundle(String projectPath, NSProjectLayout projectLayout, NSProjectAnalyzer projectAnalyzer) {
        this._projectPath = projectPath;
        this._bundleURLPrefix = _NSStringUtilities.concat(NSPathUtilities._fileURLPrefix, this._projectPath, "/");
        this._classpathPaths = new LinkedHashSet();
        this._projectLayout = projectLayout;
        this._projectAnalyzer = projectAnalyzer;
    }

    public void _bundleLoadedFromPath(String path) {
        if (this.projectPath().equals(path)) {
            if (this._classpathPaths.size() == 0) {
                path = String.valueOf(path) + File.separator + "target" + File.separator;
                this._classpathPaths.add(String.valueOf(path) + "classes");
                this._classpathPaths.add(String.valueOf(path) + "test-classes");
            }
        } else {
            this._classpathPaths.add(path);
        }
    }

    @Override
    public void _bundlesDidLoad() {
        this.ensureClassAndPackageNamesLoaded();
    }

    public String projectPath() {
        return this._projectPath;
    }

    @Override
    public String bundlePath() {
        return this._projectPath;
    }

    @Override
    public URL bundlePathURL() {
        try {
            return new File(this._projectPath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    @Override
    public String _bundleURLPrefix() {
        return this._bundleURLPrefix;
    }

    protected void fillInClassNames(Set<String> packageNames, Set<String> classNames, File folder, NSMutableArray<String> packageNameArray) {
        File[] files = folder.listFiles();
        if (files != null) {
            String packageName = null;
            File[] fileArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                String name = file.getName();
                if (file.isDirectory()) {
                    if (!name.equals("CVS") && !name.equals(".svn")) {
                        packageNameArray.addObject(name);
                        try {
                            this.fillInClassNames(packageNames, classNames, file, packageNameArray);
                        }
                        finally {
                            packageNameArray.removeLastObject();
                        }
                    }
                } else if (name.endsWith(".class")) {
                    if (packageName == null) {
                        packageName = packageNameArray.componentsJoinedByString(".");
                        packageNames.add(packageName);
                    }
                    String simpleName = name.substring(0, name.length() - ".class".length());
                    String className = packageName.length() != 0 ? String.valueOf(packageName) + "." + simpleName : simpleName;
                    classNames.add(className);
                    NSBundle._registerClassNameForBundle(className, this);
                }
                ++n2;
            }
        }
    }

    protected void fillInClassNamesFromJar(Set<String> packageNames, Set<String> classNames, File jarFile) {
        NSArray<String> jarClassNames = _NSUtilities.classNamesFromArchive(jarFile);
        for (String className : jarClassNames) {
            int lastDotIndex = className.lastIndexOf(46);
            if (lastDotIndex != -1) {
                String packageName = className.substring(0, lastDotIndex);
                packageNames.add(packageName);
            }
            classNames.add(className);
            NSBundle._registerClassNameForBundle(className, this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void _fillInClassAndPackageNames() {
        HashSet<String> packageNames = new HashSet<String>();
        HashSet<String> classNames = new HashSet<String>();
        for (String classpathPath : this._classpathPaths) {
            File classpathFile = new File(classpathPath);
            if (classpathFile.isDirectory()) {
                NSMutableArray<String> packageName = new NSMutableArray<String>();
                this.fillInClassNames(packageNames, classNames, classpathFile, packageName);
                continue;
            }
            this.fillInClassNamesFromJar(packageNames, classNames, classpathFile);
        }
        NSProjectBundle nSProjectBundle = this;
        synchronized (nSProjectBundle) {
            this._packageNames = new NSArray(packageNames);
            this._classNames = new NSArray(classNames);
        }
    }

    protected void ensureClassAndPackageNamesLoaded() {
        if (this._packageNames == null || this._classNames == null) {
            this._fillInClassAndPackageNames();
        }
    }

    @Override
    public synchronized NSArray<String> bundleClassPackageNames() {
        this.ensureClassAndPackageNamesLoaded();
        return this._packageNames;
    }

    @Override
    public synchronized NSArray<String> bundleClassNames() {
        this.ensureClassAndPackageNamesLoaded();
        return this._classNames;
    }

    @Override
    public URL _pathURLForResourcePath(String aResourcePath, boolean returnDirectories) {
        URL url = null;
        if (aResourcePath != null && aResourcePath.length() > 0) {
            String realPath;
            boolean isLocalized = true;
            if (aResourcePath.startsWith(NONLOCALIZED_LOCALE)) {
                isLocalized = false;
            }
            if (!(realPath = isLocalized ? aResourcePath : aResourcePath.substring(NONLOCALIZED_LOCALE.length())).startsWith(File.separator)) {
                realPath = File.separator.concat(realPath);
            }
            for (String resourcePath : this._projectLayout.relativePathForResourceType(this.resourceTypeForResourceNamed(aResourcePath))) {
                try {
                    File f = new File(String.valueOf(this._projectPath) + File.separator + resourcePath + realPath);
                    if (!f.exists() || !f.isFile() && !returnDirectories) continue;
                    url = NSPathUtilities._URLWithPath(f.getCanonicalPath());
                    break;
                }
                catch (Exception exception) {
                    throw NSForwardException._runtimeExceptionForThrowable(exception);
                }
            }
        }
        return url;
    }

    @Override
    public boolean isFramework() {
        return "FMWK".equals(this.infoDictionary().objectForKey("CFBundlePackageType"));
    }

    @Override
    public boolean _isCFBundle() {
        return false;
    }

    @Override
    public boolean isJar() {
        return false;
    }

    @Override
    public JarFile _jarFile() {
        return null;
    }

    @Override
    public NSDictionary<String, ? extends NSDictionary<String, ?>> _jarFileLayout() {
        return null;
    }

    @Override
    public boolean load() {
        return false;
    }

    @Override
    public String name() {
        return (String)this.infoDictionary().objectForKey("NSExecutable");
    }

    @Override
    public String pathForResource(String aName, String anExtension, String aSubDirPath) {
        throw new RuntimeException("NSProjectBundle.pathForResource: " + aName + ":" + anExtension + ":" + aSubDirPath);
    }

    @Override
    public NSArray<String> pathsForResources(String anExtension, String aSubDirPath) {
        throw new RuntimeException("NSProjectBundle.pathsForResources: " + anExtension + ":" + aSubDirPath);
    }

    @Override
    public void registerProperties() {
        URL url = this._pathURLForResourcePath(this.resourcePathForLocalizedResourceNamed("Properties", null), false);
        String username = NSProperties.stringForKey("user.name");
        if (username != null && username.length() > 0) {
            URL userUrl = this._pathURLForResourcePath(this.resourcePathForLocalizedResourceNamed("Properties." + username, null), false);
            this.registerPropertiesWithURL(userUrl);
        }
        this.registerPropertiesWithURL(url);
    }

    @Override
    @Deprecated
    public Properties properties() {
        URL url = this._pathURLForResourcePath(this.resourcePathForLocalizedResourceNamed("Properties", null), false);
        if (url != null) {
            return NSPropertyFileSource.propertiesFromFile(new File(url.getFile()), false, new NSBundleSourceErrorDelegate(NSValueUtilities.booleanValue(System.getProperty("NSValidateProperties", "true"))));
        }
        return new Properties();
    }

    protected void registerPropertiesWithURL(URL url) {
        if (url != null) {
            if (NSBundle.mainBundle().equals(this)) {
                NSBundleSourceFactory.registerMainBundleURL(url, false);
            } else {
                NSBundleSourceFactory.registerURL(url, false);
            }
        }
    }

    @Override
    public String resourcePath() {
        return this.bundlePath();
    }

    @Override
    public String resourcePathForLocalizedResourceNamed(String aName, String aSubDirPath) {
        return this.resourcePathForLocalizedResourceNamed(aName, aSubDirPath, this._projectLayout.relativePathForResourceType(this.resourceTypeForResourceNamed(aName)));
    }

    @Override
    public NSArray<String> resourcePathsForDirectories(String extension, String aSubDirPath) {
        NSArray<String> list = null;
        FilenameFilter rdf = extension == null ? TheDirectoryFilter : NSProjectBundle.ResourceDirectoryFilterForExtension(extension);
        NSMutableArray<String> masterList = new NSMutableArray<String>();
        for (String relativeResourcePath : this._projectLayout.relativePathForResourceType(this.resourceTypeForResourceWithExtension(extension))) {
            String resourcePath = _NSStringUtilities.concat(this._projectPath, File.separator, relativeResourcePath);
            if (aSubDirPath == null) {
                NSMutableArray<String> allPaths = new NSMutableArray<String>(this.resourcePathsForDirectoriesInDirectory(resourcePath, resourcePath, rdf, false));
                NSArray<String> lProjDirs = this.resourcePathsForDirectoriesInDirectory(resourcePath, resourcePath, NSProjectBundle.ResourceDirectoryFilterForExtension(".lproj"), false);
                int count = lProjDirs.count();
                int i = 0;
                while (i < count) {
                    String lProjDir = lProjDirs.objectAtIndex(i);
                    allPaths.addObjectsFromArray(this.resourcePathsForDirectoriesInDirectory(_NSStringUtilities.concat(resourcePath, File.separator, lProjDir), resourcePath, rdf, false));
                    ++i;
                }
                list = allPaths;
            } else {
                String absolutePath = NSPathUtilities.stringByNormalizingExistingPath(_NSStringUtilities.concat(resourcePath, File.separator, aSubDirPath));
                if (absolutePath.startsWith(resourcePath.concat(File.separator))) {
                    list = this.resourcePathsForDirectoriesInDirectory(absolutePath, resourcePath, rdf, false);
                }
            }
            if (list == null) continue;
            masterList.addObjectsFromArray(list);
        }
        if (masterList == null || masterList.count() == 0) {
            return NSArray.emptyArray();
        }
        return masterList;
    }

    @Override
    public NSArray<String> resourcePathsForLocalizedResources(String extension, String aSubDirPath) {
        throw new RuntimeException("NSProjectBundle.resourcePathsForLocalizedResources: " + extension + ":" + aSubDirPath);
    }

    @Override
    public NSArray<String> resourcePathsForResources(String extension, String aSubDirPath) {
        String anExtension = extension;
        FilenameFilter rf = anExtension == null ? TheFilesFilter : NSProjectBundle.ResourceFilterForExtension(anExtension);
        NSMutableArray<String> masterList = new NSMutableArray<String>();
        for (String relativeResourcePath : this._projectLayout.relativePathForResourceType(this.resourceTypeForResourceWithExtension(extension))) {
            String resourcePath = _NSStringUtilities.concat(this._projectPath, File.separator, relativeResourcePath);
            NSArray<String> list = null;
            if (aSubDirPath == null) {
                list = this.resourcePathsForResourcesInDirectory(resourcePath, resourcePath, rf, false);
            } else {
                String absolutePath = NSPathUtilities.stringByNormalizingExistingPath(_NSStringUtilities.concat(resourcePath, File.separator, aSubDirPath));
                if (absolutePath.startsWith(resourcePath.concat(File.separator))) {
                    boolean prependNonLocalizedLproj = aSubDirPath.indexOf(".lproj") == -1;
                    list = this.resourcePathsForResourcesInDirectory(absolutePath, resourcePath, rf, prependNonLocalizedLproj);
                }
            }
            if (list == null) continue;
            masterList.addObjectsFromArray(list);
        }
        if (masterList == null || masterList.count() == 0) {
            return NSArray.emptyArray();
        }
        return masterList;
    }

    @Override
    public void _simplePathsInDirectoryInJar(String startPath, String dirExtension, NSMutableArray<String> dirs, String fileExtension, NSMutableArray<String> files) {
        throw new RuntimeException("NSProjectBundle._simplePathsInDirectoryInJar: " + startPath + ", " + dirExtension + "," + dirs + "," + fileExtension + "," + files);
    }

    public NSResourceType resourceTypeForResourceWithExtension(String extension) {
        NSResourceType resourceType = null;
        if (extension != null) {
            resourceType = _resourceTypeExtensions.get(extension);
        }
        if (resourceType == null) {
            resourceType = NSResourceType.Other;
        }
        return resourceType;
    }

    public NSResourceType resourceTypeForResourceNamed(String resourceName) {
        String extension = NSPathUtilities.pathExtension(resourceName);
        if (extension == null || extension.length() == 0) {
            extension = resourceName;
        }
        return this.resourceTypeForResourceWithExtension(extension);
    }

    public NSProjectLayout projectLayout() {
        return this._projectLayout;
    }

    public NSDictionary<String, Object> infoDictionary() {
        if (this._infoDictionary == null) {
            this._infoDictionary = NSDictionary.emptyDictionary();
            NSProjectAnalyzer.BundleType bundleType = this._projectAnalyzer.bundleType();
            String bundleName = this._projectAnalyzer.bundleName();
            String principalClass = this._projectAnalyzer.principalClass();
            NSArray<String> dependencies = this._projectAnalyzer.dependencies();
            if (bundleName == null) {
                bundleName = new File(this.projectPath()).getName();
                System.err.println("NSBundle: Unable to determine the project name for '" + this.projectPath() + "'. Guessing '" + bundleName + "'.");
            }
            if (bundleType == null) {
                bundleType = NSProjectAnalyzer.BundleType.Framework;
                System.err.println("NSBundle: Unable to determine the project type for '" + this.projectPath() + "'. Guessing it is a framework.");
            }
            NSMutableDictionary<String, Object> mockInfoPlist = new NSMutableDictionary<String, Object>();
            mockInfoPlist.setObjectForKey(bundleName, "NSExecutable");
            mockInfoPlist.setObjectForKey("webo", "CFBundleSignatureKey");
            if (bundleType == NSProjectAnalyzer.BundleType.Application) {
                mockInfoPlist.setObjectForKey("APPL", "CFBundlePackageType");
            } else {
                mockInfoPlist.setObjectForKey("FMWK", "CFBundlePackageType");
            }
            if (principalClass != null) {
                mockInfoPlist.setObjectForKey(principalClass, "NSPrincipalClass");
            }
            mockInfoPlist.setObjectForKey("true", "Has_WOComponents");
            NSMutableArray<String> requiredBundleNames = new NSMutableArray<String>();
            if (dependencies != null) {
                for (String dependency : dependencies) {
                    requiredBundleNames.addObject(dependency.trim());
                }
            }
            mockInfoPlist.setObjectForKey("1.2.3", "CFBundleShortVersionString");
            mockInfoPlist.setObjectForKey("0", "Implementation-Version");
            NSDictionary<String, Object> analyzerInfoDictionary = this._projectAnalyzer.infoDictionary();
            if (analyzerInfoDictionary != null) {
                mockInfoPlist.addEntriesFromDictionary(analyzerInfoDictionary);
            }
            this._infoDictionary = mockInfoPlist;
        }
        return this._infoDictionary;
    }
}

