/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.development.NSBuildPropertiesProjectAnalyzer;
import com.webobjects.foundation.development.NSCompositeProjectAnalyzer;
import com.webobjects.foundation.development.NSEclipseProjectAnalyzer;
import com.webobjects.foundation.development.NSFluffyBunnyAnalyzer;
import com.webobjects.foundation.development.NSProjectLayout;
import com.webobjects.foundation.development.NSUserDefinedProjectAnalyzer;
import java.io.File;

public interface NSProjectAnalyzer {
    public Boolean isBundle();

    public BundleType bundleType();

    public String bundleName();

    public String principalClass();

    public NSDictionary<String, Object> infoDictionary();

    public NSArray<String> dependencies();

    public NSProjectLayout projectLayout();

    public boolean isProjectRoot();

    public static enum BundleType {
        Application,
        Framework;

    }

    public static class Factory {
        public static NSProjectAnalyzer projectAnalyzerForFolder(File projectFolder) {
            NSCompositeProjectAnalyzer projectAnalyzer = new NSCompositeProjectAnalyzer();
            NSArray projectAnalyzerClassNames = NSProperties.arrayForKey("NSProjectAnalyzers");
            if (projectAnalyzerClassNames == null) {
                projectAnalyzer.addProjectAnalyzer(new NSUserDefinedProjectAnalyzer(projectFolder));
                projectAnalyzer.addProjectAnalyzer(new NSBuildPropertiesProjectAnalyzer(projectFolder));
                projectAnalyzer.addProjectAnalyzer(new NSEclipseProjectAnalyzer(projectFolder));
                projectAnalyzer.addProjectAnalyzer(new NSFluffyBunnyAnalyzer(projectFolder));
            } else {
                for (String projectAnalyzerClassName : projectAnalyzerClassNames) {
                    try {
                        projectAnalyzer.addProjectAnalyzer(Class.forName(projectAnalyzerClassName).asSubclass(NSProjectAnalyzer.class).getConstructor(File.class).newInstance(projectFolder));
                    }
                    catch (Exception exception) {
                        throw new IllegalArgumentException("Failed to create a project analyzer for the class named '" + projectAnalyzerClassName + "'.");
                    }
                }
            }
            return projectAnalyzer;
        }
    }
}

