/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.development.NSProjectLayout;
import com.webobjects.foundation.development.NSResourceType;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class NSMavenProjectLayout
extends NSProjectLayout {
    private boolean _testsEnabled = NSProperties.booleanForKey("NSMavenTestPathsEnabled");

    public NSMavenProjectLayout(File projectFolder) {
        super(projectFolder);
    }

    @Override
    public List<String> relativePathForResourceType(NSResourceType type) {
        ArrayList<String> aList = new ArrayList<String>();
        if (NSResourceType.Component.equals(type)) {
            aList.add("src/main/components");
            if (this._testsEnabled) {
                aList.add("src/test/components");
            }
        } else if (NSResourceType.Strings.equals(type)) {
            aList.add("src/main/resources");
            aList.add("src/main/woresources");
            if (this._testsEnabled) {
                aList.add("src/test/resources");
                aList.add("src/test/woresources");
            }
        } else if (NSResourceType.Model.equals(type)) {
            aList.add("src/main/resources");
            if (this._testsEnabled) {
                aList.add("src/test/resources");
            }
        } else if (NSResourceType.D2WModel.equals(type)) {
            aList.add("src/main/resources");
            aList.add("src/main/woresources");
            if (this._testsEnabled) {
                aList.add("src/test/resources");
                aList.add("src/test/woresources");
            }
        } else if (NSResourceType.WebServer.equals(type)) {
            aList.add("src/main/webserverresources");
            aList.add("src/main/webserver-resources");
            if (this._testsEnabled) {
                aList.add("src/test/webserverresources");
                aList.add("src/test/webserver-resources");
            }
        } else if (NSResourceType.Java.equals(type)) {
            aList.add("src/main/java");
            if (this._testsEnabled) {
                aList.add("src/test/java");
            }
        } else if (NSResourceType.JavaClient.equals(type)) {
            aList.add("src/client/java");
        } else if (NSResourceType.JavaClientResources.equals(type)) {
            aList.add("src/client/resources");
        } else if (NSResourceType.InfoPlist.equals(type)) {
            aList.add("src/main/woresources");
            aList.add("src/main/resources");
            aList.add("target/Classes/Resources/");
            aList.add("woproject");
            if (this._testsEnabled) {
                aList.add("src/test/woresources");
                aList.add("src/test/resources");
            }
        } else {
            aList.add("src/main/woresources");
            aList.add("src/main/resources");
            aList.add("src/main/components");
            aList.add("src/main/webserverresources");
            aList.add("src/main/webserver-resources");
            if (this._testsEnabled) {
                aList.add("src/test/woresources");
                aList.add("src/test/resources");
                aList.add("src/test/components");
                aList.add("src/test/webserverresources");
                aList.add("src/test/webserver-resources");
            }
        }
        return aList;
    }
}

