/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.development.NSMavenProjectLayout;
import com.webobjects.foundation.development.NSProjectAnalyzer;
import com.webobjects.foundation.development.NSProjectLayout;
import com.webobjects.foundation.xml._NSXMLUtilities;
import java.io.File;
import java.io.IOException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class NSMavenProjectAnalyzer
implements NSProjectAnalyzer {
    private NSDictionary<String, Object> _infoPlist;
    private File _projectFolder;
    private NSProjectLayout _layout;
    private String _bundleName;
    private boolean _hasLayout;

    public NSMavenProjectAnalyzer(File projectFolder) {
        File infoPlistFile;
        File pomFile = new File(projectFolder, "pom.xml");
        if (pomFile.exists()) {
            try {
                Element projectElement;
                NodeList nameList;
                Node node;
                Document pomDocument = _NSXMLUtilities.newDocumentBuilderFactory().newDocumentBuilder().parse(pomFile);
                pomDocument.normalize();
                NodeList packagingElements = pomDocument.getElementsByTagName("packaging");
                this._hasLayout = true;
                if (packagingElements != null && packagingElements.getLength() > 0 && (node = packagingElements.item(0).getFirstChild()) != null && ("woapplication".equals(node.getNodeValue()) || "woframework".equals(node.getNodeValue()))) {
                    this._hasLayout = false;
                }
                if ((nameList = (projectElement = pomDocument.getDocumentElement()).getElementsByTagName("name")).getLength() > 0) {
                    this._bundleName = ((Element)nameList.item(0)).getFirstChild().getNodeValue();
                }
                this._projectFolder = projectFolder;
            }
            catch (Throwable t) {
                System.out.println("NSMavenProjectAnalyzer: Can't read " + pomFile + " (" + t + ")");
            }
        }
        if (!(infoPlistFile = new File(projectFolder, "target/Classes/Resources/Info.plist")).exists()) {
            infoPlistFile = new File(projectFolder, "src/main/woresources/Info.plist");
        }
        if (infoPlistFile.exists()) {
            try {
                this._infoPlist = (NSDictionary)NSPropertyListSerialization.propertyListWithPathURL(infoPlistFile.toURI().toURL());
            }
            catch (IOException iOException) {}
        }
        if (this._infoPlist != null && this._infoPlist.objectForKey("CFBundleName") != null) {
            this._bundleName = (String)this._infoPlist.objectForKey("CFBundleName");
        }
    }

    @Override
    public Boolean isBundle() {
        if (this._infoPlist != null) {
            return Boolean.TRUE;
        }
        return null;
    }

    @Override
    public NSProjectAnalyzer.BundleType bundleType() {
        if (this._infoPlist != null) {
            String packageType = (String)this._infoPlist.objectForKey("CFBundlePackageType");
            if ("FMWK".equals(packageType)) {
                return NSProjectAnalyzer.BundleType.Framework;
            }
            if ("APPL".equals(packageType)) {
                return NSProjectAnalyzer.BundleType.Application;
            }
        }
        return null;
    }

    @Override
    public String bundleName() {
        return this._bundleName;
    }

    @Override
    public NSArray<String> dependencies() {
        return null;
    }

    @Override
    public NSDictionary<String, Object> infoDictionary() {
        return this._infoPlist;
    }

    @Override
    public String principalClass() {
        return null;
    }

    @Override
    public NSProjectLayout projectLayout() {
        if (this._hasLayout) {
            return new NSMavenProjectLayout(this._projectFolder);
        }
        return this._layout;
    }

    @Override
    public boolean isProjectRoot() {
        return this._projectFolder != null;
    }
}

