/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.development.NSMavenProjectLayout;
import com.webobjects.foundation.development.NSProjectAnalyzer;
import com.webobjects.foundation.development.NSProjectLayout;
import com.webobjects.foundation.xml._NSXMLUtilities;
import java.io.File;
import java.util.HashSet;
import java.util.Set;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class NSEclipseProjectAnalyzer
implements NSProjectAnalyzer {
    private File _projectFolder;
    private Set<String> _natures;
    private String _name;

    public NSEclipseProjectAnalyzer(File projectFolder) {
        File eclipseProjectFile = new File(projectFolder, ".project");
        if (eclipseProjectFile.exists()) {
            try {
                Node nameFirstChild;
                Node nameListNode;
                NodeList nameList;
                Document eclipseProjectDocument = _NSXMLUtilities.newDocumentBuilderFactory().newDocumentBuilder().parse(eclipseProjectFile);
                eclipseProjectDocument.normalize();
                this._natures = new HashSet<String>();
                Element projectDescriptionElement = eclipseProjectDocument.getDocumentElement();
                NodeList naturesNodeList = projectDescriptionElement.getElementsByTagName("natures");
                if (naturesNodeList.getLength() > 0) {
                    Element naturesElement = (Element)naturesNodeList.item(0);
                    NodeList natureNodeList = naturesElement.getElementsByTagName("nature");
                    int i = 0;
                    while (i < natureNodeList.getLength()) {
                        Node natureNode = natureNodeList.item(i);
                        if (natureNode instanceof Element) {
                            String nature = null;
                            NodeList natureChildNodeList = ((Element)natureNode).getChildNodes();
                            if (natureChildNodeList != null) {
                                int natureChildNodeNum = 0;
                                while (natureChildNodeNum < natureChildNodeList.getLength()) {
                                    Node natureChildNode = natureChildNodeList.item(natureChildNodeNum);
                                    if (natureChildNode instanceof Text) {
                                        nature = natureChildNode.getNodeValue();
                                    }
                                    ++natureChildNodeNum;
                                }
                                if (nature != null) {
                                    this._natures.add(nature);
                                }
                            }
                        }
                        ++i;
                    }
                }
                if ((nameList = projectDescriptionElement.getElementsByTagName("name")).getLength() > 0 && (nameListNode = nameList.item(0)) instanceof Element && (nameFirstChild = ((Element)nameListNode).getFirstChild()) != null) {
                    String nameValue;
                    this._name = nameValue = nameFirstChild.getNodeValue();
                }
                this._projectFolder = projectFolder;
            }
            catch (Throwable t) {
                System.out.println("NSEclipseProjectAnalyzer: Can't read " + eclipseProjectFile + " (" + t + ")");
            }
        }
    }

    @Override
    public Boolean isBundle() {
        if (this._natures != null) {
            for (String nature : this._natures) {
                if (!nature.startsWith("org.objectstyle.wolips.")) continue;
                return Boolean.TRUE;
            }
        }
        return null;
    }

    @Override
    public NSProjectAnalyzer.BundleType bundleType() {
        if (this._natures != null) {
            for (String nature : this._natures) {
                if (nature.startsWith("org.objectstyle.wolips.") && nature.endsWith("applicationnature")) {
                    return NSProjectAnalyzer.BundleType.Application;
                }
                if (!nature.startsWith("org.objectstyle.wolips.") || !nature.endsWith("frameworknature")) continue;
                return NSProjectAnalyzer.BundleType.Framework;
            }
        }
        return null;
    }

    @Override
    public String bundleName() {
        return this._name;
    }

    @Override
    public NSDictionary<String, Object> infoDictionary() {
        return null;
    }

    @Override
    public String principalClass() {
        return null;
    }

    @Override
    public NSArray<String> dependencies() {
        return null;
    }

    @Override
    public NSProjectLayout projectLayout() {
        if (this._natures != null && this._natures.contains("org.eclipse.m2e.core.maven2Nature")) {
            return new NSMavenProjectLayout(this._projectFolder);
        }
        return null;
    }

    @Override
    public boolean isProjectRoot() {
        return this._projectFolder != null;
    }
}

