/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSPathUtilities;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation.development.NSConfigurationValidationPropertiesCoordinator;
import com.webobjects.foundation.development.NSConfigurationValidatorFailure;
import com.webobjects.foundation.plist.NSPList;
import com.webobjects.foundation.properties.NSPropertyValidationError;
import com.webobjects.foundation.properties.NSPropertyValidationException;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.PrintWriter;
import java.io.StringWriter;

public class NSConfigurationValidator {
    public static final NSArray<String> plistFileTypes = NSValueUtilities.arrayValueWithDefault(System.getProperty("NSConfigurationValidator.plistExtensions"), new NSArray<String>("plist", "strings", "eomodeld"));
    public static final NSArray<String> propertyFileTypes = NSValueUtilities.arrayValueWithDefault(System.getProperty("NSConfigurationValidator.propertyExtensions"), new NSArray<String>("properties"));

    public void validate(File baseDir, File resourceDirectory, String[] filePaths, File testResultsPath) throws NSConfigurationValidatorFailure {
        if (!testResultsPath.exists()) {
            testResultsPath.mkdirs();
        }
        String propertyResults = this.validateProperties(baseDir, resourceDirectory, filePaths, testResultsPath);
        String plistResults = this.validatePListFiles(baseDir, resourceDirectory, filePaths, testResultsPath);
        if (propertyResults != null || plistResults != null) {
            String message = propertyResults;
            if (message == null) {
                message = plistResults;
            } else if (plistResults != null) {
                message = String.valueOf(message) + ", " + plistResults;
            }
            throw new NSConfigurationValidatorFailure(message);
        }
    }

    private String validatePListFiles(File basedir, File resourceDirectory, String[] filePaths, File testResultsPath) {
        JUnitTestSuiteData testSuiteData = new JUnitTestSuiteData(basedir.getName());
        int basePathLength = basedir.getPath().length() + 1;
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            if (this.isPlistFile(filePath)) {
                File file = new File(resourceDirectory, filePath);
                String projectRelativeName = file.toString().substring(basePathLength);
                try {
                    NSPList.read(file).asAny();
                    testSuiteData.addSuccess(new JUnitTestCaseData(projectRelativeName));
                }
                catch (RuntimeException e) {
                    testSuiteData.addFailure(new JUnitTestCaseData(projectRelativeName, e));
                }
                catch (StackOverflowError e) {
                    testSuiteData.addFailure(new JUnitTestCaseData(projectRelativeName, e));
                }
                catch (AssertionError e) {
                    testSuiteData.addFailure(new JUnitTestCaseData(projectRelativeName, (Throwable)((Object)e)));
                }
            }
            ++n2;
        }
        testSuiteData.outputTo(testResultsPath, "Plist");
        if (testSuiteData.failures > 0) {
            return String.valueOf(testSuiteData.failures) + this.plistPluralized(testSuiteData.failures) + " failed validation in " + testSuiteData.name;
        }
        return null;
    }

    private boolean isPlistFile(String filePath) {
        return plistFileTypes.containsObject(NSPathUtilities.pathExtension(filePath));
    }

    private String validateProperties(File basedir, File resourceDirectory, String[] filePaths, File testResultsPath) throws IllegalArgumentException {
        JUnitTestSuiteData testSuiteData = new JUnitTestSuiteData(basedir.getName());
        int basePathLength = basedir.getPath().length() + 1;
        String[] stringArray = filePaths;
        int n = filePaths.length;
        int n2 = 0;
        while (n2 < n) {
            String filePath = stringArray[n2];
            if (this.isPropertiesFile(filePath)) {
                File file = new File(resourceDirectory, filePath);
                String projectRelativeName = file.toString().substring(basePathLength);
                try {
                    NSConfigurationValidationPropertiesCoordinator.loadPropertyFiles(file.getAbsolutePath());
                    testSuiteData.addSuccess(new JUnitTestCaseData(projectRelativeName));
                }
                catch (NSPropertyValidationException e) {
                    testSuiteData.addFailure(new JUnitTestCaseData(projectRelativeName, e));
                }
                catch (RuntimeException e) {
                    testSuiteData.addFailure(new JUnitTestCaseData(projectRelativeName, e));
                }
                catch (StackOverflowError e) {
                    testSuiteData.addFailure(new JUnitTestCaseData(projectRelativeName, e));
                }
                catch (AssertionError e) {
                    testSuiteData.addFailure(new JUnitTestCaseData(projectRelativeName, (Throwable)((Object)e)));
                }
            }
            ++n2;
        }
        testSuiteData.outputTo(testResultsPath, "Properties");
        if (testSuiteData.failures > 0) {
            return String.valueOf(testSuiteData.failures) + this.propertyPluralized(testSuiteData.failures) + " failed validation in " + testSuiteData.name;
        }
        return null;
    }

    private boolean isPropertiesFile(String filePath) {
        return propertyFileTypes.containsObject(NSPathUtilities.pathExtension(filePath)) || NSPathUtilities.lastPathComponent(filePath).equals("Properties");
    }

    private String propertyPluralized(int count) {
        return count == 1 ? " property" : " properties";
    }

    private String plistPluralized(int count) {
        return " plist or string file" + (count == 1 ? "" : "s");
    }

    private class JUnitTestCaseData {
        public String name;
        public int failures = 0;
        public String failureDetails;

        public JUnitTestCaseData(String name) {
            this.name = name;
        }

        public JUnitTestCaseData(String name, NSPropertyValidationException e) {
            this(name);
            this.failures = e.errors().count();
            StringBuilder sb = new StringBuilder();
            for (NSPropertyValidationError error : e.errors()) {
                sb.append("Failed: ");
                sb.append(error.key());
                sb.append("=");
                sb.append(error.values().get(0));
                sb.append(" ");
                sb.append(error.error());
                sb.append('\n');
            }
            this.failureDetails = sb.toString();
        }

        public JUnitTestCaseData(String name, Throwable t) {
            this(name);
            this.failures = 1;
            StringBuilder sb = new StringBuilder();
            sb.append(t.getLocalizedMessage());
            sb.append('\n');
            StringWriter writer = new StringWriter();
            t.printStackTrace(new PrintWriter(writer));
            sb.append(writer.toString());
            this.failureDetails = sb.toString();
        }
    }

    private class JUnitTestSuiteData {
        private NSMutableArray<JUnitTestCaseData> testCases = new NSMutableArray();
        public String name;
        public int failures = 0;

        public JUnitTestSuiteData(String name) {
            this.name = name;
        }

        public void outputTo(File outputPath, String suffix) {
            StringBuilder consoleBuilder = new StringBuilder();
            consoleBuilder.append("Validating ");
            consoleBuilder.append(suffix.toLowerCase());
            consoleBuilder.append(" files in ");
            consoleBuilder.append(this.name);
            consoleBuilder.append("\n");
            StringBuilder xmlReport = new StringBuilder();
            xmlReport.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
            xmlReport.append("<testsuite xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xsi:schemaLocation=\"https://maven.apache.org/surefire/maven-surefire-plugin/xsd/surefire-test-report.xsd\" name=\"");
            xmlReport.append(this.name);
            xmlReport.append("\" errors=\"0\" tests=\"");
            xmlReport.append(this.testCases.count());
            xmlReport.append("\" failures=\"");
            xmlReport.append(this.failures);
            xmlReport.append("\" time=\"0.0\">\n");
            xmlReport.append("    <properties></properties>\n");
            StringBuilder textReport = new StringBuilder();
            textReport.append("-------------------------------------------------------------------------------\n");
            textReport.append("Verifying ");
            textReport.append(suffix.toLowerCase());
            textReport.append(" files in ");
            textReport.append(this.name);
            textReport.append("\n");
            textReport.append("-------------------------------------------------------------------------------\n");
            for (JUnitTestCaseData testCase : this.testCases) {
                xmlReport.append("    <testcase name=\"");
                xmlReport.append(testCase.name);
                xmlReport.append("\" time=\"0.0\">\n");
                textReport.append("Verifying ");
                textReport.append(testCase.name);
                textReport.append("\n");
                if (testCase.failureDetails != null) {
                    consoleBuilder.append(testCase.name);
                    consoleBuilder.append(": ");
                    consoleBuilder.append(testCase.failureDetails);
                    consoleBuilder.append("\n");
                    xmlReport.append("        <failure message=\"");
                    xmlReport.append(testCase.failures);
                    xmlReport.append(NSConfigurationValidator.this.propertyPluralized(testCase.failures));
                    xmlReport.append(" failed validation in ");
                    xmlReport.append(testCase.name);
                    xmlReport.append("\">\n");
                    xmlReport.append(testCase.failureDetails);
                    xmlReport.append("        </failure>\n");
                    textReport.append(testCase.failureDetails);
                    textReport.append("\n");
                }
                xmlReport.append("    </testcase>\n");
            }
            consoleBuilder.append("Validated ");
            consoleBuilder.append(this.testCases.count());
            consoleBuilder.append(" files\n");
            xmlReport.append("</testsuite>\n");
            String fileName = String.valueOf(this.name.replaceAll(File.pathSeparator, "_")) + "_" + suffix;
            File xmlReportFile = new File(outputPath, "TEST-" + fileName + ".xml");
            File txtReportFile = new File(outputPath, String.valueOf(fileName) + ".txt");
            try {
                System.out.println(consoleBuilder.toString());
                PrintWriter out = new PrintWriter(xmlReportFile);
                out.print(xmlReport);
                out.close();
                out = new PrintWriter(txtReportFile);
                out.print(textReport);
                out.close();
            }
            catch (FileNotFoundException e) {
                throw new RuntimeException(e);
            }
        }

        public void addFailure(JUnitTestCaseData testCase) {
            this.failures += testCase.failures;
            this.testCases.add(testCase);
        }

        public void addSuccess(JUnitTestCaseData testCase) {
            this.testCases.add(testCase);
        }
    }
}

