/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.development.NSProjectAnalyzer;
import com.webobjects.foundation.development.NSProjectLayout;
import java.util.LinkedList;
import java.util.List;

public class NSCompositeProjectAnalyzer
implements NSProjectAnalyzer {
    private List<NSProjectAnalyzer> _projectAnalyzers = new LinkedList<NSProjectAnalyzer>();

    public void addProjectAnalyzer(NSProjectAnalyzer projectAnalyzer) {
        this._projectAnalyzers.add(projectAnalyzer);
    }

    @Override
    public Boolean isBundle() {
        for (NSProjectAnalyzer projectAnalyzer : this._projectAnalyzers) {
            Boolean isBundle = projectAnalyzer.isBundle();
            if (isBundle == null || !isBundle.booleanValue()) continue;
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    @Override
    public NSProjectAnalyzer.BundleType bundleType() {
        for (NSProjectAnalyzer projectAnalyzer : this._projectAnalyzers) {
            NSProjectAnalyzer.BundleType type = projectAnalyzer.bundleType();
            if (type == null) continue;
            return type;
        }
        return null;
    }

    @Override
    public NSDictionary<String, Object> infoDictionary() {
        NSMutableDictionary<String, Object> infoDictionary = new NSMutableDictionary<String, Object>();
        int analyzerNum = this._projectAnalyzers.size() - 1;
        while (analyzerNum >= 0) {
            NSProjectAnalyzer projectAnalyzer = this._projectAnalyzers.get(analyzerNum);
            NSDictionary<String, Object> analyzerInfoDictionary = projectAnalyzer.infoDictionary();
            if (analyzerInfoDictionary != null) {
                infoDictionary.addEntriesFromDictionary(analyzerInfoDictionary);
            }
            --analyzerNum;
        }
        return infoDictionary;
    }

    @Override
    public String principalClass() {
        for (NSProjectAnalyzer projectAnalyzer : this._projectAnalyzers) {
            String principalClass = projectAnalyzer.principalClass();
            if (principalClass == null) continue;
            return principalClass;
        }
        return null;
    }

    @Override
    public String bundleName() {
        for (NSProjectAnalyzer projectAnalyzer : this._projectAnalyzers) {
            String bundleName = projectAnalyzer.bundleName();
            if (bundleName == null) continue;
            return bundleName;
        }
        return null;
    }

    @Override
    public NSArray<String> dependencies() {
        for (NSProjectAnalyzer projectAnalyzer : this._projectAnalyzers) {
            NSArray<String> dependencies = projectAnalyzer.dependencies();
            if (dependencies == null) continue;
            return dependencies;
        }
        return null;
    }

    @Override
    public NSProjectLayout projectLayout() {
        for (NSProjectAnalyzer projectAnalyzer : this._projectAnalyzers) {
            NSProjectLayout projectLayout = projectAnalyzer.projectLayout();
            if (projectLayout == null) continue;
            return projectLayout;
        }
        return null;
    }

    @Override
    public boolean isProjectRoot() {
        for (NSProjectAnalyzer projectAnalyzer : this._projectAnalyzers) {
            if (!projectAnalyzer.isProjectRoot()) continue;
            return true;
        }
        return false;
    }
}

