/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSBundle;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation.development.NSLegacyBundle;
import com.webobjects.foundation.development.NSProjectBundleFactory;

public abstract class NSBundleFactory {
    public static void registerBundleFactory(NSBundleFactory bundleFactory) {
        LazyInitializer._bundleFactories.insertObjectAtIndex(bundleFactory, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static NSBundle bundleForPathWithRegistry(String path, boolean shouldCreateBundle, boolean newIsJar) {
        Class<NSBundle> clazz = NSBundle.class;
        synchronized (NSBundle.class) {
            NSBundle bundle = null;
            for (NSBundleFactory bundleFactory : LazyInitializer._bundleFactories) {
                bundle = bundleFactory.bundleForPath(path, shouldCreateBundle, newIsJar);
                if (bundle != null) break;
            }
            if (bundle != null) {
                NSBundle.addBundle(bundle);
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return bundle;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void _bundleFactoriesBundlesDidLoad() {
        Class<NSBundle> clazz = NSBundle.class;
        synchronized (NSBundle.class) {
            for (NSBundleFactory bundleFactory : LazyInitializer._bundleFactories) {
                bundleFactory.bundlesDidLoad();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public abstract NSBundle bundleForPath(String var1, boolean var2, boolean var3);

    public abstract void bundlesDidLoad();

    private static class LazyInitializer {
        public static NSMutableArray<NSBundleFactory> _bundleFactories;

        static {
            NSArray bundleFactories;
            _bundleFactories = new NSMutableArray();
            NSBundleFactory.registerBundleFactory(new NSLegacyBundle.Factory());
            if (NSProjectBundleFactory.isEnabled()) {
                NSBundleFactory.registerBundleFactory(new NSProjectBundleFactory());
            }
            if ((bundleFactories = NSValueUtilities.arrayValue(System.getProperty("NSBundleFactories"))) != null) {
                for (String bundleFactory : bundleFactories) {
                    try {
                        NSBundleFactory.registerBundleFactory(Class.forName(bundleFactory).asSubclass(NSBundleFactory.class).newInstance());
                    }
                    catch (Throwable t) {
                        throw new IllegalArgumentException("Failed to create the bundle factory: " + bundleFactory + ".", t);
                    }
                }
            }
        }

        private LazyInitializer() {
        }
    }
}

