/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation.development;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.development.NSProjectAnalyzer;
import com.webobjects.foundation.development.NSProjectLayout;
import java.io.File;
import java.io.FileInputStream;
import java.util.Properties;

public class NSBuildPropertiesProjectAnalyzer
implements NSProjectAnalyzer {
    private File _projectFolder;
    private String _bundleName;
    private NSProjectAnalyzer.BundleType _bundleType;
    private NSArray<String> _dependencies;
    private String _principalClass;
    private NSMutableDictionary<String, Object> _infoDictionary = null;

    public NSBuildPropertiesProjectAnalyzer(File projectFolder) {
        String folderName;
        File buildPropertiesFile = new File(projectFolder, "woantbuild.properties");
        if (!buildPropertiesFile.exists()) {
            buildPropertiesFile = new File(projectFolder, "build.properties");
        }
        if (buildPropertiesFile.exists() && !(folderName = projectFolder.getName()).endsWith(".framework") && !folderName.endsWith(".woa") && !projectFolder.getPath().endsWith("target/classes")) {
            Properties buildProperties = new Properties();
            this._projectFolder = projectFolder;
            try (FileInputStream buildPropertiesInputStream = new FileInputStream(buildPropertiesFile);){
                String eoAdaptorClassName;
                String dependenciesStr;
                buildProperties.load(buildPropertiesInputStream);
                String projectType = buildProperties.getProperty("project.type");
                this._bundleType = "framework".equals(projectType) || buildProperties.getProperty("framework.name") != null ? NSProjectAnalyzer.BundleType.Framework : ("application".equals(projectType) || buildProperties.getProperty("application.name") != null ? NSProjectAnalyzer.BundleType.Application : null);
                this._bundleName = buildProperties.getProperty("framework.name");
                if (this._bundleName == null) {
                    this._bundleName = buildProperties.getProperty("application.name");
                    if (this._bundleName == null) {
                        this._bundleName = buildProperties.getProperty("project.name");
                    }
                }
                if ((dependenciesStr = buildProperties.getProperty("dependencies")) != null) {
                    this._dependencies = NSArray.componentsSeparatedByString(dependenciesStr, ",");
                }
                this._infoDictionary = new NSMutableDictionary();
                this._principalClass = buildProperties.getProperty("principalClass");
                if (this._principalClass != null) {
                    this._infoDictionary.setObjectForKey(this._principalClass, "NSPrincipalClass");
                }
                if ((eoAdaptorClassName = buildProperties.getProperty("eoAdaptorClassName")) != null) {
                    this._infoDictionary.setObjectForKey(eoAdaptorClassName, "EOAdaptorClassName");
                }
                if (this._infoDictionary.count() == 0) {
                    this._infoDictionary = null;
                }
            }
            catch (Throwable t) {
                System.out.println("NSBundle: Can't read " + buildPropertiesFile + " (" + t + ")");
            }
        }
    }

    @Override
    public Boolean isBundle() {
        if (this._bundleType != null) {
            return true;
        }
        return false;
    }

    @Override
    public NSProjectAnalyzer.BundleType bundleType() {
        return this._bundleType;
    }

    @Override
    public String bundleName() {
        return this._bundleName;
    }

    @Override
    public String principalClass() {
        return this._principalClass;
    }

    @Override
    public NSDictionary<String, Object> infoDictionary() {
        return this._infoDictionary;
    }

    @Override
    public NSArray<String> dependencies() {
        return this._dependencies;
    }

    @Override
    public NSProjectLayout projectLayout() {
        return null;
    }

    @Override
    public boolean isProjectRoot() {
        return this._projectFolder != null;
    }
}

