/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakMutableCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Iterator;

public class _NSWeakValueMutableDictionary<K, V, R extends WeakReference<? extends V>>
extends _NSWeakMutableCollection<V, R>
implements Serializable {
    public static final Class<_NSWeakValueMutableDictionary> _CLASS = _NSUtilities._classWithClassLiteral(_NSWeakValueMutableDictionary.class);
    static final long serialVersionUID = 2670319059934557103L;
    private static final String SerializationKeysFieldKey = "keys";
    private static final String SerializationValuesFieldKey = "objects";
    NSMutableDictionary<K, R> dictionary;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("keys", _NSUtilities._NoObjectArray.getClass()), new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};

    @Deprecated
    public _NSWeakValueMutableDictionary() {
        this.dictionary = new NSMutableDictionary(16);
    }

    @Deprecated
    public _NSWeakValueMutableDictionary(int capacity) {
        this.dictionary = new NSMutableDictionary(capacity);
    }

    public static <K, V> _NSWeakValueMutableDictionary<K, V, ?> dictionary() {
        return new _NSWeakValueMutableDictionary();
    }

    public static <K, V> _NSWeakValueMutableDictionary<K, V, ?> dictionaryWithCapacity(int capacity) {
        return new _NSWeakValueMutableDictionary(capacity);
    }

    public NSArray<K> allKeys() {
        this.processQueue();
        return this.dictionary.allKeys();
    }

    public NSArray<V> allValues() {
        this.processQueue();
        NSMutableArray<int> list = new NSMutableArray<int>(this.dictionary.count());
        Iterator iterator = this.dictionary.values().iterator();
        while (iterator.hasNext()) {
            Object object = ((WeakReference)iterator.next()).get();
            if (object == null) continue;
            list.add((int)object);
        }
        return list.immutableClone();
    }

    @Override
    public NSArray<V> allObjects() {
        return this.allValues();
    }

    @Override
    public int count() {
        return this.dictionary.count();
    }

    @Override
    public Object[] objects() {
        return this.allValues().objects();
    }

    public Enumeration<K> keyEnumerator() {
        return new _NSJavaArrayEnumerator(this.dictionary.keysNoCopy(), false);
    }

    @Override
    public Enumeration<V> objectEnumerator() {
        return new _NSWeakMutableCollection._NSWeakMutableCollectionEnumerator(this.dictionary.objectEnumerator());
    }

    @Override
    public Enumeration<R> referenceEnumerator() {
        return this.dictionary.objectEnumerator();
    }

    public void setObjectForKey(V object, K key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an NSDictionary");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an NSDictionary");
        }
        this.processQueue();
        this.dictionary.setObjectForKey(new _NSWeakMutableCollection._NSWeakMutableCollectionReference<V>(object, this.queue, key), key);
    }

    public Object removeObjectForKey(Object key) {
        this.processQueue();
        return this.dictionary.removeObjectForKey(key);
    }

    @Override
    public void removeAllObjects() {
        this.processQueue();
        this.dictionary.removeAllObjects();
    }

    public V objectForKey(Object key) {
        this.processQueue();
        if (this.dictionary.count() == 0 || key == null) {
            return null;
        }
        WeakReference temp = (WeakReference)this.dictionary.objectForKey(key);
        return temp == null ? null : (V)temp.get();
    }

    public R referenceForKey(Object key) {
        if (this.dictionary.count() == 0 || key == null) {
            return null;
        }
        return (R)((WeakReference)this.dictionary.objectForKey(key));
    }

    @Override
    public void addObject(V anObject) {
        throw new UnsupportedOperationException("_NSWeakValueMutableDictionary does not support addObject(Object)");
    }

    @Override
    public void addReference(R anObject) {
        throw new UnsupportedOperationException("_NSWeakValueMutableDictionary does not support addReference(Object)");
    }

    @Override
    public void removeObject(Object object) {
        throw new UnsupportedOperationException("_NSWeakValueMutableDictionary does not support removeObject(Object)");
    }

    @Override
    public void removeReference(Object object) {
        this.processQueue();
        this.dictionary.removeObjectForKey(((_NSWeakMutableCollection._NSWeakMutableCollectionReference)object).key());
    }

    @Override
    protected void __removeReference(Reference<?> object) {
        this.dictionary.removeObjectForKey(((_NSWeakMutableCollection._NSWeakMutableCollectionReference)object).key());
    }

    @Override
    public String toString() {
        this.processQueue();
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("{ ");
        Iterator<K> iterator = this.dictionary.keySet().iterator();
        while (iterator.hasNext()) {
            K key = iterator.next();
            R object = this.referenceForKey(key);
            buffer.append(key.toString());
            buffer.append(" = ");
            if (object == null) {
                buffer.append("gc'd");
            } else {
                buffer.append(object.toString());
            }
            if (!iterator.hasNext()) continue;
            buffer.append(";\n");
        }
        buffer.append(" }");
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] keys = this.allKeys().objects();
        int c = keys.length;
        Object[] values = new Object[c];
        int i = 0;
        while (i < c) {
            values[i] = this.objectForKey(keys[i]);
            ++i;
        }
        fields.put(SerializationKeysFieldKey, keys);
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        values = values == null ? _NSUtilities._NoObjectArray : values;
        int c = keys.length;
        int i = 0;
        while (i < c) {
            this.setObjectForKey(values[i], keys[i]);
            ++i;
        }
    }
}

