/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakMutableCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;

public class _NSWeakMutableSet<T, R extends WeakReference<? extends T>>
extends _NSWeakMutableCollection<T, R>
implements Serializable {
    public static final Class<_NSWeakMutableSet> _CLASS = _NSUtilities._classWithClassLiteral(_NSWeakMutableSet.class);
    static final long serialVersionUID = 2344836447092997917L;
    private static final String SerializationKeysFieldKey = "objects";
    private NSMutableSet<R> set;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};

    public _NSWeakMutableSet() {
        this.set = new NSMutableSet<int>(16);
    }

    public _NSWeakMutableSet(int capacity) {
        this.set = new NSMutableSet<int>(capacity);
    }

    @Override
    public NSArray<T> allObjects() {
        this.processQueue();
        NSMutableArray<int> list = new NSMutableArray<int>(this.set.count());
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            Object object = ((WeakReference)iterator.next()).get();
            if (object == null) continue;
            list.add((int)object);
        }
        return list.immutableClone();
    }

    @Override
    public int count() {
        return this.set.count();
    }

    @Override
    public Object[] objects() {
        return this.allObjects().objects();
    }

    @Override
    public Enumeration<T> objectEnumerator() {
        return new _NSWeakMutableCollection._NSWeakMutableCollectionEnumerator(this.set.objectEnumerator());
    }

    @Override
    public Enumeration<R> referenceEnumerator() {
        return this.set.objectEnumerator();
    }

    @Override
    public void addObject(T object) {
        this.processQueue();
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an _NSWeakMutableSet");
        }
        this.set.addObject(new _NSWeakMutableCollection._NSWeakMutableCollectionReference<T>(object, this.queue));
    }

    @Override
    public void addReference(R object) {
        this.set.addObject(object);
    }

    @Override
    public void removeObject(Object object) {
        this.processQueue();
        if (object == null || this.set.count() == 0) {
            return;
        }
        ArrayList<WeakReference> deleted = new ArrayList<WeakReference>();
        for (WeakReference reference : this.set) {
            Object referencedObject = reference.get();
            if (!object.equals(referencedObject)) continue;
            deleted.add(reference);
        }
        this.set.removeAll(deleted);
    }

    @Override
    public void removeReference(Object object) {
        this.processQueue();
        this.set.removeObject(object);
    }

    @Override
    protected void __removeReference(Reference<?> object) {
        this.set.removeObject(object);
    }

    protected void removeReferencesWithReferent(Object object) {
        if (object == null) {
            return;
        }
        ArrayList<WeakReference> deleted = new ArrayList<WeakReference>();
        if (object instanceof WeakReference) {
            for (WeakReference reference : this.set) {
                if (!object.equals(reference)) continue;
                deleted.add(reference);
            }
        } else {
            for (WeakReference reference : this.set) {
                Object referencedObject = reference.get();
                if (!object.equals(referencedObject)) continue;
                deleted.add(reference);
            }
        }
        this.set.removeAll(deleted);
    }

    @Override
    public void removeAllObjects() {
        this.set.removeAllObjects();
    }

    @Override
    public String toString() {
        this.processQueue();
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("( ");
        Iterator iterator = this.set.iterator();
        while (iterator.hasNext()) {
            Object object = ((WeakReference)iterator.next()).get();
            if (object == null) {
                buffer.append("gc'd");
            } else {
                buffer.append(object.toString());
            }
            if (!iterator.hasNext()) continue;
            buffer.append(",\n");
        }
        buffer.append(" )");
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] keys = this.allObjects().objects();
        fields.put(SerializationKeysFieldKey, keys);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        int c = keys.length;
        int i = 0;
        while (i < c) {
            this.addObject(keys[i]);
            ++i;
        }
    }
}

