/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakMutableCollection;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.util.Enumeration;
import java.util.Iterator;

public class _NSWeakMutableArray<T, R extends WeakReference<? extends T>>
extends _NSWeakMutableCollection<T, R>
implements Serializable {
    public static final Class<_NSWeakMutableArray> _CLASS = _NSUtilities._classWithClassLiteral(_NSWeakMutableArray.class);
    static final long serialVersionUID = 2421998404808971281L;
    private static final String SerializationValuesFieldKey = "objects";
    private NSMutableArray<R> array;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};

    public _NSWeakMutableArray() {
        this(16);
    }

    public _NSWeakMutableArray(int capacity) {
        this.array = new NSMutableArray<int>(capacity);
    }

    @Override
    public NSArray<T> allObjects() {
        this.processQueue();
        NSMutableArray<int> list = new NSMutableArray<int>(this.array.count());
        Iterator<R> iterator = this.array.iterator();
        while (iterator.hasNext()) {
            Object object = ((WeakReference)iterator.next()).get();
            if (object == null) continue;
            list.add((int)object);
        }
        return list.immutableClone();
    }

    @Override
    public int count() {
        return this.array.count();
    }

    public int indexOfObject(Object anObject) {
        this.processQueue();
        int c = this.array.count();
        int i = 0;
        while (i < c) {
            if (anObject == ((WeakReference)this.array.objectAtIndex(i)).get()) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public Object[] objects() {
        return this.allObjects().objects();
    }

    @Override
    public Enumeration<T> objectEnumerator() {
        return new _NSWeakMutableCollection._NSWeakMutableCollectionEnumerator(this.array.objectEnumerator());
    }

    @Override
    public Enumeration<R> referenceEnumerator() {
        return this.array.objectEnumerator();
    }

    @Override
    public void addObject(T object) {
        this.processQueue();
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an _NSWeakMutableArray");
        }
        this.array.addObject(new _NSWeakMutableCollection._NSWeakMutableCollectionReference<T>(object, this.queue));
    }

    @Override
    public void addReference(R object) {
        this.processQueue();
        this.array.addObject(object);
    }

    @Override
    public void removeObject(Object object) {
        this.processQueue();
        if (object == null || this.array.count() == 0) {
            return;
        }
        this.array.removeObject(new _NSWeakMutableCollection._NSWeakMutableCollectionReference<Object>(object, this.queue));
    }

    @Override
    public void removeReference(Object object) {
        this.processQueue();
        this.array.removeObject(object);
    }

    @Override
    protected void __removeReference(Reference<?> object) {
        this.array.removeObject(object);
    }

    @Override
    public void removeAllObjects() {
        this.array.removeAllObjects();
    }

    @Override
    public String toString() {
        this.processQueue();
        StringBuilder buffer = new StringBuilder(128);
        buffer.append("( ");
        Iterator<R> iterator = this.array.iterator();
        while (iterator.hasNext()) {
            Object object = ((WeakReference)iterator.next()).get();
            if (object == null) {
                buffer.append("gc'd");
            } else {
                buffer.append(object.toString());
            }
            if (!iterator.hasNext()) continue;
            buffer.append(",\n");
        }
        buffer.append(" )");
        return buffer.toString();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        Object[] values = this.allObjects().objects();
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        values = values == null ? _NSUtilities._NoObjectArray : values;
        int c = values.length;
        int i = 0;
        while (i < c) {
            this.addObject(values[i]);
            ++i;
        }
    }
}

