/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import java.io.IOException;
import java.io.OutputStream;

public abstract class _NSThresholdingOutputStream
extends OutputStream {
    private final int _threshold;
    private long _written;
    private boolean _thresholdExceeded;

    public _NSThresholdingOutputStream(int threshold) {
        this._threshold = threshold;
    }

    @Override
    public void write(int b) throws IOException {
        this.checkThreshold(1);
        this.stream().write(b);
        ++this._written;
    }

    @Override
    public void write(byte[] b) throws IOException {
        this.checkThreshold(b.length);
        this.stream().write(b);
        this._written += (long)b.length;
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.checkThreshold(len);
        this.stream().write(b, off, len);
        this._written += (long)len;
    }

    @Override
    public void flush() throws IOException {
        this.stream().flush();
    }

    @Override
    public void close() throws IOException {
        try {
            this.flush();
        }
        catch (IOException iOException) {}
        this.stream().close();
    }

    public int threshold() {
        return this._threshold;
    }

    public long getByteCount() {
        return this._written;
    }

    public boolean isThresholdExceeded() {
        return this._written > (long)this._threshold;
    }

    protected void checkThreshold(int count) throws IOException {
        if (!this._thresholdExceeded && this._written + (long)count > (long)this._threshold) {
            this._thresholdExceeded = true;
            this.thresholdReached();
        }
    }

    protected void resetByteCount() {
        this._thresholdExceeded = false;
        this._written = 0L;
    }

    protected abstract OutputStream stream() throws IOException;

    protected abstract void thresholdReached() throws IOException;
}

