/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSThreadsafeWrapper;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;

public class _NSThreadsafeMutableSet<E>
extends _NSThreadsafeWrapper
implements Serializable {
    public static final Class<_NSThreadsafeMutableSet> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(_NSThreadsafeMutableSet.class);
    static final long serialVersionUID = -4265668114665479254L;
    private static final String SerializationSetFieldKey = "set";
    private static final Class<NSMutableSet> _NSMutableSetClass = NSMutableSet.class;
    private final NSMutableSet<E> _delegate;
    private NSMutableSet<E> _serializationDelegate;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("set", _NSMutableSetClass)};

    public _NSThreadsafeMutableSet(NSMutableSet<E> set) {
        this._delegate = set;
        if (set == null) {
            throw new IllegalArgumentException();
        }
    }

    public NSMutableSet<E> delegate() {
        return this._delegate;
    }

    public Object clone() {
        NSMutableSet clone = null;
        this.acquireReadLock();
        try {
            clone = (NSMutableSet)this._delegate.clone();
        }
        finally {
            this.releaseReadLock();
        }
        return new _NSThreadsafeMutableSet<E>(clone);
    }

    public Enumeration<E> objectEnumerator() {
        this.acquireReadLock();
        try {
            _NSJavaArrayEnumerator _NSJavaArrayEnumerator2 = new _NSJavaArrayEnumerator(this._delegate.objectsNoCopy(), false);
            return _NSJavaArrayEnumerator2;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public int count() {
        this.acquireReadLock();
        try {
            int n = this._delegate.count();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public E member(Object value) {
        this.acquireReadLock();
        try {
            Object e = this._delegate.member(value);
            return e;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void addObject(E value) {
        this.acquireWriteLock();
        try {
            this._delegate.addObject(value);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void addObjectsFromArray(NSArray<E> array) {
        this.acquireWriteLock();
        try {
            this._delegate.addObjectsFromArray(array);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public E removeObject(Object value) {
        this.acquireWriteLock();
        try {
            E e = this._delegate.removeObject(value);
            return e;
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void removeAllObjects() {
        this.acquireWriteLock();
        try {
            this._delegate.removeAllObjects();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public NSSet<E> immutableClone() {
        this.acquireReadLock();
        try {
            NSSet<E> nSSet = this._delegate.immutableClone();
            return nSSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public NSMutableSet<E> mutableClone() {
        this.acquireReadLock();
        try {
            NSMutableSet<E> nSMutableSet = this._delegate.mutableClone();
            return nSMutableSet;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public NSArray<E> allObjects() {
        this.acquireReadLock();
        try {
            NSArray nSArray = this._delegate.allObjects();
            return nSArray;
        }
        finally {
            this.releaseReadLock();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.acquireWriteLock();
        try {
            ObjectOutputStream.PutField fields = s.putFields();
            fields.put(SerializationSetFieldKey, this._delegate);
            s.writeFields();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._serializationDelegate = (NSMutableSet)fields.get(SerializationSetFieldKey, null);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this._serializationDelegate == null) {
            throw new IllegalArgumentException("content array must not be a null reference.");
        }
        return new _NSThreadsafeMutableSet<E>(this._serializationDelegate);
    }
}

