/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSJavaArrayEnumerator;
import com.webobjects.foundation._NSThreadsafeWrapper;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.util.Enumeration;

public class _NSThreadsafeMutableArray<E>
extends _NSThreadsafeWrapper
implements Serializable,
NSKeyValueCoding {
    public static final Class<_NSThreadsafeMutableArray> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(_NSThreadsafeMutableArray.class);
    static final long serialVersionUID = -5889016674885728271L;
    private static final String SerializationArrayFieldKey = "array";
    private static final Class<NSMutableArray> _NSMutableArrayClass = NSMutableArray.class;
    private final NSMutableArray<E> _delegate;
    private NSMutableArray<E> _serializationDelegate;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("array", _NSMutableArrayClass)};

    public _NSThreadsafeMutableArray(NSMutableArray<E> array) {
        this._delegate = array;
        if (array == null) {
            throw new IllegalArgumentException("content array must not be a null reference.");
        }
    }

    public NSMutableArray<E> array() {
        return this._delegate;
    }

    public Enumeration<E> objectEnumerator() {
        this.acquireReadLock();
        try {
            _NSJavaArrayEnumerator _NSJavaArrayEnumerator2 = new _NSJavaArrayEnumerator(this._delegate.objectsNoCopy(), false);
            return _NSJavaArrayEnumerator2;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public String componentsJoinedByString(String separator) {
        this.acquireReadLock();
        try {
            String string = this._delegate.componentsJoinedByString(separator);
            return string;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public NSArray<E> immutableClone() {
        this.acquireReadLock();
        try {
            NSArray<E> nSArray = this._delegate.immutableClone();
            return nSArray;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public Object clone() {
        NSMutableArray clone = null;
        this.acquireReadLock();
        try {
            clone = (NSMutableArray)this._delegate.clone();
        }
        finally {
            this.releaseReadLock();
        }
        return new _NSThreadsafeMutableArray<E>(clone);
    }

    public int count() {
        this.acquireReadLock();
        try {
            int n = this._delegate.count();
            return n;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public E objectAtIndex(int index) {
        this.acquireReadLock();
        try {
            Object e = this._delegate.objectAtIndex(index);
            return e;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void addObject(E object) {
        this.acquireWriteLock();
        try {
            this._delegate.addObject(object);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public void addObjectIfAbsent(E object) {
        this.acquireWriteLock();
        try {
            if (!this._delegate.containsObject(object)) {
                this._delegate.addObject(object);
            }
        }
        finally {
            this.releaseWriteLock();
        }
    }

    public boolean containsObject(Object object) {
        this.acquireReadLock();
        try {
            boolean bl = this._delegate.containsObject(object);
            return bl;
        }
        finally {
            this.releaseReadLock();
        }
    }

    public void removeObject(Object object) {
        this.acquireWriteLock();
        try {
            this._delegate.removeObject(object);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    @Override
    public Object valueForKey(String key) {
        this.acquireReadLock();
        try {
            Object object = this._delegate.valueForKey(key);
            return object;
        }
        finally {
            this.releaseReadLock();
        }
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        this.acquireWriteLock();
        try {
            this._delegate.takeValueForKey(value, key);
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        this.acquireWriteLock();
        try {
            ObjectOutputStream.PutField fields = s.putFields();
            fields.put(SerializationArrayFieldKey, this._delegate);
            s.writeFields();
        }
        finally {
            this.releaseWriteLock();
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        this._serializationDelegate = (NSMutableArray)fields.get(SerializationArrayFieldKey, null);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this._serializationDelegate == null) {
            throw new IllegalArgumentException("content array must not be a null reference.");
        }
        return new _NSThreadsafeMutableArray<E>(this._serializationDelegate);
    }
}

