/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSProperties;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.management.LockInfo;
import java.lang.management.ManagementFactory;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.lang.management.ThreadMXBean;
import java.lang.reflect.Method;
import java.util.Map;
import org.slf4j.Logger;

public class _NSThreadUtilities {
    private static Boolean _shouldFireEvents;
    private static Method _fireEventMethod;
    private static Class<?> _fireEventClass;

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void wait(Object monitoredObject) {
        try {
            monitoredObject.wait();
        }
        catch (InterruptedException interruptedException) {}
    }

    public static void logAllStacksTraces(Logger logger) {
        logger.error("=== full thread dump ===\n" + _NSThreadUtilities.dumpAllStacksTracesAsString() + "\n===");
    }

    public static String dumpAllStacksTracesAsString() {
        StringWriter sw = new StringWriter();
        _NSThreadUtilities.dumpAllStacksTraces(new PrintWriter((Writer)sw, true));
        return sw.toString();
    }

    public static void dumpAllStacksTraces() {
        _NSThreadUtilities.dumpAllStacksTraces(new PrintWriter(System.err));
    }

    public static void dumpAllStacksTraces(PrintWriter ps) {
        if (NSProperties.booleanForKeyWithDefault("_NSThreadUtilities.showLocksInStackTraces", true)) {
            _NSThreadUtilities.dumpAllThreadInfos(ps, true);
            return;
        }
        Map<Thread, StackTraceElement[]> stackTraces = Thread.getAllStackTraces();
        for (Map.Entry<Thread, StackTraceElement[]> stackTraceEntries : stackTraces.entrySet()) {
            Thread t = stackTraceEntries.getKey();
            StackTraceElement[] stackTrace = stackTraceEntries.getValue();
            ps.println("\"" + t.getName() + "\"" + " " + (t.isDaemon() ? "daemon" : "") + " prio=" + t.getPriority() + " Thread id=" + t.getId() + " " + (Object)((Object)t.getState()));
            StackTraceElement[] stackTraceElementArray = stackTrace;
            int n = stackTrace.length;
            int n2 = 0;
            while (n2 < n) {
                StackTraceElement line = stackTraceElementArray[n2];
                ps.println("\t" + line);
                ++n2;
            }
            ps.println("");
        }
    }

    public static void dumpAllThreadInfos(PrintWriter ps, boolean showLocked) {
        ThreadMXBean bean = ManagementFactory.getThreadMXBean();
        ThreadInfoFormatter formatter = new ThreadInfoFormatter();
        ThreadInfo[] threadInfoArray = bean.dumpAllThreads(showLocked, showLocked);
        int n = threadInfoArray.length;
        int n2 = 0;
        while (n2 < n) {
            ThreadInfo info = threadInfoArray[n2];
            ps.print(formatter.format(info));
            ++n2;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void fireEvent(String event) {
        if (_shouldFireEvents == null) {
            Class<_NSThreadUtilities> clazz = _NSThreadUtilities.class;
            // MONITORENTER : com.webobjects.foundation._NSThreadUtilities.class
            try {
                boolean shouldFire = false;
                _fireEventClass = Class.forName("edu.illinois.imunit.IMUnit");
                if (_fireEventClass != null) {
                    _fireEventMethod = _fireEventClass.getDeclaredMethod("fireEvent", String.class);
                    shouldFire = true;
                }
                _shouldFireEvents = NSProperties.booleanForKeyWithDefault("NSShouldFireEvents", shouldFire);
            }
            catch (Exception e) {
                throw new NSForwardException(e);
            }
        }
        if (_shouldFireEvents == false) return;
        try {
            String label = String.valueOf(Thread.currentThread().getName()) + "@" + event;
            System.out.println(">> " + label);
            _fireEventMethod.invoke(_fireEventClass, event);
            System.out.println("<< " + label);
            return;
        }
        catch (Exception e) {
            throw new NSForwardException(e);
        }
    }

    public static class ThreadInfoFormatter {
        public String format(ThreadInfo info) {
            int n;
            StringBuilder sb = new StringBuilder(300);
            sb.append('\"').append(info.getThreadName()).append('\"');
            sb.append(" #").append(info.getThreadId());
            sb.append(" tid=").append(ThreadInfoFormatter.hexString(info.getThreadId()));
            sb.append(" ").append((Object)info.getThreadState());
            LockInfo lockInfo = info.getLockInfo();
            if (lockInfo != null) {
                if (this.inObjectWait(info)) {
                    sb.append(" (on object monitor)");
                } else if (this.isParked(info)) {
                    sb.append(" (parking)");
                } else {
                    sb.append(" (on ").append(this.formatLockInfo(lockInfo)).append(')');
                }
            }
            if (info.getLockOwnerName() != null) {
                sb.append(" owned by \"").append(info.getLockOwnerName());
                sb.append("\" Id=").append(ThreadInfoFormatter.hexString(info.getLockOwnerId()));
            }
            if (info.isSuspended()) {
                sb.append(" (suspended)");
            }
            if (info.isInNative()) {
                sb.append(" (in native)");
            }
            sb.append('\n');
            StackTraceElement[] stackTrace = info.getStackTrace();
            int i = 0;
            while (i < stackTrace.length) {
                StackTraceElement ste = stackTrace[i];
                sb.append("\tat ").append(ste);
                sb.append('\n');
                if (i == 0 && lockInfo != null) {
                    Thread.State ts = info.getThreadState();
                    switch (ts) {
                        case BLOCKED: {
                            sb.append("\t- blocked on ").append(this.formatLockInfo(lockInfo));
                            sb.append('\n');
                            break;
                        }
                        case WAITING: {
                            sb.append("\t- waiting on ").append(this.formatLockInfo(lockInfo));
                            sb.append('\n');
                            break;
                        }
                        case TIMED_WAITING: {
                            if (this.isParked(info)) {
                                sb.append("\t- parking to wait for ").append(this.formatLockInfo(lockInfo));
                            } else {
                                sb.append("\t- waiting on ").append(this.formatLockInfo(lockInfo));
                            }
                            sb.append('\n');
                        }
                    }
                }
                MonitorInfo[] monitorInfoArray = info.getLockedMonitors();
                int n2 = monitorInfoArray.length;
                n = 0;
                while (n < n2) {
                    MonitorInfo mi = monitorInfoArray[n];
                    if (mi.getLockedStackDepth() == i) {
                        sb.append("\t- locked ").append(this.formatLockInfo(mi));
                        sb.append('\n');
                    }
                    ++n;
                }
                ++i;
            }
            LockInfo[] locks = info.getLockedSynchronizers();
            if (locks.length > 0) {
                sb.append("\n\tNumber of locked synchronizers = ").append(locks.length);
                sb.append('\n');
                LockInfo[] lockInfoArray = locks;
                n = locks.length;
                int n3 = 0;
                while (n3 < n) {
                    LockInfo li = lockInfoArray[n3];
                    sb.append("\t- ").append(this.formatLockInfo(li));
                    sb.append('\n');
                    ++n3;
                }
            }
            sb.append('\n');
            return sb.toString();
        }

        protected boolean isParked(ThreadInfo info) {
            return this._threadIn(info, "sun.misc.Unsafe", "park");
        }

        protected boolean inObjectWait(ThreadInfo info) {
            return this._threadIn(info, "java.lang.Object", "wait");
        }

        protected boolean _threadIn(ThreadInfo info, String className, String methodName) {
            StackTraceElement firstFrame;
            StackTraceElement[] stackTrace = info.getStackTrace();
            StackTraceElement stackTraceElement = firstFrame = stackTrace.length > 0 ? stackTrace[0] : null;
            return firstFrame != null && firstFrame.getClassName().equals(className) && firstFrame.getMethodName().equals(methodName);
        }

        protected String formatLockInfo(LockInfo lockInfo) {
            return "<" + ThreadInfoFormatter.hexString(lockInfo.getIdentityHashCode()) + "> (a " + lockInfo.getClassName() + ")";
        }

        private static String hexString(long value) {
            return String.format("0x%015x", value);
        }
    }
}

