/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation._NSUtilitiesExtra;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _NSReadReentrantReaderWriterLock {
    public static final Class<_NSReadReentrantReaderWriterLock> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(_NSReadReentrantReaderWriterLock.class);
    private static final Logger log = LoggerFactory.getLogger(_NSReadReentrantReaderWriterLock.class);
    private int _readingCounter;
    private boolean _readersMustCheck;
    private boolean _writersMustCheck;
    private int _waitingWriters;
    private int _waitingReaders;

    public synchronized void startReading() {
        while (this._readersMustCheck) {
            ++this._waitingReaders;
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                log.debug("An exception occurred", (Throwable)exception);
                this.notify();
            }
            --this._waitingReaders;
        }
        this._writersMustCheck = true;
        ++this._readingCounter;
        if (this._waitingReaders > 0) {
            this.notifyAll();
        }
    }

    public synchronized void endReading() {
        --this._readingCounter;
        if (this._readingCounter == 0) {
            this._writersMustCheck = false;
            if (this._waitingWriters > 0) {
                this.notify();
            }
        } else if (this._readingCounter < 0) {
            this._readingCounter = 0;
            throw new IllegalStateException("Unbalanced call: endReading without corresponding startReading");
        }
    }

    public synchronized void startWriting() {
        while (this._writersMustCheck) {
            ++this._waitingWriters;
            try {
                this.wait();
            }
            catch (InterruptedException exception) {
                log.debug("An exception occurred", (Throwable)exception);
                this.notify();
            }
            --this._waitingWriters;
        }
        this._writersMustCheck = true;
        this._readersMustCheck = true;
    }

    public synchronized void endWriting() {
        boolean error = !this._readersMustCheck;
        this._writersMustCheck = false;
        this._readersMustCheck = false;
        if (this._waitingReaders + this._waitingWriters > 0) {
            this.notify();
        }
        if (error) {
            throw new IllegalStateException("Unbalanced call: endWriting without corresponding startWriting");
        }
    }
}

