/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSProperties;
import java.io.IOException;
import java.lang.reflect.Field;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import sun.misc.Unsafe;

@IgnoreJRERequirement
public final class _NSLZ4 {
    private static final int MEMORY_USAGE = 14;
    private static final int MIN_MATCH = 4;
    private static final int MAX_DISTANCE = 65536;
    private static final int LAST_LITERALS = 5;
    private static final int HASH_LOG_HC = 15;
    private static final int HASH_TABLE_SIZE_HC = 32768;
    private static final int OPTIMAL_ML = 18;
    private static final ByteOrder NATIVE_BYTE_ORDER = ByteOrder.nativeOrder();
    private static final Unsafe Unsafe = _NSLZ4.getUnsafe();
    private static final long BYTE_ARRAY_OFFSET = Unsafe != null ? Unsafe.arrayBaseOffset(byte[].class) : 0;
    private static final long INTEGER_ARRAY_OFFSET = Unsafe != null ? Unsafe.arrayBaseOffset(int[].class) : 0;
    static final ThreadLocal<HCHashTable> _LocalHCHashTable = new ThreadLocal<HCHashTable>(){

        @Override
        protected HCHashTable initialValue() {
            return new HCHashTable();
        }
    };
    static final ThreadLocal<HashTable> _LocalHashTable = new ThreadLocal<HashTable>(){

        @Override
        protected HashTable initialValue() {
            return new HashTable();
        }
    };

    private static Unsafe getUnsafe() {
        if (NSProperties.booleanForKeyWithDefault("_NSLZ4.useUnsafe", true)) {
            try {
                Field f = Unsafe.class.getDeclaredField("theUnsafe");
                f.setAccessible(true);
                return (Unsafe)f.get(null);
            }
            catch (Exception exception) {}
        }
        return null;
    }

    private static int hash(int i, int hashBits) {
        return i * -1640531535 >>> 32 - hashBits;
    }

    private static byte readByte(byte[] buf, int i) {
        if (Unsafe != null) {
            return Unsafe.getByte(buf, BYTE_ARRAY_OFFSET + (long)i);
        }
        return buf[i];
    }

    private static void copyBytes(byte[] src, int i, byte[] dst, int j, int len) {
        if (Unsafe != null) {
            Unsafe.copyMemory(src, BYTE_ARRAY_OFFSET + (long)i, dst, BYTE_ARRAY_OFFSET + (long)j, len);
        } else {
            System.arraycopy(src, i, dst, j, len);
        }
    }

    private static int readIntBE(byte[] buf, int i) {
        return (buf[i] & 0xFF) << 24 | (buf[i + 1] & 0xFF) << 16 | (buf[i + 2] & 0xFF) << 8 | buf[i + 3] & 0xFF;
    }

    private static int readIntLE(byte[] buf, int i) {
        return buf[i] & 0xFF | (buf[i + 1] & 0xFF) << 8 | (buf[i + 2] & 0xFF) << 16 | (buf[i + 3] & 0xFF) << 24;
    }

    private static int readInt(byte[] buf, int i) {
        if (Unsafe != null) {
            return Unsafe.getInt(buf, BYTE_ARRAY_OFFSET + (long)i);
        }
        if (NATIVE_BYTE_ORDER == ByteOrder.BIG_ENDIAN) {
            return _NSLZ4.readIntBE(buf, i);
        }
        return _NSLZ4.readIntLE(buf, i);
    }

    private static int readInt(int[] buf, int i) {
        if (Unsafe != null) {
            return Unsafe.getInt(buf, INTEGER_ARRAY_OFFSET + (long)(i * 4));
        }
        return buf[i];
    }

    private static void writeInt(int[] buf, int i, int value) {
        if (Unsafe != null) {
            Unsafe.putInt(buf, INTEGER_ARRAY_OFFSET + (long)(i * 4), value);
        } else {
            buf[i] = value;
        }
    }

    private static long readUnsafeLong(byte[] buf, int i) {
        return Unsafe.getLong(buf, BYTE_ARRAY_OFFSET + (long)i);
    }

    private static boolean readIntEquals(byte[] buf, int i, int j) {
        if (Unsafe != null) {
            return Unsafe.getInt(buf, BYTE_ARRAY_OFFSET + (long)i) == Unsafe.getInt(buf, BYTE_ARRAY_OFFSET + (long)j);
        }
        return buf[i] == buf[j] && buf[i + 1] == buf[j + 1] && buf[i + 2] == buf[j + 2] && buf[i + 3] == buf[j + 3];
    }

    private static int commonBytes(byte[] b, int ref, int sOff, int limit) {
        assert (ref < sOff);
        int count = 0;
        if (Unsafe != null) {
            while (sOff < limit - 8 && _NSLZ4.readUnsafeLong(b, ref) == _NSLZ4.readUnsafeLong(b, sOff)) {
                count += 8;
                ref += 8;
                sOff += 8;
            }
        }
        while (sOff < limit && _NSLZ4.readByte(b, ref++) == _NSLZ4.readByte(b, sOff++)) {
            ++count;
        }
        return count;
    }

    private _NSLZ4() {
    }

    public static final int maxCompressedLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("length must be >= 0, got " + length);
        }
        return length + length / 255 + 16;
    }

    public static int decompress(byte[] compressed, int decompressedLen, byte[] dest, int dOff) throws IOException {
        return _NSLZ4.decompress(ByteBuffer.wrap(compressed), decompressedLen, dest, dOff);
    }

    public static int decompress(ByteBuffer compressed, int decompressedLen, byte[] dest, int dOff) throws IOException {
        int destEnd = dest.length;
        do {
            int token;
            int literalLen;
            if ((literalLen = (token = compressed.get() & 0xFF) >>> 4) != 0) {
                if (literalLen == 15) {
                    byte len;
                    while ((len = compressed.get()) == -1) {
                        literalLen += 255;
                    }
                    literalLen += len & 0xFF;
                }
                compressed.get(dest, dOff, literalLen);
                dOff += literalLen;
            }
            if (dOff >= decompressedLen || !compressed.hasRemaining()) {
                if (literalLen >= 5 || decompressedLen <= 5) break;
                throw new IOException("Compressed data is invalid. Must end with 5 literals");
            }
            int matchDec = compressed.get() & 0xFF | (compressed.get() & 0xFF) << 8;
            if (matchDec == 0) continue;
            int matchLen = token & 0xF;
            if (matchLen == 15) {
                byte len;
                while ((len = compressed.get()) == -1) {
                    matchLen += 255;
                }
                matchLen += len & 0xFF;
            }
            if (dOff + (matchLen += 4) > decompressedLen - 5) {
                throw new IOException("Compressed data is invalid. Must end with 5 literals");
            }
            int fastLen = matchLen + 7 & 0xFFFFFFF8;
            if (matchDec < matchLen || dOff + fastLen > destEnd) {
                int ref = dOff - matchDec;
                int end = dOff + matchLen;
                while (dOff < end && dOff < destEnd) {
                    dest[dOff] = dest[ref];
                    ++ref;
                    ++dOff;
                }
            } else {
                _NSLZ4.copyBytes(dest, dOff - matchDec, dest, dOff, fastLen);
                dOff += matchLen;
            }
        } while (dOff < decompressedLen);
        return dOff;
    }

    private static void encodeLen(int l, ByteBuffer out) throws IOException {
        while (l >= 255) {
            out.put((byte)-1);
            l -= 255;
        }
        out.put((byte)l);
    }

    private static void encodeLiterals(byte[] bytes, int token, int anchor, int literalLen, ByteBuffer out) throws IOException {
        out.put((byte)token);
        if (literalLen >= 15) {
            _NSLZ4.encodeLen(literalLen - 15, out);
        }
        out.put(bytes, anchor, literalLen);
    }

    private static void encodeLastLiterals(byte[] bytes, int anchor, int literalLen, ByteBuffer out) throws IOException {
        int token = Math.min(literalLen, 15) << 4;
        _NSLZ4.encodeLiterals(bytes, token, anchor, literalLen, out);
    }

    private static void encodeSequence(byte[] bytes, int anchor, int matchRef, int matchOff, int matchLen, ByteBuffer out) throws IOException {
        int literalLen = matchOff - anchor;
        assert (matchLen >= 4);
        int token = Math.min(literalLen, 15) << 4 | Math.min(matchLen - 4, 15);
        _NSLZ4.encodeLiterals(bytes, token, anchor, literalLen, out);
        int matchDec = matchOff - matchRef;
        assert (matchDec > 0 && matchDec < 65536);
        out.put((byte)matchDec);
        out.put((byte)(matchDec >>> 8));
        if (matchLen >= 19) {
            _NSLZ4.encodeLen(matchLen - 15 - 4, out);
        }
    }

    public static int compress(byte[] bytes, int off, int len, byte[] out) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(out);
        _NSLZ4.compress(bytes, off, len, buffer);
        return buffer.position();
    }

    public static int compress(byte[] bytes, int off, int len, byte[] out, HashTable ht) throws IOException {
        ByteBuffer buffer = ByteBuffer.wrap(out);
        _NSLZ4.compress(bytes, off, len, buffer, ht);
        return buffer.position();
    }

    public static void compress(byte[] bytes, int off, int len, ByteBuffer out) throws IOException {
        _NSLZ4.compress(bytes, off, len, out, _LocalHashTable.get());
    }

    public static void compress(byte[] bytes, int off, int len, ByteBuffer out, HashTable ht) throws IOException {
        int base = off;
        int end = off + len;
        if (end == 0 || bytes.length == 0) {
            return;
        }
        int anchor = off++;
        if (len > 9) {
            int limit = end - 5;
            int matchLimit = limit - 4;
            ht.reset(len);
            int hashLog = ht.hashLog;
            int[] hashTable = ht.hashTable;
            block0: while (off <= limit) {
                while (off < matchLimit) {
                    int v = _NSLZ4.readInt(bytes, off);
                    int h = _NSLZ4.hash(v, hashLog);
                    int ref = base + _NSLZ4.readInt(hashTable, h);
                    _NSLZ4.writeInt(hashTable, h, off - base);
                    if (off - ref >= 65536 || _NSLZ4.readInt(bytes, ref) != v) {
                        ++off;
                        continue;
                    }
                    int matchLen = 4 + _NSLZ4.commonBytes(bytes, ref + 4, off + 4, limit);
                    _NSLZ4.encodeSequence(bytes, anchor, ref, off, matchLen, out);
                    anchor = off += matchLen;
                    continue block0;
                }
                break block0;
            }
        }
        int literalLen = end - anchor;
        assert (literalLen >= 5 || literalLen == len);
        _NSLZ4.encodeLastLiterals(bytes, anchor, end - anchor, out);
    }

    public static void compressHC(byte[] src, int srcOff, int srcLen, byte[] out) throws IOException {
        _NSLZ4.compressHC(src, srcOff, srcLen, ByteBuffer.wrap(out), _LocalHCHashTable.get());
    }

    public static void compressHC(byte[] src, int srcOff, int srcLen, byte[] out, HCHashTable ht) throws IOException {
        _NSLZ4.compressHC(src, srcOff, srcLen, ByteBuffer.wrap(out), ht);
    }

    public static void compressHC(byte[] src, int srcOff, int srcLen, ByteBuffer out) throws IOException {
        _NSLZ4.compressHC(src, srcOff, srcLen, out, _LocalHCHashTable.get());
    }

    public static void compressHC(byte[] src, int srcOff, int srcLen, ByteBuffer out, HCHashTable ht) throws IOException {
        int srcEnd = srcOff + srcLen;
        int matchLimit = srcEnd - 5;
        int mfLimit = matchLimit - 4;
        int sOff = srcOff;
        int anchor = sOff++;
        ht.reset(srcOff);
        Match match0 = new Match();
        Match match1 = new Match();
        Match match2 = new Match();
        Match match3 = new Match();
        block0: while (sOff <= mfLimit) {
            if (!ht.insertAndFindBestMatch(src, sOff, matchLimit, match1)) {
                ++sOff;
                continue;
            }
            match1.copyTo(match0);
            block1: while (true) {
                assert (match1.start >= anchor);
                if (match1.end() >= mfLimit || !ht.insertAndFindWiderMatch(src, match1.end() - 2, match1.start + 1, matchLimit, match1.len, match2)) {
                    _NSLZ4.encodeSequence(src, anchor, match1.ref, match1.start, match1.len, out);
                    anchor = sOff = match1.end();
                    continue block0;
                }
                if (match0.start < match1.start && match2.start < match1.start + match0.len) {
                    match0.copyTo(match1);
                }
                assert (match2.start > match1.start);
                if (match2.start - match1.start < 3) {
                    match2.copyTo(match1);
                    continue;
                }
                while (true) {
                    int correction;
                    if (match2.start - match1.start < 18) {
                        int correction2;
                        int newMatchLen = match1.len;
                        if (newMatchLen > 18) {
                            newMatchLen = 18;
                        }
                        if (match1.start + newMatchLen > match2.end() - 4) {
                            newMatchLen = match2.start - match1.start + match2.len - 4;
                        }
                        if ((correction2 = newMatchLen - (match2.start - match1.start)) > 0) {
                            match2.fix(correction2);
                        }
                    }
                    if (match2.start + match2.len >= mfLimit || !ht.insertAndFindWiderMatch(src, match2.end() - 3, match2.start, matchLimit, match2.len, match3)) {
                        if (match2.start < match1.end()) {
                            match1.len = match2.start - match1.start;
                        }
                        _NSLZ4.encodeSequence(src, anchor, match1.ref, match1.start, match1.len, out);
                        anchor = sOff = match1.end();
                        _NSLZ4.encodeSequence(src, anchor, match2.ref, match2.start, match2.len, out);
                        anchor = sOff = match2.end();
                        continue block0;
                    }
                    if (match3.start < match1.end() + 3) {
                        if (match3.start >= match1.end()) {
                            if (match2.start < match1.end()) {
                                correction = match1.end() - match2.start;
                                match2.fix(correction);
                                if (match2.len < 4) {
                                    match3.copyTo(match2);
                                }
                            }
                            _NSLZ4.encodeSequence(src, anchor, match1.ref, match1.start, match1.len, out);
                            anchor = sOff = match1.end();
                            match3.copyTo(match1);
                            match2.copyTo(match0);
                            continue block1;
                        }
                        match3.copyTo(match2);
                        continue;
                    }
                    if (match2.start < match1.end()) {
                        if (match2.start - match1.start < 15) {
                            if (match1.len > 18) {
                                match1.len = 18;
                            }
                            if (match1.end() > match2.end() - 4) {
                                match1.len = match2.end() - match1.start - 4;
                            }
                            correction = match1.end() - match2.start;
                            match2.fix(correction);
                        } else {
                            match1.len = match2.start - match1.start;
                        }
                    }
                    _NSLZ4.encodeSequence(src, anchor, match1.ref, match1.start, match1.len, out);
                    anchor = sOff = match1.end();
                    match2.copyTo(match1);
                    match3.copyTo(match2);
                }
                break;
            }
        }
        _NSLZ4.encodeLastLiterals(src, anchor, srcEnd - anchor, out);
    }

    public static final class HCHashTable {
        final int MAX_ATTEMPTS = 256;
        final int MASK = 65535;
        int nextToUpdate;
        private int base;
        private final int[] hashTable = new int[32768];
        private final short[] chainTable = new short[65536];

        private int hashHC(int i) {
            return _NSLZ4.hash(i, 15);
        }

        private void reset(int base) {
            this.base = base;
            this.nextToUpdate = base;
            Arrays.fill(this.hashTable, -1);
            Arrays.fill(this.chainTable, (short)0);
        }

        private int hashPointer(byte[] bytes, int off) {
            int v = _NSLZ4.readInt(bytes, off);
            int h = this.hashHC(v);
            return _NSLZ4.readInt(this.hashTable, h);
        }

        private int next(int off) {
            return off - (this.chainTable[off & 0xFFFF] & 0xFFFF);
        }

        private void addHash(byte[] bytes, int off) {
            int v = _NSLZ4.readInt(bytes, off);
            int h = this.hashHC(v);
            int delta = off - _NSLZ4.readInt(this.hashTable, h);
            assert (delta > 0) : delta;
            if (delta >= 65536) {
                delta = 65535;
            }
            this.chainTable[off & 0xFFFF] = (short)delta;
            _NSLZ4.writeInt(this.hashTable, h, off);
        }

        private int commonBytesBackward(byte[] b, int o1, int o2, int l1, int l2) {
            int count = 0;
            while (o1 > l1 && o2 > l2 && b[--o1] == b[--o2]) {
                ++count;
            }
            return count;
        }

        void insert(int off, byte[] bytes) {
            while (this.nextToUpdate < off) {
                this.addHash(bytes, this.nextToUpdate);
                ++this.nextToUpdate;
            }
        }

        boolean insertAndFindBestMatch(byte[] buf, int off, int matchLimit, Match match) {
            match.start = off;
            match.len = 0;
            int delta = 0;
            int repl = 0;
            this.insert(off, buf);
            int ref = this.hashPointer(buf, off);
            if (ref >= off - 4 && ref <= off && ref >= this.base) {
                if (_NSLZ4.readIntEquals(buf, ref, off)) {
                    delta = off - ref;
                    repl = match.len = 4 + _NSLZ4.commonBytes(buf, ref + 4, off + 4, matchLimit);
                    match.ref = ref;
                }
                ref = this.next(ref);
            }
            int i = 0;
            while (i < 256) {
                int matchLen;
                if (ref < Math.max(this.base, off - 65536 + 1) || ref > off) break;
                if (_NSLZ4.readByte(buf, ref + match.len) == _NSLZ4.readByte(buf, off + match.len) && _NSLZ4.readIntEquals(buf, ref, off) && (matchLen = 4 + _NSLZ4.commonBytes(buf, ref + 4, off + 4, matchLimit)) > match.len) {
                    match.ref = ref;
                    match.len = matchLen;
                }
                ref = this.next(ref);
                ++i;
            }
            if (repl != 0) {
                int ptr = off;
                int end = off + repl - 3;
                while (ptr < end - delta) {
                    this.chainTable[ptr & 0xFFFF] = (short)delta;
                    ++ptr;
                }
                do {
                    this.chainTable[ptr & 0xFFFF] = (short)delta;
                    _NSLZ4.writeInt(this.hashTable, this.hashHC(_NSLZ4.readInt(buf, ptr)), ptr);
                } while (++ptr < end);
                this.nextToUpdate = end;
            }
            return match.len != 0;
        }

        boolean insertAndFindWiderMatch(byte[] buf, int off, int startLimit, int matchLimit, int minLen, Match match) {
            match.len = minLen;
            this.insert(off, buf);
            int delta = off - startLimit;
            int ref = this.hashPointer(buf, off);
            int i = 0;
            while (i < 256) {
                if (ref < Math.max(this.base, off - 65536 + 1) || ref > off) break;
                if (_NSLZ4.readByte(buf, ref - delta + match.len) == _NSLZ4.readByte(buf, startLimit + match.len) && _NSLZ4.readIntEquals(buf, ref, off)) {
                    int matchLenForward = 4 + _NSLZ4.commonBytes(buf, ref + 4, off + 4, matchLimit);
                    int matchLenBackward = this.commonBytesBackward(buf, ref, off, this.base, startLimit);
                    int matchLen = matchLenBackward + matchLenForward;
                    if (matchLen > match.len) {
                        match.len = matchLen;
                        match.ref = ref - matchLenBackward;
                        match.start = off - matchLenBackward;
                    }
                }
                ref = this.next(ref);
                ++i;
            }
            return match.len > minLen;
        }
    }

    public static final class HashTable {
        private int hashLog;
        private int[] hashTable;

        void reset(int len) {
            int bitsPerOffset = this.bitsRequired(len - 5);
            int bitsPerOffsetLog = 32 - Integer.numberOfLeadingZeros(bitsPerOffset - 1);
            this.hashLog = 17 - bitsPerOffsetLog;
            if (this.hashTable == null || this.hashTable.length < 1 << this.hashLog) {
                this.hashTable = new int[1 << this.hashLog];
            } else {
                Arrays.fill(this.hashTable, 0);
            }
        }

        public int bitsRequired(long maxValue) {
            if (maxValue < 0L) {
                throw new IllegalArgumentException("maxValue must be non-negative (got: " + maxValue + ")");
            }
            return Math.max(1, 64 - Long.numberOfLeadingZeros(maxValue));
        }
    }

    private static class Match {
        int start;
        int ref;
        int len;

        private Match() {
        }

        void fix(int correction) {
            this.start += correction;
            this.ref += correction;
            this.len -= correction;
        }

        int end() {
            return this.start + this.len;
        }

        private void copyTo(Match m2) {
            m2.len = this.len;
            m2.start = this.start;
            m2.ref = this.ref;
        }
    }
}

