/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableDictionary;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;

public class _NSJavaMapKeySetIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    private NSDictionary<K, V> _dict;
    private Object[] _keys;
    private int _limit;
    private int _index;
    private boolean _mutable;

    public _NSJavaMapKeySetIterator(NSDictionary<K, V> dict, Object[] keys, boolean mutable) {
        this._dict = dict;
        this._keys = keys;
        this._limit = keys == null ? 0 : keys.length;
        this._index = 0;
        this._mutable = mutable;
    }

    @Override
    public boolean hasNext() {
        return this._index < this._limit;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (this._index < this._limit) {
            Object k = this._keys[this._index++];
            return new _NSJavaMapEntry<Object, V>(k, this._dict.objectForKey(k));
        }
        throw new NoSuchElementException("Dictionary enumerator is already exhausted");
    }

    @Override
    public void remove() {
        if (this._index >= this._limit) {
            throw new NoSuchElementException("Dictionary enumerator is already exhausted");
        }
        if (!this._mutable) {
            throw new UnsupportedOperationException("You can not remove from an NSDictionary.");
        }
        Object k = this._keys[this._index++];
        ((NSMutableDictionary)this._dict).removeObjectForKey(k);
    }

    public static class _NSJavaMapEntry<K, V>
    implements Map.Entry<K, V> {
        private V _entryValue;
        private K _entryKey;

        public _NSJavaMapEntry(K key, V value) {
            this._entryKey = key;
            this._entryValue = value;
        }

        @Override
        public K getKey() {
            return this._entryKey;
        }

        @Override
        public V getValue() {
            return this._entryValue;
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("setValue is not a supported operation in _JavaNSDictionaryMapEntry");
        }

        @Override
        public boolean equals(Object o) {
            return this._entryKey == null && ((Map.Entry)o).getKey() == null && this.getKey().equals(((Map.Entry)o).getKey()) && this.getValue().equals(((Map.Entry)o).getValue());
        }

        @Override
        public int hashCode() {
            return this._entryKey == null ? System.identityHashCode(this) : this._entryKey.hashCode();
        }

        public String toString() {
            return "[_NSJavaMapKeySetIterator._NSJavaMapEntry: key=" + this._entryKey + ", value=" + this._entryValue + "]";
        }
    }
}

