/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class _NSIntegerKeyDictionary<V>
implements Cloneable,
Serializable,
_NSFoundationCollection {
    public static final Class<_NSIntegerKeyDictionary> _CLASS = _NSUtilities._classWithClassLiteral(_NSIntegerKeyDictionary.class);
    static final long serialVersionUID = -5739902356180760350L;
    private static final String SerializationKeysFieldKey = "keys";
    private static final String SerializationValuesFieldKey = "objects";
    protected transient int _capacity;
    protected transient int _hashtableBuckets;
    protected transient int _count;
    protected V[] _values;
    protected transient V[] _valuesCache;
    protected transient short[] _flags;
    protected int[] _keys;
    protected transient int[] _keysCache;
    protected transient int _hashCache;
    protected static int _NSDictionaryClassHashCode = _CLASS.hashCode();
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("keys", _NSUtilities._NoIntArray.getClass()), new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};

    protected void _initializeDictionary() {
        this._count = 0;
        this._capacity = 0;
        this._valuesCache = null;
        this._values = null;
        this._flags = null;
        this._keysCache = null;
        this._keys = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
    }

    protected void _ensureCapacity(int capacity) {
        int oldCapacity = capacity;
        if (oldCapacity > this._capacity) {
            if (oldCapacity < 4) {
                oldCapacity = 4;
            } else {
                int testCapacity = 2 * this._capacity;
                if (testCapacity > oldCapacity) {
                    oldCapacity = testCapacity;
                }
            }
            int newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity(oldCapacity);
            if (newCapacity != this._capacity) {
                int oldSize = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
                this._capacity = oldCapacity;
                this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
                int newSize = this._hashtableBuckets;
                if (newSize == 0) {
                    this._values = null;
                    this._keys = null;
                    this._flags = null;
                } else {
                    V[] oldValues = this._values;
                    int[] oldKeys = this._keys;
                    short[] oldFlags = this._flags;
                    this._values = new Object[newSize];
                    this._keys = new int[newSize];
                    this._flags = new short[newSize];
                    int i = 0;
                    while (i < oldSize) {
                        if ((oldFlags[i] & 0xFFFFC000) == Short.MIN_VALUE) {
                            _NSCollectionPrimitives.addValueInHashTable(oldKeys[i], oldValues[i], this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets);
                        }
                        ++i;
                    }
                }
            }
        }
    }

    public _NSIntegerKeyDictionary() {
        this._initializeDictionary();
    }

    public _NSIntegerKeyDictionary(V value, int key) {
        if (value == null) {
            throw new IllegalArgumentException("attempt to insert null value into an " + this.getClass().getName() + ".");
        }
        this._initializeDictionary();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueInHashTable(key, value, this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets)) {
            ++this._count;
        }
    }

    private void initFromIntegers(V[] values, int[] keys, boolean checkForNull) {
        int i;
        if (values.length != keys.length) {
            throw new IllegalArgumentException("attempt to create an " + this.getClass().getName() + " with a different number of values and keys.");
        }
        if (checkForNull) {
            i = 0;
            while (i < keys.length) {
                if (values[i] == null) {
                    throw new IllegalArgumentException("attempt to insert null value into an " + this.getClass().getName() + ".");
                }
                ++i;
            }
        }
        this._initializeDictionary();
        this._ensureCapacity(values.length);
        i = 0;
        while (i < values.length) {
            if (_NSCollectionPrimitives.addValueInHashTable(keys[i], values[i], this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets)) {
                ++this._count;
            }
            ++i;
        }
    }

    private _NSIntegerKeyDictionary(V[] values, int[] keys, boolean checkForNull) {
        this.initFromIntegers(values, keys, checkForNull);
    }

    public _NSIntegerKeyDictionary(V[] values, int[] keys) {
        this(values, keys, true);
    }

    public _NSIntegerKeyDictionary(_NSIntegerKeyDictionary<V> otherIntegerKeyDictionary) {
        this._initializeDictionary();
        int[] keys = otherIntegerKeyDictionary.keysNoCopy();
        this._ensureCapacity(keys.length);
        int i = 0;
        while (i < keys.length) {
            if (_NSCollectionPrimitives.addValueInHashTable(keys[i], otherIntegerKeyDictionary.objectForKey(keys[i]), this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets)) {
                ++this._count;
            }
            ++i;
        }
    }

    protected int[] keysNoCopy() {
        if (this._keysCache == null) {
            this._keysCache = this._count == 0 ? _NSCollectionPrimitives.EmptyIntegerArray : _NSCollectionPrimitives.keysInHashTable(this._keys, (Object[])this._values, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._keysCache;
    }

    protected V[] objectsNoCopy() {
        if (this._valuesCache == null) {
            this._valuesCache = this._count == 0 ? _NSCollectionPrimitives.emptyArray() : _NSCollectionPrimitives.valuesInHashTable(this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._valuesCache;
    }

    public int count() {
        return this._count;
    }

    public V objectForKey(int key) {
        if (this._count == 0) {
            return null;
        }
        return _NSCollectionPrimitives.findValueInHashTable(key, this._keys, this._values, this._flags, this._capacity, this._hashtableBuckets);
    }

    public int[] allKeys() {
        if (this._count == 0) {
            return _NSCollectionPrimitives.EmptyIntegerArray;
        }
        return _NSCollectionPrimitives.copyArray(this.keysNoCopy(), this._count);
    }

    public NSArray<V> allObjects() {
        return new NSArray<V>(this.objectsNoCopy());
    }

    public int[] allKeysForObject(Object value) {
        if (value != null) {
            int[] keysArray = this.keysNoCopy();
            int index = 0;
            int[] array = new int[keysArray.length];
            int i = 0;
            while (i < keysArray.length) {
                V temp = this.objectForKey(keysArray[i]);
                if (temp == value) {
                    array[index++] = keysArray[i];
                }
                ++i;
            }
            return index == array.length ? array : _NSCollectionPrimitives.copyArray(array, index);
        }
        return _NSCollectionPrimitives.EmptyIntegerArray;
    }

    public NSArray<V> objectsForKeys(int[] keys) {
        if (keys != null) {
            NSMutableArray<int> array = new NSMutableArray<int>(keys.length);
            int i = 0;
            while (i < keys.length) {
                V value = this.objectForKey(keys[i]);
                if (value != null) {
                    array.addObject((int)value);
                }
                ++i;
            }
            return array;
        }
        return NSArray.emptyArray();
    }

    private boolean _equalsIntegerKeyDictionary(_NSIntegerKeyDictionary<?> otherIntegerKeyDictionary) {
        int count = this.count();
        if (count != otherIntegerKeyDictionary.count()) {
            return false;
        }
        int[] keys = this.keysNoCopy();
        int i = 0;
        while (i < count) {
            V value = this.objectForKey(keys[i]);
            Object otherValue = otherIntegerKeyDictionary.objectForKey(keys[i]);
            if (otherValue == null || !value.equals(otherValue)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualToIntegerKeyDictionary(_NSIntegerKeyDictionary<?> otherIntegerKeyDictionary) {
        if (otherIntegerKeyDictionary == null) {
            return false;
        }
        if (otherIntegerKeyDictionary == this) {
            return true;
        }
        return this._equalsIntegerKeyDictionary(otherIntegerKeyDictionary);
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof _NSIntegerKeyDictionary) {
            return this._equalsIntegerKeyDictionary((_NSIntegerKeyDictionary)object);
        }
        return false;
    }

    @Override
    public int _shallowHashCode() {
        return this.hashCode();
    }

    public int hashCode() {
        return _NSDictionaryClassHashCode ^ this.count();
    }

    public Object clone() {
        return this;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("{");
        int[] keys = this.keysNoCopy();
        int i = 0;
        while (i < keys.length) {
            buffer.append(keys[i]);
            buffer.append(" = " + this.objectForKey(keys[i]));
            buffer.append("; ");
            ++i;
        }
        buffer.append("}");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        int[] keys = this.keysNoCopy();
        int c = keys.length;
        Object[] values = new Object[c];
        int i = 0;
        while (i < c) {
            values[i] = this.objectForKey(keys[i]);
            ++i;
        }
        fields.put(SerializationKeysFieldKey, keys);
        fields.put(SerializationValuesFieldKey, values);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        int[] keys = (int[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoIntArray);
        keys = keys == null ? _NSUtilities._NoIntArray : keys;
        Object[] values = (Object[])fields.get(SerializationValuesFieldKey, _NSUtilities._NoObjectArray);
        values = values == null ? _NSUtilities._NoObjectArray : values;
        this.initFromIntegers(values, keys, true);
    }
}

