/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class _NSGregorianCalendar
extends GregorianCalendar {
    static final long serialVersionUID = -2925803115066575854L;
    public long realtime;
    private static final TimeZone UTC_TIMEZONE = TimeZone.getTimeZone("UTC");

    public _NSGregorianCalendar(NSTimeZone nstz, long millis) {
        this.setTimeZone(nstz);
        this.setTimeInMillis(millis);
    }

    public _NSGregorianCalendar(NSTimeZone nstz, Date ts) {
        long millis = ts.getTime();
        this.setTimeZone(nstz);
        this.setTimeInMillis(millis);
    }

    public void setTimeZone(NSTimeZone nstz) {
        super.setTimeZone(nstz);
    }

    @Override
    public void setTimeZone(TimeZone tz) {
        this.setTimeZone(NSTimeZone._nstimeZoneWithTimeZone(tz));
    }

    @Override
    public TimeZone getTimeZone() {
        TimeZone tz = super.getTimeZone();
        NSTimeZone nstz = NSTimeZone._nstimeZoneWithTimeZone(tz);
        if (!(tz instanceof NSTimeZone)) {
            this.setTimeZone(nstz);
        }
        return nstz;
    }

    @Override
    public long getTimeInMillis() {
        return this.realtime;
    }

    @Override
    public void setTimeInMillis(long millis) {
        this.realtime = millis;
        super.setTimeInMillis(millis);
        this.computeFields();
    }

    @Override
    protected void computeTime() {
        this.time = this.realtime;
    }

    @Override
    protected void computeFields() {
        NSTimestamp ts = new NSTimestamp(this.time);
        GregorianCalendar gmtCal = new GregorianCalendar(UTC_TIMEZONE);
        int offset = ((NSTimeZone)this.getTimeZone()).getOffset(ts);
        boolean isDST = ((NSTimeZone)this.getTimeZone()).isDaylightSavingTimeForTimestamp(ts);
        gmtCal.setTime(new Date(this.time + (long)offset));
        this.set(0, gmtCal.get(0));
        this.set(1, gmtCal.get(1));
        this.set(6, gmtCal.get(6));
        this.set(3, gmtCal.get(3));
        this.set(2, gmtCal.get(2));
        this.set(5, gmtCal.get(5));
        this.set(8, gmtCal.get(8));
        this.set(4, gmtCal.get(4));
        this.set(5, gmtCal.get(5));
        this.set(7, gmtCal.get(7));
        this.set(10, gmtCal.get(10));
        this.set(9, gmtCal.get(9));
        this.set(11, gmtCal.get(11));
        this.set(12, gmtCal.get(12));
        this.set(13, gmtCal.get(13));
        this.set(14, gmtCal.get(14));
        this.set(15, offset);
        this.set(16, isDST ? 1 : 0);
    }
}

