/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.properties.NSIntegerProperty;
import java.io.BufferedReader;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _NSFileUtilities {
    private static final Logger log = LoggerFactory.getLogger(_NSFileUtilities.class);
    public static final NSIntegerProperty retryPeriod = new NSIntegerProperty("NSFileUtilities.resolveLinkRetryPeriod", 5000);
    public static final NSIntegerProperty timeoutPeriod = new NSIntegerProperty("NSFileUtilities.resolveLinkTimeoutPeriod", 60000);

    protected static void freeProcessResources(Process p) {
        if (p != null) {
            try {
                if (p.getInputStream() != null) {
                    p.getInputStream().close();
                }
                if (p.getOutputStream() != null) {
                    p.getOutputStream().close();
                }
                if (p.getErrorStream() != null) {
                    p.getErrorStream().close();
                }
                p.destroy();
            }
            catch (IOException iOException) {}
        }
    }

    public static File resolveLink(String path, String linkName) {
        int retry = retryPeriod.value();
        int timeout = timeoutPeriod.value();
        return _NSFileUtilities.resolveLink(path, linkName, retry, timeout);
    }

    public static File resolveLink(String path, String linkName, int retry, int timeout) {
        File resolvedPath;
        boolean debuggingEnabled = NSProperties.booleanForKeyWithDefault("NSFileUtilities.debugMissingCurrentLinks", false);
        if (debuggingEnabled) {
            log.info("Resolving link (" + linkName + ") for: " + path);
        }
        try {
            File f = new File(path);
            boolean isNamedLink = f.getName().toLowerCase().equals(linkName.toLowerCase());
            long timeoutPoint = System.currentTimeMillis() + (long)timeout;
            if (debuggingEnabled) {
                log.info("Testing isNamedLink: " + f.getName() + " == " + linkName + " ==> " + (isNamedLink ? "true" : "false"));
            }
            int retryCount = 0;
            while (true) {
                if (debuggingEnabled) {
                    String output;
                    block38: {
                        Process task;
                        block37: {
                            output = "";
                            String[] cmd = new String[]{"stat", f.getPath()};
                            task = null;
                            try {
                                try {
                                    task = Runtime.getRuntime().exec(cmd);
                                    while (true) {
                                        try {
                                            task.waitFor();
                                        }
                                        catch (InterruptedException interruptedException) {
                                            continue;
                                        }
                                        break;
                                    }
                                    Throwable throwable = null;
                                    Object var14_16 = null;
                                    try (BufferedReader out = new BufferedReader(new InputStreamReader(task.getInputStream()));){
                                        output = out.readLine();
                                        if (task.exitValue() == 0) break block37;
                                        Throwable throwable2 = null;
                                        Object var17_21 = null;
                                        try (BufferedReader err = new BufferedReader(new InputStreamReader(task.getErrorStream()));){
                                            output = String.valueOf(output) + " ERROR: " + err.readLine();
                                        }
                                        catch (Throwable throwable3) {
                                            if (throwable2 == null) {
                                                throwable2 = throwable3;
                                            } else if (throwable2 != throwable3) {
                                                throwable2.addSuppressed(throwable3);
                                            }
                                            throw throwable2;
                                        }
                                    }
                                    catch (Throwable throwable4) {
                                        if (throwable == null) {
                                            throwable = throwable4;
                                        } else if (throwable != throwable4) {
                                            throwable.addSuppressed(throwable4);
                                        }
                                        throw throwable;
                                    }
                                }
                                catch (Throwable t) {
                                    log.info("Failed to run stat with exception", t);
                                    _NSFileUtilities.freeProcessResources(task);
                                    break block38;
                                }
                            }
                            catch (Throwable throwable) {
                                _NSFileUtilities.freeProcessResources(task);
                                throw throwable;
                            }
                        }
                        _NSFileUtilities.freeProcessResources(task);
                    }
                    log.info("debugMissingCurrentLinks: stat output: " + output);
                }
                resolvedPath = f.getCanonicalFile();
                if (debuggingEnabled) {
                    log.info("Fetched resolved path: " + resolvedPath);
                }
                if (!isNamedLink || !resolvedPath.getName().toLowerCase().equals(linkName.toLowerCase())) {
                    if (debuggingEnabled) {
                        log.info("resolveLink succeeded");
                    }
                    if (retryCount > 0) {
                        log.info("resolveLink: retry helped for path: " + path + " linkName: " + linkName + " after: " + retryCount * retry + " ms (" + retryCount + " * " + retry + ")", (Throwable)new Exception());
                    }
                    break;
                }
                if (debuggingEnabled) {
                    log.info("resolveLink failed");
                }
                if (System.currentTimeMillis() + (long)retry >= timeoutPoint) {
                    log.info("resolveLink: timeout trying to resolve path: " + path + " linkName: " + linkName + " after: " + retryCount * retry + " ms (" + retryCount + " * " + retry + ")", (Throwable)new Exception());
                    break;
                }
                Thread.sleep(retry);
                ++retryCount;
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to safely resolve current path: " + path, e);
        }
        return resolvedPath;
    }

    public static File resolveLinkForFile(File file) {
        int retry = retryPeriod.value();
        int timeout = timeoutPeriod.value();
        return _NSFileUtilities.resolveLinkForFile(file, retry, timeout);
    }

    public static File resolveLinkForFile(File file, int retry, int timeout) {
        boolean debuggingEnabled = NSProperties.booleanForKeyWithDefault("NSFileUtilities.debugMissingCurrentLinks", false);
        if (debuggingEnabled) {
            log.info("resolveLinkForFile (" + file.getAbsolutePath() + ")");
        }
        try {
            long timeoutPoint = System.currentTimeMillis() + (long)timeout;
            int retryCount = 0;
            while (true) {
                boolean isDanglingSymLink = _NSFileUtilities.isDanglingSymbolicLink(file);
                if (debuggingEnabled) {
                    log.info("isDanglingSymLink: " + isDanglingSymLink);
                }
                if (!isDanglingSymLink) {
                    if (debuggingEnabled) {
                        log.info("Resolved link");
                    }
                    if (retryCount > 0) {
                        log.info("resolveLinkForFile: retry helped for file: " + file, (Throwable)new Exception());
                    }
                    return file.getCanonicalFile();
                }
                log.error("Failed to resolve link for file: " + file.getAbsolutePath());
                if (System.currentTimeMillis() + (long)retry >= timeoutPoint) break;
                Thread.sleep(retry);
                ++retryCount;
            }
            log.warn("resolveLinkForFile: timeout trying to resolve file: " + file, (Throwable)new Exception());
            return file.getCanonicalFile();
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to safely resolve current path: " + file.getAbsolutePath(), e);
        }
    }

    public static boolean isDanglingSymbolicLink(String name) throws IOException {
        return _NSFileUtilities.isDanglingSymbolicLink(new File(name));
    }

    public static boolean isDanglingSymbolicLink(File file) throws IOException {
        return _NSFileUtilities.isDanglingSymbolicLink(file.getParentFile(), file.getName());
    }

    public static boolean isDanglingSymbolicLink(File parent, String name) throws IOException {
        File f = new File(parent, name);
        if (!f.exists()) {
            final String localName = f.getName();
            String[] c = parent.list(new FilenameFilter(){

                @Override
                public boolean accept(File d, String n) {
                    return localName.equals(n);
                }
            });
            return c != null && c.length > 0;
        }
        return false;
    }
}

