/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation._NSArrayUtilities;
import com.webobjects.foundation._NSStringUtilities;
import java.io.File;
import java.io.IOException;
import java.util.Enumeration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class _NSDictionaryUtilities {
    private static final Logger log = LoggerFactory.getLogger(_NSDictionaryUtilities.class);

    public static <V> NSDictionary<String, V> extractObjectsForKeysWithPrefix(NSMutableDictionary<String, ? extends V> self, String prefix, boolean removePrefix) {
        if (prefix == null) {
            return null;
        }
        String key = null;
        int prefixLength = prefix.length();
        NSArray keys = self.allKeys();
        NSMutableDictionary<String, V> result = new NSMutableDictionary<String, V>(8);
        int i = 0;
        int c = keys.count();
        while (i < c) {
            key = (String)keys.objectAtIndex(i);
            if (key.startsWith(prefix)) {
                V target = self.removeObjectForKey(key);
                result.setObjectForKey(target, removePrefix ? key.substring(prefixLength) : key);
            }
            ++i;
        }
        return result;
    }

    public static <V> NSMutableDictionary<String, V> mutableValuesForKeys(NSDictionary<?, ? extends V> object, NSArray<String> keys) {
        if (keys == null) {
            return new NSMutableDictionary(0);
        }
        int count = keys.count();
        NSMutableDictionary<String, Object> values = new NSMutableDictionary<String, Object>(count);
        int i = 0;
        while (i < count) {
            String key = keys.objectAtIndex(i);
            Object value = object.valueForKey(key);
            if (value == null) {
                value = NSKeyValueCoding.Utility.nullValue();
            }
            values.setObjectForKey(value, key);
            ++i;
        }
        return values;
    }

    public static <K, V> void translateFromKeysToKeys(NSMutableDictionary<K, V> dic, NSArray<K> currentKeys, NSArray<K> newKeys) {
        Object value;
        int count = currentKeys.count();
        if (count != newKeys.count()) {
            throw new IllegalStateException("translateFromKeysToKeys: key arrays must contain equal number of keys");
        }
        Object nullPlaceholder = new Object();
        NSMutableArray<int> holder = new NSMutableArray<int>(count);
        int i = 0;
        while (i < count) {
            K key = currentKeys.objectAtIndex(i);
            value = dic.removeObjectForKey(key);
            if (value == null) {
                value = nullPlaceholder;
            }
            holder.addObject((int)value);
            ++i;
        }
        dic.removeAllObjects();
        i = 0;
        while (i < count) {
            value = holder.objectAtIndex(i);
            if (value != nullPlaceholder) {
                dic.setObjectForKey(value, newKeys.objectAtIndex(i));
            }
            ++i;
        }
    }

    public static boolean boolValueForKeyDefault(NSDictionary<?, ?> dic, String key, boolean defaultBool) {
        String value = (String)dic.objectForKey(key);
        if (value == null) {
            return defaultBool;
        }
        return value.equals("YES");
    }

    public static <K, V> NSMutableDictionary<K, V> mutablePropertyList(NSDictionary<? extends K, ? extends V> dic) {
        int count = dic.count();
        Object[] objects = new Object[count];
        Object[] keys = new Object[count];
        Enumeration<K> keyEnumerator = dic.keyEnumerator();
        int k = 0;
        while (keyEnumerator.hasMoreElements()) {
            K key = keyEnumerator.nextElement();
            keys[k] = key;
            objects[k] = dic.objectForKey(key);
            if (objects[k] instanceof NSDictionary) {
                objects[k] = _NSDictionaryUtilities.mutablePropertyList((NSDictionary)objects[k]);
            } else if (objects[k] instanceof NSArray) {
                objects[k] = _NSArrayUtilities.mutablePropertyList((NSArray)objects[k]);
            }
            ++k;
        }
        return new NSMutableDictionary<Object, Object>(objects, keys);
    }

    public static boolean writeToFile(NSDictionary<?, ?> dic, String path) {
        boolean returnValue;
        block2: {
            returnValue = true;
            try {
                File file = new File(path);
                _NSStringUtilities.writeToFile(file, NSPropertyListSerialization.stringFromPropertyList(dic));
            }
            catch (RuntimeException e) {
                log.debug("An exception occurred", (Throwable)e);
                if (!(NSForwardException._originalThrowable(e) instanceof IOException)) break block2;
                returnValue = false;
            }
        }
        return returnValue;
    }

    public static boolean containsOnlyNullObjects(NSDictionary<?, ?> dic) {
        NSArray<?> values = dic.allValues();
        int c = values.count();
        int i = 0;
        while (i < c) {
            if (values.objectAtIndex(i) != NSKeyValueCoding.NullValue) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public static boolean containsAnyNullObject(NSDictionary<?, ?> dic) {
        NSArray<?> values = dic.allValues();
        int c = values.count();
        int i = 0;
        while (i < c) {
            if (values.objectAtIndex(i) == NSKeyValueCoding.NullValue) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public static <K, V> void overrideEntriesWithObjectsFromDictionaryKeys(NSMutableDictionary<K, V> self, NSDictionary<?, ? extends V> other, NSArray<? extends K> keys) {
        int i = keys.count() - 1;
        while (i >= 0) {
            K key = keys.objectAtIndex(i);
            V value = other.objectForKey(key);
            if (value != null) {
                self.setObjectForKey(value, key);
            }
            --i;
        }
    }

    public static <K, V> NSDictionary<K, V> dictionaryWithNullValuesForKeys(NSArray<? extends K> keys) {
        NSMutableDictionary<K, NSKeyValueCoding.Null> dict = null;
        int count = keys.count();
        if (count > 0) {
            dict = new NSMutableDictionary<K, NSKeyValueCoding.Null>(count);
            int i = 0;
            while (i < count) {
                K key = keys.objectAtIndex(i);
                dict.setObjectForKey(NSKeyValueCoding.NullValue, key);
                ++i;
            }
        }
        return dict;
    }

    @Deprecated
    public static <V> V nullEnabledValueForKey(NSDictionary<String, ? extends V> dic, String key) {
        if (dic == null) {
            throw new IllegalArgumentException("The dictionary must not be null.");
        }
        V value = dic.objectForKey(key);
        return (V)(value != NSKeyValueCoding.NullValue ? value : null);
    }

    public static <V> V nullSafeObjectForKey(NSDictionary<?, V> dictionary, Object key) {
        V object = dictionary.objectForKey(key == null ? NSKeyValueCoding.NullValue : key);
        return object == NSKeyValueCoding.NullValue ? null : (V)object;
    }

    public static <K, V> void setNullSafeObjectForKey(NSMutableDictionary<K, V> dictionary, V object, K key) {
        NSKeyValueCoding.Null nullSafeKey = key == null ? NSKeyValueCoding.NullValue : key;
        NSKeyValueCoding.Null nullSafeObject = object == null ? NSKeyValueCoding.NullValue : object;
        dictionary.setObjectForKey(nullSafeObject, nullSafeKey);
    }

    public static NSDictionary<String, String> dictionaryWithContentsOfStringsFile(String path) {
        NSDictionary dictionary;
        String string = _NSStringUtilities.stringFromFile(path, null);
        if (string == null) {
            return null;
        }
        try {
            dictionary = string.startsWith("{") ? (NSDictionary)NSPropertyListSerialization.propertyListFromString(string) : (NSDictionary)NSPropertyListSerialization.propertyListFromString(string);
        }
        catch (Exception e) {
            log.debug("An exception occurred", (Throwable)e);
            dictionary = null;
        }
        if (dictionary == null) {
            return null;
        }
        return new NSDictionary<String, String>(dictionary);
    }

    public static NSDictionary<String, ?> dictionaryFromObjectWithKeys(Object object, NSArray<String> keys) {
        NSMutableDictionary<String, Object> result = new NSMutableDictionary<String, Object>();
        if (object != null && keys != null) {
            Enumeration<String> e = keys.objectEnumerator();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(object, key);
                if (value == null) continue;
                result.setObjectForKey(value, key);
            }
        }
        return result.immutableClone();
    }

    public static <K, V> NSDictionary<K, V> dictionaryWithDictionaryAndDictionary(NSDictionary<K, V> dict1, NSDictionary<K, V> dict2) {
        if (dict1 == null || dict1.isEmpty()) {
            return dict2;
        }
        if (dict2 == null || dict2.isEmpty()) {
            return dict1;
        }
        NSMutableDictionary<K, V> result = new NSMutableDictionary<K, V>(dict1);
        result.addEntriesFromDictionary(dict2);
        return result;
    }
}

