/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSReflectionUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.io.StreamCorruptedException;
import java.lang.reflect.Method;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class _NSDelegate
implements Serializable {
    public static final Class<_NSDelegate> _CLASS = _NSUtilities._classWithClassLiteral(_NSDelegate.class);
    private static final Logger log = LoggerFactory.getLogger(_NSDelegate.class);
    private static final Object MethodNotFoundMarker = NSKeyValueCoding.NullValue;
    static final long serialVersionUID = 5174022775928575411L;
    private static final String InterfaceFieldKey = "interface";
    private static final String DelegateFieldKey = "delegate";
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("interface", _NSUtilities._ClassClass), new ObjectStreamField("delegate", _NSUtilities._ObjectClass)};
    private volatile Class<?> _interface;
    private volatile Object _delegate;
    private volatile transient boolean _delegateConformsToInterface;
    private volatile transient NSMutableDictionary<String, Object> _methodsByName;
    private transient String _lastMethodName;
    private transient Method _lastMethod;
    private transient Method[] _interfaceMethods;

    public _NSDelegate(Class<?> delegateInterface) {
        if (delegateInterface == null) {
            throw new IllegalArgumentException("Delegate's interface cannot be null");
        }
        this._interface = delegateInterface;
    }

    public _NSDelegate(Class<?> delegateInterface, Object delegate) {
        this(delegateInterface);
        this.setDelegate(delegate);
    }

    public void setDelegate(Object delegate) {
        this._setupForDelegate(delegate);
    }

    public Object delegate() {
        return this._delegate;
    }

    public boolean delegateConformsToInterface() {
        return this._delegateConformsToInterface;
    }

    private synchronized void _setupForDelegate(Object delegate) {
        this._delegate = delegate;
        this._methodsByName = null;
        this._lastMethodName = null;
        this._lastMethod = null;
        this._interfaceMethods = null;
        if (this._delegate == null) {
            return;
        }
        this._delegateConformsToInterface = this._interface.isAssignableFrom(delegate.getClass());
        this._methodsByName = new NSMutableDictionary(4);
    }

    private Method _cachedMethodForName(String methodName) {
        Object temp = this._methodsByName.objectForKey(methodName);
        if (temp == MethodNotFoundMarker) {
            return null;
        }
        if (temp != null) {
            return (Method)temp;
        }
        Method delegateMethod = null;
        if (this._interfaceMethods == null) {
            this._interfaceMethods = _NSReflectionUtilities.methodsOnClass(this._interface);
        }
        Class<?> delegateClass = this._delegate.getClass();
        int c = this._interfaceMethods == null ? 0 : this._interfaceMethods.length;
        int i = 0;
        while (i < c) {
            if (this._interfaceMethods[i].getName().equals(methodName) && (delegateMethod = _NSDelegate._delegateMethodForInterfaceMethod(methodName, this._interfaceMethods[i], delegateClass)) != null) {
                this._methodsByName.setObjectForKey(delegateMethod, methodName);
                break;
            }
            ++i;
        }
        if (delegateMethod == null) {
            this._methodsByName.setObjectForKey(MethodNotFoundMarker, methodName);
        }
        return delegateMethod;
    }

    private static Method _delegateMethodForInterfaceMethod(String name, Method method, Class<?> delegateClass) {
        try {
            return delegateClass.getMethod(name, method.getParameterTypes());
        }
        catch (NoSuchMethodException e) {
            log.debug("Exception while getting method: {} on class:{}", new Object[]{name, delegateClass.getName(), e});
        }
        catch (SecurityException e) {
            log.debug("Exception while getting method: {} on class:{}", new Object[]{name, delegateClass.getName(), e});
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean respondsTo(String methodName) {
        boolean result;
        if (this._methodsByName == null) {
            return false;
        }
        if (this._delegateConformsToInterface) {
            return true;
        }
        _NSDelegate _NSDelegate2 = this;
        synchronized (_NSDelegate2) {
            if (methodName != this._lastMethodName && !methodName.equals(this._lastMethodName)) {
                this._lastMethodName = methodName;
                this._lastMethod = this._cachedMethodForName(methodName);
            }
            result = this._lastMethod != null;
        }
        return result;
    }

    public Object perform(String methodName) {
        return this._perform(methodName, new Object[0]);
    }

    public Object perform(String methodName, Object arg) {
        return this._perform(methodName, new Object[]{arg});
    }

    public Object perform(String methodName, Object arg1, Object arg2) {
        return this._perform(methodName, new Object[]{arg1, arg2});
    }

    public Object perform(String methodName, Object arg1, Object arg2, Object arg3) {
        return this._perform(methodName, new Object[]{arg1, arg2, arg3});
    }

    public Object perform(String methodName, Object ... args) {
        return this._perform(methodName, args);
    }

    public boolean booleanPerform(String methodName) {
        return (Boolean)this._perform(methodName, new Object[0]);
    }

    public boolean booleanPerform(String methodName, Object arg) {
        return (Boolean)this._perform(methodName, new Object[]{arg});
    }

    public boolean booleanPerform(String methodName, Object arg1, Object arg2) {
        return (Boolean)this._perform(methodName, new Object[]{arg1, arg2});
    }

    public boolean booleanPerform(String methodName, Object arg1, Object arg2, Object arg3) {
        return (Boolean)this._perform(methodName, new Object[]{arg1, arg2, arg3});
    }

    public boolean booleanPerform(String methodName, Object ... args) {
        return (Boolean)this._perform(methodName, args);
    }

    public String toString() {
        String tmpStr = "Class: '" + this._interface.getName() + "'";
        String delegateStr = this._delegate == null ? "null" : this._delegate.toString();
        tmpStr = String.valueOf(tmpStr) + " Object: <" + delegateStr + ">";
        return tmpStr;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Object _perform(String methodName, Object[] args) {
        Method currentMethod = null;
        Object currentDelegate = null;
        if (this._delegate == null) {
            throw new IllegalArgumentException("attempt to invoke method on null delegate");
        }
        _NSDelegate _NSDelegate2 = this;
        synchronized (_NSDelegate2) {
            if (this._lastMethodName != methodName && !methodName.equals(this._lastMethodName)) {
                this._lastMethodName = methodName;
                this._lastMethod = this._cachedMethodForName(methodName);
            }
            currentMethod = this._lastMethod;
            currentDelegate = this._delegate;
        }
        if (currentMethod == null) {
            throw new IllegalArgumentException(currentDelegate.getClass() + " doesn't implement method named " + methodName);
        }
        return NSSelector._safeInvokeMethod(currentMethod, currentDelegate, args);
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        ObjectOutputStream.PutField fields = out.putFields();
        fields.put(InterfaceFieldKey, this._interface);
        fields.put(DelegateFieldKey, this._delegate);
        out.writeFields();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = in.readFields();
        this._interface = (Class)fields.get(InterfaceFieldKey, null);
        if (this._interface == null) {
            throw new StreamCorruptedException("While unarchiving a \"" + this.getClass().getName() + "\" the delegate's interface was missing from the stream.");
        }
        this._delegate = fields.get(DelegateFieldKey, null);
        this._setupForDelegate(this._delegate);
    }
}

