/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation._NSByteArrayOutputStream;
import com.webobjects.foundation._NSStreamUtilities;
import com.webobjects.foundation._NSThresholdingOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class _NSDeferredFileOutputStream
extends _NSThresholdingOutputStream {
    private _NSByteArrayOutputStream _memoryOutputStream;
    private OutputStream _currentOutputStream;
    private File _outputFile;
    private final String _prefix;
    private final String _suffix;
    private final File _directory;
    private boolean _closed = false;

    public _NSDeferredFileOutputStream(int threshold, File outputFile) {
        this(threshold, outputFile, null, null, null);
    }

    public _NSDeferredFileOutputStream(int threshold, String prefix, String suffix, File directory) {
        this(threshold, null, prefix, suffix, directory);
        if (prefix == null) {
            throw new IllegalArgumentException("Temporary file prefix is missing");
        }
    }

    private _NSDeferredFileOutputStream(int threshold, File outputFile, String prefix, String suffix, File directory) {
        super(threshold);
        this._outputFile = outputFile;
        this._memoryOutputStream = new _NSByteArrayOutputStream();
        this._currentOutputStream = this._memoryOutputStream;
        this._prefix = prefix;
        this._suffix = suffix;
        this._directory = directory;
    }

    @Override
    protected OutputStream stream() throws IOException {
        return this._currentOutputStream;
    }

    @Override
    protected void thresholdReached() throws IOException {
        if (this._prefix != null) {
            this._outputFile = File.createTempFile(this._prefix, this._suffix, this._directory);
            this._outputFile.deleteOnExit();
        }
        FileOutputStream fos = new FileOutputStream(this._outputFile);
        this._memoryOutputStream.writeTo(fos);
        this._currentOutputStream = fos;
        this._memoryOutputStream = null;
    }

    public boolean isInMemory() {
        return !this.isThresholdExceeded();
    }

    public byte[] bytes() {
        if (this._memoryOutputStream != null) {
            return this._memoryOutputStream.toByteArray();
        }
        return null;
    }

    public File file() {
        return this._outputFile;
    }

    @Override
    public void close() throws IOException {
        super.close();
        this._closed = true;
    }

    public void writeTo(OutputStream out) throws IOException {
        if (!this._closed) {
            throw new IOException("Stream not closed");
        }
        if (this.isInMemory()) {
            this._memoryOutputStream.writeTo(out);
        } else {
            FileInputStream fis = new FileInputStream(this._outputFile);
            try {
                _NSStreamUtilities.copy(fis, out);
            }
            finally {
                _NSStreamUtilities.closeQuietly(fis);
            }
        }
    }
}

