/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation._NSClosedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.SequenceInputStream;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class _NSByteArrayOutputStream
extends OutputStream {
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private final List<byte[]> _buffers = new ArrayList<byte[]>();
    private int _currentBufferIndex;
    private int _filledBufferSum;
    private byte[] _currentBuffer;
    private int _count;

    public _NSByteArrayOutputStream() {
        this(1024);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public _NSByteArrayOutputStream(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Negative initial size: " + size);
        }
        _NSByteArrayOutputStream _NSByteArrayOutputStream2 = this;
        synchronized (_NSByteArrayOutputStream2) {
            this.needNewBuffer(size);
        }
    }

    private void needNewBuffer(int newcount) {
        if (this._currentBufferIndex < this._buffers.size() - 1) {
            this._filledBufferSum += this._currentBuffer.length;
            ++this._currentBufferIndex;
            this._currentBuffer = this._buffers.get(this._currentBufferIndex);
        } else {
            int newBufferSize;
            if (this._currentBuffer == null) {
                newBufferSize = newcount;
                this._filledBufferSum = 0;
            } else {
                newBufferSize = Math.max(this._currentBuffer.length << 1, newcount - this._filledBufferSum);
                this._filledBufferSum += this._currentBuffer.length;
            }
            ++this._currentBufferIndex;
            this._currentBuffer = new byte[newBufferSize];
            this._buffers.add(this._currentBuffer);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len > b.length || off + len < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (len == 0) {
            return;
        }
        _NSByteArrayOutputStream _NSByteArrayOutputStream2 = this;
        synchronized (_NSByteArrayOutputStream2) {
            int newcount = this._count + len;
            int remaining = len;
            int inBufferPos = this._count - this._filledBufferSum;
            while (remaining > 0) {
                int part = Math.min(remaining, this._currentBuffer.length - inBufferPos);
                System.arraycopy(b, off + len - remaining, this._currentBuffer, inBufferPos, part);
                if ((remaining -= part) <= 0) continue;
                this.needNewBuffer(newcount);
                inBufferPos = 0;
            }
            this._count = newcount;
        }
    }

    @Override
    public synchronized void write(int b) {
        int inBufferPos = this._count - this._filledBufferSum;
        if (inBufferPos == this._currentBuffer.length) {
            this.needNewBuffer(this._count + 1);
            inBufferPos = 0;
        }
        this._currentBuffer[inBufferPos] = (byte)b;
        ++this._count;
    }

    public synchronized int write(InputStream in) throws IOException {
        int readCount = 0;
        int inBufferPos = this._count - this._filledBufferSum;
        int n = in.read(this._currentBuffer, inBufferPos, this._currentBuffer.length - inBufferPos);
        while (n != -1) {
            readCount += n;
            this._count += n;
            if ((inBufferPos += n) == this._currentBuffer.length) {
                this.needNewBuffer(this._currentBuffer.length);
                inBufferPos = 0;
            }
            n = in.read(this._currentBuffer, inBufferPos, this._currentBuffer.length - inBufferPos);
        }
        return readCount;
    }

    public synchronized int size() {
        return this._count;
    }

    @Override
    public void close() throws IOException {
    }

    public synchronized void reset() {
        this._count = 0;
        this._filledBufferSum = 0;
        this._currentBufferIndex = 0;
        this._currentBuffer = this._buffers.get(this._currentBufferIndex);
    }

    public synchronized void writeTo(OutputStream out) throws IOException {
        int remaining = this._count;
        for (byte[] buf : this._buffers) {
            int c = Math.min(buf.length, remaining);
            out.write(buf, 0, c);
            if ((remaining -= c) == 0) break;
        }
    }

    public static InputStream toBufferedInputStream(InputStream input) throws IOException {
        _NSByteArrayOutputStream output = new _NSByteArrayOutputStream();
        output.write(input);
        return output.toBufferedInputStream();
    }

    private InputStream toBufferedInputStream() {
        int remaining = this._count;
        if (remaining == 0) {
            return new _NSClosedInputStream();
        }
        ArrayList<ByteArrayInputStream> list = new ArrayList<ByteArrayInputStream>(this._buffers.size());
        for (byte[] buf : this._buffers) {
            int c = Math.min(buf.length, remaining);
            list.add(new ByteArrayInputStream(buf, 0, c));
            if ((remaining -= c) == 0) break;
        }
        return new SequenceInputStream(Collections.enumeration(list));
    }

    public synchronized byte[] toByteArray() {
        int remaining = this._count;
        if (remaining == 0) {
            return EMPTY_BYTE_ARRAY;
        }
        byte[] newbuf = new byte[remaining];
        int pos = 0;
        for (byte[] buf : this._buffers) {
            int c = Math.min(buf.length, remaining);
            System.arraycopy(buf, 0, newbuf, pos, c);
            pos += c;
            if ((remaining -= c) == 0) break;
        }
        return newbuf;
    }

    public String toString() {
        return new String(this.toByteArray());
    }

    public String toString(String enc) throws UnsupportedEncodingException {
        return new String(this.toByteArray(), enc);
    }
}

