/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSAssert;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSDictionaryUtilities;
import com.webobjects.foundation._NSReflectionUtilities;
import com.webobjects.foundation._NSUtilities;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class _NSArrayUtilities {
    private static final Logger log = LoggerFactory.getLogger(_NSArrayUtilities.class);
    private static final int _SCAN_THRESHOLD = 16;
    public static final NSSelector<String> _nameSelector = new NSSelector("name", null);
    public static final int NotFound = -1;
    private static final Field NSArrayObjectsField = _NSReflectionUtilities.ClassUtil.getDeclaredField(NSArray.class, "_objects");
    public static final String NULL_GROUPING_KEY = "**** NULL GROUPING KEY ****";

    static {
        NSArrayObjectsField.setAccessible(true);
    }

    @Deprecated
    public static Object arrayWithGCDBase(NSArray<?> arr) {
        return _NSArrayUtilities.arrayWithGCDBase(arr.objectsNoCopy());
    }

    @Deprecated
    public static Object arrayWithGCDBase(NSSet<?> set) {
        return _NSArrayUtilities.arrayWithGCDBase(set.objectsNoCopy());
    }

    @Deprecated
    public static Object arrayWithGCDBase(Object[] objects) {
        int c = objects.length;
        Object[] result = new Object[c];
        int i = 0;
        while (i < c) {
            Object index = objects[i];
            if (index == NSKeyValueCoding.NullValue) {
                index = null;
            }
            result[i] = index;
            ++i;
        }
        return result;
    }

    public static NSArray<Integer> indexesForObjectsIndenticalTo(NSArray<?> self, NSArray<?> other) {
        if (other != null) {
            int count = other.count();
            NSMutableArray<int> result = new NSMutableArray<int>(count);
            int i = 0;
            while (i < count) {
                Object object = other.objectAtIndex(i);
                int idx = self.indexOfIdenticalObject(object);
                if (idx >= 0) {
                    result.addObject((int)_NSUtilities.IntegerForInt(idx));
                }
                ++i;
            }
            return result;
        }
        return NSArray.emptyArray();
    }

    public static <T> NSArray<T> objectsAtIndexes(NSArray<? extends T> self, NSArray<Number> indexes) {
        if (indexes != null) {
            int count = indexes.count();
            NSMutableArray<int> result = new NSMutableArray<int>(count);
            int i = 0;
            while (i < count) {
                result.addObject((int)self.objectAtIndex(indexes.objectAtIndex(i).intValue()));
                ++i;
            }
            return result;
        }
        return NSArray.emptyArray();
    }

    public static NSArray<Integer> closestMatchingIndexes(NSArray<? extends Integer> self, int max, boolean selectFirstOnNoMatch) {
        int count = self.count();
        NSMutableArray<int> result = new NSMutableArray<int>(count);
        boolean strippedBig = false;
        int i = 0;
        while (i < count) {
            Integer number = self.objectAtIndex(i);
            int index = number;
            if (index < max) {
                result.addObject((int)number);
            } else {
                strippedBig = true;
            }
            ++i;
        }
        if (result.count() == 0 && count != 0 && max != 0) {
            if (selectFirstOnNoMatch || !strippedBig) {
                result.addObject((int)_NSUtilities.IntegerForInt(0));
            } else {
                result.addObject((int)_NSUtilities.IntegerForInt(max - 1));
            }
        }
        return result;
    }

    public static <T> NSArray<T> arrayExcludingObjectsInArray(NSArray<? extends T> self, NSArray<?> array) {
        NSMutableArray<T> result = null;
        if (self == null || array == null) {
            return self;
        }
        int count = self.count();
        int otherCount = array.count();
        if (otherCount == 0) {
            return self;
        }
        if (count * otherCount < 100) {
            while (count-- > 0) {
                T o = self.objectAtIndex(count);
                if (array.indexOfIdenticalObject(o) >= 0) continue;
                if (result == null) {
                    result = new NSMutableArray<T>();
                }
                result.addObject(o);
            }
        } else {
            NSMutableSet<int> table = new NSMutableSet<int>(otherCount);
            while (otherCount-- > 0) {
                table.addObject((int)array.objectAtIndex(otherCount));
            }
            while (count-- > 0) {
                T o = self.objectAtIndex(count);
                if (table.containsObject(o)) continue;
                if (result == null) {
                    result = new NSMutableArray();
                }
                result.addObject(o);
            }
        }
        return result;
    }

    public static boolean addObjectIfAbsent(NSMutableArray<Object> self, Object object) {
        if (self.indexOfIdenticalObject(object) < 0) {
            self.addObject(object);
            return true;
        }
        return false;
    }

    public static <T> NSMutableArray<T> resultsOfPerformingSelector(NSArray<?> array, NSSelector<T> selector) {
        if (selector == null) {
            throw new IllegalStateException("Cannot execute _resultsOfPerformingSelector with a null selector");
        }
        String selectorName = null;
        NSMutableArray<T> results = new NSMutableArray<T>();
        int count = array.count();
        int i = 0;
        while (i < count) {
            Object value;
            Object object = array.objectAtIndex(i);
            if (object instanceof NSKeyValueCoding) {
                if (selectorName == null) {
                    selectorName = selector.name();
                }
                value = ((NSKeyValueCoding)object).valueForKey(selectorName);
            } else {
                value = NSSelector._safeInvokeSelector(selector, object, null);
            }
            if (value != null) {
                results.addObject(value);
            }
            ++i;
        }
        return results;
    }

    public static <T> NSArray<T> arrayExcludingObjectsFromArray(NSArray<? extends T> array, NSArray<?> excludeObjects) {
        if (array instanceof ArrayExcludingObjectsFromArrayInterface) {
            return ((ArrayExcludingObjectsFromArrayInterface)((Object)array)).arrayExcludingObjectsFromArray(excludeObjects);
        }
        return _NSArrayUtilities._arrayExcludingObjectsFromArray(array, excludeObjects);
    }

    public static <T> NSArray<T> _arrayExcludingObjectsFromArray(NSArray<? extends T> array, NSArray<?> excludeObjects) {
        NSMutableArray<T> excludingArray = new NSMutableArray<T>(array);
        excludingArray.removeObjectsInArray(excludeObjects);
        return excludingArray;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean containsIdenticalObjectsInArray(NSArray<?> array1, NSArray<?> array2) {
        count = array1.count();
        if (array2.count() == count) ** GOTO lbl6
        return false;
lbl-1000:
        // 1 sources

        {
            if (-1 != array1.indexOfIdenticalObject(array2.objectAtIndex(count))) continue;
            return false;
lbl6:
            // 2 sources

            ** while (count-- != 0)
        }
lbl7:
        // 1 sources

        return true;
    }

    public static NSArray<Object> arrayWithValuesForKey(NSArray<?> array, String key) {
        if (array == null) {
            return null;
        }
        int count = array.count();
        NSMutableArray<Object> result = new NSMutableArray<Object>();
        int i = 0;
        while (i < count) {
            Object val = ((NSKeyValueCodingAdditions)array.objectAtIndex(i)).valueForKeyPath(key);
            if (val != null) {
                result.addObject(val);
            }
            ++i;
        }
        return result;
    }

    private static Object scanRange(Object[] array, String name, int min, int max) {
        int i = min;
        while (i < max) {
            Object object = array[i];
            String aName = NSSelector._safeInvokeSelector(_nameSelector, object, null);
            if (name.equals(aName)) {
                return object;
            }
            ++i;
        }
        return null;
    }

    private static Object objectInRange(Object[] array, String name, int min, int max) {
        if (max - min < 16) {
            return _NSArrayUtilities.scanRange(array, name, min, max);
        }
        int mid = min + (max - min) / 2;
        Object object = array[mid];
        String aName = NSSelector._safeInvokeSelector(_nameSelector, object, null);
        int comp = name.compareTo(aName);
        if (comp < 0) {
            return _NSArrayUtilities.objectInRange(array, name, min, mid);
        }
        if (comp > 0) {
            return _NSArrayUtilities.objectInRange(array, name, mid + 1, max);
        }
        return object;
    }

    public static Object objectInSortedArrayWithName(NSArray<?> array, String name) {
        if (name == null) {
            return null;
        }
        if (array == null || array.count() == 0) {
            return null;
        }
        return _NSArrayUtilities.objectInRange(array.objects(), name, 0, array.count());
    }

    public static <E> NSMutableArray<E> mutablePropertyList(NSArray<? extends E> theArray) {
        int count = theArray.count();
        NSMutableArray<E> array = new NSMutableArray<E>();
        int k = 0;
        while (k < count) {
            Object object = theArray.objectAtIndex(k);
            if (object instanceof NSDictionary) {
                object = _NSDictionaryUtilities.mutablePropertyList((NSDictionary)object);
            } else if (object instanceof NSArray) {
                object = _NSArrayUtilities.mutablePropertyList((NSArray)object);
            }
            array.addObject(object);
            ++k;
        }
        return array;
    }

    public static void performSelectorWithEachObjectInArray(Object object, NSSelector<?> selector, NSArray<?> array) {
        if (array == null) {
            return;
        }
        int iCount = array.count();
        int i = 0;
        while (i < iCount) {
            NSSelector._safeInvokeSelector(selector, object, array.objectAtIndex(i));
            ++i;
        }
    }

    public static <T> NSArray<T> resultsOfPerformingSelectorWithEachObjectInArray(Object object, NSSelector<T> selector, NSArray<?> args) {
        if (args == null) {
            return null;
        }
        NSMutableArray<T> results = new NSMutableArray<T>();
        int iCount = args.count();
        int i = 0;
        while (i < iCount) {
            results.addObject(NSSelector._safeInvokeSelector(selector, object, args.objectAtIndex(i)));
            ++i;
        }
        return results;
    }

    public static <T> NSMutableArray<T> mutableArrayFromArray(NSArray<? extends T> array) {
        if (array == null) {
            return new NSMutableArray();
        }
        return NSArray.mutableCloneOf(array);
    }

    private static Object[] _objects(NSArray<?> array) {
        try {
            return (Object[])NSArrayObjectsField.get(array);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new RuntimeException(illegalAccessException);
        }
    }

    private static <E> NSArray<E> convert(Iterator<? extends E> iterator, int size) {
        NSMutableArray<int> nsarray = new NSMutableArray<int>(size);
        while (iterator.hasNext()) {
            E object = iterator.next();
            nsarray.addObject((int)object);
        }
        return nsarray;
    }

    public static <E> NSArray<E> convert(Iterator<? extends E> iterator) {
        return _NSArrayUtilities.convert(iterator, 4);
    }

    public static <E> NSArray<E> convert(Collection<? extends E> collection) {
        Iterator<? extends E> iterator = collection.iterator();
        return _NSArrayUtilities.convert(iterator, collection.size());
    }

    public static <E> NSArray<E> subtract(NSArray<? extends E> sourceArray, NSArray<?> toBeRemovedArray) {
        int toBeRemovedCount;
        if (sourceArray == null || toBeRemovedArray == null) {
            return sourceArray;
        }
        int sourceArrayCount = sourceArray.count();
        int count = sourceArrayCount - (toBeRemovedCount = toBeRemovedArray.count());
        int initalCapacity = count < 0 ? 1 : count;
        NSMutableArray<int> nsarray = new NSMutableArray<int>(initalCapacity);
        Object[] toBeRemovedObjects = _NSArrayUtilities._objects(toBeRemovedArray);
        boolean useSet = toBeRemovedCount > 8;
        Set<Object> unwantedElementSet = useSet ? _NSCollectionPrimitives.toSet(toBeRemovedObjects, 0, toBeRemovedCount) : null;
        Object[] sourceArrayObjects = _NSArrayUtilities._objects(sourceArray);
        int index = 0;
        while (index < sourceArrayCount) {
            boolean containsElement;
            Object element = sourceArrayObjects[index];
            boolean bl = containsElement = useSet ? unwantedElementSet.contains(element) : _NSCollectionPrimitives.contains(toBeRemovedObjects, 0, toBeRemovedCount, element, false);
            if (!containsElement) {
                nsarray.addObject((int)element);
            }
            ++index;
        }
        return nsarray;
    }

    public static <E> Set<E> toSet(NSArray<? extends E> array) {
        Object[] objects = _NSArrayUtilities._objects(array);
        int count = array.count();
        return _NSCollectionPrimitives.toSet(objects, 0, count);
    }

    public static void toArray(NSArray<?> array, Object[] destinationArray) {
        Object[] objects = _NSArrayUtilities._objects(array);
        int index = 0;
        int length = destinationArray.length;
        while (index < length) {
            destinationArray[index] = objects[index];
            ++index;
        }
    }

    public static int indexOf(NSArray<?> array, Object target) {
        Object[] objects = _NSArrayUtilities._objects(array);
        int index = 0;
        int length = array.count();
        while (index < length) {
            Object object = objects[index];
            if (target.equals(object)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    public static boolean contains(NSArray<?> array, Object target) {
        return _NSArrayUtilities.indexOf(array, target) != -1;
    }

    public static int count(NSArray<?> array) {
        return array == null ? 0 : array.count();
    }

    public static <E> NSArray<E> shrink(NSArray<? extends E> array, int size) {
        if (array == null || array.count() == 0) {
            return NSArray.emptyArray();
        }
        if (array.count() <= size) {
            return array;
        }
        int newSize = Math.min(_NSArrayUtilities.count(array), size);
        return new NSArray<Object>(array.objects(new NSRange(0, newSize)));
    }

    public static <K, V> NSDictionary<K, NSSet<V>> setsOfObjectsGroupedByKeyPath(NSArray<?> array, String keyPath) {
        NSDictionary<K, NSArray<V>> d = _NSArrayUtilities.arrayGroupedByKeyPath(array, keyPath);
        Enumeration<K> keyEnumerator = d.keyEnumerator();
        NSMutableDictionary<K, NSSet<V>> result = new NSMutableDictionary<K, NSSet<V>>();
        while (keyEnumerator.hasMoreElements()) {
            K theKey = keyEnumerator.nextElement();
            NSArray<V> objects = d.objectForKey(theKey);
            result.setObjectForKey(new NSSet<V>(objects), theKey);
        }
        return result.immutableClone();
    }

    public static <E> Iterator<NSArray<E>> batchIterator(NSArray<? extends E> array, int batchSize, NSMutableArray<E> nextBatch) {
        return new BatchIterator(array, batchSize, nextBatch);
    }

    public static boolean isEmpty(NSArray<?> array) {
        return array == null || array.count() == 0;
    }

    public static <E> NSArray<E> permute(NSArray<? extends E> array) {
        ArrayList<Object> list = new ArrayList<Object>(Arrays.asList(array.objects()));
        Collections.shuffle(list);
        return new NSArray<Object>(list.toArray());
    }

    public static <E> NSArray<E> sortedArrayUsingComparator(NSArray<? extends E> array, NSComparator comparator) {
        NSArray<E> result;
        if (array != null) {
            if (array.count() < 2) {
                result = array;
            } else {
                try {
                    result = array.sortedArrayUsingComparator(comparator);
                }
                catch (NSComparator.ComparisonException e) {
                    log.error("Exception thrown during sorting.", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            result = null;
        }
        return result;
    }

    public static <E> void exchangeObjectAtIndexWithObjectAtIndex(NSMutableArray<E> array, int firstIndex, int secondIndex) {
        if (array != null) {
            Object firstObject = array.objectAtIndex(firstIndex);
            Object secondObject = array.objectAtIndex(secondIndex);
            if (firstIndex != secondIndex) {
                array.replaceObjectAtIndex(firstObject, secondIndex);
                array.replaceObjectAtIndex(secondObject, firstIndex);
            }
        }
    }

    public static int[] toIntArray(NSArray<? extends Number> array) {
        int[] result = null;
        if (array != null) {
            int count = array.count();
            result = new int[count];
            int i = 0;
            while (i < count) {
                result[i] = array.objectAtIndex(i).intValue();
                ++i;
            }
        }
        return result;
    }

    public static <E> NSArray<E> arrayByRemovingObjectsInArray(NSArray<? extends E> array, NSArray<?> objectsToRemove) {
        NSArray<Object> result = null;
        if (array != null) {
            if (array.count() == 0) {
                result = NSArray.emptyArray();
            } else if (objectsToRemove != null && objectsToRemove.count() > 0) {
                NSMutableArray<E> a = NSArray.mutableCloneOf(array);
                a.removeObjectsInArray(objectsToRemove);
                result = a.immutableClone();
            } else {
                result = NSArray.immutableCloneOf(array);
            }
        }
        return result;
    }

    public static <K> NSDictionary<K, Integer> dictionaryOfObjectsToFrequency(NSArray<? extends K> array) {
        int numberOfObjects = array != null ? array.count() : 0;
        NSMutableDictionary<K, Integer> result = null;
        if (numberOfObjects > 0) {
            NSMutableDictionary<K, Integer> d = new NSMutableDictionary<K, Integer>();
            int i = 0;
            while (i < numberOfObjects) {
                K theObject = array.objectAtIndex(i);
                Integer currentValue = (Integer)d.objectForKey(theObject);
                int currentCount = currentValue != null ? currentValue : 0;
                d.setObjectForKey(currentCount + 1, theObject);
                ++i;
            }
            result = d;
        }
        return result != null ? ((NSDictionary)result).immutableClone() : NSDictionary.emptyDictionary();
    }

    private static Object _firstObjectThatIsInstanceOfClassWithNegating(NSArray<?> array, Class<?> clazz, boolean negate) {
        Object result = null;
        if (array != null && clazz != null) {
            int count = array.count();
            int i = 0;
            while (i < count && result == null) {
                Object theObject = array.objectAtIndex(i++);
                if ((negate || !clazz.isInstance(theObject)) && (!negate || clazz.isInstance(theObject))) continue;
                result = theObject;
            }
        }
        return result;
    }

    public static Object firstObjectThatIsNotInstanceOfClass(NSArray<?> array, Class<?> clazz) {
        return _NSArrayUtilities._firstObjectThatIsInstanceOfClassWithNegating(array, clazz, true);
    }

    public static <E> E firstObjectThatIsInstanceOfClass(NSArray<?> array, Class<? extends E> clazz) {
        return clazz.cast(_NSArrayUtilities._firstObjectThatIsInstanceOfClassWithNegating(array, clazz, false));
    }

    public static <E> NSArray<NSArray<E>> columnize(NSArray<? extends E> array, int columns) {
        if (array == null || array.count() == 0) {
            return NSArray.emptyArray();
        }
        NSMutableArray a = new NSMutableArray();
        int max = array.count() / columns;
        int offset = array.count() % columns;
        if (offset == 0) {
            int i = 0;
            while (i < max) {
                NSMutableArray<E> row = new NSMutableArray<E>();
                int j = 0;
                while (j < columns) {
                    row.addObject(array.objectAtIndex(i + j * max));
                    ++j;
                }
                a.addObject(row);
                ++i;
            }
        } else {
            int i = 0;
            while (i < max) {
                NSMutableArray<E> row = new NSMutableArray<E>();
                int j = 0;
                while (j < offset) {
                    row.addObject(array.objectAtIndex(i + j * max + j));
                    ++j;
                }
                j = 0;
                while (j < columns - offset) {
                    row.addObject(array.objectAtIndex(i + j * max + offset * (max + 1)));
                    ++j;
                }
                a.addObject(row);
                ++i;
            }
            if (offset != 0) {
                NSMutableArray<E> row = new NSMutableArray<E>();
                int i2 = 0;
                while (i2 < offset) {
                    row.addObject(array.objectAtIndex(max + (max + 1) * i2));
                    ++i2;
                }
                a.addObject(row);
            }
        }
        return a;
    }

    public static <E> NSArray<NSArray<E>> rowize(NSArray<? extends E> array, int columns) {
        if (array == null || array.count() == 0) {
            return NSArray.emptyArray();
        }
        NSMutableArray a = new NSMutableArray();
        int rows = array.count() / columns;
        int leftover = array.count() % columns;
        int i = 0;
        while (i < rows) {
            NSMutableArray<E> row = new NSMutableArray<E>();
            int j = 0;
            while (j < columns) {
                row.addObject(array.objectAtIndex(i * columns + j));
                ++j;
            }
            a.addObject(row);
            ++i;
        }
        if (leftover != 0) {
            NSMutableArray<E> row = new NSMutableArray<E>();
            int i2 = 0;
            while (i2 < leftover) {
                row.addObject(array.objectAtIndex(rows * columns + i2));
                ++i2;
            }
            a.addObject(row);
        }
        return a;
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<?> objects, String keyPath) {
        return _NSArrayUtilities.arrayGroupedByKeyPath(objects, keyPath, true, null);
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<?> objects, String keyPath, boolean includeNulls, String valueKeyPath) {
        return _NSArrayUtilities.arrayGroupedByKeyPath(objects, keyPath, includeNulls ? NULL_GROUPING_KEY : null, valueKeyPath);
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByKeyPath(NSArray<?> objects, String keyPath, K nullGroupingKey, String valueKeyPath) {
        NSMutableDictionary result = new NSMutableDictionary();
        Enumeration<?> e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            NSMutableArray existingGroup;
            boolean isNullKey;
            Object eo = e.nextElement();
            Object key = NSKeyValueCodingAdditions.Utility.valueForKeyPath(eo, keyPath);
            boolean bl = isNullKey = key == null || key instanceof NSKeyValueCoding.Null;
            if (isNullKey && nullGroupingKey == null) continue;
            if (isNullKey) {
                key = nullGroupingKey;
            }
            if ((existingGroup = (NSMutableArray)result.objectForKey(key)) == null) {
                existingGroup = new NSMutableArray();
                result.setObjectForKey(existingGroup, key);
            }
            if (valueKeyPath != null) {
                Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(eo, valueKeyPath);
                if (value == null) continue;
                existingGroup.addObject(value);
                continue;
            }
            existingGroup.addObject(eo);
        }
        return result;
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<?> objects, String keyPath, boolean includeNulls) {
        return _NSArrayUtilities.arrayGroupedByToManyKeyPath(objects, keyPath, includeNulls ? NULL_GROUPING_KEY : null);
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<?> objects, String keyPath, K nullGroupingKey) {
        return _NSArrayUtilities.arrayGroupedByKeyPath(objects, keyPath, nullGroupingKey, null);
    }

    public static <K, V> NSDictionary<K, NSArray<V>> arrayGroupedByToManyKeyPath(NSArray<?> objects, String keyPath, K nullGroupingKey, String valueKeyPath) {
        NSMutableDictionary result = new NSMutableDictionary();
        Enumeration<?> e = objects.objectEnumerator();
        while (e.hasMoreElements()) {
            boolean isNullKey;
            Object object = e.nextElement();
            Object key = NSKeyValueCodingAdditions.Utility.valueForKeyPath(object, keyPath);
            boolean bl = isNullKey = key == null || key instanceof NSKeyValueCoding.Null;
            if (isNullKey && nullGroupingKey == null) continue;
            if (isNullKey) {
                key = nullGroupingKey;
            }
            NSArray array = (NSArray)key;
            Enumeration keys = array.objectEnumerator();
            while (keys.hasMoreElements()) {
                key = keys.nextElement();
                NSMutableArray existingGroup = (NSMutableArray)result.objectForKey(key);
                if (existingGroup == null) {
                    existingGroup = new NSMutableArray();
                    result.setObjectForKey(existingGroup, key);
                }
                if (valueKeyPath != null) {
                    Object value = NSKeyValueCodingAdditions.Utility.valueForKeyPath(object, valueKeyPath);
                    if (value == null) continue;
                    existingGroup.addObject(value);
                    continue;
                }
                existingGroup.addObject(object);
            }
        }
        return result;
    }

    public static interface ArrayExcludingObjectsFromArrayInterface<E> {
        public NSArray<E> arrayExcludingObjectsFromArray(NSArray<?> var1);
    }

    private static final class BatchIterator<E>
    implements Iterator<NSArray<E>> {
        private final Object[] _sourceObjects;
        private final int _sourceCount;
        private final int _batchSize;
        private final NSMutableArray<E> _batchArray;
        private int _nextSourceIndex;

        private BatchIterator(NSArray<? extends E> sourceArray, int batchSize, NSMutableArray<E> batchArray) {
            this._sourceCount = sourceArray.count();
            this._sourceObjects = _NSArrayUtilities._objects(sourceArray);
            this._batchSize = batchSize;
            this._batchArray = batchArray;
            this._nextSourceIndex = 0;
        }

        @Override
        public boolean hasNext() {
            return this._nextSourceIndex < this._sourceCount;
        }

        @Override
        public NSArray<E> next() {
            this._batchArray.removeAllObjects();
            int batchEndIndex = Math.min(this._nextSourceIndex + this._batchSize, this._sourceCount);
            int index = this._nextSourceIndex;
            while (index < batchEndIndex) {
                Object object = this._sourceObjects[index];
                this._batchArray.addObject(object);
                ++index;
            }
            this._nextSourceIndex = batchEndIndex;
            return this._batchArray;
        }

        @Override
        public void remove() {
            _NSAssert.notSupported();
        }
    }
}

