/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSCollectionPrimitives;
import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

class SubList<E>
extends AbstractList<E> {
    private static final long serialVersionUID = -1000018024349250135L;
    public static final int NotFound = -1;
    List<E> _supportingList;
    List<E> _parentList;
    int _offset;
    int _size;

    SubList(List<E> list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        if (list instanceof NSMutableArray) {
            this._parentList = list;
        }
        this._supportingList = list;
        this._offset = fromIndex;
        this._size = toIndex - fromIndex;
    }

    protected SubList(NSMutableArray<E> parentList, NSMutableArray<E> list, int fromIndex, int toIndex) {
        if (fromIndex < 0) {
            throw new IndexOutOfBoundsException("fromIndex = " + fromIndex);
        }
        if (toIndex > list.size()) {
            throw new IndexOutOfBoundsException("toIndex = " + toIndex);
        }
        if (fromIndex > toIndex) {
            throw new IllegalArgumentException("fromIndex(" + fromIndex + ") > toIndex(" + toIndex + ")");
        }
        this._parentList = parentList;
        this._supportingList = list;
        this._offset = fromIndex;
        this._size = toIndex - fromIndex + 1;
    }

    @Override
    public E set(int index, E t) {
        this.rangeCheck(index);
        return this._supportingList.set(index + this._offset, t);
    }

    @Override
    public E get(int index) {
        this.rangeCheck(index);
        return this._supportingList.get(index + this._offset);
    }

    private final int _findObjectInParentArray(int index, int length, Object object, boolean identical) {
        if (this.size() > 0) {
            Object[] objects = this._supportingList.toArray();
            int maxIndex = index + length - 1;
            int i = index;
            while (i <= maxIndex) {
                if (objects[i] == object) {
                    return i - index;
                }
                ++i;
            }
            if (!identical) {
                i = index;
                while (i <= maxIndex) {
                    if (object.equals(objects[i])) {
                        return i - index;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    private final int _findObjectInSubList(int index, int length, Object object, boolean identical) {
        if (this.size() > 0) {
            Object[] objects = ((SubList)this._supportingList).objectsInRange(new NSRange(this._offset, this._offset + this._size));
            int maxIndex = index + length - 1;
            int i = index;
            while (i <= maxIndex) {
                if (objects[i] == object) {
                    return i - index;
                }
                ++i;
            }
            if (!identical) {
                i = index;
                while (i <= maxIndex) {
                    if (object.equals(objects[i])) {
                        return i - index;
                    }
                    ++i;
                }
            }
        }
        return -1;
    }

    @Override
    public boolean contains(Object element) {
        if (element == null) {
            return false;
        }
        if (this._supportingList instanceof SubList) {
            return this._findObjectInSubList(this._offset, this._size, element, false) != -1;
        }
        return this._findObjectInParentArray(this._offset, this._size, element, false) != -1;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            return false;
        }
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSArray || object instanceof SubList || object instanceof List) {
            return this._equalsArray((List)object);
        }
        return false;
    }

    private boolean _equalsArray(List<?> otherArray) {
        int count = this.size();
        if (count != otherArray.size()) {
            return false;
        }
        Object[] objects = this.toArray();
        Object[] otherObjects = this.toArray();
        int i = 0;
        while (i < count) {
            if (!objects[i].equals(otherObjects[i])) {
                return false;
            }
            ++i;
        }
        return true;
    }

    @Override
    public int size() {
        return this._size;
    }

    @Override
    public int indexOf(Object elem) {
        int i = 0;
        while (i < this._size) {
            if (this.get(i).equals(elem)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this._size == 0;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retainAll(Collection<?> c) {
        void var7_8;
        Object[] objs;
        boolean modified = false;
        ArrayList<Object> toRemove = new ArrayList<Object>();
        Object[] objectArray = objs = this.toArray();
        int n = objs.length;
        boolean n2 = false;
        while (var7_8 < n) {
            Object obj = objectArray[var7_8];
            if (!c.contains(obj)) {
                toRemove.add(obj);
            }
            ++var7_8;
        }
        if (!toRemove.isEmpty()) {
            modified = true;
            for (Object e : toRemove) {
                this.remove(e);
            }
        }
        return modified;
    }

    @Override
    public E remove(int index) {
        this.rangeCheck(index);
        E result = this._supportingList.remove(index + this._offset);
        --this._size;
        return result;
    }

    @Override
    public boolean remove(Object obj) {
        if (this._supportingList.remove(obj)) {
            --this._size;
            return true;
        }
        return false;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        Object[] objectArray = collection.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            if (!this.remove(obj)) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    @Override
    public void clear() {
        this.removeRange(0, this._size - 1);
    }

    public Object clone() {
        ArrayList<Object> newList = new ArrayList<Object>();
        Object[] objectArray = this.toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            Object obj = objectArray[n2];
            newList.add(obj);
            ++n2;
        }
        return newList;
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        this.rangeCheck(fromIndex, toIndex);
        int i = this._offset + toIndex;
        while (i >= this._offset + fromIndex) {
            this._supportingList.remove(i);
            --i;
        }
        this._size -= toIndex - fromIndex + 1;
    }

    public void logState(String prefix) {
        System.out.println(String.valueOf(prefix) + " _size: " + this._size + " _offset=" + this._offset + "\n supportingList: " + this._supportingList + "\nsub:" + this.toString());
    }

    @Override
    public void add(int index, E element) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException();
        }
        this._supportingList.add(index + this._offset, element);
        ++this._size;
    }

    @Override
    public boolean add(E element) {
        this.add(this._size, element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this._size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._size);
        }
        int cSize = c.size();
        if (cSize == 0) {
            return false;
        }
        this._supportingList.addAll(this._offset + index, c);
        this._size += cSize;
        return true;
    }

    public Object[] objectsInRange(NSRange range) {
        if (range == null) {
            return _NSCollectionPrimitives.EmptyArray;
        }
        int rangeLength = range.length();
        Object[] objects = new Object[rangeLength];
        System.arraycopy(this._supportingList.toArray(), range.location(), objects, 0, rangeLength);
        return objects;
    }

    @Override
    public Object[] toArray() {
        return this.objectsInRange(new NSRange(this._offset, this._size));
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        if (objects == null) {
            throw new NullPointerException("List.toArray() cannot have a null parameter");
        }
        int count = this.size();
        if (count <= 0) {
            return objects;
        }
        Object[] result = objects;
        if (result.length < count) {
            result = (Object[])Array.newInstance(result.getClass().getComponentType(), count);
        }
        int j = 0;
        while (j < result.length) {
            result[j] = j < count ? this.get(j) : null;
            ++j;
        }
        return result;
    }

    @Override
    public String toString() {
        Object[] objs = this.toArray();
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("( ");
        int i = 0;
        while (i < objs.length) {
            buffer.append(objs[i]);
            if (i < objs.length - 1) {
                buffer.append(", ");
            }
            ++i;
        }
        buffer.append(" )");
        return new String(buffer);
    }

    @Override
    public Iterator<E> iterator() {
        return this.listIterator(0);
    }

    @Override
    public int lastIndexOf(Object o) {
        int lastIndex = -1;
        int i = this._offset;
        while (i < this._offset + this._size) {
            E curr = this._supportingList.get(i);
            if (curr.equals(o)) {
                lastIndex = i - this._offset;
            }
            ++i;
        }
        return lastIndex;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this._size) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: " + this._size);
        }
        return new ListIterator<E>(index){
            private ListIterator<E> _supportingListIterator;
            {
                this._supportingListIterator = SubList.this._supportingList.listIterator(n + SubList.this._offset);
            }

            @Override
            public boolean hasNext() {
                return this.nextIndex() < SubList.this._size;
            }

            @Override
            public E next() {
                if (this.hasNext()) {
                    return this._supportingListIterator.next();
                }
                throw new NoSuchElementException();
            }

            @Override
            public boolean hasPrevious() {
                return this.previousIndex() >= 0;
            }

            @Override
            public E previous() {
                if (this.hasPrevious()) {
                    return this._supportingListIterator.previous();
                }
                throw new NoSuchElementException();
            }

            @Override
            public int nextIndex() {
                return this._supportingListIterator.nextIndex() - SubList.this._offset;
            }

            @Override
            public int previousIndex() {
                return this._supportingListIterator.previousIndex() - SubList.this._offset;
            }

            @Override
            public void remove() {
                this._supportingListIterator.remove();
                --SubList.this._size;
            }

            @Override
            public void set(E o) {
                this._supportingListIterator.set(o);
            }

            @Override
            public void add(E o) {
                this._supportingListIterator.add(o);
                ++SubList.this._size;
            }
        };
    }

    private void rangeCheck(int fromIndex, int toIndex) {
        if (fromIndex < 0 || fromIndex >= this._size) {
            throw new IndexOutOfBoundsException("Index: " + fromIndex + ",Size: " + this._size);
        }
        if (toIndex < 0 || toIndex > this._size) {
            throw new IndexOutOfBoundsException("Index: " + toIndex + ",Size: " + this._size);
        }
    }

    private void rangeCheck(int index) {
        if (index < 0 || index >= this._size) {
            throw new IndexOutOfBoundsException("Index: " + index + ",Size: " + this._size);
        }
    }
}

