/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSReflectionUtilities;
import com.webobjects.foundation._NSThreadsafeMutableSet;
import com.webobjects.foundation._NSUtilities;
import java.lang.reflect.Method;

public interface NSValidation {
    public static final Class<NSValidation> _CLASS = _NSUtilities._classWithClassLiteral(NSValidation.class);

    public Object validateValueForKey(Object var1, String var2) throws ValidationException;

    public Object validateTakeValueForKeyPath(Object var1, String var2) throws ValidationException;

    public static class DefaultImplementation {
        public static final Class<DefaultImplementation> _CLASS = _NSUtilities._classWithClassLiteral(DefaultImplementation.class);
        private static final _NSThreadsafeMutableSet<_ValidationBinding> _validationBindings = new _NSThreadsafeMutableSet<int>(new NSMutableSet<int>(256));

        DefaultImplementation() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }

        public static void _flushCaches() {
            _validationBindings.removeAllObjects();
        }

        public static Object validateValueForKey(Object object, Object value, String key) throws ValidationException {
            return DefaultImplementation._validateValueForKey(object, value, key, null);
        }

        public static Object _validateValueForKey(Object object, Object value, String key, Class<?> valueBaseInterfaceHint) throws ValidationException {
            if (key == null) {
                return value;
            }
            Class<?> objectClass = object.getClass();
            _ValidationBinding validationBinding = _validationBindings.member(new _ValidationBinding(objectClass, key));
            if (validationBinding == null) {
                Method method = _NSReflectionUtilities._keyManipulationMethodWithPrefix(objectClass, "validate", key, value != null ? value.getClass() : null, valueBaseInterfaceHint);
                validationBinding = method != null ? new _MethodBinding(objectClass, key, method) : new _ValidationBinding(objectClass, key);
                _validationBindings.addObject(validationBinding);
            }
            return validationBinding.validateValueOnObject(value, object);
        }

        public static Object validateTakeValueForKeyPath(Object object, Object value, String keyPath) throws ValidationException {
            if (keyPath == null) {
                throw new IllegalArgumentException("Key path cannot be null");
            }
            int index = keyPath.indexOf(46);
            if (index < 0) {
                Object validatedValue = Utility.validateValueForKey(object, value, keyPath);
                Object currentValue = NSKeyValueCoding.Utility.valueForKey(object, keyPath);
                if (!(currentValue == validatedValue || validatedValue != null && currentValue != null && validatedValue.equals(currentValue))) {
                    NSKeyValueCoding.Utility.takeValueForKey(object, validatedValue, keyPath);
                }
                return validatedValue;
            }
            String key = keyPath.substring(0, index);
            Object targetObject = NSKeyValueCoding.Utility.valueForKey(object, key);
            return targetObject != null ? Utility.validateTakeValueForKeyPath(targetObject, value, keyPath.substring(index + 1)) : null;
        }
    }

    public static class Utility {
        public static final Class<Utility> _CLASS = _NSUtilities._classWithClassLiteral(Utility.class);

        Utility() {
            throw new IllegalStateException("Cannot instantiate an instance of class " + this.getClass().getName());
        }

        public static Object validateValueForKey(Object object, Object value, String key) throws ValidationException {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSValidation) {
                return ((NSValidation)object).validateValueForKey(value, key);
            }
            return DefaultImplementation.validateValueForKey(object, value, key);
        }

        public static Object validateTakeValueForKeyPath(Object object, Object value, String keyPath) throws ValidationException {
            if (object == null) {
                throw new IllegalArgumentException("Object cannot be null");
            }
            if (object instanceof NSValidation) {
                return ((NSValidation)object).validateTakeValueForKeyPath(value, keyPath);
            }
            return DefaultImplementation.validateTakeValueForKeyPath(object, value, keyPath);
        }
    }

    public static class ValidationException
    extends RuntimeException {
        private static final long serialVersionUID = 7884335820425213084L;
        public static final Class<ValidationException> _CLASS = _NSUtilities._classWithClassLiteral(ValidationException.class);
        @Deprecated
        public static final String ValidatedObjectUserInfoKey = "NSValidatedObjectUserInfoKey";
        @Deprecated
        public static final String ValidatedKeyUserInfoKey = "NSValidatedKeyUserInfoKey";
        @Deprecated
        public static final String AdditionalExceptionsKey = "NSAdditionalExceptionsKey";
        private NSDictionary<String, Object> _userInfo;

        public static ValidationException aggregateExceptionWithExceptions(NSArray<ValidationException> aggregateExceptions) {
            int count;
            if (aggregateExceptions != null && (count = aggregateExceptions.count()) > 0) {
                ValidationException exception = aggregateExceptions.objectAtIndex(0);
                if (count == 1) {
                    return exception;
                }
                NSMutableArray<int> exceptions = new NSMutableArray<int>(count);
                NSArray<ValidationException> additionalExceptions = exception.additionalExceptions();
                if (additionalExceptions != null && additionalExceptions.count() > 0) {
                    exceptions.addObjectsFromArray(additionalExceptions);
                }
                int i = 1;
                while (i < count) {
                    ValidationException otherException = aggregateExceptions.objectAtIndex(i);
                    exceptions.addObject((int)otherException);
                    additionalExceptions = otherException.additionalExceptions();
                    if (additionalExceptions != null && additionalExceptions.count() > 0) {
                        exceptions.addObjectsFromArray(additionalExceptions);
                    }
                    ++i;
                }
                NSDictionary<String, Object> userInfo = exception.userInfo();
                NSMutableDictionary<String, Object> dictionary = null;
                dictionary = userInfo != null ? (userInfo instanceof NSMutableDictionary ? (NSMutableDictionary<String, Object>)userInfo : new NSMutableDictionary<String, Object>(userInfo)) : new NSMutableDictionary<String, Object>(1);
                dictionary.setObjectForKey(exceptions, AdditionalExceptionsKey);
                exception._userInfo = dictionary;
                return exception;
            }
            return null;
        }

        public ValidationException(String message) {
            this(message, (NSDictionary<String, Object>)null);
        }

        public ValidationException(String message, Object object, String key) {
            super(message);
            NSMutableDictionary<String, Object> dictionary = new NSMutableDictionary<String, Object>(2);
            if (object != null) {
                dictionary.setObjectForKey(object, ValidatedObjectUserInfoKey);
            }
            if (key != null) {
                dictionary.setObjectForKey(key, ValidatedKeyUserInfoKey);
            }
            this._userInfo = dictionary;
        }

        @Deprecated
        public ValidationException(String message, NSDictionary<String, Object> userInfo) {
            super(message);
            this._userInfo = userInfo != null ? (NSDictionary)userInfo.clone() : NSDictionary.emptyDictionary();
        }

        public Object object() {
            return this.userInfo().objectForKey(ValidatedObjectUserInfoKey);
        }

        public String key() {
            return (String)this.userInfo().objectForKey(ValidatedKeyUserInfoKey);
        }

        public NSArray<ValidationException> additionalExceptions() {
            return (NSArray)this.userInfo().objectForKey(AdditionalExceptionsKey);
        }

        @Deprecated
        public NSDictionary<String, Object> userInfo() {
            return this._userInfo;
        }

        @Deprecated
        public ValidationException exceptionAddingEntriesToUserInfo(Object object, String key) {
            return this.exceptionWithObjectAndKey(object, key);
        }

        public ValidationException exceptionWithObjectAndKey(Object object, String key) {
            NSMutableDictionary<String, Object> dictionary;
            NSDictionary<String, Object> userInfo = this.userInfo();
            NSMutableDictionary<String, Object> nSMutableDictionary = dictionary = userInfo != null ? new NSMutableDictionary<String, Object>(userInfo) : new NSMutableDictionary(2);
            if (object != null) {
                dictionary.setObjectForKey(object, ValidatedObjectUserInfoKey);
            }
            if (key != null) {
                dictionary.setObjectForKey(key, ValidatedKeyUserInfoKey);
            }
            this._userInfo = dictionary;
            return this;
        }
    }

    public static class _MethodBinding
    extends _ValidationBinding {
        protected Method _method;

        public _MethodBinding(Class<? extends Object> targetClass, String key, Method method) {
            super(targetClass, key);
            this._method = method;
        }

        @Override
        public Object validateValueOnObject(Object value, Object object) throws ValidationException {
            return _NSReflectionUtilities._invokeMethodOnObject(object, this._method, new Object[]{value});
        }

        @Override
        public String toString() {
            return String.valueOf(super.toString()) + ", method = " + (this._method != null ? this._method.toString() : "<NULL>");
        }
    }

    public static class _ValidationBinding {
        public static final Class<_ValidationBinding> _CLASS = _NSUtilities._classWithClassLiteral(_ValidationBinding.class);
        protected Class<? extends Object> _targetClass;
        protected String _key;
        private int _hashCode;

        public _ValidationBinding(Class<? extends Object> targetClass, String key) {
            this._targetClass = targetClass;
            this._key = key;
            this._hashCode = targetClass != null && this._key != null ? this._targetClass.hashCode() ^ this._key.hashCode() : 0;
        }

        public final Class<? extends Object> targetClass() {
            return this._targetClass;
        }

        public final String key() {
            return this._key;
        }

        public final int hashCode() {
            return this._hashCode;
        }

        public final boolean isEqualToValidationBinding(_ValidationBinding otherValidationBinding) {
            if (otherValidationBinding == null) {
                return false;
            }
            if (otherValidationBinding == this) {
                return true;
            }
            return this._targetClass == otherValidationBinding._targetClass && (this._key == otherValidationBinding._key || this._key.equals(otherValidationBinding._key));
        }

        public final boolean equals(Object object) {
            return object instanceof _ValidationBinding ? this.isEqualToValidationBinding((_ValidationBinding)object) : false;
        }

        public Object validateValueOnObject(Object value, Object object) throws ValidationException {
            return value;
        }

        public String toString() {
            return String.valueOf(this.getClass().getName()) + ": target class = " + (this._targetClass != null ? this._targetClass.getName() : "<NULL>") + ", key = " + (this._key != null ? this._key : "<NULL>");
        }
    }
}

