/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSNumberFormatter;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSPropertyListSerialization;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation._NSGregorianCalendar;
import com.webobjects.foundation._NSThreadsafeMutableDictionary;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.text.DateFormat;
import java.text.DateFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSTimestampFormatter
extends Format
implements Serializable {
    public static final Class<NSTimestampFormatter> _CLASS = _NSUtilities._classWithClassLiteral(NSTimestampFormatter.class);
    private static final Logger log = LoggerFactory.getLogger(NSTimestampFormatter.class);
    private static final int __NOT_FOUND = -1;
    private static final String[] _patterns = new String[]{"EEE", "EEEE", "MMM", "MMMM", "_localizedDateTimePattern()", "dd", "d", "SSS", "HH", "hh", "DDD", "MM", "mm", "aa", "ss", "EE", "_localizedDatePattern()", "_localizedTimePattern()", "yy", "yyyy", "zzzz", "zzzz"};
    private static final char _QuoteCharacter = '\'';
    private static final char _SpecifierCharacter = '%';
    private static final char[] _specifiers = new char[]{'a', 'A', 'b', 'B', 'c', 'd', 'e', 'F', 'H', 'I', 'j', 'm', 'M', 'p', 'S', 'w', 'x', 'X', 'y', 'Y', 'Z', 'z'};
    private static final String DefaultPattern = "%Y-%m-%d %H:%M:%S %Z";
    private static final String __usPatternChars = new DateFormatSymbols(Locale.US).getLocalPatternChars();
    private static final String[][] _defaultZoneStrings = NSTimestampFormatter._getDefaultZoneStrings();
    private static final DateFormatSymbols _legacyDefaultDateFormatSymbols;
    private static final NSTimestampFormatter _defaultTimestampFormatter;
    static final long serialVersionUID = -3895651253027642187L;
    private static final String SerializationPatternFieldKey = "pattern";
    private static final String SerializationFormatSymbolsFieldKey = "formatSymbols";
    private static final String SerializationFormatTimeZoneFieldKey = "formatTimeZone";
    private static final String SerializationParseTimeZoneFieldKey = "parseTimeZone";
    static boolean _JVM131Compatible;
    private static Locale _defaultLocaleForDatePattern;
    private static Locale _defaultLocaleForTimePattern;
    private static String _localizedDatePattern;
    private static String _localizedTimePattern;
    private static final NSNumberFormatter __minuteFormatter;
    static _NSThreadsafeMutableDictionary<String, NSTimeZone> _knownTZNameMappings;
    private static boolean shouldUseLegacyFormatterBehavior;
    private static final ThreadLocal<NSTimestampFormatter> _UtcThreadLocal;
    protected Locale locale;
    private DateFormatSymbols _dateFormatSymbols;
    private NSTimeZone _formatTimeZone;
    private NSTimeZone _parseTimeZone;
    private String _pattern;
    private __NSSimpleDateFormat _formatDateFormat;
    private __NSSimpleDateFormat _parseDateFormat;
    private boolean isLenient = true;
    private static final ObjectStreamField[] serialPersistentFields;

    static {
        DateFormatSymbols dfs = new DateFormatSymbols();
        dfs.setZoneStrings(_defaultZoneStrings);
        dfs.setLocalPatternChars(__usPatternChars);
        _legacyDefaultDateFormatSymbols = dfs;
        _defaultTimestampFormatter = new NSTimestampFormatter(DefaultPattern);
        String timeInString = " 2003-01-22 16:55:28";
        SimpleDateFormat formatter = new SimpleDateFormat("z' 'yyyy'-'MM'-'dd' 'HH':'mm':'ss");
        Date date = formatter.parse(timeInString, new ParsePosition(0));
        _JVM131Compatible = date != null;
        _defaultLocaleForDatePattern = null;
        _defaultLocaleForTimePattern = null;
        _localizedDatePattern = null;
        _localizedTimePattern = null;
        __minuteFormatter = new NSNumberFormatter(".00;.00");
        _knownTZNameMappings = new _NSThreadsafeMutableDictionary(new NSMutableDictionary(16));
        shouldUseLegacyFormatterBehavior = NSPropertyListSerialization.booleanForString(NSProperties.stringForKeyWithDefault("NSTimestampFormatterUseLegacyBehavior", "true"));
        _UtcThreadLocal = new ThreadLocal();
        try {
            __minuteFormatter.setDecimalSeparator(":");
        }
        catch (Throwable e) {
            log.error("Exception encountered while initializing number formatter during class initialization", e);
        }
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationPatternFieldKey, _NSUtilities._StringClass), new ObjectStreamField(SerializationFormatTimeZoneFieldKey, NSTimeZone._CLASS), new ObjectStreamField(SerializationParseTimeZoneFieldKey, NSTimeZone._CLASS), new ObjectStreamField(SerializationFormatSymbolsFieldKey, _NSUtilities._DateFormatSymbolsClass)};
    }

    public static String[][] _getDefaultZoneStrings() {
        NSArray<String> zoneNames = NSTimeZone.knownTimeZoneNames();
        String[][] defaultZoneStrings = new String[zoneNames.count()][5];
        int zsl = defaultZoneStrings.length;
        int i = 0;
        while (i < zsl) {
            String[] zoneNameVariants = new String[5];
            String zoneName = zoneNames.objectAtIndex(i);
            String nospacedZoneName = zoneName.replace(' ', '_');
            zoneNameVariants[0] = zoneName;
            zoneNameVariants[1] = nospacedZoneName;
            zoneNameVariants[2] = nospacedZoneName;
            zoneNameVariants[3] = nospacedZoneName;
            zoneNameVariants[4] = nospacedZoneName;
            defaultZoneStrings[i] = zoneNameVariants;
            ++i;
        }
        return defaultZoneStrings;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _localizedDatePattern() {
        Locale locale = Locale.getDefault();
        if (_localizedDatePattern == null || _defaultLocaleForDatePattern != locale) {
            Class<NSTimestampFormatter> clazz = _CLASS;
            synchronized (clazz) {
                if (_localizedDatePattern == null || _defaultLocaleForDatePattern != locale) {
                    DateFormat format = DateFormat.getDateInstance(3);
                    _defaultLocaleForDatePattern = locale;
                    _localizedDatePattern = format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : "dd/MM/yyyy";
                }
            }
        }
        return _localizedDatePattern;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String _localizedTimePattern() {
        Locale locale = Locale.getDefault();
        if (_localizedTimePattern == null || _defaultLocaleForTimePattern != locale) {
            Class<NSTimestampFormatter> clazz = _CLASS;
            synchronized (clazz) {
                if (_localizedTimePattern == null || _defaultLocaleForTimePattern != locale) {
                    DateFormat format = DateFormat.getTimeInstance(3);
                    _defaultLocaleForTimePattern = locale;
                    _localizedTimePattern = format instanceof SimpleDateFormat ? ((SimpleDateFormat)format).toPattern() : "hh:mm aa";
                }
            }
        }
        return _localizedTimePattern;
    }

    private static synchronized String _localizedDateTimePattern() {
        return String.valueOf(NSTimestampFormatter._localizedDatePattern()) + " " + NSTimestampFormatter._localizedTimePattern();
    }

    private static synchronized String _patternForSpecifierString(String string) {
        if (string == null) {
            return null;
        }
        if (string.indexOf(37) < 0) {
            return string;
        }
        boolean conversionNecessary = false;
        int length = string.length();
        boolean insideQuote = false;
        int i = 0;
        while (i < length && !conversionNecessary) {
            char character = string.charAt(i);
            if (character == '\'') {
                if (i + 1 < length && string.charAt(i + 1) == '\'') {
                    ++i;
                } else {
                    insideQuote = !insideQuote;
                }
            } else if (!insideQuote && character == '%') {
                conversionNecessary = true;
            }
            ++i;
        }
        if (!conversionNecessary) {
            return string;
        }
        StringBuffer buffer = new StringBuffer(32);
        insideQuote = false;
        int i2 = 0;
        while (i2 < length) {
            block21: {
                char character;
                block20: {
                    char specifier;
                    character = string.charAt(i2);
                    if (character != '%' || i2 >= length - 1 || (specifier = string.charAt(++i2)) == '%') break block20;
                    boolean specifierFound = false;
                    int j = 0;
                    while (j < _specifiers.length) {
                        if (specifier == _specifiers[j]) {
                            String pattern = specifier == 'c' ? NSTimestampFormatter._localizedDateTimePattern() : (specifier == 'x' ? NSTimestampFormatter._localizedDatePattern() : (specifier == 'X' ? NSTimestampFormatter._localizedTimePattern() : _patterns[j]));
                            if (insideQuote) {
                                buffer.append('\'');
                                insideQuote = false;
                            }
                            buffer.append(pattern);
                            specifierFound = true;
                            break;
                        }
                        ++j;
                    }
                    if (specifierFound) break block21;
                }
                if (!insideQuote) {
                    buffer.append('\'');
                    insideQuote = true;
                }
                if (character == '\'') {
                    buffer.append('\'');
                    buffer.append('\'');
                } else {
                    buffer.append(character);
                }
            }
            ++i2;
        }
        if (insideQuote) {
            buffer.append('\'');
        }
        return new String(buffer);
    }

    public NSTimestampFormatter() {
        this(null);
        this.locale = Locale.getDefault();
        this._dateFormatSymbols = this._defaultDateFormatSymbols();
        this.setPattern(DefaultPattern);
    }

    public NSTimestampFormatter(String aPattern) {
        this.locale = Locale.getDefault();
        this._dateFormatSymbols = this._defaultDateFormatSymbols();
        this.setPattern(aPattern == null ? DefaultPattern : aPattern);
    }

    public NSTimestampFormatter(String aPattern, DateFormatSymbols symbols) {
        if (symbols == null) {
            this._dateFormatSymbols = this._defaultDateFormatSymbols();
        } else {
            this._dateFormatSymbols = (DateFormatSymbols)symbols.clone();
            if (shouldUseLegacyFormatterBehavior) {
                this._dateFormatSymbols.setLocalPatternChars(__usPatternChars);
            }
        }
        this.setPattern(aPattern == null ? DefaultPattern : aPattern);
    }

    public DateFormatSymbols defaultDateFormatSymbols() {
        return (DateFormatSymbols)this._defaultDateFormatSymbols().clone();
    }

    private DateFormatSymbols _defaultDateFormatSymbols() {
        if (shouldUseLegacyFormatterBehavior) {
            return _legacyDefaultDateFormatSymbols;
        }
        return new DateFormatSymbols(this.locale);
    }

    private String[][] _defaultZoneStrings() {
        return _defaultZoneStrings;
    }

    private __NSSimpleDateFormat _parseDateFormat() {
        if (this._parseDateFormat == null) {
            this._parseDateFormat = this._getSimpleDateFormat();
            this._parseDateFormat._breakPattern();
        }
        this._parseDateFormat.setLenient(this.isLenient());
        return this._parseDateFormat;
    }

    private __NSSimpleDateFormat _formatDateFormat() {
        if (this._formatDateFormat == null) {
            this._formatDateFormat = this._getSimpleDateFormat();
        }
        return this._formatDateFormat;
    }

    private synchronized __NSSimpleDateFormat _getSimpleDateFormat() {
        return this._getSimpleDateFormat(this._pattern);
    }

    private synchronized __NSSimpleDateFormat _getSimpleDateFormat(String pattern) {
        __NSSimpleDateFormat result = null;
        if (pattern == null) {
            SimpleDateFormat df = (SimpleDateFormat)DateFormat.getDateTimeInstance(3, 3, Locale.US);
            result = new __NSSimpleDateFormat();
            result.setCalendar(df.getCalendar());
            result.setNumberFormat(df.getNumberFormat());
            result.setDateFormatSymbols(this._defaultDateFormatSymbols());
            result._displayNamesForZones = this._defaultZoneStrings();
        } else {
            result = new __NSSimpleDateFormat(NSTimestampFormatter._patternForSpecifierString(pattern), Locale.US);
            if (this._dateFormatSymbols != null) {
                result.setDateFormatSymbols(this._dateFormatSymbols);
                result._displayNamesForZones = this._dateFormatSymbols.getZoneStrings();
            } else {
                result.setDateFormatSymbols(this._defaultDateFormatSymbols());
                result._displayNamesForZones = this._defaultZoneStrings();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        StringBuffer result = null;
        if (obj != null && obj instanceof NSTimestamp) {
            NSTimestampFormatter nSTimestampFormatter = this;
            synchronized (nSTimestampFormatter) {
                NSTimestamp timestamp = (NSTimestamp)obj;
                this._formatDateFormat().setCalendar(new _NSGregorianCalendar(this.defaultFormatTimeZone(), timestamp));
                String pattern = this.pattern();
                int zIndex = pattern.indexOf("%z");
                if (zIndex > -1) {
                    boolean removeTimeZoneSpace = false;
                    if (zIndex > 0 && pattern.charAt(zIndex - 1) != ' ') {
                        pattern = pattern.replaceFirst("%z", " %z");
                        result = this._getSimpleDateFormat(pattern).format(timestamp, toAppendTo, pos);
                        removeTimeZoneSpace = true;
                    } else {
                        result = this._formatDateFormat().format(timestamp, toAppendTo, pos);
                    }
                    NSMutableArray<String> substrings = new NSMutableArray<String>(NSArray.componentsSeparatedByString(result.toString(), " "));
                    NSTimeZone tz = null;
                    int index = 0;
                    int count = substrings.count();
                    tz = NSTimeZone.timeZoneWithName((String)substrings.objectAtIndex(index), true);
                    if (tz == null) {
                        tz = NSTimeZone.timeZoneWithName((String)substrings.lastObject(), true);
                        index = count - 1;
                    }
                    StringBuffer displayOffset = new StringBuffer();
                    int offset = tz.secondsFromGMTForTimestamp((NSTimestamp)obj);
                    if (offset < 0) {
                        displayOffset.append("-");
                        offset *= -1;
                    } else {
                        displayOffset.append("+");
                    }
                    int h = offset / 3600;
                    if (h < 10) {
                        displayOffset.append(0);
                    }
                    displayOffset.append(h);
                    int m = (offset - h * 3600) / 60;
                    if (m < 10) {
                        displayOffset.append(0);
                    }
                    displayOffset.append(m);
                    substrings.replaceObjectAtIndex(displayOffset.toString(), index);
                    if (removeTimeZoneSpace) {
                        result = new StringBuffer(result.length());
                        int i = 0;
                        while (i < count) {
                            if (i > 0 && i != index) {
                                result.append(' ');
                            }
                            result.append((String)substrings.objectAtIndex(i));
                            ++i;
                        }
                    } else {
                        result = new StringBuffer(substrings.componentsJoinedByString(" "));
                    }
                } else {
                    result = this._formatDateFormat().format(timestamp, toAppendTo, pos);
                }
            }
        } else {
            throw new IllegalArgumentException("The object (" + (obj != null ? obj.toString() : "null") + ") is not an NSTimestamp.");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object parseObjectInUTC(String text, ParsePosition pos) {
        NSTimestamp result = null;
        ParsePosition tpos = new ParsePosition(pos.getIndex());
        if (text != null && text.length() != 0) {
            Date date = null;
            if (this.pattern().equals("%z")) {
                pos.setErrorIndex(0);
                throw new IllegalArgumentException("\"%z\" is not a legal parse format string.");
            }
            NSTimestampFormatter nSTimestampFormatter = this;
            synchronized (nSTimestampFormatter) {
                date = this._parseDateFormat()._parseInUTC(text, tpos);
            }
            if (date != null) {
                result = new NSTimestamp(date.getTime());
            } else if (this != _defaultTimestampFormatter) {
                tpos = new ParsePosition(pos.getIndex());
                result = (NSTimestamp)_defaultTimestampFormatter.parseObjectInUTC(text, tpos);
            }
        }
        pos.setIndex(tpos.getIndex());
        pos.setErrorIndex(tpos.getErrorIndex());
        return result;
    }

    public static NSTimestamp parseUTC(String utcString) {
        NSTimestampFormatter threadLocalFormatter = _UtcThreadLocal.get();
        if (threadLocalFormatter == null) {
            threadLocalFormatter = new NSTimestampFormatter("%Y-%m-%dT%H:%M:%SZ");
            _UtcThreadLocal.set(threadLocalFormatter);
        }
        return (NSTimestamp)threadLocalFormatter.parseObjectInUTC(utcString, new ParsePosition(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object parseObject(String text, ParsePosition pos) {
        NSTimestamp result = null;
        ParsePosition tpos = new ParsePosition(pos.getIndex());
        if (this.pattern().equals("%z")) {
            pos.setErrorIndex(0);
            throw new IllegalArgumentException("\"%z\" is not a legal parse format string.");
        }
        if (text != null && text.length() != 0) {
            NSTimestampFormatter nSTimestampFormatter = this;
            synchronized (nSTimestampFormatter) {
                this._parseDateFormat().setTimeZone(this.defaultParseTimeZone());
                result = (NSTimestamp)this._parseDateFormat().parse(text, tpos);
            }
            if (result == null && this != _defaultTimestampFormatter) {
                tpos = new ParsePosition(pos.getIndex());
                result = (NSTimestamp)_defaultTimestampFormatter.parseObject(text, tpos);
            }
        }
        pos.setIndex(tpos.getIndex());
        pos.setErrorIndex(tpos.getErrorIndex());
        return result;
    }

    public NSTimeZone defaultFormatTimeZone() {
        return this._formatTimeZone == null ? NSTimeZone.defaultTimeZone() : this._formatTimeZone;
    }

    public synchronized NSTimeZone defaultParseTimeZone() {
        return this._parseTimeZone == null ? NSTimeZone.defaultTimeZone() : this._parseTimeZone;
    }

    public synchronized void setDefaultFormatTimeZone(NSTimeZone zone) {
        this._formatTimeZone = zone;
    }

    public synchronized void setDefaultParseTimeZone(NSTimeZone zone) {
        this._parseTimeZone = zone;
    }

    public synchronized void setPattern(String pattern) {
        this._pattern = pattern;
        this._formatDateFormat = null;
        this._parseDateFormat = null;
    }

    public String pattern() {
        return this._pattern;
    }

    public boolean isLenient() {
        return this.isLenient;
    }

    public void setLenient(boolean lenient) {
        this.isLenient = lenient;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(256);
        buffer.append(this.getClass().getName());
        buffer.append(" < parseTimeZone = ");
        buffer.append(this._parseTimeZone != null ? this._parseTimeZone.getID() : "null");
        buffer.append(" ; formatTimeZone = ");
        buffer.append(this._formatTimeZone != null ? this._formatTimeZone.getID() : "null");
        buffer.append(" ; pattern = ");
        buffer.append(this._pattern != null ? this._pattern : "null");
        buffer.append(" >");
        return new String(buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        NSTimestampFormatter nSTimestampFormatter = this;
        synchronized (nSTimestampFormatter) {
            fields.put(SerializationPatternFieldKey, this.pattern());
            fields.put(SerializationFormatSymbolsFieldKey, this._dateFormatSymbols);
            fields.put(SerializationFormatTimeZoneFieldKey, this._formatTimeZone);
            fields.put(SerializationParseTimeZoneFieldKey, this._parseTimeZone);
        }
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        String pattern = (String)fields.get(SerializationPatternFieldKey, DefaultPattern);
        pattern = pattern == null ? DefaultPattern : pattern;
        this._dateFormatSymbols = (DateFormatSymbols)fields.get(SerializationFormatSymbolsFieldKey, null);
        this._formatTimeZone = (NSTimeZone)fields.get(SerializationFormatTimeZoneFieldKey, null);
        this._parseTimeZone = (NSTimeZone)fields.get(SerializationParseTimeZoneFieldKey, null);
        this.setPattern(pattern);
    }

    class __NSSimpleDateFormat
    extends SimpleDateFormat {
        static final long serialVersionUID = -1855367820958427136L;
        String[][] _displayNamesForZones;
        private String _tzPattern;
        private boolean _tzAtEnd;

        __NSSimpleDateFormat() {
            this._tzAtEnd = false;
        }

        __NSSimpleDateFormat(String aPattern, Locale aLocale) {
            super(aPattern, aLocale);
            this._tzAtEnd = false;
        }

        String[] _breakPattern() {
            String pattern;
            String timePattern = pattern = this.toPattern();
            String[] broken = new String[2];
            this._tzPattern = "";
            if (this._isTZPatternPresent(pattern, pattern.length())) {
                NSRange zsr = this._zoneSubpatternRange(pattern);
                int pl = pattern.length();
                if (zsr.location() == 0) {
                    this._tzPattern = pattern.substring(0, zsr.length());
                    timePattern = pattern.substring(zsr.length());
                } else {
                    timePattern = pattern.substring(0, zsr.location());
                    this._tzPattern = pattern.substring(zsr.location(), pl);
                    this._tzAtEnd = true;
                }
            }
            broken[0] = timePattern;
            broken[1] = this._tzPattern;
            this.applyPattern(timePattern);
            return broken;
        }

        private NSRange _zoneSubpatternRange(String pattern) {
            boolean foundTZPattern = false;
            int index = 0;
            boolean patternIsValid = false;
            if (pattern == null) {
                throw new IllegalArgumentException("Null pattern");
            }
            int patternLength = pattern.length();
            boolean bl = this._tzAtEnd = pattern.endsWith("z") && pattern.startsWith("z") ? false : pattern.endsWith("z");
            if (pattern.endsWith("z") || pattern.startsWith("z")) {
                index = this._tzAtEnd ? patternLength - 1 : 0;
                while ((this._tzAtEnd ? index > 0 : index < patternLength - 1) && pattern.charAt(index) == 'z') {
                    index += this._tzAtEnd ? -1 : 1;
                }
                switch (pattern.charAt(index)) {
                    case '\t': 
                    case '\n': 
                    case '\r': 
                    case ' ': 
                    case 'z': {
                        foundTZPattern = true;
                        patternIsValid = true;
                        break;
                    }
                    case '\'': {
                        break;
                    }
                    default: {
                        foundTZPattern = true;
                        patternIsValid = false;
                        break;
                    }
                }
            } else if (this._isTZPatternPresent(pattern, patternLength)) {
                foundTZPattern = true;
                patternIsValid = false;
            } else {
                foundTZPattern = false;
                patternIsValid = true;
            }
            if (foundTZPattern && !patternIsValid) {
                throw new IllegalArgumentException("Invalid pattern " + pattern);
            }
            index = this._tzAtEnd ? ++index : --index;
            return new NSRange(this._tzAtEnd ? index : 0, this._tzAtEnd ? patternLength - index : index);
        }

        private String[] _breakString(String str, ParsePosition pos) {
            if (this._tzPattern.length() == 0) {
                String[] retVal = new String[]{str.substring(pos.getIndex()), ""};
                return retVal;
            }
            String aString = str.substring(pos.getIndex());
            String timeString = "";
            String zoneString = "";
            String[] brokenString = new String[2];
            int i = 0;
            int strlen = aString.length();
            if (this._tzAtEnd) {
                i = strlen - 1;
                while (i > 0) {
                    if (this._isWhitespace(aString.charAt(i))) break;
                    --i;
                }
                timeString = aString.substring(0, i + 1);
                zoneString = aString.substring(i + 1);
            } else {
                i = 0;
                while (i < strlen) {
                    if (this._isWhitespace(aString.charAt(i))) break;
                    ++i;
                }
                zoneString = aString.substring(0, i);
                timeString = aString.substring(i);
            }
            brokenString[0] = timeString;
            brokenString[1] = zoneString;
            return brokenString;
        }

        private boolean _isWhitespace(char aChar) {
            return aChar == ' ' || aChar == '\t' || aChar == '\n' || aChar == '\r';
        }

        private boolean _isTZPatternPresent(String aPattern, int aPatternLength) {
            boolean result = false;
            if (aPattern.indexOf("z") != -1) {
                boolean inQuote = false;
                int index = 0;
                while (index < aPatternLength) {
                    char ch = aPattern.charAt(index);
                    if (ch == '\'') {
                        inQuote = !inQuote;
                    } else if (ch == 'z' && !inQuote) {
                        result = true;
                        break;
                    }
                    ++index;
                }
            }
            return result;
        }

        private NSTimeZone _parseTZName(String text, ParsePosition pos) {
            if (text.length() == 0 || this._tzPattern.length() == 0) {
                return null;
            }
            if (NSTimestampFormatter.this.pattern().indexOf("%z") > -1) {
                NSTimeZone tzForOffset = null;
                int start = 1;
                char firstChar = text.charAt(0);
                block1 : switch (text.length()) {
                    case 4: {
                        if (firstChar == '0' || firstChar == '1') {
                            start = 0;
                        }
                    }
                    case 5: {
                        int seconds = 0;
                        try {
                            seconds = Integer.valueOf(text.substring(start, start + 2)) * 3600 + Integer.valueOf(text.substring(start + 2, start + 4)) * 60;
                        }
                        catch (NumberFormatException numberFormatException) {
                            throw new IllegalArgumentException("String \"" + text + "\" cannot be parsed into a valid NSTimeZone.");
                        }
                        switch (firstChar) {
                            case '+': 
                            case '0': 
                            case '1': {
                                tzForOffset = NSTimeZone.timeZoneForSecondsFromGMT(seconds);
                                break block1;
                            }
                            case '-': {
                                tzForOffset = NSTimeZone.timeZoneForSecondsFromGMT(seconds * -1);
                                break block1;
                            }
                        }
                        pos.setErrorIndex(0);
                        throw new IllegalArgumentException("String \"" + text + "\" cannot be parsed into a valid NSTimeZone.");
                    }
                    default: {
                        pos.setErrorIndex(0);
                        throw new IllegalArgumentException("String \"" + text + "\" cannot be parsed into a valid NSTimeZone.");
                    }
                }
                return tzForOffset;
            }
            NSTimeZone cachedTZ = _knownTZNameMappings.objectForKey(text);
            if (cachedTZ != null) {
                return cachedTZ;
            }
            NSTimeZone result = null;
            String[][] knownTZNames = this._displayNamesForZones;
            int kTZNLength = knownTZNames.length;
            NSMutableArray<String> possibilities = new NSMutableArray<String>();
            int index = 0;
            while (index < kTZNLength) {
                int j = 0;
                while (j < 5) {
                    boolean isPossibleName = false;
                    String tzName = knownTZNames[index][j];
                    isPossibleName = text.equals(tzName);
                    if (isPossibleName) {
                        possibilities.addObject(knownTZNames[index][0]);
                        break;
                    }
                    ++j;
                }
                ++index;
            }
            if (possibilities.count() > 1) {
                pos.setErrorIndex(0);
                throw new IllegalStateException("Ambiguous parse string: " + text + "\nSeveral possible timezone name matches: " + possibilities.toString());
            }
            result = NSTimeZone.timeZoneWithName(text, true);
            if (result == null) {
                pos.setErrorIndex(0);
                throw new IllegalStateException("Unable to find a valid timezone name in parse string: " + text);
            }
            _knownTZNameMappings.setObjectForKey(result, text);
            return result;
        }

        @Override
        public StringBuffer format(Date date, StringBuffer toAppendTo, FieldPosition pos) {
            return super.format(date, toAppendTo, pos);
        }

        private Date _parseTimeInUTC(String text, ParsePosition pos) {
            Date result;
            if (_JVM131Compatible) {
                result = super.parse(text, pos);
            } else {
                String oldPattern = super.toPattern();
                if (oldPattern.startsWith("z'")) {
                    super.applyPattern(oldPattern.substring(4));
                    result = super.parse(text, pos);
                    super.applyPattern(oldPattern);
                } else {
                    result = super.parse(text, pos);
                }
            }
            return result;
        }

        public Date _parseInUTC(String text, ParsePosition pos) {
            String[] brokenString = this._breakString(text, pos);
            ParsePosition timePos = new ParsePosition(0);
            Date result = null;
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
            try {
                result = this._parseTimeInUTC(brokenString[0], timePos);
            }
            catch (RuntimeException ex) {
                if (this._tzAtEnd) {
                    pos.setErrorIndex(pos.getIndex() + timePos.getErrorIndex());
                } else {
                    pos.setErrorIndex(pos.getIndex() + brokenString[1].length() + timePos.getErrorIndex());
                }
                throw ex;
            }
            if (this._tzAtEnd) {
                pos.setIndex(pos.getIndex() + timePos.getIndex());
            } else {
                pos.setIndex(pos.getIndex() + brokenString[1].length() + timePos.getIndex());
            }
            return result;
        }

        @Override
        public Date parse(String text, ParsePosition pos) {
            long offset2;
            long offset1;
            if (NSTimestampFormatter.this.pattern().equals("%z")) {
                pos.setErrorIndex(0);
                throw new IllegalArgumentException("\"%z\" is not a legal parse format string.");
            }
            ParsePosition timePos = new ParsePosition(0);
            String[] brokenString = this._breakString(text, pos);
            Date result = null;
            NSTimeZone dtz = (NSTimeZone)this.getTimeZone();
            this.setTimeZone(TimeZone.getTimeZone("GMT"));
            result = this._parseTimeInUTC(brokenString[0], timePos);
            if (result == null || timePos.getErrorIndex() > -1) {
                if (this._tzAtEnd) {
                    pos.setErrorIndex(pos.getIndex() + (timePos.getErrorIndex() > -1 ? timePos.getErrorIndex() : pos.getIndex()));
                } else {
                    pos.setErrorIndex(pos.getIndex() + brokenString[1].length() + (timePos.getErrorIndex() > -1 ? timePos.getErrorIndex() : pos.getIndex()));
                }
                return result;
            }
            long utcValue = result.getTime();
            ParsePosition tzPos = new ParsePosition(0);
            NSTimeZone tz = null;
            if (this._tzPattern.length() > 0) {
                try {
                    tz = this._parseTZName(brokenString[1], tzPos);
                }
                catch (RuntimeException ex) {
                    if (this._tzAtEnd) {
                        pos.setErrorIndex(pos.getIndex() + brokenString[1].length() + tzPos.getErrorIndex());
                    } else {
                        pos.setErrorIndex(pos.getIndex() + tzPos.getErrorIndex());
                    }
                    throw ex;
                }
            }
            if (tz == null) {
                tz = dtz;
            }
            NSTimestamp ts = new NSTimestamp(utcValue -= (offset1 = (long)tz.getOffset(new NSTimestamp(utcValue))) == (offset2 = (long)tz.getOffset(new NSTimestamp(utcValue - offset1))) ? offset1 : offset2);
            pos.setIndex(text.length());
            return ts;
        }
    }
}

