/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSTimeZone;
import com.webobjects.foundation._NSGregorianCalendar;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.TimeZone;

public class NSTimestamp
extends Timestamp
implements NSCoding {
    public static final Class<NSTimestamp> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSTimestamp.class);
    private static transient boolean _JVM131Compatible = false;
    private static ThreadLocal<_CalendarInfo> _calendarInfo;
    public static final NSTimestamp DistantPast;
    public static final NSTimestamp DistantFuture;
    static final long serialVersionUID = 6870088373061302940L;
    private static int _DistantPastYear;
    private static int _DistantFutureYear;
    private static String[] _unitNames;
    private static int[] _gregorianUnitIDs;
    private static final String SerializationLegacyFieldKey = "_timeZone";
    private static final ObjectStreamField[] serialPersistentFields;

    static {
        Timestamp ts = new Timestamp(29922898L);
        if (ts.getTime() % 1000L == 0L) {
            _JVM131Compatible = true;
        }
        _calendarInfo = new ThreadLocal<_CalendarInfo>(){

            @Override
            protected _CalendarInfo initialValue() {
                return new _CalendarInfo();
            }
        };
        DistantPast = new NSTimestamp(-62125920000000L);
        DistantFuture = new NSTimestamp(Long.MAX_VALUE);
        _DistantPastYear = -1;
        _DistantFutureYear = -1;
        _unitNames = new String[]{"Years", "Months", "Days", "Hours", "Minutes", "Seconds"};
        _gregorianUnitIDs = new int[]{1, 2, 5, 10, 12, 13};
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationLegacyFieldKey, NSTimeZone._CLASS)};
    }

    @Deprecated
    public static long currentTimeIntervalSinceReferenceDate() {
        return System.currentTimeMillis() / 1000L;
    }

    @Deprecated
    public static NSTimestamp distantFuture() {
        return DistantFuture;
    }

    @Deprecated
    public static NSTimestamp distantPast() {
        return DistantPast;
    }

    @Deprecated
    public static long millisecondsToTimeInterval(long milliseconds) {
        return milliseconds / 1000L;
    }

    @Deprecated
    public static long timeIntervalToMilliseconds(long timeInterval) {
        return timeInterval * 1000L;
    }

    @Override
    public Class<?> classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        long milliseconds = coder.decodeLong();
        int nanos = coder.decodeInt();
        String tzString = (String)coder.decodeObject();
        return new NSTimestamp(milliseconds, nanos, NSTimeZone.timeZoneWithName(tzString, true));
    }

    @Override
    public void encodeWithCoder(NSCoder coder) {
        coder.encodeLong(this.getTime());
        coder.encodeInt(this.getNanos());
        coder.encodeObject(this.timeZone().getID());
    }

    public NSTimestamp() {
        this(System.currentTimeMillis());
    }

    public NSTimestamp(long time) {
        super(time);
        if (_JVM131Compatible) {
            this._shiftMilliseconds(0);
        } else {
            this._initialize(time, 0);
        }
    }

    public NSTimestamp(long milliseconds, int nanoseconds) {
        super(milliseconds);
        if (_JVM131Compatible) {
            this._shiftMilliseconds(nanoseconds);
        } else {
            this._initialize(milliseconds, nanoseconds);
        }
    }

    public NSTimestamp(long time, NSTimestamp date) {
        super(time + date.getTime());
        if (_JVM131Compatible) {
            this._shiftMilliseconds(date.getNanos());
        } else {
            this._initialize(time + date.getTime(), date.getNanos());
        }
    }

    public NSTimestamp(long time, TimeZone tz) {
        super(NSTimestamp._timestampAdjustedForZone(time, tz));
        if (_JVM131Compatible) {
            this._shiftMilliseconds(0);
        } else {
            this._initialize(NSTimestamp._timestampAdjustedForZone(time, tz), 0);
        }
    }

    public NSTimestamp(long time, int nanos, TimeZone tz) {
        super(NSTimestamp._timestampAdjustedForZone(time, tz));
        if (_JVM131Compatible) {
            this._shiftMilliseconds(nanos);
        } else {
            this._initialize(NSTimestamp._timestampAdjustedForZone(time, tz), nanos);
        }
    }

    public NSTimestamp(int year, int month, int date, int hour, int minute, int second, TimeZone tz) {
        super(0L);
        if (_DistantPastYear < 0) {
            _DistantPastYear = DistantPast.yearOfCommonEra();
            _DistantFutureYear = DistantFuture.yearOfCommonEra();
        }
        if (year <= _DistantPastYear) {
            throw new IllegalArgumentException("Cannot create a timestamp before " + DistantPast + " (or of that year).  Use another constructor.");
        }
        if (year >= _DistantFutureYear) {
            throw new IllegalArgumentException("Cannot create a timestamp after " + DistantFuture + " (or of that year).  Use another constructor.");
        }
        GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("GMT"));
        cal.clear();
        cal.set(year, month - 1, date, hour, minute, second);
        long millis = cal.getTime().getTime();
        NSTimeZone ntz = tz != null ? NSTimeZone._nstimeZoneWithTimeZone(tz) : NSTimeZone.getGMT();
        int rawOffset1 = ntz.getOffset(new NSTimestamp(millis));
        int rawOffset2 = ntz.getOffset(new NSTimestamp(millis - (long)rawOffset1));
        if (rawOffset1 == rawOffset2) {
            super.setTime(millis - (long)rawOffset1);
        } else if (hour == 2) {
            long special = rawOffset1 > rawOffset2 ? millis - (long)rawOffset2 : millis - (long)rawOffset1;
            super.setTime(special);
        } else {
            super.setTime(millis - (long)rawOffset2);
        }
    }

    public NSTimestamp(Date date) {
        this(date.getTime());
    }

    public NSTimestamp(Timestamp sqlTimestamp) {
        this(_JVM131Compatible ? sqlTimestamp.getTime() : sqlTimestamp.getTime() - (long)(sqlTimestamp.getNanos() / 1000000), sqlTimestamp.getNanos());
    }

    @Deprecated
    public NSTimestamp timestampByAddingGregorianUnits(int years, int months, int days, int hours, int minutes, int seconds) {
        return this.timestampByAddingGregorianUnits(years, months, days, hours, minutes, seconds, null);
    }

    public NSTimestamp timestampByAddingGregorianUnits(int years, int months, int days, int hours, int minutes, int seconds, TimeZone timeZone) {
        GregorianCalendar aCalendar = new GregorianCalendar();
        aCalendar.setTimeZone(timeZone != null ? timeZone : NSTimestamp.getStandardTimeZone());
        aCalendar.setTime(this);
        aCalendar.add(1, years);
        aCalendar.add(2, months);
        aCalendar.add(5, days);
        aCalendar.add(11, hours);
        aCalendar.add(12, minutes);
        aCalendar.add(13, seconds);
        return new NSTimestamp(aCalendar.getTimeInMillis());
    }

    private long absoluteTimeAddGregorianUnits(long at, GregorianDateAsRawUnits units, boolean dateIsPostGregorian) {
        boolean newDateIsMidGregorian;
        long atCorrected = at;
        if (!dateIsPostGregorian) {
            atCorrected += -864000L;
        }
        GregorianDateAsRawUnits gdate = this.absoluteTimeGetGregorianDate(atCorrected);
        long correction = atCorrected - this.gregorianDateGetAbsoluteTime(gdate);
        gdate.years += units.years;
        gdate.months += units.months;
        while (12 < gdate.months) {
            gdate.months -= 12;
            ++gdate.years;
        }
        while (gdate.months < 1) {
            gdate.months += 12;
            --gdate.years;
        }
        int monthdays = this.__DaysInMonth(gdate.months, gdate.years - 1970);
        if (monthdays < gdate.days) {
            gdate.days = monthdays;
        }
        gdate.days += units.days;
        while (monthdays < gdate.days) {
            ++gdate.months;
            if (12 < gdate.months) {
                gdate.months -= 12;
                ++gdate.years;
            }
            gdate.days -= monthdays;
            monthdays = this.__DaysInMonth(gdate.months, gdate.years - 1970);
        }
        while (gdate.days < 1) {
            --gdate.months;
            if (gdate.months < 1) {
                gdate.months += 12;
                --gdate.years;
            }
            monthdays = this.__DaysInMonth(gdate.months, gdate.years - 1970);
            gdate.days += monthdays;
        }
        int correctionFactor = 0;
        boolean newDateIsPreGregorian = gdate.years < 1582 || gdate.years == 1582 && gdate.months < 10 || gdate.years == 1582 && gdate.months == 10 && gdate.days <= 4;
        boolean bl = newDateIsMidGregorian = gdate.years == 1582 && gdate.months == 10 && gdate.days > 4 && gdate.days < 15;
        if (newDateIsPreGregorian) {
            correctionFactor = 864000;
        } else if (newDateIsMidGregorian) {
            gdate.days = 15;
        }
        long candidate_at0 = this.gregorianDateGetAbsoluteTime(gdate);
        long candidate_at1 = (long)((double)candidate_at0 + 3600.0 * (double)units.hours + 60.0 * (double)units.minutes + (double)units.seconds + (double)correctionFactor);
        return candidate_at1 + correction;
    }

    private GregorianDateAsRawUnits absoluteTimeGetGregorianDate(long at) {
        GregorianDateAsRawUnits gdate = new GregorianDateAsRawUnits();
        GregorianDateAsRawUnits ymd = new GregorianDateAsRawUnits();
        double fixedat = at;
        int absolute = (int)Math.floor(fixedat / 86400.0);
        this.__YMDFromAbsolute(absolute, ymd);
        gdate.years = ymd.years + 1970;
        gdate.months = ymd.months;
        gdate.days = ymd.days;
        gdate.hours = this.__DoubleModToInt(Math.floor(fixedat / 3600.0), 24);
        gdate.minutes = this.__DoubleModToInt(Math.floor(fixedat / 60.0), 60);
        gdate.seconds = (int)this.__DoubleMod(fixedat, 60);
        return gdate;
    }

    private long gregorianDateGetAbsoluteTime(GregorianDateAsRawUnits gdate) {
        long at = (long)(86400.0 * (double)this.__AbsoluteFromYMD(gdate.years - 1970, gdate.months, gdate.days));
        at = (long)((double)at + (3600.0 * (double)gdate.hours + 60.0 * (double)gdate.minutes + (double)gdate.seconds));
        return at;
    }

    private int __AbsoluteFromYMD(int year, int month, int day) {
        int absolute = 0;
        if (year < 0) {
            int idx = year;
            while (idx < 0) {
                absolute -= this.__DaysAfterMonth(0, idx);
                ++idx;
            }
        } else {
            int idx = year - 1;
            while (idx >= 0) {
                absolute += this.__DaysAfterMonth(0, idx);
                --idx;
            }
        }
        return absolute += this.__DaysBeforeMonth(month, year) + day - 1;
    }

    private void __YMDFromAbsolute(int absolute, GregorianDateAsRawUnits ymd) {
        int y = 0;
        int absoluteDate = absolute;
        while (absoluteDate < 0) {
            absoluteDate += this.__DaysAfterMonth(0, --y);
        }
        int ydays = this.__DaysAfterMonth(0, y);
        while (ydays <= absoluteDate) {
            absoluteDate -= ydays;
            ydays = this.__DaysAfterMonth(0, ++y);
        }
        int m = absoluteDate / 33 + 1;
        while (this.__DaysBeforeMonth(m + 1, y) <= absoluteDate) {
            ++m;
        }
        ymd.years = y;
        ymd.months = m;
        ymd.days = absoluteDate - this.__DaysBeforeMonth(m, y) + 1;
    }

    private int __DaysInMonth(int month, int year) {
        int correctedYear = year;
        switch (month) {
            case 1: {
                return 31;
            }
            case 2: {
                if ((correctedYear += 1970) < 1600) {
                    return correctedYear % 4 == 0 ? 29 : 28;
                }
                int y = correctedYear % 400;
                return correctedYear % 4 == 0 && y != 100 && y != 200 && y != 300 ? 29 : 28;
            }
            case 3: {
                return 31;
            }
            case 4: {
                return 30;
            }
            case 5: {
                return 31;
            }
            case 6: {
                return 30;
            }
            case 7: {
                return 31;
            }
            case 8: {
                return 31;
            }
            case 9: {
                return 30;
            }
            case 10: {
                return 31;
            }
            case 11: {
                return 30;
            }
            case 12: {
                return 31;
            }
        }
        return 0;
    }

    private int __DaysBeforeMonth(int month, int year) {
        switch (month) {
            case 1: {
                return 0;
            }
            case 2: {
                return 31;
            }
            case 3: {
                return 31 + this.__DaysInMonth(2, year);
            }
            case 4: {
                return 62 + this.__DaysInMonth(2, year);
            }
            case 5: {
                return 92 + this.__DaysInMonth(2, year);
            }
            case 6: {
                return 123 + this.__DaysInMonth(2, year);
            }
            case 7: {
                return 153 + this.__DaysInMonth(2, year);
            }
            case 8: {
                return 184 + this.__DaysInMonth(2, year);
            }
            case 9: {
                return 215 + this.__DaysInMonth(2, year);
            }
            case 10: {
                return 245 + this.__DaysInMonth(2, year);
            }
            case 11: {
                return 276 + this.__DaysInMonth(2, year);
            }
            case 12: {
                return 306 + this.__DaysInMonth(2, year);
            }
            case 13: {
                return 337 + this.__DaysInMonth(2, year);
            }
        }
        return 0;
    }

    private int __DaysAfterMonth(int month, int year) {
        switch (month) {
            case 0: {
                return 337 + this.__DaysInMonth(2, year);
            }
            case 1: {
                return 306 + this.__DaysInMonth(2, year);
            }
            case 2: {
                return 306;
            }
            case 3: {
                return 275;
            }
            case 4: {
                return 245;
            }
            case 5: {
                return 214;
            }
            case 6: {
                return 184;
            }
            case 7: {
                return 153;
            }
            case 8: {
                return 122;
            }
            case 9: {
                return 92;
            }
            case 10: {
                return 61;
            }
            case 11: {
                return 31;
            }
            case 12: {
                return 0;
            }
        }
        return 0;
    }

    private int __DoubleModToInt(double d, int modulus) {
        int result = (int)Math.floor(d - Math.floor(d / (double)modulus) * (double)modulus);
        if (result < 0) {
            result += modulus;
        }
        return result;
    }

    private double __DoubleMod(double d, int modulus) {
        double result = d - Math.floor(d / (double)modulus) * (double)modulus;
        if (result < 0.0) {
            result += (double)modulus;
        }
        return result;
    }

    @Deprecated
    public NSTimestamp timestampByAddingTimeInterval(long interval) {
        return new NSTimestamp(interval * 1000L + this.getTime(), this.getNanos());
    }

    private Calendar _calendar() {
        return _calendarInfo.get().calendar(this);
    }

    @Deprecated
    public long dayOfCommonEra() {
        int correction = 0;
        long time = this.getTime();
        if (time < 0L) {
            correction = -1;
        }
        return 719163L + time / 86400000L + (long)correction;
    }

    @Deprecated
    public int dayOfMonth() {
        return this._calendar().get(5);
    }

    @Deprecated
    public int dayOfWeek() {
        return this._calendar().get(7) - 1;
    }

    @Deprecated
    public int dayOfYear() {
        return this._calendar().get(6);
    }

    @Deprecated
    public int hourOfDay() {
        return this._calendar().get(11);
    }

    @Deprecated
    public int microsecondOfSecond() {
        return this._calendar().get(14) * 1000 + this.getNanos() / 1000;
    }

    @Deprecated
    public int minuteOfHour() {
        return this._calendar().get(12);
    }

    @Deprecated
    public int monthOfYear() {
        return this._calendar().get(2) + 1;
    }

    @Deprecated
    public int secondOfMinute() {
        return this._calendar().get(13);
    }

    @Deprecated
    public int yearOfCommonEra() {
        return this._calendar().get(1);
    }

    public void gregorianUnitsSinceTimestamp(IntRef years, IntRef months, IntRef days, IntRef hours, IntRef minutes, IntRef seconds, NSTimestamp timestamp) {
        if (timestamp == null) {
            throw new IllegalArgumentException("timestamp argument cannot be null");
        }
        if (this.equals(DistantPast) || this.equals(DistantFuture) || timestamp.equals(DistantPast) || timestamp.equals(DistantFuture)) {
            String thisLabel;
            String string = this.equals(DistantPast) ? "NSTimestamp.DistantPast" : (thisLabel = this.equals(DistantFuture) ? "NSTimestamp.DistantFuture" : this.toString());
            String timestampLabel = timestamp.equals(DistantPast) ? "NSTimestamp.DistantPast" : (timestamp.equals(DistantFuture) ? "NSTimestamp.DistantFuture" : this.toString());
            throw new IllegalArgumentException("DistantPast and DistantFuture arguments cannot be used for calculating Gregorian Unit offsets. this = '" + thisLabel + "'; timestamp = '" + timestampLabel + "'");
        }
        long baseSeconds = timestamp.getTime() / 1000L;
        long targetSeconds = this.getTime() / 1000L;
        if (targetSeconds != baseSeconds) {
            boolean isForwardOffset;
            long incr;
            IntRef[] resultPointers = new IntRef[5];
            long[] offsets = new long[5];
            long[] unitSeconds = new long[]{31622400L, 2678400L, 86400L, 3600L, 60L};
            GregorianCalendar timeTest = new GregorianCalendar(NSTimestamp.getStandardTimeZone());
            resultPointers[0] = years;
            resultPointers[1] = months;
            resultPointers[2] = days;
            resultPointers[3] = hours;
            resultPointers[4] = minutes;
            if (targetSeconds > baseSeconds) {
                incr = 1L;
                isForwardOffset = true;
            } else {
                incr = -1L;
                isForwardOffset = false;
            }
            int i = 0;
            while (i < resultPointers.length) {
                if (resultPointers[i] != null) {
                    Long candidate = null;
                    long initialEstimatedOffset = (targetSeconds - baseSeconds) / unitSeconds[i];
                    NSTimestamp._checkIntegerOverflow(initialEstimatedOffset, _unitNames[i]);
                    offsets[i] = -2L * incr + (long)((int)initialEstimatedOffset);
                    while (true) {
                        timeTest.setTime(timestamp);
                        int j = 0;
                        while (j < 5) {
                            timeTest.add(_gregorianUnitIDs[j], (int)offsets[j]);
                            ++j;
                        }
                        if (candidate != null && (isForwardOffset && timeTest.getTimeInMillis() < candidate || !isForwardOffset && timeTest.getTimeInMillis() > candidate) || isForwardOffset && timeTest.getTimeInMillis() > this.getTime() || !isForwardOffset && timeTest.getTimeInMillis() < this.getTime()) break;
                        long timeTestSeconds = timeTest.getTimeInMillis() / 1000L;
                        long currentOffsetDeviationUnits = (targetSeconds - timeTestSeconds) / unitSeconds[i];
                        if (Math.abs(currentOffsetDeviationUnits) > 3L) {
                            int n = i;
                            offsets[n] = offsets[n] + (currentOffsetDeviationUnits - 2L * incr);
                        } else {
                            int n = i;
                            offsets[n] = offsets[n] + incr;
                        }
                        candidate = timeTest.getTimeInMillis();
                    }
                    int n = i;
                    offsets[n] = offsets[n] - incr;
                    NSTimestamp._checkIntegerOverflow(offsets[i], _unitNames[i]);
                    resultPointers[i].value = (int)offsets[i];
                    if (candidate == null) {
                        throw new IllegalStateException("Bug: null candidate value when calculating offset for " + _unitNames[i] + "; this = " + this + "; this.getTime() = " + this.getTime() + "; since time = " + timestamp + "; since time.getTime() = " + timestamp.getTime());
                    }
                    baseSeconds = candidate / 1000L;
                }
                ++i;
            }
            if (seconds != null) {
                long value = targetSeconds - baseSeconds;
                NSTimestamp._checkIntegerOverflow(value, "Seconds");
                seconds.value = (int)value;
            }
        } else {
            if (years != null) {
                years.value = 0;
            }
            if (months != null) {
                months.value = 0;
            }
            if (days != null) {
                days.value = 0;
            }
            if (hours != null) {
                hours.value = 0;
            }
            if (minutes != null) {
                minutes.value = 0;
            }
            if (seconds != null) {
                seconds.value = 0;
            }
        }
    }

    private static void _checkIntegerOverflow(long value, String unitName) {
        if (value > Integer.MAX_VALUE || value < Integer.MIN_VALUE) {
            StringBuilder m = new StringBuilder();
            m.append("The result for the '");
            m.append(unitName);
            m.append("' exceeds the maximum or minimum possible value that <");
            m.append(IntRef.class.getName());
            m.append("> can accommodate. You should consider adding a 'Years' unit argument");
            throw new ArithmeticException(m.toString());
        }
    }

    @Deprecated
    public long timeIntervalSinceTimestamp(NSTimestamp ts) {
        return (this.getTime() - ts.getTime()) / 1000L;
    }

    @Deprecated
    public long timeIntervalSinceNow() {
        return (this.getTime() - System.currentTimeMillis()) / 1000L;
    }

    @Deprecated
    public long timeIntervalSinceReferenceDate() {
        return this.getTime() / 1000L;
    }

    public int compare(NSTimestamp ts) {
        if (this.before(ts)) {
            return -1;
        }
        if (this.after(ts)) {
            return 1;
        }
        return 0;
    }

    @Deprecated
    public NSTimestamp earlierTimestamp(NSTimestamp ts) {
        if (this.before(ts)) {
            return this;
        }
        return ts;
    }

    @Deprecated
    public NSTimestamp laterTimestamp(NSTimestamp ts) {
        if (this.before(ts)) {
            return ts;
        }
        return this;
    }

    @Override
    public String toString() {
        StringBuilder buffer = new StringBuilder(24);
        buffer.append(this.yearOfCommonEra());
        buffer.append("-");
        if (this.monthOfYear() < 10) {
            buffer.append("0");
        }
        buffer.append(this.monthOfYear());
        buffer.append("-");
        if (this.dayOfMonth() < 10) {
            buffer.append("0");
        }
        buffer.append(this.dayOfMonth());
        buffer.append(" ");
        if (this.hourOfDay() < 10) {
            buffer.append("0");
        }
        buffer.append(this.hourOfDay());
        buffer.append(":");
        if (this.minuteOfHour() < 10) {
            buffer.append("0");
        }
        buffer.append(this.minuteOfHour());
        buffer.append(":");
        if (this.secondOfMinute() < 10) {
            buffer.append("0");
        }
        buffer.append(this.secondOfMinute());
        buffer.append(" ");
        buffer.append(this.timeZone().getID());
        return buffer.toString();
    }

    @Deprecated
    public NSTimeZone timeZone() {
        return NSTimeZone.getGMT();
    }

    public static TimeZone getStandardTimeZone() {
        return TimeZone.getTimeZone("UTC");
    }

    private long _timeInMillis(long milliseconds, int nanos) {
        int nanosToMillis = nanos / 1000000;
        return milliseconds + (long)nanosToMillis;
    }

    @Override
    @Deprecated
    public void setNanos(int nanoseconds) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setNanos() are illegal.");
    }

    @Override
    @Deprecated
    public void setDate(int date) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setDate() are illegal.");
    }

    @Override
    @Deprecated
    public void setHours(int hours) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setHours() are illegal.");
    }

    @Override
    @Deprecated
    public void setMinutes(int minutes) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setMinutes() are illegal.");
    }

    @Override
    @Deprecated
    public void setMonth(int month) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setMonth() are illegal.");
    }

    @Override
    @Deprecated
    public void setSeconds(int seconds) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setSeconds() are illegal.");
    }

    @Override
    @Deprecated
    public void setTime(long time) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setTime() are illegal.");
    }

    private static long _timestampAdjustedForZone(long time, TimeZone tz) {
        if (tz == null) {
            return time;
        }
        NSTimeZone ntz = NSTimeZone._nstimeZoneWithTimeZone(tz);
        int delta = ntz.secondsFromGMTForOffsetInSeconds(time / 1000L);
        return time + (long)delta * 1000L;
    }

    private void _shiftMilliseconds(int nanos) {
        int fractionalSeconds;
        long integralSeconds = this.getTime();
        long integralMillis = this._timeInMillis(integralSeconds, fractionalSeconds = this.getNanos() + nanos);
        int delta = (int)(integralMillis - integralSeconds);
        if (delta < 0) {
            delta = -delta;
        }
        int fractionalMillis = fractionalSeconds - 1000000 * delta;
        super.setTime(integralMillis);
        super.setNanos(fractionalMillis);
    }

    private void _initialize(long m, int n) {
        super.setTime(m);
        super.setNanos(super.getNanos() / 1000000 * 1000000 + n);
    }

    @Override
    public long getTime() {
        if (!_JVM131Compatible) {
            return super.getTime();
        }
        return super.getTime() + (long)(super.getNanos() / 1000000);
    }

    @Override
    public int getNanos() {
        return super.getNanos() % 1000000;
    }

    @Override
    @Deprecated
    public void setYear(int year) {
        throw new IllegalStateException(String.valueOf(this.getClass().getName()) + " is an immutable object.  Invocations of setYear() are illegal.");
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        s.putFields();
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.readFields();
        if (_JVM131Compatible) {
            this._shiftMilliseconds(0);
        }
    }

    private class GregorianDateAsRawUnits {
        public int years = 0;
        public int months = 0;
        public int days = 0;
        public int hours = 0;
        public int minutes = 0;
        public int seconds = 0;

        public GregorianDateAsRawUnits(int[] units) {
            this.years = units[0];
            this.months = units[1];
            this.days = units[2];
            this.hours = units[3];
            this.minutes = units[4];
            this.seconds = units[5];
        }

        public GregorianDateAsRawUnits(int y, int m, int d, int h, int min, int s) {
            this.years = y;
            this.months = m;
            this.days = d;
            this.hours = h;
            this.minutes = min;
            this.seconds = s;
        }

        public GregorianDateAsRawUnits() {
        }

        public String toString() {
            return "<GregorianDateAsRawUnits years=" + this.years + "months=" + this.months + "days=" + this.days + "hours=" + this.hours + "minutes=" + this.minutes + "seconds=" + this.seconds + ">";
        }
    }

    public static class IntRef {
        public int value;

        public String toString() {
            StringBuffer buffer = new StringBuffer(50);
            buffer.append(this.getClass().getName());
            buffer.append(" < value = ");
            buffer.append(this.value);
            buffer.append(" >");
            return new String(buffer);
        }
    }

    private static class _CalendarInfo {
        private NSTimestamp _timestamp;
        private Calendar _calendar;

        private _CalendarInfo() {
        }

        public Calendar calendar(NSTimestamp timestamp) {
            if (timestamp == this._timestamp && this._calendar != null) {
                return this._calendar;
            }
            this._timestamp = timestamp;
            this._calendar = new _NSGregorianCalendar(this._timestamp.timeZone(), this._timestamp.getTime());
            return this._calendar;
        }
    }
}

