/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSKeyValueCodingAdditions;
import com.webobjects.foundation.NSMutableDictionary;

public class NSThreadContext
implements NSKeyValueCodingAdditions {
    private static ThreadLocal<NSThreadContext> _defaultContext = new ThreadLocal();
    private static int _defaultDictionarySize = 10;
    private NSMutableDictionary<Object, Object> _dictionary;

    public static NSThreadContext defaultContext() {
        NSThreadContext context = _defaultContext.get();
        if (context == null) {
            context = new NSThreadContext();
            _defaultContext.set(context);
        }
        return context;
    }

    public NSMutableDictionary<Object, Object> dictionary() {
        return this.dictionary(true);
    }

    public Object objectForKey(Object key) {
        NSMutableDictionary<Object, Object> dictionary = this.dictionary(false);
        return dictionary != null ? dictionary.objectForKey(key) : null;
    }

    public void setObjectForKey(Object object, Object key) {
        NSMutableDictionary<Object, Object> dictionary = this.dictionary(true);
        dictionary.setObjectForKey(object, key);
    }

    public Object removeObjectForKey(Object key) {
        Object object = null;
        NSMutableDictionary<Object, Object> dictionary = this.dictionary(false);
        if (dictionary != null) {
            object = dictionary.removeObjectForKey(key);
        }
        return object;
    }

    public void reset() {
        this._dictionary = null;
    }

    @Override
    public Object valueForKey(String key) {
        NSMutableDictionary<Object, Object> dictionary = this.dictionary(false);
        return dictionary != null ? dictionary.valueForKey(key) : null;
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        NSMutableDictionary<Object, Object> dictionary = this.dictionary(true);
        dictionary.takeValueForKey(value, key);
    }

    @Override
    public Object valueForKeyPath(String keyPath) {
        NSMutableDictionary<Object, Object> dictionary = this.dictionary(false);
        return dictionary != null ? dictionary.valueForKey(keyPath) : null;
    }

    @Override
    public void takeValueForKeyPath(Object value, String keyPath) {
        NSMutableDictionary<Object, Object> dictionary = this.dictionary(true);
        dictionary.takeValueForKeyPath(value, keyPath);
    }

    protected NSMutableDictionary<Object, Object> dictionary(boolean create) {
        if (this._dictionary == null && create) {
            this._dictionary = new NSMutableDictionary(_defaultDictionarySize);
        }
        return this._dictionary;
    }
}

