/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import java.util.LinkedHashMap;
import java.util.Map;

public class NSSizeLimitedLinkedHashMap<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = -5273353835281837352L;
    private final int _maxSize;
    private final NSDisposalDelegate _disposalDelegate;
    private static final float StandardMaxLoadFactor = 0.5f;

    public NSSizeLimitedLinkedHashMap(int maxSize, boolean isIdentity, NSDisposalDelegate disposalDelegate) {
        super(maxSize < 1 ? 4096 : maxSize, 0.5f, true);
        this._maxSize = maxSize < 1 ? Integer.MAX_VALUE : maxSize;
        this._disposalDelegate = disposalDelegate;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        if (this.size() > this._maxSize) {
            if (this._disposalDelegate != null) {
                this._disposalDelegate.valueRemoved(eldest.getValue());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean equals(Object paramObject) {
        if (paramObject == null || paramObject instanceof NSSizeLimitedLinkedHashMap) {
            return this == paramObject;
        }
        return paramObject.equals(this);
    }

    public static interface NSDisposalDelegate {
        public void valueRemoved(Object var1);
    }
}

