/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import java.util.Enumeration;
import org.codehaus.mojo.animal_sniffer.IgnoreJRERequirement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import sun.misc.Signal;
import sun.misc.SignalHandler;

@IgnoreJRERequirement
public class NSSignalHandler
implements SignalHandler {
    static NSSignalHandler _handler;
    private NSMutableDictionary<String, NSMutableArray<SignalHandler>> signals = new NSMutableDictionary();
    private static final Logger _log;

    static {
        _log = LoggerFactory.getLogger(NSSignalHandler.class);
    }

    public static synchronized void register(String signalName, SignalHandler handler) {
        NSMutableArray<SignalHandler> listeners;
        signalName = NSSignalHandler.normalize(signalName);
        if (_handler == null) {
            _handler = new NSSignalHandler();
        }
        if ((listeners = (NSMutableArray<SignalHandler>)NSSignalHandler._handler.signals.objectForKey(signalName)) == null) {
            listeners = new NSMutableArray<SignalHandler>();
            Signal signal = new Signal(signalName);
            SignalHandler oldHandler = Signal.handle(signal, _handler);
            NSSignalHandler._handler.signals.setObjectForKey(listeners, signalName);
            if (oldHandler != null) {
                listeners.addObject(oldHandler);
            }
        }
        listeners.insertObjectAtIndex(handler, 0);
    }

    public static synchronized void unregister(String signalName, SignalHandler handler) {
        NSMutableArray listeners = (NSMutableArray)NSSignalHandler._handler.signals.objectForKey(signalName = NSSignalHandler.normalize(signalName));
        if (listeners == null) {
            listeners = new NSMutableArray();
        }
        listeners.removeObject(handler);
    }

    @Override
    public void handle(Signal signal) {
        NSMutableArray listeners = (NSMutableArray)this.signals.objectForKey(NSSignalHandler.normalize(signal.getName()));
        if (listeners != null) {
            if (_log.isDebugEnabled()) {
                _log.debug("Executing " + listeners.count() + " handlers for signal " + signal.getName());
            }
            Enumeration handlersEnum = listeners.objectEnumerator();
            while (handlersEnum.hasMoreElements()) {
                SignalHandler handler = (SignalHandler)handlersEnum.nextElement();
                handler.handle(signal);
            }
        }
    }

    private static String normalize(String signalName) {
        return signalName.toUpperCase();
    }
}

