/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation._NSCollectionEnumerator;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSFoundationCollection;
import com.webobjects.foundation._NSJavaSetIterator;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;

public class NSSet<E>
implements Cloneable,
Serializable,
NSCoding,
_NSFoundationCollection,
Set<E> {
    public static final Class<NSSet> _CLASS = _NSUtilities._classWithClassLiteral(NSSet.class);
    public static final NSSet EmptySet = new NSSet();
    static final long serialVersionUID = -8833684352747517048L;
    private static final String SerializationKeysFieldKey = "objects";
    protected transient int _capacity;
    protected transient int _hashtableBuckets;
    protected transient int _count;
    protected Object[] _objects;
    protected transient Object[] _objectsCache;
    protected transient short[] _flags;
    protected transient int _hashCache;
    protected transient int _deletionLimit;
    protected static int _NSSetClassHashCode = _CLASS.hashCode();
    public static final boolean CheckForNull = true;
    public static final boolean IgnoreNull = true;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("objects", _NSUtilities._NoObjectArray.getClass())};

    protected void _initializeSet() {
        this._count = 0;
        this._capacity = 0;
        this._objectsCache = null;
        this._objects = null;
        this._flags = null;
        this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(this._capacity);
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
    }

    protected void _ensureCapacity(int capacity) {
        int newCapacity;
        int currentCapacity = this._capacity;
        if (capacity > currentCapacity && (newCapacity = _NSCollectionPrimitives.hashTableCapacityForCapacity(capacity)) != currentCapacity) {
            int oldSize = this._hashtableBuckets;
            this._capacity = newCapacity;
            this._hashtableBuckets = _NSCollectionPrimitives.hashTableBucketsForCapacity(newCapacity);
            int newSize = this._hashtableBuckets;
            if (newSize == 0) {
                this._objects = null;
                this._flags = null;
            } else {
                Object[] oldObjects = this._objects != null ? this._objects : new Object[]{};
                short[] oldFlags = this._flags;
                this._objects = new Object[newSize];
                this._flags = new short[newSize];
                int i = 0;
                while (i < oldSize) {
                    if ((oldFlags[i] & 0xFFFFC000) == Short.MIN_VALUE) {
                        _NSCollectionPrimitives.addValueToSet(oldObjects[i], this._objects, this._flags);
                    }
                    ++i;
                }
            }
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(newSize);
        }
    }

    protected void _clearDeletionsAndCollisions() {
        int size = this._hashtableBuckets;
        if (this._count == 0) {
            this._flags = new short[size];
        } else {
            Object[] oldObjects = this._objects != null ? this._objects : new Object[]{};
            short[] oldFlags = this._flags;
            this._objects = new Object[size];
            this._flags = new short[size];
            int i = 0;
            while (i < size) {
                if ((oldFlags[i] & 0xFFFFC000) == Short.MIN_VALUE) {
                    _NSCollectionPrimitives.addValueToSet(oldObjects[i], this._objects, this._flags);
                }
                ++i;
            }
        }
        this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(size);
    }

    public static <E> NSSet<E> set() {
        return NSSet.emptySet();
    }

    public static <E> NSSet<E> setWithArray(NSArray<? extends E> array) {
        return new NSSet<E>(array);
    }

    public static <E> NSSet<E> setWithObject(E object) {
        return new NSSet<E>(object);
    }

    public static <E> NSSet<E> setWithObjects(E ... objects) {
        return new NSSet<E>(objects, true);
    }

    public static <E> NSSet<E> setWithSet(NSSet<? extends E> set) {
        return new NSSet<E>(set);
    }

    public static <E> NSSet<E> setWithCollection(Collection<? extends E> objects) {
        return new NSSet<E>(objects);
    }

    public NSSet() {
        this._initializeSet();
    }

    public NSSet(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        this._initializeSet();
        this._ensureCapacity(1);
        if (_NSCollectionPrimitives.addValueToSet(object, this._objects, this._flags)) {
            ++this._count;
        }
    }

    private void initFromObjects(Object[] objects, boolean checkForNull) {
        int i;
        if (checkForNull) {
            if (objects == null) {
                this._initializeSet();
                return;
            }
            i = 0;
            while (i < objects.length) {
                if (objects[i] == null) {
                    throw new IllegalArgumentException("Attempt to insert null object into an  " + this.getClass().getName() + ".");
                }
                ++i;
            }
        }
        this._initializeSet();
        this._ensureCapacity(objects.length);
        i = 0;
        while (i < objects.length) {
            if (objects[i] != null && _NSCollectionPrimitives.addValueToSet(objects[i], this._objects, this._flags)) {
                ++this._count;
            }
            ++i;
        }
    }

    protected NSSet(Object[] objects, boolean checkForNull) {
        this.initFromObjects(objects, checkForNull);
    }

    public NSSet(E[] objects) {
        this(objects, true);
    }

    public NSSet(E object, E ... objects) {
        this(objects, true);
        this._ensureCapacity(this._count + 1);
        if (_NSCollectionPrimitives.addValueToSet(object, this._objects, this._flags)) {
            ++this._count;
        }
    }

    public NSSet(NSArray<? extends E> objects) {
        this(objects != null ? objects.objectsNoCopy() : null, false);
    }

    public NSSet(NSSet<? extends E> otherSet) {
        this(otherSet != null ? otherSet.objectsNoCopy() : null, false);
    }

    public NSSet(Set<? extends E> set, boolean ignoreNull) {
        if (set == null) {
            throw new IllegalArgumentException("Set cannot be null");
        }
        Object[] aSet = set.toArray();
        this.initFromObjects(aSet, !ignoreNull);
    }

    public NSSet(Collection<? extends E> collection) {
        if (collection == null) {
            throw new NullPointerException("collection cannot be null");
        }
        Object[] aSet = collection.toArray();
        this.initFromObjects(aSet, false);
    }

    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            this._objectsCache = this._count == 0 ? _NSCollectionPrimitives.emptyArray() : _NSCollectionPrimitives.valuesInHashTable(this._objects, this._objects, this._flags, this._capacity, this._hashtableBuckets);
        }
        return this._objectsCache;
    }

    public int count() {
        return this._count;
    }

    public E member(Object object) {
        return (E)(this._count == 0 || object == null ? null : _NSCollectionPrimitives.findValueInHashTable(object, this._objects, this._objects, this._flags));
    }

    public NSSet<E> setByIntersectingSet(NSSet<?> otherSet) {
        NSMutableSet set = new NSMutableSet(this);
        set.intersectSet(otherSet);
        return set;
    }

    public NSSet<E> setBySubtractingSet(NSSet<?> otherSet) {
        NSMutableSet set = new NSMutableSet(this);
        set.subtractSet(otherSet);
        return set;
    }

    public NSSet<E> setByUnioningSet(NSSet<? extends E> otherSet) {
        NSMutableSet<? extends E> set = new NSMutableSet<E>(this);
        set.unionSet(otherSet);
        return set;
    }

    public boolean containsObject(Object object) {
        return object != null ? this.member(object) != null : false;
    }

    public boolean intersectsSet(NSSet<?> otherSet) {
        if (this.count() != 0 && otherSet != null && otherSet.count() != 0) {
            Object[] objects = this.objectsNoCopy();
            int i = 0;
            while (i < objects.length) {
                if (otherSet.member(objects[i]) != null) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public boolean isSubsetOfSet(NSSet<?> otherSet) {
        int count = this.count();
        if (otherSet == null || otherSet.count() < count) {
            return false;
        }
        if (count == 0) {
            return true;
        }
        Object[] objects = this.objectsNoCopy();
        int i = 0;
        while (i < objects.length) {
            if (otherSet.member(objects[i]) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean _equalsSet(NSSet<?> otherSet) {
        int count = this.count();
        if (count != otherSet.count()) {
            return false;
        }
        Object[] objects = this.objectsNoCopy();
        int i = 0;
        while (i < count) {
            if (otherSet.member(objects[i]) == null) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public boolean isEqualToSet(NSSet<?> otherSet) {
        if (otherSet == null) {
            return false;
        }
        if (otherSet == this) {
            return true;
        }
        return this._equalsSet(otherSet);
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof NSSet) {
            return this._equalsSet((NSSet)object);
        }
        return false;
    }

    public E anyObject() {
        return (E)(this.count() > 0 ? this.objectsNoCopy()[0] : null);
    }

    public Object[] _allObjects() {
        int count = this.count();
        Object[] objects = new Object[count];
        if (count > 0) {
            System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        }
        return objects;
    }

    public NSArray<E> allObjects() {
        Object[] objects = this.objectsNoCopy();
        return new NSArray(objects, 0, objects.length, false, true);
    }

    public Enumeration<E> objectEnumerator() {
        return new _NSCollectionEnumerator(this._objects, this._flags, this._count);
    }

    @Override
    public Class<?> classForCoder() {
        return _CLASS;
    }

    public static Object decodeObject(NSCoder coder) {
        return new NSSet<Object>(coder.decodeObjects());
    }

    @Override
    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObjects(this.objectsNoCopy());
    }

    @Override
    public int _shallowHashCode() {
        return _NSSetClassHashCode;
    }

    @Override
    public int hashCode() {
        return _NSSetClassHashCode ^ this.count();
    }

    public HashSet<E> hashSet() {
        Object[] objects = this.objectsNoCopy();
        HashSet<Object> set = new HashSet<Object>(objects.length);
        int i = 0;
        while (i < objects.length) {
            set.add(objects[i]);
            ++i;
        }
        return set;
    }

    public Object clone() {
        return this;
    }

    public NSSet<E> immutableClone() {
        return this;
    }

    public NSMutableSet<E> mutableClone() {
        return new NSMutableSet(this);
    }

    public static final <E> NSSet<E> immutableCloneOf(NSSet<? extends E> set) {
        return set.immutableClone();
    }

    public static final <E> NSMutableSet<E> mutableCloneOf(NSSet<? extends E> set) {
        return set.mutableClone();
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer(128);
        buffer.append("(");
        Object[] objects = this.objectsNoCopy();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            if (i > 0) {
                buffer.append(", ");
            }
            if (object instanceof String) {
                buffer.append('\"');
                buffer.append((String)object);
                buffer.append('\"');
            } else if (object instanceof Boolean) {
                buffer.append((Boolean)object != false ? "true" : "false");
            } else {
                buffer.append(object.toString());
            }
            ++i;
        }
        buffer.append(")");
        return new String(buffer);
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationKeysFieldKey, this._allObjects());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        Object[] keys = (Object[])fields.get(SerializationKeysFieldKey, _NSUtilities._NoObjectArray);
        keys = keys == null ? _NSUtilities._NoObjectArray : keys;
        this.initFromObjects(keys, true);
    }

    private Object readResolve() throws ObjectStreamException {
        if (this.getClass() == _CLASS && this.count() == 0) {
            return EmptySet;
        }
        return this;
    }

    public static final <T> NSSet<T> emptySet() {
        return EmptySet;
    }

    @Override
    public int size() {
        return this._count;
    }

    @Override
    public boolean isEmpty() {
        return this._count == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.containsObject(o);
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c == null) {
            throw new NullPointerException("Collection passed into containsAll() cannot be null");
        }
        Object[] objects = c.toArray();
        if (objects.length > 0) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] == null) {
                    return false;
                }
                if (this.member(objects[i]) == null) {
                    return false;
                }
                ++i;
            }
        }
        return true;
    }

    @Override
    public Iterator<E> iterator() {
        return new _NSJavaSetIterator(this.objectsNoCopy());
    }

    @Override
    public Object[] toArray() {
        return this.objectsNoCopy();
    }

    @Override
    public <T> T[] toArray(T[] objects) {
        if (objects == null) {
            throw new NullPointerException("Cannot pass null as parameter");
        }
        int count = this.count();
        if (count <= 0) {
            return objects;
        }
        if (count > objects.length) {
            Object[] newobjects = (Object[])Array.newInstance(objects.getClass().getComponentType(), count);
            System.arraycopy(this.objectsNoCopy(), 0, newobjects, 0, count);
            return newobjects;
        }
        System.arraycopy(this.objectsNoCopy(), 0, objects, 0, count);
        return objects;
    }

    @Override
    public boolean add(E o) {
        throw new UnsupportedOperationException("add is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public boolean remove(Object o) {
        throw new UnsupportedOperationException("remove is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        throw new UnsupportedOperationException("addAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        throw new UnsupportedOperationException("removeAll is not a supported operation in com.webobjects.foundation.NSSet");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("clear is not a supported operation in com.webobjects.foundation.NSSet");
    }
}

