/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSKeyValueCoding;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSSelector<R>
implements Serializable {
    public static final Class<NSSelector> _CLASS = _NSUtilities._classWithClassLiteral(NSSelector.class);
    private static final Logger log = LoggerFactory.getLogger(NSSelector.class);
    static final long serialVersionUID = -8480824199131722348L;
    private static final String SerializationNameFieldKey = "name";
    private static final String SerializationTypesFieldKey = "types";
    protected String _name;
    protected Class<?>[] _types;
    private volatile transient Map.Entry<Class<?>, Method> _cachedEntry;
    private transient ConcurrentMap<Class<?>, Object> _classToMethodMapTable;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", _NSUtilities._StringClass), new ObjectStreamField("types", _NSUtilities._NoStringArray.getClass())};

    public static <T> T _safeInvokeSelector(NSSelector<T> selector, Object receiver, Object ... parameters) {
        try {
            return selector.invoke(receiver, parameters);
        }
        catch (InvocationTargetException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("Either the receiver or the method is not public: " + e.getMessage());
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException(e.getMessage());
        }
    }

    public static Object _safeInvokeMethod(Method method, Object receiver, Object ... parameters) {
        try {
            return method.invoke(receiver, parameters);
        }
        catch (InvocationTargetException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        catch (IllegalAccessException e) {
            throw new IllegalArgumentException("<NSSelector> method is not public: " + method + "\n" + e.getMessage());
        }
        catch (IllegalArgumentException e2) {
            throw new IllegalArgumentException("<NSSelector> method has wrong number of arguments: " + method + "\n" + e2.getMessage());
        }
    }

    public NSSelector(String name) {
        this(name, null);
    }

    private void initFromObjects(String name, Class<?> ... parameterTypes) {
        if (name == null) {
            throw new IllegalArgumentException("Selector name cannot be null");
        }
        this._name = name;
        if (parameterTypes != null) {
            this._types = new Class[parameterTypes.length];
            System.arraycopy(parameterTypes, 0, this._types, 0, parameterTypes.length);
        } else {
            this._types = _NSUtilities._NoClassArray;
        }
        this._classToMethodMapTable = new ConcurrentHashMap(8);
    }

    public NSSelector(String name, Class<?> ... parameterTypes) {
        this.initFromObjects(name, parameterTypes);
    }

    public boolean equals(Object otherSelector) {
        Class<?>[] parameterTypes;
        NSSelector selector;
        if (otherSelector == this) {
            return true;
        }
        if (otherSelector instanceof NSSelector && this._name.equals((selector = (NSSelector)otherSelector).name()) && (parameterTypes = selector.parameterTypes()).length == this._types.length) {
            int i = 0;
            while (i < parameterTypes.length) {
                if (parameterTypes[i] != this._types[i]) {
                    return false;
                }
                ++i;
            }
            return true;
        }
        return false;
    }

    public String name() {
        return this._name;
    }

    public Class<?>[] parameterTypes() {
        if (this._types.length == 0) {
            return this._types;
        }
        Class[] types = new Class[this._types.length];
        System.arraycopy(this._types, 0, types, 0, this._types.length);
        return types;
    }

    private synchronized Method _methodOnClass(Class<?> targetClass) {
        Map.Entry<Class<?>, Method> cachedEntry = this._cachedEntry;
        if (cachedEntry != null && targetClass == cachedEntry.getKey()) {
            return cachedEntry.getValue();
        }
        targetClass.getName();
        Method method = null;
        Object value = this._classToMethodMapTable.get(targetClass);
        if (value == null) {
            try {
                method = targetClass.getMethod(this._name, this._types);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                log.debug("Exception while getting method {} on class: {}", (Object)this._name, (Object)targetClass.getName());
            }
            value = method;
            if (value == null) {
                value = NSKeyValueCoding.NullValue;
            }
            this._classToMethodMapTable.put(targetClass, value);
        } else if (value != NSKeyValueCoding.NullValue) {
            method = (Method)value;
        }
        this._cachedEntry = new AbstractMap.SimpleImmutableEntry(targetClass, method);
        return method;
    }

    public Method methodOnClass(Class<?> targetClass) throws NoSuchMethodException {
        if (targetClass == null) {
            throw new IllegalArgumentException("Target class cannot be null");
        }
        Method method = this._methodOnClass(targetClass);
        if (method == null) {
            throw new NoSuchMethodException("Class " + targetClass.getName() + " does not implement method " + this._name);
        }
        return method;
    }

    public Method methodOnObject(Object target) throws NoSuchMethodException {
        if (target == null) {
            throw new IllegalArgumentException("Target cannot be null");
        }
        return this.methodOnClass(target.getClass());
    }

    public boolean implementedByClass(Class<?> targetClass) {
        if (targetClass != null) {
            return this._methodOnClass(targetClass) != null;
        }
        return false;
    }

    public boolean implementedByObject(Object target) {
        return target != null ? this.implementedByClass(target.getClass()) : false;
    }

    public R invoke(Object target, Object[] parameters) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        try {
            return (R)this.methodOnClass(target instanceof Class ? (Class<?>)target : target.getClass()).invoke(target, parameters);
        }
        catch (InvocationTargetException exception) {
            throw NSForwardException._runtimeExceptionForThrowable(exception);
        }
    }

    public R invoke(Object target) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        return this.invoke(target, null);
    }

    public R invoke(Object target, Object argument) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        return this.invoke(target, new Object[]{argument});
    }

    public R invoke(Object target, Object argument1, Object argument2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        return this.invoke(target, new Object[]{argument1, argument2});
    }

    public static Object invoke(String name, Class<?>[] parameterTypes, Object target, Object[] parameters) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        NSSelector selector = new NSSelector(name, parameterTypes);
        return selector.invoke(target, parameters);
    }

    public static Object invoke(String name, Class<?> parameterType, Object target, Object argument) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        if (parameterType == null) {
            throw new IllegalArgumentException("Parameter type cannot be null");
        }
        NSSelector selector = new NSSelector(name, parameterType);
        return selector.invoke(target, new Object[]{argument});
    }

    public static Object invoke(String name, Class<?> parameterType1, Class<?> parameterType2, Object target, Object argument1, Object argument2) throws IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException {
        if (parameterType1 == null || parameterType2 == null) {
            throw new IllegalArgumentException("Neither parameter type can be null");
        }
        NSSelector selector = new NSSelector(name, parameterType1, parameterType2);
        return selector.invoke(target, new Object[]{argument1, argument2});
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    public String toString() {
        return "<" + this.getClass().toString() + " (methodName=" + this._name + ")>";
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        Class<?>[] types = this.parameterTypes();
        String[] parameterTypesClassNames = new String[types.length];
        int i = 0;
        int l = types.length;
        while (i < l) {
            parameterTypesClassNames[i] = types[i] == null ? null : types[i].getName();
            ++i;
        }
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationNameFieldKey, this.name());
        fields.put(SerializationTypesFieldKey, parameterTypesClassNames);
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        String name = (String)fields.get(SerializationNameFieldKey, null);
        String[] parameterTypesClassNames = (String[])fields.get(SerializationTypesFieldKey, null);
        Class[] types = new Class[parameterTypesClassNames.length];
        int i = 0;
        int l = parameterTypesClassNames.length;
        while (i < l) {
            types[i] = parameterTypesClassNames[i] == null ? null : Class.forName(parameterTypesClassNames[i]);
            ++i;
        }
        this.initFromObjects(name, types);
    }
}

