/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSForwardException;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableData;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSProperties;
import com.webobjects.foundation.NSTimestamp;
import com.webobjects.foundation.NSValueUtilities;
import com.webobjects.foundation._NSBase64;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation.plist._BinaryPListImpl;
import com.webobjects.foundation.plist._JSONPListImpl;
import com.webobjects.foundation.properties.NSArrayProperty;
import com.webobjects.foundation.xml._NSXMLUtilities;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.net.URL;
import java.text.Normalizer;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.TimeZone;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXParseException;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class NSPropertyListSerialization {
    private static final Set<Object> _globallySharedValues = Collections.synchronizedSet(new HashSet());
    private static final Logger log = LoggerFactory.getLogger(NSPropertyListSerialization.class);
    public static final Class<NSPropertyListSerialization> _CLASS = _NSUtilities._classWithClassLiteral(NSPropertyListSerialization.class);
    private static final int EOT = -1;
    public static final boolean Indents = true;
    public static final boolean NoIndents = false;
    public static final boolean ForceXML = true;
    public static final int MAX_DEPTH = 1000;

    private NSPropertyListSerialization() {
        throw new IllegalStateException("Can't instantiate an instance of class " + this.getClass().getName());
    }

    public static String stringFromPropertyList(Object plist) {
        return NSPropertyListSerialization.stringFromPropertyList(plist, true);
    }

    public static String stringFromPropertyList(Object plist, boolean indents) {
        return new _ApplePList(indents).stringFromPropertyList(plist);
    }

    public static String debugStringFromPropertyList(Object plist) {
        return new _AppleDebugPList(true).stringFromPropertyList(plist);
    }

    public static String xmlStringFromPropertyList(Object plist) {
        return NSPropertyListSerialization.xmlStringFromPropertyList(plist, true);
    }

    public static String xmlStringFromPropertyList(Object plist, boolean indents) {
        return new _XML(indents).stringFromPropertyList(plist);
    }

    static boolean startsWithXMLDeclaration(String string) {
        return string != null && string.trim().startsWith("<?xml");
    }

    public static Object propertyListFromString(String string) {
        return NSPropertyListSerialization.propertyListFromString(string, false);
    }

    public static Object propertyListFromString(String string, boolean forceXML) {
        if (forceXML || NSPropertyListSerialization.startsWithXMLDeclaration(string)) {
            return new _XML().parseStringIntoPlist(string);
        }
        return new _ApplePList().parseStringIntoPlist(string);
    }

    public static Object propertyListWithPathURL(URL url) {
        return NSPropertyListSerialization.propertyListWithPathURL(url, false);
    }

    public static Object propertyListWithPathURL(URL url, boolean forceXML) {
        if (url == null) {
            return null;
        }
        return NSPropertyListSerialization.propertyListFromString(_NSStringUtilities.stringFromPathURL(url), forceXML);
    }

    public static Object propertyListFromJSONString(String string) {
        return NSPropertyListSerialization.propertyListFromJSONString(string, null);
    }

    public static Object propertyListFromJSONString(String string, Normalizer.Form normalizerForm) {
        return new _JSONPListImpl().propertyListFromString(string, normalizerForm);
    }

    public static String jsonStringFromPropertyList(Object plist) {
        return new _JSONPListImpl().stringFromPropertyList(plist, true);
    }

    public static String jsonStringFromPropertyList(Object plist, boolean suppressWhiteSpace) {
        return new _JSONPListImpl().stringFromPropertyList(plist, suppressWhiteSpace);
    }

    @Deprecated
    public static NSData dataFromPropertyList(Object plist) {
        return NSPropertyListSerialization.dataFromPropertyList(plist, null);
    }

    public static NSData dataFromPropertyList(Object plist, String encoding) {
        if (plist == null) {
            return null;
        }
        return new NSData(_NSStringUtilities.bytesForString(NSPropertyListSerialization.stringFromPropertyList(plist), encoding));
    }

    @Deprecated
    public static Object propertyListFromData(NSData data) {
        return NSPropertyListSerialization.propertyListFromData(data, null);
    }

    public static Object propertyListFromData(NSData data, String encoding) {
        if (data == null) {
            return null;
        }
        return NSPropertyListSerialization.propertyListFromString(_NSStringUtilities.stringForBytes(data.bytes(), encoding));
    }

    public static Object propertyListFromBinaryStream(InputStream is) {
        return NSPropertyListSerialization.propertyListFromStream(is, PListFormat.NSPropertyListBinaryFormat_v1_0, null);
    }

    public static Object propertyListFromBinaryStream(InputStream is, Normalizer.Form form) {
        return NSPropertyListSerialization.propertyListFromStream(is, PListFormat.NSPropertyListBinaryFormat_v1_0, null, form);
    }

    public static Object propertyListFromStream(InputStream is, PListFormat type, String encoding) {
        return NSPropertyListSerialization.propertyListFromStream(is, type, encoding, null);
    }

    public static Object propertyListFromStream(InputStream is, PListFormat type, String encoding, Normalizer.Form normalizerForm) {
        Object obj;
        if (is == null) {
            return null;
        }
        switch (type) {
            case NSPropertyListBinaryFormat_v1_0: {
                obj = new _BinaryPListImpl().propertyListWithStream(is, normalizerForm);
                break;
            }
            case NSPropertyListXMLFormat_v1_0: {
                obj = NSPropertyListSerialization.propertyListFromString(_NSStringUtilities.stringFromInputStream(is, encoding), true);
                break;
            }
            case NSPropertyListOpenStepFormat: {
                obj = NSPropertyListSerialization.propertyListFromString(_NSStringUtilities.stringFromInputStream(is, encoding), false);
                break;
            }
            case NSPropertyListJsonFormat_v1_0: {
                obj = NSPropertyListSerialization.propertyListFromJSONString(_NSStringUtilities.stringFromInputStream(is, encoding), normalizerForm);
                break;
            }
            default: {
                obj = NSPropertyListSerialization.propertyListFromString(_NSStringUtilities.stringFromInputStream(is, encoding));
            }
        }
        return obj;
    }

    public static boolean booleanForString(String value) {
        if (value != null) {
            String testValue = value.toLowerCase().trim();
            return testValue.equals("yes") || testValue.equals("true");
        }
        return false;
    }

    public static int intForString(String value) {
        if (value != null) {
            try {
                return Integer.parseInt(value.trim());
            }
            catch (Exception exception) {
                throw NSForwardException._runtimeExceptionForThrowable(exception);
            }
        }
        return 0;
    }

    public static NSArray arrayWithPathURL(URL url) {
        return NSPropertyListSerialization.arrayWithPathURL(url, false);
    }

    public static NSArray arrayWithPathURL(URL url, boolean forceXML) {
        Object result = NSPropertyListSerialization.propertyListWithPathURL(url, forceXML);
        return result instanceof NSArray ? (NSArray)result : NSArray.EmptyArray;
    }

    public static NSArray arrayForString(String value) {
        return NSPropertyListSerialization.arrayForString(value, false);
    }

    public static NSArray arrayForString(String value, boolean forceXML) {
        Object result = NSPropertyListSerialization.propertyListFromString(value, forceXML);
        return result instanceof NSArray ? (NSArray)result : NSArray.EmptyArray;
    }

    public static NSDictionary dictionaryWithPathURL(URL url) {
        return NSPropertyListSerialization.dictionaryWithPathURL(url, false);
    }

    public static Object propertyListWithBinaryPropertyListURL(URL url) {
        if (url == null) {
            return null;
        }
        _BinaryPListImpl parser = new _BinaryPListImpl();
        try {
            return parser.propertyListWithURL(url, null);
        }
        catch (IOException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
    }

    public static Document documentWithBinaryPropertyListURL(URL url) {
        if (url == null) {
            return null;
        }
        _BinaryPListImpl parser = new _BinaryPListImpl();
        Document doc = parser.propertyListDocumentWithURL(url, null);
        return doc;
    }

    public static String xmlStringWithBinaryPropertyListURL(URL url) {
        if (url == null) {
            return "";
        }
        return NSPropertyListSerialization.convertDOMToString(NSPropertyListSerialization.documentWithBinaryPropertyListURL(url));
    }

    private static String convertDOMToString(Document doc) {
        if (doc == null) {
            return null;
        }
        StringWriter stringOut = new StringWriter();
        try {
            TransformerFactory tf = TransformerFactory.newInstance();
            Transformer transformer = tf.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            DOMSource domSource = new DOMSource(doc);
            StreamResult result = new StreamResult(stringOut);
            transformer.transform(domSource, result);
        }
        catch (TransformerConfigurationException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        catch (TransformerException e) {
            throw NSForwardException._runtimeExceptionForThrowable(e);
        }
        return stringOut.toString();
    }

    public static NSDictionary dictionaryWithPathURL(URL url, boolean forceXML) {
        Object result = NSPropertyListSerialization.propertyListWithPathURL(url, forceXML);
        return result instanceof NSDictionary ? (NSDictionary)result : NSDictionary.EmptyDictionary;
    }

    public static NSDictionary dictionaryForString(String value) {
        return NSPropertyListSerialization.dictionaryForString(value, false);
    }

    public static NSDictionary dictionaryForString(String value, boolean forceXML) {
        Object result = NSPropertyListSerialization.propertyListFromString(value, forceXML);
        return result instanceof NSDictionary ? (NSDictionary)result : NSDictionary.EmptyDictionary;
    }

    public static void writePropertyListToStream(Object plist, OutputStream out, PListFormat type, String encoding) {
        if (plist == null || out == null) {
            return;
        }
        String plistString = null;
        switch (type) {
            case NSPropertyListBinaryFormat_v1_0: {
                _BinaryPListImpl parser = new _BinaryPListImpl();
                try {
                    parser.writePropertyListToStream(plist, out);
                    break;
                }
                catch (IOException e) {
                    throw new NSForwardException("Error writing binary formatted plist to outputstream.", e);
                }
            }
            case NSPropertyListXMLFormat_v1_0: {
                plistString = NSPropertyListSerialization.xmlStringFromPropertyList(plist, false);
                if (plistString == null) break;
                try {
                    out.write(plistString.getBytes(encoding));
                    break;
                }
                catch (IOException e) {
                    throw new NSForwardException("Error writing xml formatted plist to outputstream.", e);
                }
            }
            case NSPropertyListOpenStepFormat: {
                plistString = NSPropertyListSerialization.stringFromPropertyList(plist, false);
                if (plistString == null) break;
                try {
                    out.write(plistString.getBytes(encoding));
                    break;
                }
                catch (IOException e) {
                    throw new NSForwardException("Error writing ascii formatted plist to outputstream.", e);
                }
            }
            case NSPropertyListJsonFormat_v1_0: {
                plistString = NSPropertyListSerialization.jsonStringFromPropertyList(plist, false);
                if (plistString == null) break;
                try {
                    out.write(plistString.getBytes(encoding));
                    break;
                }
                catch (IOException e) {
                    throw new NSForwardException("Error writing jsons formatted plist to outputstream.", e);
                }
            }
        }
    }

    public static void addGloballySharedValue(Object ... objects) {
        Object[] objectArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            Object o = objectArray[n2];
            _globallySharedValues.add(o);
            ++n2;
        }
    }

    public static enum PListFormat {
        NSPropertyListOpenStepFormat,
        NSPropertyListXMLFormat_v1_0,
        NSPropertyListBinaryFormat_v1_0,
        NSPropertyListJsonFormat_v1_0;

    }

    public static class _AppleDebugPList
    extends _ApplePList {
        public _AppleDebugPList(boolean indent) {
            super(indent);
        }

        @Override
        protected void _appendObjectToStringBuffer(Object obj, StringBuffer stringbuffer, int i) {
            if (obj instanceof String) {
                this._appendStringToStringBuffer((String)obj, stringbuffer, i);
            } else if (obj instanceof StringBuffer) {
                this._appendStringToStringBuffer(((StringBuffer)obj).toString(), stringbuffer, i);
            } else if (obj instanceof NSData) {
                this._appendDataToStringBuffer((NSData)obj, stringbuffer, i);
            } else if (obj instanceof NSArray) {
                this._appendArrayToStringBuffer((NSArray)obj, stringbuffer, i);
            } else if (obj instanceof NSDictionary) {
                this._appendDictionaryToStringBuffer((NSDictionary)obj, stringbuffer, i);
            } else if (obj instanceof Boolean) {
                String s = (Boolean)obj != false ? "true" : "false";
                this._appendUnquotedStringToStringBuffer(s, stringbuffer, i);
            } else {
                this._appendUnquotedStringToStringBuffer(obj.toString(), stringbuffer, i);
            }
        }

        @Override
        protected void _appendDictionaryToStringBuffer(NSDictionary<?, ?> nsdictionary, StringBuffer stringbuffer, int i) {
            stringbuffer.append('{');
            int j = nsdictionary.count();
            if (j > 0) {
                Enumeration<?> enumeration = nsdictionary.keyEnumerator();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    this._appendNewLineToStringBuffer(stringbuffer, i);
                    this._appendIndentationToStringBuffer(stringbuffer, i + 1);
                    this._appendUnquotedStringToStringBuffer(obj.toString(), stringbuffer, i + 1);
                    stringbuffer.append(" = ");
                    this._appendObjectToStringBuffer(nsdictionary.objectForKey(obj), stringbuffer, i + 1);
                    stringbuffer.append(';');
                }
                this._appendNewLineToStringBuffer(stringbuffer, i);
                this._appendIndentationToStringBuffer(stringbuffer, i);
            }
            stringbuffer.append('}');
        }
    }

    public static class _ApplePList
    extends _PListParser {
        private int _lineNumber;
        private int _startOfLineCharIndex;
        private int _savedIndex;
        private int _savedLineNumber;
        private int _savedStartOfLineCharIndex;
        private static final int _C_NON_COMMENT_OR_SPACE = 1;
        private static final int _C_WHITESPACE = 2;
        private static final int _C_SINGLE_LINE_COMMENT = 3;
        private static final int _C_MULTI_LINE_COMMENT = 4;
        private static final int[] NSToPrecompUnicodeTable = new int[]{160, 192, 193, 194, 195, 196, 197, 199, 200, 201, 202, 203, 204, 205, 206, 207, 208, 209, 210, 211, 212, 213, 214, 217, 218, 219, 220, 221, 222, 181, 215, 247, 169, 161, 162, 163, 8260, 165, 402, 167, 164, 8217, 8220, 171, 8249, 8250, 64257, 64258, 174, 8211, 8224, 8225, 183, 166, 182, 8226, 8218, 8222, 8221, 187, 8230, 8240, 172, 191, 185, 715, 180, 710, 732, 175, 728, 729, 168, 178, 730, 184, 179, 733, 731, 711, 8212, 177, 188, 189, 190, 224, 225, 226, 227, 228, 229, 231, 232, 233, 234, 235, 236, 198, 237, 170, 238, 239, 240, 241, 321, 216, 338, 186, 242, 243, 244, 245, 246, 230, 249, 250, 251, 305, 252, 253, 322, 248, 339, 223, 254, 255, 65533, 65533};

        public _ApplePList() {
            super(true);
        }

        public _ApplePList(boolean indents) {
            super(indents);
        }

        private void _saveIndexes(int i, int j, int k) {
            this._savedIndex = i;
            this._savedLineNumber = j;
            this._savedStartOfLineCharIndex = k;
        }

        private String _savedIndexesAsString() {
            StringBuilder result = new StringBuilder();
            if (this._includeLineNumbersOnErrors()) {
                result.append("line number: " + this._savedLineNumber + ", ");
            }
            result.append("column: " + (this._savedIndex - this._savedStartOfLineCharIndex));
            return result.toString();
        }

        public static boolean propertyListsAreEqual(Object obj, Object obj1) {
            if (obj == null && obj1 == null) {
                return true;
            }
            if ((obj instanceof String || obj instanceof StringBuffer) && (obj1 instanceof String || obj1 instanceof StringBuffer)) {
                return obj.toString().equals(obj1.toString());
            }
            if (obj instanceof NSData && obj1 instanceof NSData) {
                return ((NSData)obj).isEqualToData((NSData)obj1);
            }
            if (obj instanceof NSArray && obj1 instanceof NSArray) {
                int k;
                NSArray nsarray = (NSArray)obj;
                NSArray nsarray1 = (NSArray)obj1;
                int i = nsarray.count();
                if (i != (k = nsarray1.count())) {
                    return false;
                }
                int i1 = 0;
                while (i1 < i) {
                    if (!_ApplePList.propertyListsAreEqual(nsarray.objectAtIndex(i1), nsarray1.objectAtIndex(i1))) {
                        return false;
                    }
                    ++i1;
                }
                return true;
            }
            if (obj instanceof NSDictionary && obj1 instanceof NSDictionary) {
                int l;
                NSDictionary nsdictionary = (NSDictionary)obj;
                NSDictionary nsdictionary1 = (NSDictionary)obj1;
                int j = nsdictionary.count();
                if (j != (l = nsdictionary1.count())) {
                    return false;
                }
                Enumeration enumeration = nsdictionary.keyEnumerator();
                while (enumeration.hasMoreElements()) {
                    Object obj2 = enumeration.nextElement();
                    Object obj3 = nsdictionary1.objectForKey(obj2);
                    if (obj3 == null) {
                        return false;
                    }
                    Object obj4 = nsdictionary.objectForKey(obj2);
                    if (_ApplePList.propertyListsAreEqual(obj4, obj3)) continue;
                    return false;
                }
                return true;
            }
            return false;
        }

        public static Object copyPropertyList(Object obj) {
            if (obj == null) {
                return null;
            }
            if (obj instanceof String) {
                return obj;
            }
            if (obj instanceof StringBuffer) {
                return new String((StringBuffer)obj);
            }
            if (obj instanceof NSData) {
                return ((NSData)obj).clone();
            }
            if (obj instanceof NSArray) {
                NSArray array = (NSArray)obj;
                int i = array.count();
                NSMutableArray<int> newArray = new NSMutableArray<int>(i);
                int j = 0;
                while (j < i) {
                    newArray.addObject((int)_ApplePList.copyPropertyList(array.objectAtIndex(j)));
                    ++j;
                }
                return newArray;
            }
            if (obj instanceof NSDictionary) {
                NSDictionary dictionary = (NSDictionary)obj;
                NSMutableDictionary<Object, Object> newDictionary = new NSMutableDictionary<Object, Object>(dictionary.count());
                Object key = null;
                Object value = null;
                Enumeration enumeration = dictionary.keyEnumerator();
                while (enumeration.hasMoreElements()) {
                    key = enumeration.nextElement();
                    value = dictionary.objectForKey(key);
                    newDictionary.setObjectForKey(_ApplePList.copyPropertyList(value), _ApplePList.copyPropertyList(key));
                }
                return newDictionary;
            }
            throw new IllegalArgumentException("Property list copying failed while attempting to copy non property list type: " + obj.getClass().getName());
        }

        public String stringFromPropertyList(Object plist) {
            if (plist == null) {
                return null;
            }
            StringBuffer buffer = new StringBuffer(128);
            this._appendObjectToStringBuffer(plist, buffer, 0);
            return buffer.toString();
        }

        @Override
        public Object parseStringIntoPlist(String string) {
            if (string == null) {
                return null;
            }
            char[] charArray = string.toCharArray();
            Object[] aobj = new Object[1];
            this._lineNumber = 1;
            this._startOfLineCharIndex = 0;
            aobj[0] = null;
            int i = 0;
            i = this._readObjectIntoObjectReference(charArray, i, aobj, 1000);
            if ((i = this._skipWhitespaceAndComments(charArray, i)) != -1) {
                String error = "parseStringIntoPlist parsed an object, but there's still more text in the string. A plist should contain only one top-level object. At ";
                if (this._includeLineNumbersOnErrors()) {
                    error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                }
                error = String.valueOf(error) + "column: " + (i - this._startOfLineCharIndex) + ".";
                throw new IllegalArgumentException(error);
            }
            return aobj[0];
        }

        protected void _appendObjectToStringBuffer(Object obj, StringBuffer stringbuffer, int i) {
            if (obj instanceof String) {
                this._appendStringToStringBuffer((String)obj, stringbuffer, i);
            } else if (obj instanceof StringBuffer) {
                this._appendStringToStringBuffer(((StringBuffer)obj).toString(), stringbuffer, i);
            } else if (obj instanceof NSData) {
                this._appendDataToStringBuffer((NSData)obj, stringbuffer, i);
            } else if (obj instanceof NSArray) {
                this._appendArrayToStringBuffer((NSArray)obj, stringbuffer, i);
            } else if (obj instanceof NSDictionary) {
                this._appendDictionaryToStringBuffer((NSDictionary)obj, stringbuffer, i);
            } else if (obj instanceof Boolean) {
                String s = (Boolean)obj != false ? "true" : "false";
                this._appendStringToStringBuffer(s, stringbuffer, i);
            } else {
                this._appendStringToStringBuffer(obj.toString(), stringbuffer, i);
            }
        }

        protected void _appendUnquotedStringToStringBuffer(String s, StringBuffer stringbuffer, int i) {
            char[] ac = s.toCharArray();
            int j = 0;
            while (j < ac.length) {
                if (ac[j] < '\u0080') {
                    if (ac[j] == '\n') {
                        stringbuffer.append("\\n");
                    } else if (ac[j] == '\r') {
                        stringbuffer.append("\\r");
                    } else if (ac[j] == '\t') {
                        stringbuffer.append("\\t");
                    } else if (ac[j] == '\"') {
                        stringbuffer.append('\\');
                        stringbuffer.append('\"');
                    } else if (ac[j] == '\\') {
                        stringbuffer.append("\\\\");
                    } else if (ac[j] == '\f') {
                        stringbuffer.append("\\f");
                    } else if (ac[j] == '\b') {
                        stringbuffer.append("\\b");
                    } else if (ac[j] == '\u0007') {
                        stringbuffer.append("\\a");
                    } else if (ac[j] == '\u000b') {
                        stringbuffer.append("\\v");
                    } else {
                        stringbuffer.append(ac[j]);
                    }
                } else {
                    char c = ac[j];
                    byte byte0 = (byte)(c & 0xF);
                    c = (char)(c >> 4);
                    byte byte1 = (byte)(c & 0xF);
                    c = (char)(c >> 4);
                    byte byte2 = (byte)(c & 0xF);
                    c = (char)(c >> 4);
                    byte byte3 = (byte)(c & 0xF);
                    c = (char)(c >> 4);
                    stringbuffer.append("\\U");
                    stringbuffer.append(this._hexDigitForNibble(byte3));
                    stringbuffer.append(this._hexDigitForNibble(byte2));
                    stringbuffer.append(this._hexDigitForNibble(byte1));
                    stringbuffer.append(this._hexDigitForNibble(byte0));
                }
                ++j;
            }
        }

        protected void _appendStringToStringBuffer(String s, StringBuffer stringbuffer, int i) {
            stringbuffer.append('\"');
            this._appendUnquotedStringToStringBuffer(s, stringbuffer, i);
            stringbuffer.append('\"');
        }

        protected void _appendDataToStringBuffer(NSData nsdata, StringBuffer stringbuffer, int i) {
            stringbuffer.append('<');
            byte[] abyte0 = nsdata.bytes();
            int j = 0;
            while (j < abyte0.length) {
                byte byte0 = abyte0[j];
                byte byte1 = (byte)(byte0 & 0xF);
                byte0 = (byte)(byte0 >> 4);
                byte byte2 = (byte)(byte0 & 0xF);
                stringbuffer.append(this._hexDigitForNibble(byte2));
                stringbuffer.append(this._hexDigitForNibble(byte1));
                ++j;
            }
            stringbuffer.append('>');
        }

        protected void _appendArrayToStringBuffer(NSArray<?> nsarray, StringBuffer stringbuffer, int i) {
            stringbuffer.append('(');
            int j = nsarray.count();
            if (j > 0) {
                int k = 0;
                while (k < j) {
                    if (k > 0) {
                        stringbuffer.append(',');
                    }
                    this._appendNewLineToStringBuffer(stringbuffer, i);
                    this._appendIndentationToStringBuffer(stringbuffer, i + 1);
                    this._appendObjectToStringBuffer(nsarray.objectAtIndex(k), stringbuffer, i + 1);
                    ++k;
                }
                this._appendNewLineToStringBuffer(stringbuffer, i);
                this._appendIndentationToStringBuffer(stringbuffer, i);
            }
            stringbuffer.append(')');
        }

        protected void _appendDictionaryToStringBuffer(NSDictionary<?, ?> nsdictionary, StringBuffer stringbuffer, int i) {
            stringbuffer.append('{');
            int j = nsdictionary.count();
            if (j > 0) {
                Enumeration<?> enumeration = nsdictionary.keyEnumerator();
                while (enumeration.hasMoreElements()) {
                    Object obj = enumeration.nextElement();
                    if (!(obj instanceof String)) {
                        throw new IllegalArgumentException("Property list generation failed while attempting to write hashtable. Non-String key found in Hashtable. Property list dictionaries must have String's as keys.");
                    }
                    this._appendNewLineToStringBuffer(stringbuffer, i);
                    this._appendIndentationToStringBuffer(stringbuffer, i + 1);
                    this._appendStringToStringBuffer((String)obj, stringbuffer, i + 1);
                    stringbuffer.append(" = ");
                    this._appendObjectToStringBuffer(nsdictionary.objectForKey(obj), stringbuffer, i + 1);
                    stringbuffer.append(';');
                }
                this._appendNewLineToStringBuffer(stringbuffer, i);
                this._appendIndentationToStringBuffer(stringbuffer, i);
            }
            stringbuffer.append('}');
        }

        private final char _hexDigitForNibble(byte nibble) {
            char c = '\u0000';
            if (nibble >= 0 && nibble <= 9) {
                c = (char)(48 + (char)nibble);
            } else if (nibble >= 10 && nibble <= 15) {
                c = (char)(97 + (char)(nibble - 10));
            }
            return c;
        }

        private int _readObjectIntoObjectReference(char[] ac, int index, Object[] aobj, int depthLeft) {
            if (depthLeft <= 0 && NSProperties.booleanForKeyWithDefault("NSPropertyListSerialization.CheckMaxDeepness", true)) {
                throw new RuntimeException("The provided property list was more than 1000 levels deep.");
            }
            int aBufferIndex = index;
            if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1 || aBufferIndex >= ac.length) {
                aobj[0] = null;
            } else if (ac[aBufferIndex] == '\"') {
                StringBuffer buffer = new StringBuffer(64);
                aBufferIndex = this._readQuotedStringIntoStringBuffer(ac, aBufferIndex, buffer);
                aobj[0] = buffer.toString();
            } else if (ac[aBufferIndex] == '<') {
                NSMutableData data = new NSMutableData(this._lengthOfData(ac, aBufferIndex));
                aBufferIndex = this._readDataContentsIntoData(ac, aBufferIndex, data);
                aobj[0] = data;
            } else if (ac[aBufferIndex] == '(') {
                NSMutableArray<Object> array = new NSMutableArray<Object>();
                aBufferIndex = this._readArrayContentsIntoArray(ac, aBufferIndex, array, depthLeft);
                aobj[0] = array;
            } else if (ac[aBufferIndex] == '{') {
                NSMutableDictionary<String, Object> dictionary = new NSMutableDictionary<String, Object>();
                aBufferIndex = this._readDictionaryContentsIntoDictionary(ac, aBufferIndex, dictionary, depthLeft);
                aobj[0] = dictionary;
            } else {
                StringBuffer buffer = new StringBuffer(64);
                aBufferIndex = this._readUnquotedStringIntoStringBuffer(ac, aBufferIndex, buffer);
                aobj[0] = buffer.toString();
            }
            return aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _readUnquotedStringIntoStringBuffer(char[] ac, int index, StringBuffer buffer) {
            int aBufferIndex;
            int j = aBufferIndex = index;
            buffer.setLength(0);
            while (aBufferIndex < ac.length && (ac[aBufferIndex] >= 'a' && ac[aBufferIndex] <= 'z' || ac[aBufferIndex] >= 'A' && ac[aBufferIndex] <= 'Z' || ac[aBufferIndex] >= '0' && ac[aBufferIndex] <= '9' || ac[aBufferIndex] == '_' || ac[aBufferIndex] == '$' || ac[aBufferIndex] == ':' || ac[aBufferIndex] == '.' || ac[aBufferIndex] == '/' || ac[aBufferIndex] == '-')) {
                ++aBufferIndex;
            }
            if (j >= aBufferIndex) {
                String error = "Property list parsing failed while attempting to read unquoted string. No allowable characters were found. At ";
                if (this._includeLineNumbersOnErrors()) {
                    error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                }
                error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                throw new IllegalArgumentException(error);
            }
            buffer.append(ac, j, aBufferIndex - j);
            return aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _readQuotedStringIntoStringBuffer(char[] ac, int index, StringBuffer stringbuffer) {
            int aBufferIndex = index;
            this._saveIndexes(aBufferIndex, this._lineNumber, this._startOfLineCharIndex);
            int j = ++aBufferIndex;
            while (aBufferIndex < ac.length && ac[aBufferIndex] != '\"') {
                if (ac[aBufferIndex] == '\\') {
                    if (j < aBufferIndex) {
                        stringbuffer.append(ac, j, aBufferIndex - j);
                    }
                    if (++aBufferIndex >= ac.length) {
                        String error = "Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".";
                        throw new IllegalArgumentException(error);
                    }
                    if (ac[aBufferIndex] == 'n') {
                        stringbuffer.append('\n');
                    } else if (ac[aBufferIndex] == 'r') {
                        stringbuffer.append('\r');
                        ++aBufferIndex;
                    } else if (ac[aBufferIndex] == 't') {
                        stringbuffer.append('\t');
                        ++aBufferIndex;
                    } else if (ac[aBufferIndex] == 'f') {
                        stringbuffer.append('\f');
                        ++aBufferIndex;
                    } else if (ac[aBufferIndex] == 'b') {
                        stringbuffer.append('\b');
                        ++aBufferIndex;
                    } else if (ac[aBufferIndex] == 'a') {
                        stringbuffer.append('\u0007');
                        ++aBufferIndex;
                    } else if (ac[aBufferIndex] == 'v') {
                        stringbuffer.append('\u000b');
                        ++aBufferIndex;
                    } else if (ac[aBufferIndex] == 'u' || ac[aBufferIndex] == 'U') {
                        if (aBufferIndex + 4 >= ac.length) {
                            String error = "Property list parsing failed while attempting to read quoted string. Input exhausted before escape sequence was completed.  Opening quote was at " + this._savedIndexesAsString() + ".";
                            throw new IllegalArgumentException(error);
                        }
                        if (!(this._isHexDigit(ac[++aBufferIndex]) && this._isHexDigit(ac[aBufferIndex + 1]) && this._isHexDigit(ac[aBufferIndex + 2]) && this._isHexDigit(ac[aBufferIndex + 3]))) {
                            String error = "Property list parsing failed while attempting to read quoted string. Improperly formed \\U type escape sequence. At ";
                            if (this._includeLineNumbersOnErrors()) {
                                error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                            }
                            error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                            throw new IllegalArgumentException(error);
                        }
                        byte byte0 = this._nibbleForHexDigit(ac[aBufferIndex]);
                        byte byte1 = this._nibbleForHexDigit(ac[aBufferIndex + 1]);
                        byte byte2 = this._nibbleForHexDigit(ac[aBufferIndex + 2]);
                        byte byte3 = this._nibbleForHexDigit(ac[aBufferIndex + 3]);
                        stringbuffer.append((char)((byte0 << 12) + (byte1 << 8) + (byte2 << 4) + byte3));
                        aBufferIndex += 4;
                    } else if (ac[aBufferIndex] >= '0' && ac[aBufferIndex] <= '7') {
                        int k = 0;
                        int l = 1;
                        int[] ai = new int[3];
                        ai[0] = ac[aBufferIndex] - 48;
                        ++aBufferIndex;
                        while (l < 3 && aBufferIndex < ac.length && ac[aBufferIndex] >= '0' && ac[aBufferIndex] <= '7') {
                            ai[l++] = ac[aBufferIndex] - 48;
                            ++aBufferIndex;
                        }
                        if (l == 3 && ai[0] > 3) {
                            String error = "Property list parsing failed while attempting to read quoted string. Octal escape sequence too large (bigger than octal 377). At ";
                            if (this._includeLineNumbersOnErrors()) {
                                error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                            }
                            error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                            throw new IllegalArgumentException(error);
                        }
                        int i1 = 0;
                        while (i1 < l) {
                            k *= 8;
                            k += ai[i1];
                            ++i1;
                        }
                        stringbuffer.append(this._nsToUnicode(k));
                    } else {
                        stringbuffer.append(ac[aBufferIndex]);
                        if (ac[aBufferIndex] == '\n') {
                            ++this._lineNumber;
                            this._startOfLineCharIndex = aBufferIndex + 1;
                        }
                        ++aBufferIndex;
                    }
                    j = ++aBufferIndex;
                    continue;
                }
                if (ac[aBufferIndex] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = aBufferIndex + 1;
                }
                ++aBufferIndex;
            }
            if (j < aBufferIndex) {
                stringbuffer.append(ac, j, aBufferIndex - j);
            }
            if (aBufferIndex >= ac.length) {
                String error = "Property list parsing failed while attempting to read quoted string. Input exhausted before closing quote was found. Opening quote was at " + this._savedIndexesAsString() + ".";
                throw new IllegalArgumentException(error);
            }
            return ++aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private boolean _includeLineNumbersOnErrors() {
            return NSValueUtilities.booleanValueWithDefault(System.getProperty("com.webobjects.foundation.NSPropertyListSerialization.ShowLineNumbersOnErrors"), true);
        }

        private int _lengthOfData(char[] ac, int index) {
            boolean isHexDigit;
            int aBufferIndex = index;
            int j = 0;
            ++aBufferIndex;
            while (aBufferIndex < ac.length && ((isHexDigit = this._isHexDigit(ac[aBufferIndex])) || this._isWhitespace(ac[aBufferIndex]))) {
                if (isHexDigit) {
                    ++j;
                }
                ++aBufferIndex;
            }
            if (aBufferIndex >= ac.length) {
                String error = "Property list parsing failed while attempting to read data. Input exhausted before data was terminated with '>'. At ";
                if (this._includeLineNumbersOnErrors()) {
                    error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                }
                error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                throw new IllegalArgumentException(error);
            }
            if (ac[aBufferIndex] != '>') {
                String error = "Property list parsing failed while attempting to read data. Illegal character encountered in data: '" + ac[aBufferIndex] + "'. At ";
                if (this._includeLineNumbersOnErrors()) {
                    error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                }
                error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                throw new IllegalArgumentException(error);
            }
            if (j % 2 != 0) {
                String error = "Property list parsing failed while attempting to read data. An odd number of half-bytes were specified. At ";
                if (this._includeLineNumbersOnErrors()) {
                    error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                }
                error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                throw new IllegalArgumentException(error);
            }
            return j / 2;
        }

        private int _readDataContentsIntoData(char[] ac, int index, NSMutableData nsmutabledata) {
            int aBufferIndex = index;
            ++aBufferIndex;
            while (ac[aBufferIndex] != '>' && ac[aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)] != '>') {
                byte byte0 = this._nibbleForHexDigit(ac[aBufferIndex]);
                ++aBufferIndex;
                aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
                byte byte1 = this._nibbleForHexDigit(ac[aBufferIndex]);
                ++aBufferIndex;
                nsmutabledata.appendByte((byte)((byte0 << 4) + byte1));
            }
            return ++aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _readArrayContentsIntoArray(char[] ac, int index, NSMutableArray<Object> nsmutablearray, int depthLeft) {
            int aBufferIndex = index;
            Object[] aobj = new Object[1];
            ++aBufferIndex;
            nsmutablearray.removeAllObjects();
            aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
            while (aBufferIndex != -1 && ac[aBufferIndex] != ')') {
                if (nsmutablearray.count() > 0) {
                    if (ac[aBufferIndex] != ',') {
                        String error = "Property list parsing failed while attempting to read array. No comma found between array elements. At ";
                        if (this._includeLineNumbersOnErrors()) {
                            error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                        }
                        error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                        throw new IllegalArgumentException(error);
                    }
                    ++aBufferIndex;
                    if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1) {
                        String error = "Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At ";
                        if (this._includeLineNumbersOnErrors()) {
                            error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                        }
                        error = String.valueOf(error) + "column: " + (ac.length - this._startOfLineCharIndex) + ".";
                        throw new IllegalArgumentException(error);
                    }
                }
                if (ac[aBufferIndex] == ')') continue;
                aobj[0] = null;
                aBufferIndex = this._readObjectIntoObjectReference(ac, aBufferIndex, aobj, depthLeft - 1);
                if (aobj[0] == null) {
                    String error = "Property list parsing failed while attempting to read array. Failed to read content object. At ";
                    if (this._includeLineNumbersOnErrors()) {
                        error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                    }
                    error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                    throw new IllegalArgumentException(error);
                }
                aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
                nsmutablearray.addObject(this._sharedValue(aobj[0]));
            }
            if (aBufferIndex == -1) {
                String error = "Property list parsing failed while attempting to read array. Input exhausted before end of array was found. At ";
                if (this._includeLineNumbersOnErrors()) {
                    error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                }
                error = String.valueOf(error) + "column: " + (ac.length - this._startOfLineCharIndex) + ".";
                throw new IllegalArgumentException(error);
            }
            return ++aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _readDictionaryContentsIntoDictionary(char[] ac, int index, NSMutableDictionary<String, Object> nsmutabledictionary, int depthLeft) {
            String error;
            int aBufferIndex = index;
            Object[] aobj = new Object[1];
            Object[] aobj1 = new Object[1];
            ++aBufferIndex;
            if (nsmutabledictionary.count() != 0) {
                Enumeration enumeration = nsmutabledictionary.keyEnumerator();
                while (enumeration.hasMoreElements()) {
                    nsmutabledictionary.removeObjectForKey(enumeration.nextElement());
                }
            }
            aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
            while (aBufferIndex != -1 && ac[aBufferIndex] != '}') {
                aBufferIndex = this._readObjectIntoObjectReference(ac, aBufferIndex, aobj, depthLeft - 1);
                if (aobj[0] == null || !(aobj[0] instanceof String)) {
                    error = "Property list parsing failed while attempting to read dictionary. Failed to read key or key is not a String. At ";
                    if (this._includeLineNumbersOnErrors()) {
                        error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                    }
                    error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                    throw new IllegalArgumentException(error);
                }
                if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1 || ac[aBufferIndex] != '=') {
                    error = "Property list parsing failed while attempting to read dictionary. Read key " + aobj[0] + " with no value. At ";
                    if (this._includeLineNumbersOnErrors()) {
                        error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                    }
                    error = String.valueOf(error) + "column: " + ((aBufferIndex == -1 ? ac.length : aBufferIndex) - this._startOfLineCharIndex) + ".";
                    throw new IllegalArgumentException(error);
                }
                ++aBufferIndex;
                if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1) {
                    error = "Property list parsing failed while attempting to read dictionary. Read key " + aobj[0] + " with no value. At ";
                    if (this._includeLineNumbersOnErrors()) {
                        error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                    }
                    error = String.valueOf(error) + "column: " + (ac.length - this._startOfLineCharIndex) + ".";
                    throw new IllegalArgumentException(error);
                }
                aBufferIndex = this._readObjectIntoObjectReference(ac, aBufferIndex, aobj1, depthLeft - 1);
                if (aobj1[0] == null) {
                    error = "Property list parsing failed while attempting to read dictionary. Failed to read value. At ";
                    if (this._includeLineNumbersOnErrors()) {
                        error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                    }
                    error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                    throw new IllegalArgumentException(error);
                }
                if ((aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex)) == -1 || ac[aBufferIndex] != ';') {
                    error = "Property list parsing failed while attempting to read dictionary. Read key and value with no terminating semicolon. At ";
                    if (this._includeLineNumbersOnErrors()) {
                        error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                    }
                    error = String.valueOf(error) + "column: " + ((aBufferIndex == -1 ? ac.length : aBufferIndex) - this._startOfLineCharIndex) + ".";
                    throw new IllegalArgumentException(error);
                }
                ++aBufferIndex;
                aBufferIndex = this._skipWhitespaceAndComments(ac, aBufferIndex);
                nsmutabledictionary.setObjectForKey(this._sharedValue(aobj1[0]), (String)this._sharedValue(aobj[0]));
            }
            if (aBufferIndex == -1 || aBufferIndex >= ac.length) {
                error = "Property list parsing failed while attempting to read dictionary. Exhausted input before end of dictionary was found. At ";
                if (this._includeLineNumbersOnErrors()) {
                    error = String.valueOf(error) + "line number: " + this._lineNumber + ", ";
                }
                error = String.valueOf(error) + "column: " + ((aBufferIndex == -1 ? ac.length : aBufferIndex) - this._startOfLineCharIndex) + ".";
                throw new IllegalArgumentException(error);
            }
            return ++aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _checkForWhitespaceOrComment(char[] ac, int index) {
            if (index == -1 || index >= ac.length) {
                return 1;
            }
            if (this._isWhitespace(ac[index])) {
                return 2;
            }
            if (index + 1 < ac.length) {
                if (ac[index] == '/' && ac[index + 1] == '/') {
                    return 3;
                }
                if (ac[index] == '/' && ac[index + 1] == '*') {
                    return 4;
                }
            }
            return 1;
        }

        private int _skipWhitespaceAndComments(char[] ac, int index) {
            int aBufferIndex = index;
            int j = this._checkForWhitespaceOrComment(ac, aBufferIndex);
            while (j != 1) {
                switch (j) {
                    case 2: {
                        aBufferIndex = this._processWhitespace(ac, aBufferIndex);
                        break;
                    }
                    case 3: {
                        aBufferIndex = this._processSingleLineComment(ac, aBufferIndex);
                        break;
                    }
                    case 4: {
                        aBufferIndex = this._processMultiLineComment(ac, aBufferIndex);
                    }
                }
                j = this._checkForWhitespaceOrComment(ac, aBufferIndex);
            }
            return aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _processWhitespace(char[] ac, int index) {
            int aBufferIndex = index;
            while (aBufferIndex < ac.length && this._isWhitespace(ac[aBufferIndex])) {
                if (ac[aBufferIndex] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = aBufferIndex + 1;
                }
                ++aBufferIndex;
            }
            return aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _processSingleLineComment(char[] ac, int index) {
            int aBufferIndex = index;
            aBufferIndex += 2;
            while (aBufferIndex < ac.length && ac[aBufferIndex] != '\n') {
                ++aBufferIndex;
            }
            return aBufferIndex < ac.length ? aBufferIndex : -1;
        }

        private int _processMultiLineComment(char[] ac, int index) {
            int aBufferIndex = index;
            this._saveIndexes(aBufferIndex, this._lineNumber, this._startOfLineCharIndex);
            aBufferIndex += 2;
            while (aBufferIndex + 1 < ac.length && (ac[aBufferIndex] != '*' || ac[aBufferIndex + 1] != '/')) {
                if (ac[aBufferIndex] == '/' && ac[aBufferIndex + 1] == '*') {
                    String error = "Property list parsing does not support embedded multi line comments. The first opening comment was at " + this._savedIndexesAsString() + ". A second opening comment was found at ";
                    if (this._includeLineNumbersOnErrors()) {
                        error = String.valueOf(error) + "line " + this._lineNumber + ", ";
                    }
                    error = String.valueOf(error) + "column: " + (aBufferIndex - this._startOfLineCharIndex) + ".";
                    throw new IllegalArgumentException(error);
                }
                if (ac[aBufferIndex] == '\n') {
                    ++this._lineNumber;
                    this._startOfLineCharIndex = aBufferIndex + 1;
                }
                ++aBufferIndex;
            }
            if (aBufferIndex + 1 >= ac.length || ac[aBufferIndex] != '*' || ac[aBufferIndex + 1] != '/') {
                String error = "Property list parsing failed while attempting to find closing to comment that began at " + this._savedIndexesAsString() + ".";
                throw new IllegalArgumentException(error);
            }
            return (aBufferIndex += 2) < ac.length ? aBufferIndex : -1;
        }

        private final byte _nibbleForHexDigit(char c) {
            byte i = 0;
            if (c >= '0' && c <= '9') {
                i = (byte)(c - 48);
            } else if (c >= 'a' && c <= 'f') {
                i = (byte)(c - 97 + 10);
            } else if (c >= 'A' && c <= 'F') {
                i = (byte)(c - 65 + 10);
            } else {
                throw new IllegalArgumentException("Non-hex digit passed to _nibbleForHexDigit()");
            }
            return i;
        }

        private final boolean _isHexDigit(char c) {
            return c >= '0' && c <= '9' || c >= 'a' && c <= 'f' || c >= 'A' && c <= 'F';
        }

        private final boolean _isWhitespace(char c) {
            return Character.isWhitespace(c);
        }

        private char _nsToUnicode(int i) {
            return i >= 128 ? (char)NSToPrecompUnicodeTable[i - 128] : (char)i;
        }
    }

    public static abstract class _PListParser {
        private static final boolean REUSE_SHARED_VALUES = NSProperties.booleanForKeyWithDefault("NSCheckFix.reusePropertyListValues", true);
        private boolean _indents;
        private NSMutableSet<Object> _sharedValues;

        public _PListParser(boolean indents) {
            this._indents = indents;
            if (REUSE_SHARED_VALUES) {
                this._sharedValues = new NSMutableSet();
                this._sharedValues.addAll(_globallySharedValues);
            }
        }

        protected Object _sharedValue(Object value) {
            Object result = value;
            if (REUSE_SHARED_VALUES && (value instanceof String || value instanceof Number) && !this._sharedValues.add(value)) {
                result = this._sharedValues.member(value);
            }
            return result;
        }

        protected void _appendIndentationToStringBuffer(StringBuffer buffer, int i) {
            if (this._indents) {
                int j = 0;
                while (j < i) {
                    buffer.append('\t');
                    ++j;
                }
            }
        }

        protected void _appendNewLineToStringBuffer(StringBuffer buffer, int i) {
            if (this._indents) {
                buffer.append('\n');
            }
        }

        public abstract Object parseStringIntoPlist(String var1);
    }

    public static class _XML
    extends _PListParser {
        protected static SAXParserFactory _parserFactory;
        protected SimpleDateFormat _dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");

        public _XML() {
            this(true);
        }

        public _XML(boolean indents) {
            super(indents);
            this._dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
            this._dateFormat.setLenient(true);
        }

        public static SAXParserFactory parserFactory() {
            if (_parserFactory == null) {
                try {
                    _parserFactory = _NSXMLUtilities.newSAXParserFactory();
                    if (NSProperties.booleanForKeyWithDefault("NSPropertyListSerialization.blockAllExternalEntities", true)) {
                        _parserFactory.setFeature("http://xml.org/sax/features/external-general-entities", false);
                        try {
                            _parserFactory.setFeature("http://javax.xml.XMLConstants/feature/secure-processing", true);
                        }
                        catch (SAXNotRecognizedException ex) {
                            log.warn("Could not enable http://javax.xml.XMLConstants/feature/secure-processing", (Throwable)ex);
                        }
                        _parserFactory.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                        _parserFactory.setXIncludeAware(NSProperties.booleanForKeyWithDefault("NSPropertyListSerialization.isXIncludeAware", false));
                    }
                    if (NSProperties.booleanForKeyWithDefault("NSPropertyListSerialization.disallowDTD", false)) {
                        _parserFactory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    }
                }
                catch (Exception exception) {
                    throw NSForwardException._runtimeExceptionForThrowable(exception);
                }
            }
            return _parserFactory;
        }

        public SAXParser newSAXParser() {
            if (_XML.parserFactory() != null) {
                try {
                    SAXParser parser = _XML.parserFactory().newSAXParser();
                    return parser;
                }
                catch (Exception exception) {
                    throw NSForwardException._runtimeExceptionForThrowable(exception);
                }
            }
            return null;
        }

        @Override
        public Object parseStringIntoPlist(String string) {
            DictionaryParser dictionaryParser = new DictionaryParser();
            try {
                SAXParser parser;
                if (NSProperties.booleanForKeyWithDefault("ERXPropertyListSerialization.foundationCompatibleLenientMode", true) && string != null) {
                    string = string.trim();
                }
                if ((parser = this.newSAXParser()) != null) {
                    parser.setProperty("http://xml.org/sax/properties/lexical-handler", dictionaryParser);
                    parser.parse(new InputSource(new StringReader(string)), (DefaultHandler)dictionaryParser);
                }
            }
            catch (SAXException exception) {
                log.debug("Caught SAXException", (Throwable)exception);
                if (exception instanceof SAXParseException) {
                    throw new NSForwardException(exception, "Parsing failed in line " + ((SAXParseException)exception).getLineNumber() + ", column " + ((SAXParseException)exception).getColumnNumber());
                }
                throw new NSForwardException(exception);
            }
            catch (IOException ioexception) {
                throw NSForwardException._runtimeExceptionForThrowable(ioexception);
            }
            return dictionaryParser.plist();
        }

        public String stringFromPropertyList(Object plist) {
            if (plist == null) {
                return null;
            }
            StringBuffer stringbuffer = new StringBuffer(128);
            stringbuffer.append("<?xml version=\"1.0\" encoding=\"UTF-8\" standalone=\"yes\"?>");
            this._appendNewLineToStringBuffer(stringbuffer, 0);
            stringbuffer.append("<!DOCTYPE plist PUBLIC \"" + DictionaryParser.PUBLIC_APPLE_PLIST_1_0 + "\" \"http://www.apple.com/DTDs/PropertyList-1.0.dtd\">");
            this._appendNewLineToStringBuffer(stringbuffer, 0);
            stringbuffer.append("<plist version=\"1.0\">");
            this._appendNewLineToStringBuffer(stringbuffer, 0);
            this._appendObjectToStringBuffer(plist, stringbuffer, 1);
            stringbuffer.append("</plist>");
            return stringbuffer.toString();
        }

        private void _appendObjectToStringBuffer(Object obj, StringBuffer stringbuffer, int i) {
            if (obj instanceof String || obj instanceof StringBuffer) {
                this._appendStringToStringBuffer(obj.toString(), stringbuffer, i);
            } else if (obj instanceof Integer || obj instanceof Long || obj instanceof BigInteger) {
                this._appendIntegerToStringBuffer((Number)obj, stringbuffer, i);
            } else if (obj instanceof Float || obj instanceof Double || obj instanceof BigDecimal) {
                this._appendFloatToStringBuffer((Number)obj, stringbuffer, i);
            } else if (obj instanceof Date) {
                this._appendDateToStringBuffer((Date)obj, stringbuffer, i);
            } else if (obj instanceof Boolean) {
                this._appendBooleanToStringBuffer((Boolean)obj, stringbuffer, i);
            } else if (obj instanceof NSData) {
                this._appendDataToStringBuffer((NSData)obj, stringbuffer, i);
            } else if (obj instanceof List) {
                this._appendArrayToStringBuffer((List)obj, stringbuffer, i);
            } else if (obj instanceof Map) {
                this._appendDictionaryToStringBuffer((Map)obj, stringbuffer, i);
            } else {
                this._appendStringToStringBuffer(obj.toString(), stringbuffer, i);
            }
        }

        private void _appendStringToStringBuffer(String s, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.STRING.openTag());
            stringbuffer.append(this.escapeString(s));
            stringbuffer.append(DictionaryParser.XMLNode.Type.STRING.closeTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        private void _appendIntegerToStringBuffer(Number s, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.INTEGER.openTag());
            stringbuffer.append(s.toString());
            stringbuffer.append(DictionaryParser.XMLNode.Type.INTEGER.closeTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        private void _appendFloatToStringBuffer(Number s, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.REAL.openTag());
            stringbuffer.append(s.toString());
            stringbuffer.append(DictionaryParser.XMLNode.Type.REAL.closeTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        private void _appendBooleanToStringBuffer(Boolean s, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            if (s.booleanValue()) {
                stringbuffer.append(DictionaryParser.XMLNode.Type.TRUE.openTag());
                stringbuffer.append(DictionaryParser.XMLNode.Type.TRUE.closeTag());
            } else {
                stringbuffer.append(DictionaryParser.XMLNode.Type.FALSE.openTag());
                stringbuffer.append(DictionaryParser.XMLNode.Type.FALSE.closeTag());
            }
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        private void _appendDateToStringBuffer(Date s, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.DATE.openTag());
            stringbuffer.append(this._dateFormat.format(s));
            stringbuffer.append(DictionaryParser.XMLNode.Type.DATE.closeTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        private void _appendDataToStringBuffer(NSData s, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.DATA.openTag());
            stringbuffer.append(_NSStringUtilities.stringForBytes(_NSBase64.encode(s.bytes()), "UTF-8"));
            stringbuffer.append(DictionaryParser.XMLNode.Type.DATA.closeTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        private void _appendArrayToStringBuffer(List<?> vector, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.ARRAY.openTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
            Iterator<?> iterator = vector.iterator();
            while (iterator.hasNext()) {
                this._appendObjectToStringBuffer(iterator.next(), stringbuffer, i + 1);
            }
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.ARRAY.closeTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        private void _appendDictionaryToStringBuffer(Map<?, ?> table, StringBuffer stringbuffer, int i) {
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.DICTIONARY.openTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
            for (Object key : table.keySet()) {
                this._appendIndentationToStringBuffer(stringbuffer, i + 1);
                stringbuffer.append(DictionaryParser.XMLNode.Type.KEY.openTag());
                stringbuffer.append(this.escapeString(key.toString()));
                stringbuffer.append(DictionaryParser.XMLNode.Type.KEY.closeTag());
                this._appendNewLineToStringBuffer(stringbuffer, i + 1);
                this._appendObjectToStringBuffer(table.get(key), stringbuffer, i + 1);
                this._appendNewLineToStringBuffer(stringbuffer, i + 1);
            }
            this._appendIndentationToStringBuffer(stringbuffer, i);
            stringbuffer.append(DictionaryParser.XMLNode.Type.DICTIONARY.closeTag());
            this._appendNewLineToStringBuffer(stringbuffer, i);
        }

        protected String escapeString(String toValidate) {
            int length = toValidate.length();
            StringBuilder cleanString = new StringBuilder(length);
            int i = 0;
            while (i < length) {
                char currentChar = toValidate.charAt(i);
                switch (currentChar) {
                    case '&': {
                        cleanString.append("&amp;");
                        break;
                    }
                    case '<': {
                        cleanString.append("&lt;");
                        break;
                    }
                    case '>': {
                        cleanString.append("&gt;");
                        break;
                    }
                    case '\'': {
                        cleanString.append("&apos;");
                        break;
                    }
                    case '\"': {
                        cleanString.append("&quot;");
                        break;
                    }
                    default: {
                        cleanString.append(currentChar);
                    }
                }
                ++i;
            }
            return cleanString.toString();
        }

        public static class DictionaryParser
        extends DefaultHandler
        implements LexicalHandler {
            static String PUBLIC_APPLE_COMPUTER_PLIST_1_0 = "-//Apple Computer//DTD PLIST 1.0//EN";
            static String PUBLIC_APPLE_PLIST_1_0 = "-//Apple//DTD PLIST 1.0//EN";
            protected SimpleDateFormat _dateFormat;
            protected Stack<XMLNode> _stack;
            protected Object _plist;
            protected StringBuffer _curChars;
            protected int _deepness;
            Locator locator = null;
            private static final NSArrayProperty<String> predefinedEntityNames = new NSArrayProperty<String>("NSPropertyListSerialization.xml.predefinedEntityNames", new NSArray<String>(new String[]{"lt", "gt", "amp", "quot", "apos"}));
            final int entityExpansionLimit = NSProperties.intForKeyWithDefault("jdk.xml.entityExpansionLimit", 0);
            int entityExpansionCount = 0;

            public DictionaryParser() {
                this._dateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
                this._dateFormat.setTimeZone(TimeZone.getTimeZone("GMT"));
                this._dateFormat.setLenient(true);
            }

            public Object plist() {
                return this._plist;
            }

            @Override
            public void characters(char[] ch, int start, int length) throws SAXException {
                this._curChars.append(ch, start, length);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            @Override
            public void endDocument() throws SAXException {
                if (this._stack.empty()) return;
                if (this._stack.size() != 1) throw new SAXException("A plist may only contain one top-level node.");
                XMLNode lastNode = this._stack.pop();
                if (lastNode.tagOpen()) throw new SAXException("Starting <" + (Object)((Object)lastNode.type()) + "> node was never ended.");
                this._plist = lastNode.value();
            }

            @Override
            public void endElement(String uri, String localName, String qName) throws SAXException {
                XMLNode.Type aType = XMLNode.Type.typeForName(qName);
                if (XMLNode.Type.PLIST.equals((Object)aType)) {
                    if (this._stack.size() != 2) {
                        throw new SAXException("A plist may only contain one top-level node, and all tags must have end tags.");
                    }
                    XMLNode lastNode = this._stack.pop();
                    if (lastNode.tagOpen()) {
                        throw new SAXException("Starting <" + (Object)((Object)lastNode.type()) + "> tag was never ended.");
                    }
                    this._plist = lastNode.value();
                    this._stack.pop();
                    return;
                }
                this.saveCharContent();
                switch (aType) {
                    case PLIST: {
                        break;
                    }
                    case ARRAY: {
                        NSMutableArray<Object> array = new NSMutableArray<Object>();
                        boolean foundOpenTag = false;
                        while (!this._stack.isEmpty()) {
                            XMLNode currentNode = this._stack.peek();
                            if (currentNode.tagOpen()) {
                                if (XMLNode.Type.ARRAY.equals((Object)currentNode.type())) {
                                    foundOpenTag = true;
                                    currentNode.setValue(array);
                                    currentNode.setTagOpen(false);
                                    break;
                                }
                                throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)currentNode.type()) + "> tag.");
                            }
                            if (currentNode.value() != null) {
                                array.add(0, currentNode.value());
                            }
                            this._stack.pop();
                        }
                        if (foundOpenTag) break;
                        throw new SAXException("No starting <array> tag.");
                    }
                    case DICTIONARY: {
                        NSMutableDictionary<Object, Object> dictionary = new NSMutableDictionary<Object, Object>();
                        boolean foundOpenTag = false;
                        while (!this._stack.isEmpty()) {
                            XMLNode currentNode = this._stack.peek();
                            if (currentNode.tagOpen()) {
                                if (XMLNode.Type.DICTIONARY.equals((Object)currentNode.type())) {
                                    foundOpenTag = true;
                                    currentNode.setValue(dictionary);
                                    currentNode.setTagOpen(false);
                                    break;
                                }
                                throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)currentNode.type()) + "> tag.");
                            }
                            if (this._stack.size() > 1) {
                                Object obj = currentNode.value();
                                this._stack.pop();
                                currentNode = this._stack.peek();
                                if (XMLNode.Type.KEY.equals((Object)currentNode.type())) {
                                    if (obj != null && currentNode.value() != null) {
                                        dictionary.put(currentNode.value(), obj);
                                    }
                                    this._stack.pop();
                                    continue;
                                }
                                throw new SAXException("Key must be before the value.");
                            }
                            throw new SAXException("All values in a dictionary must have corresponding keys.");
                        }
                        if (foundOpenTag) break;
                        throw new SAXException("No starting <" + qName + "> tag.");
                    }
                    case UNKNOWN: {
                        break;
                    }
                    case STRING: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(new String(""));
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case KEY: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(new String(""));
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case DATE: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(new NSTimestamp());
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case INTEGER: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(BigInteger.ZERO);
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case REAL: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(BigDecimal.ZERO);
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case BOOLEAN: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(Boolean.FALSE);
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case TRUE: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(Boolean.TRUE);
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case FALSE: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(Boolean.FALSE);
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                    case DATA: {
                        XMLNode lastNode = this._stack.peek();
                        if (aType.equals((Object)lastNode.type())) {
                            if (lastNode.value() != null) break;
                            lastNode.setValue(new NSData());
                            lastNode.setTagOpen(false);
                            break;
                        }
                        throw new SAXException("Ending <" + qName + "> tag does not match starting <" + (Object)((Object)lastNode.type()) + "> tag.");
                    }
                }
                --this._deepness;
                if (this._deepness < 0) {
                    log.error("Deepness is less than zero: " + this._deepness);
                }
            }

            @Override
            public void error(SAXParseException exception) throws SAXException {
                log.error("Parse error", (Throwable)exception);
            }

            @Override
            public void fatalError(SAXParseException exception) throws SAXException {
                log.error("Parse fatal error", (Throwable)exception);
                throw exception;
            }

            @Override
            public void ignorableWhitespace(char[] ch, int start, int length) throws SAXException {
            }

            @Override
            public void processingInstruction(String target, String data) throws SAXException {
            }

            @Override
            public InputSource resolveEntity(String publicId, String systemId) throws SAXException {
                InputSource inputsource = null;
                if (NSProperties.booleanForKeyWithDefault("NSPropertyListSerialization.blockAllExternalEntities", true) || PUBLIC_APPLE_PLIST_1_0.equals(publicId) || PUBLIC_APPLE_COMPUTER_PLIST_1_0.equals(publicId)) {
                    inputsource = new InputSource(new StringReader(""));
                }
                return inputsource;
            }

            @Override
            public void setDocumentLocator(Locator locator) {
                this.locator = locator;
            }

            private static boolean isGeneralEntityName(String name) {
                if (name == null) {
                    return false;
                }
                if ("[dtd]".equals(name)) {
                    return false;
                }
                if (name.startsWith("%")) {
                    return false;
                }
                return !((NSArray)predefinedEntityNames.value()).contains(name);
            }

            @Override
            public void startEntity(String name) throws SAXException {
                if (!DictionaryParser.isGeneralEntityName(name)) {
                    return;
                }
                ++this.entityExpansionCount;
                if (this.entityExpansionCount > this.entityExpansionLimit) {
                    throw new SAXParseException("The parser has encountered more than \"" + this.entityExpansionLimit + "\" entity expansions in this document", this.locator);
                }
            }

            @Override
            public void endEntity(String name) throws SAXException {
            }

            @Override
            public void startDTD(String name, String publicId, String systemId) throws SAXException {
            }

            @Override
            public void endDTD() throws SAXException {
            }

            @Override
            public void startCDATA() throws SAXException {
            }

            @Override
            public void endCDATA() throws SAXException {
            }

            @Override
            public void comment(char[] ch, int start, int length) throws SAXException {
            }

            @Override
            public void startElement(String uri, String localName, String qName, Attributes attributes) {
                ++this._deepness;
                XMLNode.Type aType = XMLNode.Type.typeForName(qName);
                switch (aType) {
                    case TRUE: {
                        this._stack.push(new XMLNode(aType, (Object)Boolean.TRUE, false));
                        break;
                    }
                    case FALSE: {
                        this._stack.push(new XMLNode(aType, (Object)Boolean.FALSE, false));
                        break;
                    }
                    default: {
                        this._stack.push(new XMLNode(aType));
                    }
                }
                if (this._deepness > 1000 && NSProperties.booleanForKeyWithDefault("NSPropertyListSerialization.CheckMaxDeepness", true)) {
                    throw new RuntimeException("The provided property list was more than 1000 levels deep.");
                }
                this._curChars = new StringBuffer();
            }

            @Override
            public void startDocument() throws SAXException {
                this._stack = new Stack();
                this._plist = null;
                this._curChars = new StringBuffer();
            }

            private void saveCharContent() throws SAXException {
                if (this._curChars.length() == 0) {
                    return;
                }
                XMLNode lastNode = this._stack.peek();
                if (lastNode.tagOpen()) {
                    switch (lastNode.type()) {
                        case PLIST: {
                            break;
                        }
                        case ARRAY: {
                            break;
                        }
                        case DICTIONARY: {
                            break;
                        }
                        case UNKNOWN: {
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case STRING: {
                            lastNode.setValue(this.unescapeString(this._curChars.toString()));
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case KEY: {
                            lastNode.setValue(this.unescapeString(this._curChars.toString()));
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case DATE: {
                            try {
                                lastNode.setValue(new NSTimestamp(this._dateFormat.parse(this._curChars.toString())));
                            }
                            catch (Exception exception) {
                                throw new SAXException("Unable to convert value <" + this._curChars.toString() + "> to timestamp.");
                            }
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case INTEGER: {
                            try {
                                lastNode.setValue(new BigInteger(this._curChars.toString()));
                            }
                            catch (Exception exception) {
                                throw new SAXException("Unable to convert value <" + this._curChars.toString() + "> to integer.");
                            }
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case REAL: {
                            try {
                                lastNode.setValue(new BigDecimal(this._curChars.toString()));
                            }
                            catch (Exception exception) {
                                throw new SAXException("Unable to convert value <" + this._curChars.toString() + "> to float.");
                            }
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case BOOLEAN: {
                            lastNode.setValue(Boolean.valueOf(this._curChars.toString()));
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case TRUE: {
                            lastNode.setValue(Boolean.TRUE);
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case FALSE: {
                            lastNode.setValue(Boolean.FALSE);
                            lastNode.setTagOpen(false);
                            break;
                        }
                        case DATA: {
                            try {
                                StringBuffer stringbuffer = new StringBuffer(this._curChars.length());
                                int i = 0;
                                while (i < this._curChars.length()) {
                                    if (!Character.isWhitespace(this._curChars.charAt(i))) {
                                        stringbuffer.append(this._curChars.charAt(i));
                                    }
                                    ++i;
                                }
                                byte[] abyte0 = stringbuffer.toString().getBytes("US-ASCII");
                                byte[] abyte64 = _NSBase64.decode(abyte0);
                                if (abyte64 != null && abyte64.length > 0) {
                                    lastNode.setValue(new NSData(abyte64));
                                } else {
                                    lastNode.setValue(new NSData());
                                }
                                lastNode.setTagOpen(false);
                            }
                            catch (UnsupportedEncodingException unsupportedencodingexception) {
                                throw new SAXException(unsupportedencodingexception.getMessage());
                            }
                            lastNode.setTagOpen(false);
                        }
                    }
                }
            }

            @Override
            public void warning(SAXParseException exception) throws SAXException {
                log.warn("Parse warning", (Throwable)exception);
            }

            protected String unescapeString(String toRestore) {
                String result = toRestore.replace("&amp;", "&");
                result = toRestore.replace("&lt;", "<");
                result = toRestore.replace("&gt;", ">");
                result = toRestore.replace("&apos;", "'");
                result = toRestore.replace("&quot;", "\"");
                result = toRestore.replace("&lt;", "<");
                return result;
            }

            public static class XMLNode {
                protected Type _type;
                protected Object _value;
                protected boolean _tag_open;

                public XMLNode(Type type, Object value, boolean tag_open) {
                    this._type = type;
                    this._value = value;
                    this._tag_open = tag_open;
                }

                public XMLNode(Type type, Object value) {
                    this(type, value, true);
                }

                public XMLNode(Type type) {
                    this(type, null, true);
                }

                public XMLNode(String type, Object value, boolean tag_open) {
                    this(Type.typeForName(type), value, tag_open);
                }

                public XMLNode(String type, Object value) {
                    this(type, value, true);
                }

                public XMLNode(String type) {
                    this(type, null, true);
                }

                public Type type() {
                    return this._type;
                }

                public Object value() {
                    return this._value;
                }

                public void setValue(Object value) {
                    this._value = value;
                }

                public boolean tagOpen() {
                    return this._tag_open;
                }

                public void setTagOpen(boolean value) {
                    this._tag_open = value;
                }

                public String toString() {
                    return "type = " + (Object)((Object)this._type) + "; object = " + this._value + "; open = " + this._tag_open;
                }

                public static enum Type {
                    PLIST("plist", true),
                    STRING("string", true),
                    KEY("key", true),
                    DATA("data", true),
                    DATE("date", true),
                    INTEGER("integer", true),
                    REAL("real", true),
                    BOOLEAN("boolean", true),
                    ARRAY("array", true),
                    DICTIONARY("dict", true),
                    TRUE("true", false),
                    FALSE("false", false),
                    UNKNOWN("unknown", true);

                    String _qName;
                    String _openTag;
                    String _closeTag;

                    private Type(String qName, boolean content) {
                        this._qName = qName;
                        if (content) {
                            this._openTag = "<" + qName + ">";
                            this._closeTag = "</" + qName + ">";
                        } else {
                            this._openTag = "<" + qName + "/>";
                            this._closeTag = "";
                        }
                    }

                    public String qName() {
                        return this._qName;
                    }

                    public String openTag() {
                        return this._openTag;
                    }

                    public String closeTag() {
                        return this._closeTag;
                    }

                    public static Type typeForName(String qName) {
                        if (qName != null) {
                            String aQName = qName.toLowerCase();
                            Type[] typeArray = Type.values();
                            int n = typeArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Type aType = typeArray[n2];
                                if (aType._qName.equals(aQName)) {
                                    return aType;
                                }
                                ++n2;
                            }
                        }
                        return UNKNOWN;
                    }

                    public String toString() {
                        return this._qName;
                    }
                }
            }
        }
    }
}

