/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.text.DecimalFormatSymbols;
import java.text.FieldPosition;
import java.text.Format;
import java.text.NumberFormat;
import java.text.ParseException;
import java.text.ParsePosition;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSNumberFormatter
extends Format {
    public static final Class<NSNumberFormatter> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSNumberFormatter.class);
    private static final Logger log = LoggerFactory.getLogger(NSNumberFormatter.class);
    public static final int RoundDown = 3;
    public static final int RoundUp = 2;
    public static final int RoundPlain = 4;
    public static final int RoundBankers = 6;
    public static final String DefaultPattern = "#,##0.##";
    public static final String _DecimalPattern = "#,##0.##";
    public static final String _IntegerPattern = "0;-0";
    public static final String _CurrencyPattern = "$#,##0.00;-$#,##0.00";
    static final long serialVersionUID = 3269407185744612364L;
    private static final String SerializationPatternFieldKey = "pattern";
    private static final String SerializationStringForZeroFieldKey = "stringForZero";
    private static final String SerializationStringForNullFieldKey = "stringForNull";
    private static final String SerializationStringForNANFieldKey = "stringForNAN";
    private static final String SerializationMaximumFieldKey = "maximum";
    private static final String SerializationMinimumFieldKey = "minimum";
    private static final String SerializationRoundingBehaviorFieldKey = "rounding";
    private static final String SerializationDecimalSeparatorFieldKey = "decimalSeparator";
    private static final String SerializationThousandsMarkFieldKey = "thousandsMark";
    private static final String SerializationHasThousandsMarkFieldKey = "hasThousandsMark";
    private static final String SerializationAllowsFloatingPointFieldKey = "allowsFloatingPoint";
    private static final String SerializationLocaleFieldKey = "locale";
    private static final String SerializationLocalizedPatternFieldKey = "localizesPattern";
    private static final String SerializationCurrencyMarkFieldKey = "currencyMark";
    public static final BigDecimal NSDecimalNotANumber = new BigDecimal(0.0);
    private static final char PATTERN_SEPARATOR = ';';
    private static final String PART_OF_NUMBER = ",._#0123456789";
    private static final String STRING_FOR_ZERO = null;
    private static final String STRING_FOR_NULL = "";
    private static final String STRING_FOR_NOTANUMBER = "NaN";
    private static final String STRING_FOR_CURRENCY = "$";
    private static final int NSDecimalNoScale = Integer.MIN_VALUE;
    private static final char DefaultDecimalSeparator = '.';
    private static final char DefaultThousandSeparator = ',';
    private static final String DefaultDecimalSeparatorString = String.valueOf('.');
    private static final String DefaultThousandSeparatorString = String.valueOf(',');
    private static volatile Locale globalDefaultLocale;
    private static volatile boolean globalDefaultLocalizesFormat;
    private volatile String _negativePattern = "";
    private volatile String _positivePattern = "";
    private volatile String _stringForZero = STRING_FOR_ZERO;
    private volatile String _stringForNull = "";
    private volatile String _stringForNotANumber = "NaN";
    private volatile BigDecimal _minimum = NSDecimalNotANumber;
    private volatile BigDecimal _maximum = NSDecimalNotANumber;
    private volatile int _roundingBehavior = 4;
    private volatile char _decimalSeparator = (char)46;
    private volatile char _thousandSeparator = (char)44;
    private volatile boolean _hasThousandSeparator = true;
    private volatile boolean _allowsFloats = true;
    private volatile transient String _legalChars;
    private volatile transient String _semanticChars;
    private volatile transient String _negativeChars;
    private volatile Locale _currentLocale;
    private volatile boolean _localizesFormat;
    private volatile String _currencyString = "$";
    private volatile ConstructionBuffer _negative = new ConstructionBuffer();
    private volatile ConstructionBuffer _positive = new ConstructionBuffer();
    private static final String _IgnoredCharsInPatterns = ",._#0123456789$- ";
    private static final Class<String> _stringClass;
    private static final Class<BigDecimal> _bigDecimalClass;
    private static final Class<Locale> _LocaleClass;
    private static final ObjectStreamField[] serialPersistentFields;

    static {
        _stringClass = String.class;
        _bigDecimalClass = BigDecimal.class;
        _LocaleClass = Locale.class;
        serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField(SerializationPatternFieldKey, _stringClass), new ObjectStreamField(SerializationStringForZeroFieldKey, _stringClass), new ObjectStreamField(SerializationStringForNullFieldKey, _stringClass), new ObjectStreamField(SerializationStringForNANFieldKey, _stringClass), new ObjectStreamField(SerializationMaximumFieldKey, _bigDecimalClass), new ObjectStreamField(SerializationMinimumFieldKey, _bigDecimalClass), new ObjectStreamField(SerializationRoundingBehaviorFieldKey, Integer.TYPE), new ObjectStreamField(SerializationDecimalSeparatorFieldKey, _stringClass), new ObjectStreamField(SerializationThousandsMarkFieldKey, _stringClass), new ObjectStreamField(SerializationHasThousandsMarkFieldKey, Boolean.TYPE), new ObjectStreamField(SerializationAllowsFloatingPointFieldKey, Boolean.TYPE), new ObjectStreamField(SerializationLocaleFieldKey, _LocaleClass), new ObjectStreamField(SerializationLocalizedPatternFieldKey, Boolean.TYPE), new ObjectStreamField(SerializationCurrencyMarkFieldKey, _stringClass)};
    }

    public NSNumberFormatter() {
        this("#,##0.##");
    }

    public NSNumberFormatter(String pattern) {
        this.initializeDefaults();
        this.setPattern(pattern);
    }

    private void initializeDefaults() {
        this._localizesFormat = globalDefaultLocalizesFormat;
        if (globalDefaultLocale != null) {
            this.setLocale(globalDefaultLocale);
        }
    }

    public String decimalSeparator() {
        return String.valueOf(this._decimalSeparator());
    }

    private char _decimalSeparator() {
        return this._decimalSeparator;
    }

    public void setDecimalSeparator(String newSeparator) {
        if (newSeparator == null || newSeparator.length() != 1) {
            throw new IllegalArgumentException("Decimal separator needs to be a string with one character");
        }
        char c = newSeparator.charAt(0);
        if (c == this._thousandSeparator) {
            this._thousandSeparator = this._decimalSeparator;
        }
        this._decimalSeparator = c;
        this._updateCharSets();
    }

    private void setDecimalSeparator(char c) {
        this._decimalSeparator = c;
    }

    public String thousandSeparator() {
        return String.valueOf(this._thousandSeparator());
    }

    private char _thousandSeparator() {
        return this._thousandSeparator;
    }

    public void setThousandSeparator(String newSeparator) {
        if (newSeparator == null || newSeparator.length() != 1) {
            throw new IllegalArgumentException("Thousand separator needs to be a string with one character");
        }
        char c = newSeparator.charAt(0);
        if (c == this._decimalSeparator) {
            this._decimalSeparator = this._thousandSeparator;
        }
        this._thousandSeparator = c;
        this._updateCharSets();
    }

    private void setThousandSeparator(char c) {
        this._thousandSeparator = c;
    }

    public int roundingBehavior() {
        return this._roundingBehavior;
    }

    public void setRoundingBehavior(int newBehavior) {
        if (newBehavior != 3 && newBehavior != 2 && newBehavior != 4 && newBehavior != 6) {
            throw new IllegalArgumentException("NSNumberFormater: " + newBehavior + " is not a valid rounding behavior mode");
        }
        this._roundingBehavior = newBehavior;
    }

    public String stringForZero() {
        return this._stringForZero;
    }

    public void setStringForZero(String newString) {
        if (!(this._stringForZero == newString || this._stringForZero != null && this._stringForZero.equals(newString))) {
            this._setStringForZero(newString);
            this._updateCharSets();
        }
    }

    private void _setStringForZero(String newString) {
        this._stringForZero = newString;
    }

    public String stringForNull() {
        return this._stringForNull;
    }

    public void setStringForNull(String newString) {
        if (newString == null) {
            throw new IllegalArgumentException("The string for null must be a string of length >= 0");
        }
        this._stringForNull = newString;
    }

    public String stringForNotANumber() {
        return this._stringForNotANumber;
    }

    public void setStringForNotANumber(String newString) {
        if (newString == null) {
            throw new IllegalArgumentException("The string for Not A Number must be a string of length >= 0");
        }
        this._stringForNotANumber = newString;
    }

    @Deprecated
    public String attributedStringForZero() {
        return this.stringForZero();
    }

    @Deprecated
    public void setAttributedStringForZero(String newString) {
        this.setStringForZero(newString);
    }

    @Deprecated
    public String attributedStringForNil() {
        return this.stringForNull();
    }

    @Deprecated
    public void setAttributedStringForNil(String newString) {
        this.setStringForNull(newString);
    }

    @Deprecated
    public String attributedStringForNotANumber() {
        return this.stringForNotANumber();
    }

    @Deprecated
    public void setAttributedStringForNotANumber(String newString) {
        this.setStringForNotANumber(newString);
    }

    public boolean hasThousandSeparators() {
        return this._hasThousandSeparator;
    }

    public void setHasThousandSeparators(boolean newThousandsUsage) {
        this._hasThousandSeparator = newThousandsUsage;
    }

    public boolean allowsFloats() {
        return this._allowsFloats;
    }

    public void setAllowsFloats(boolean allowsRealNumbers) {
        this._allowsFloats = allowsRealNumbers;
    }

    public BigDecimal minimum() {
        return this._minimum;
    }

    public void setMinimum(BigDecimal newMinimum) {
        if (newMinimum == null) {
            throw new IllegalArgumentException("The new minimum must be a valid BigDecimal or NSNumberFormatter.NSDecimalNotANumber");
        }
        this._minimum = newMinimum;
    }

    public BigDecimal maximum() {
        return this._maximum;
    }

    public void setMaximum(BigDecimal newMaximum) {
        if (newMaximum == null) {
            throw new IllegalArgumentException("The new maximum must be a valid BigDecimal or NSNumberFormatter.NSDecimalNotANumber");
        }
        this._maximum = newMaximum;
    }

    public String negativePattern() {
        return this._negativePattern;
    }

    public void setNegativePattern(String pattern) {
        this.validatePattern(pattern);
        if (this._negativePattern.compareTo(pattern) != 0) {
            this.setHasThousandSeparators(pattern.indexOf(this._thousandSeparator()) >= 0);
            StringBuffer help = new StringBuffer(pattern.startsWith("[Red]") ? pattern.substring(5) : pattern);
            ConstructionBuffer newBuffer = (ConstructionBuffer)this._negative.clone();
            newBuffer.mask = this._addThousandSeparatorsToPattern(help, newBuffer).toCharArray();
            newBuffer.maskLen = newBuffer.mask.length;
            this._negative = newBuffer;
            this._negativePattern = new String(help);
            this._updateCharSets();
        }
    }

    public String positivePattern() {
        return this._positivePattern;
    }

    public void setPositivePattern(String pattern) {
        this.validatePattern(pattern);
        if (this._positivePattern.compareTo(pattern) != 0) {
            this.setHasThousandSeparators(pattern.indexOf(this._thousandSeparator()) >= 0);
            StringBuffer help = new StringBuffer(pattern);
            ConstructionBuffer newBuffer = (ConstructionBuffer)this._positive.clone();
            newBuffer.mask = this._addThousandSeparatorsToPattern(help, newBuffer).toCharArray();
            newBuffer.maskLen = newBuffer.mask.length;
            this._positive = newBuffer;
            this._positivePattern = new String(help);
            this._updateCharSets();
        }
    }

    public String pattern() {
        String stringForZero = this.stringForZero();
        if (stringForZero == null) {
            return String.valueOf(this.positivePattern()) + ';' + this.positivePattern() + ';' + this.negativePattern();
        }
        return String.valueOf(this.positivePattern()) + ';' + stringForZero + ';' + this.negativePattern();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setPattern(String pattern) {
        if (pattern == null) throw new IllegalArgumentException("NSNumberFormatter.setPattern() : pattern must not be null.");
        NSArray<String> components = NSArray.componentsSeparatedByString(pattern, String.valueOf(';'));
        int count = components.count();
        if (count <= 1) {
            this.setPositivePattern(pattern);
            this.setStringForZero(null);
            this.setNegativePattern("-" + pattern);
        } else if (count == 2) {
            this.setPositivePattern(components.objectAtIndex(0));
            this.setStringForZero(null);
            this.setNegativePattern(components.objectAtIndex(1));
        } else {
            if (count != 3) throw new IllegalArgumentException("NSNumberFormatter.setPattern() : pattern \"" + pattern + "\" is illegal.");
            this.setPositivePattern(components.objectAtIndex(0));
            this.setStringForZero(components.objectAtIndex(1));
            this.setNegativePattern(components.objectAtIndex(2));
        }
        this.setHasThousandSeparators(pattern.indexOf(this._thousandSeparator()) >= 0);
    }

    @Deprecated
    public String negativeFormat() {
        return this.negativePattern();
    }

    @Deprecated
    public void setNegativeFormat(String pattern) {
        this.setNegativePattern(pattern);
    }

    @Deprecated
    public String positiveFormat() {
        return this.positivePattern();
    }

    @Deprecated
    public void setPositiveFormat(String pattern) {
        this.setPositivePattern(pattern);
    }

    @Deprecated
    public String format() {
        return this.pattern();
    }

    @Deprecated
    public void setFormat(String pattern) {
        this.setPattern(pattern);
    }

    @Deprecated
    public boolean localizesFormat() {
        return this.localizesPattern();
    }

    @Deprecated
    public void setLocalizesFormat(boolean doLocalization) {
        this.setLocalizesPattern(doLocalization);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public String stringForObjectValue(Object inNumber) throws IllegalArgumentException {
        ConstructionBuffer buffer;
        BigDecimal tempNumber;
        boolean isNegative = false;
        if (inNumber == null) {
            return this.stringForNull();
        }
        if (inNumber instanceof BigDecimal) {
            if (inNumber == NSDecimalNotANumber) {
                return this.stringForNotANumber();
            }
            tempNumber = (BigDecimal)inNumber;
        } else if (inNumber instanceof BigInteger) {
            tempNumber = new BigDecimal((BigInteger)inNumber);
        } else if (inNumber instanceof Double || inNumber instanceof Float) {
            tempNumber = new BigDecimal(((Number)inNumber).doubleValue());
        } else if (inNumber instanceof Number) {
            tempNumber = BigDecimal.valueOf(((Number)inNumber).longValue(), 0);
        } else {
            if (!(inNumber instanceof Boolean)) throw new IllegalArgumentException("NSNumberFormatter.stringForObjectValue: argument(" + inNumber + ") of type " + inNumber.getClass().getName() + " is not a Number");
            tempNumber = BigDecimal.valueOf((Boolean)inNumber != false ? 1 : 0);
        }
        int compareResult = tempNumber.signum();
        if (compareResult == -1) {
            buffer = this._negative;
            isNegative = true;
        } else if (compareResult == 0) {
            String stringForZero = this.stringForZero();
            if (stringForZero != null) return stringForZero;
            buffer = this._positive;
        } else {
            buffer = this._positive;
        }
        int scale = buffer.fractionPartLen - 1;
        if (scale == -1) {
            scale = 0;
        } else if (scale < -1) {
            scale = Integer.MIN_VALUE;
        }
        if (scale != Integer.MIN_VALUE && tempNumber.scale() >= scale) {
            tempNumber = tempNumber.setScale(scale, this.roundingBehavior());
        }
        String resultString = this._numberStringForValueObject(tempNumber, buffer, isNegative);
        String currencyMark = this.currencySymbol();
        if (currencyMark.compareTo(STRING_FOR_CURRENCY) == 0) return resultString;
        return _NSStringUtilities.replaceAllInstancesOfString(resultString, STRING_FOR_CURRENCY, currencyMark);
    }

    public Object objectValueForString(String inString) throws ParseException {
        BigDecimal objectValue;
        String stringForNull;
        int len = 0;
        boolean isNegative = false;
        if (inString == null) {
            return null;
        }
        String strValue = inString.trim();
        if (strValue.compareTo(stringForNull = this.stringForNull()) == 0) {
            return null;
        }
        String stringForZero = this.stringForZero();
        if (strValue.compareTo("0") == 0 || stringForZero != null && strValue.compareTo(stringForZero) == 0) {
            return BigDecimal.valueOf(0L, 0);
        }
        String stringForNotANumber = this.stringForNotANumber();
        if (strValue.compareTo(stringForNotANumber) == 0) {
            return NSDecimalNotANumber;
        }
        String temp = _NSStringUtilities.deleteAllInstancesOfString(strValue, this.currencySymbol());
        if (temp != strValue) {
            strValue = temp.trim();
        }
        len = strValue.length();
        char[] buf = strValue.toCharArray();
        int dp = 0;
        int sp = 0;
        int ep = len;
        while (sp < ep) {
            char c = buf[sp];
            if (this._legalChars.indexOf(c) == -1) {
                throw new ParseException("The character " + c + " in the string " + inString + " is not a valid character for a number with a pattern of " + this.pattern(), sp);
            }
            if (c == '-' || this._negativeChars.indexOf(c) != -1) {
                isNegative = true;
            } else if (this._semanticChars.indexOf(c) != -1) {
                buf[dp++] = c;
            }
            ++sp;
        }
        StringBuffer tempBuffer = new StringBuffer(dp + 1);
        if (isNegative) {
            tempBuffer.append('-');
        }
        tempBuffer.append(buf, 0, dp);
        String filteredString = new String(tempBuffer);
        if (this._decimalSeparator() != '.') {
            filteredString = filteredString.replace(this._decimalSeparator(), '.');
        }
        if (filteredString.compareTo(STRING_FOR_NULL) == 0) {
            throw new ParseException("The string " + inString + " does not contain any numeric characters compatible with a pattern of " + this.pattern(), len);
        }
        try {
            objectValue = new BigDecimal(filteredString);
        }
        catch (NumberFormatException e) {
            log.debug("An exception occurred", (Throwable)e);
            objectValue = null;
        }
        if (objectValue == null) {
            throw new ParseException("The string " + inString + " and the pattern " + this.pattern() + " do not specify a valid BigDecimal number", len);
        }
        BigDecimal minimum = this.minimum();
        if (minimum != null && minimum != NSDecimalNotANumber && objectValue.compareTo(minimum) == -1) {
            throw new ParseException("The number " + objectValue + " is less than the minimum accepted value of " + minimum, len);
        }
        BigDecimal maximum = this.maximum();
        if (maximum != null && maximum != NSDecimalNotANumber && objectValue.compareTo(maximum) == 1) {
            throw new ParseException("The number " + objectValue + " is greater than the maximum accepted value of " + maximum, len);
        }
        if (!this.allowsFloats() && filteredString.indexOf(46) != -1) {
            throw new ParseException("The number " + objectValue + " is not an integer value, and this number formatter does not accept floating point values", len);
        }
        return objectValue;
    }

    private String _legalNegativeChars() {
        String negativePattern = this.negativePattern();
        if (negativePattern != null) {
            char c;
            int i;
            StringBuffer result = new StringBuffer();
            String positivePattern = this.positivePattern();
            if (positivePattern != null) {
                i = 0;
                while (i < positivePattern.length()) {
                    c = positivePattern.charAt(i);
                    if (negativePattern.indexOf(c) != -1) {
                        negativePattern = negativePattern.replace(c, '\u0000');
                    }
                    ++i;
                }
            }
            i = 0;
            while (i < negativePattern.length()) {
                c = negativePattern.charAt(i);
                if (c != '\u0000') {
                    result.append(c);
                }
                ++i;
            }
            return new String(result);
        }
        return STRING_FOR_NULL;
    }

    private void appendUniquePatternChars(StringBuffer buffer, String pattern) {
        char[] temp = pattern.toCharArray();
        int length = temp.length;
        int i = 0;
        while (i < length) {
            if (_IgnoredCharsInPatterns.indexOf(temp[i]) < 0) {
                buffer.append(temp[i]);
            }
            ++i;
        }
    }

    private void _updateCharSets() {
        StringBuffer legalCharsBuffer = new StringBuffer(64);
        this._semanticChars = "0123456789" + this.decimalSeparator();
        legalCharsBuffer.append(this._semanticChars);
        legalCharsBuffer.append(this._thousandSeparator());
        legalCharsBuffer.append('-');
        this.appendUniquePatternChars(legalCharsBuffer, this._positivePattern);
        this.appendUniquePatternChars(legalCharsBuffer, this._negativePattern);
        if (this._positivePattern.indexOf(95) >= 0 || this._negativePattern.indexOf(95) >= 0) {
            legalCharsBuffer.append(' ');
        }
        if (this._stringForZero != null) {
            this.appendUniquePatternChars(legalCharsBuffer, this._stringForZero);
        }
        this._legalChars = _NSStringUtilities.stringFromBuffer(legalCharsBuffer);
        this._negativeChars = this._negativePattern.length() > 0 ? this._legalNegativeChars() : STRING_FOR_NULL;
    }

    private void validatePattern(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("A null string is not a legal pattern.");
        }
        if (pattern.compareTo(STRING_FOR_NULL) == 0) {
            throw new IllegalArgumentException("The empty string is not a legal pattern.");
        }
        if (!this._containsValidNumberParts(pattern)) {
            throw new IllegalArgumentException("The pattern string (\"" + pattern + "\") does not contain a numeric character or symbolic placeholder.");
        }
    }

    private String _numberStringForValueObject(BigDecimal num, ConstructionBuffer buffer, boolean isNegative) {
        int maskChar;
        int len;
        String valueString = num.toString();
        int k = 0;
        int pointPos = -1;
        int resultPos = 0;
        char[] result = new char[201];
        int isNeg = isNegative ? 1 : 0;
        char decimalMark = this._decimalSeparator();
        char thousandMark = this._thousandSeparator();
        int resultLength = 200;
        char[] cStringBuffer = valueString.toCharArray();
        boolean hasThousandSeparators = this.hasThousandSeparators();
        int iCount = len = cStringBuffer.length - 1;
        while (iCount >= 0) {
            if (cStringBuffer[iCount--] != '.') continue;
            pointPos = iCount + 1;
            break;
        }
        if (iCount == -1) {
            iCount = len;
        }
        k = 0;
        while (k < buffer.integerPartLen) {
            int pos = buffer.integerPartLen - 1 - k;
            maskChar = buffer.integerPart[pos];
            if (hasThousandSeparators && k > 0 && k % 3 == 0) {
                if (iCount - isNeg < 0) {
                    if (maskChar == 48) {
                        result[resultLength - 1 - resultPos++] = 48;
                    }
                    if (maskChar == 95) {
                        result[resultLength - 1 - resultPos++] = 32;
                    }
                } else {
                    result[resultLength - 1 - resultPos++] = thousandMark;
                }
            }
            if (iCount >= 0 && cStringBuffer[iCount] != '-') {
                if (iCount == 0 && cStringBuffer[iCount] == '0' && len != 0 && (maskChar == 35 || maskChar == 95)) {
                    if (maskChar == 35) {
                        --iCount;
                    } else {
                        result[resultLength - 1 - resultPos++] = 32;
                        --iCount;
                    }
                } else if (cStringBuffer[iCount] == '.') {
                    result[resultLength - 1 - resultPos++] = decimalMark;
                    --iCount;
                } else {
                    result[resultLength - 1 - resultPos++] = cStringBuffer[iCount--];
                }
            } else {
                --iCount;
                if (maskChar == 35) {
                    ++k;
                } else {
                    result[resultLength - ++resultPos] = maskChar == 95 ? 32 : maskChar;
                }
            }
            ++k;
        }
        while (iCount - isNeg >= 0) {
            if (hasThousandSeparators && k > 0 && k % 3 == 0) {
                result[resultLength - 1 - resultPos++] = thousandMark;
            }
            ++k;
            if (cStringBuffer[iCount] == '0' && iCount == 0) {
                --iCount;
                continue;
            }
            if (cStringBuffer[iCount] == '-') continue;
            if (cStringBuffer[iCount] == '.') {
                result[resultLength - 1 - resultPos++] = decimalMark;
                --iCount;
                continue;
            }
            result[resultLength - 1 - resultPos++] = cStringBuffer[iCount--];
        }
        System.arraycopy(result, resultLength - resultPos, result, 0, resultPos);
        int fCount = len;
        k = 0;
        while (k < buffer.fractionPartLen) {
            if (pointPos != -1 && pointPos + k <= fCount) {
                result[resultPos++] = cStringBuffer[pointPos + k] == '.' ? decimalMark : cStringBuffer[pointPos + k];
            } else {
                maskChar = buffer.fractionPart[k];
                if (maskChar == 95) {
                    result[resultPos++] = 32;
                } else if (maskChar == 48) {
                    result[resultPos++] = maskChar;
                } else if (maskChar == 46) {
                    result[resultPos++] = decimalMark;
                }
            }
            ++k;
        }
        if (resultPos != 0 && result[resultPos - 1] == decimalMark) {
            --resultPos;
        }
        resultPos = this._surroundValueInString(result, resultPos, buffer);
        return new String(result, 0, resultPos);
    }

    private int _surroundValueInString(char[] result, int length, ConstructionBuffer buffer) {
        int oLen = length - 1;
        boolean found = false;
        char[] surrounding = buffer.mask;
        int sLen = buffer.maskLen - 1;
        int newLength = length + sLen;
        int k = 0;
        while (k < newLength) {
            if (sLen >= 0 && surrounding[sLen] == '@') {
                found = true;
                --sLen;
            }
            result[newLength - k - 1] = !found ? surrounding[sLen--] : (oLen >= 0 ? result[oLen--] : surrounding[sLen--]);
            ++k;
        }
        return newLength;
    }

    private void _addThousandSeparators(StringBuffer theString, ConstructionBuffer buffer) {
        String fractionPattern;
        String integerPattern;
        int curr;
        String localString = theString.toString();
        int prev = 0;
        StringBuffer tempBuffer = new StringBuffer(localString.length());
        while ((curr = localString.indexOf(44, prev)) >= 0) {
            tempBuffer.append(localString.substring(prev, curr));
            prev = curr + 1;
        }
        tempBuffer.append(localString.substring(prev, localString.length()));
        localString = new String(tempBuffer);
        int range = localString.lastIndexOf(46);
        if (range == -1) {
            integerPattern = localString;
            fractionPattern = null;
        } else {
            integerPattern = localString.substring(0, range);
            fractionPattern = localString.substring(range, localString.length());
        }
        if (this.hasThousandSeparators()) {
            if (integerPattern.length() < 4) {
                switch (integerPattern.length()) {
                    case 0: {
                        integerPattern = "####";
                        break;
                    }
                    case 1: {
                        integerPattern = "###" + integerPattern;
                        break;
                    }
                    case 2: {
                        integerPattern = "##" + integerPattern;
                        break;
                    }
                    case 3: {
                        integerPattern = "#" + integerPattern;
                    }
                }
            }
            buffer.integerPartLen = integerPattern.length();
            buffer.integerPart = integerPattern.toCharArray();
            String tempStr = this._stringWithSeparator(integerPattern, ',', 3);
            theString.setLength(0);
            theString.append(tempStr);
            if (fractionPattern != null) {
                theString.append(fractionPattern);
            }
        } else {
            buffer.integerPartLen = integerPattern.length();
            buffer.integerPart = integerPattern.toCharArray();
        }
        if (fractionPattern != null) {
            buffer.fractionPartLen = fractionPattern.length();
            buffer.fractionPart = fractionPattern.toCharArray();
        } else {
            buffer.fractionPartLen = 0;
        }
    }

    private String _addThousandSeparatorsToPattern(StringBuffer theString, ConstructionBuffer buffer) {
        StringBuffer center;
        String postfix;
        String prefix;
        String localString = theString.toString();
        int curr = this._findFirstPartOfNumber(localString);
        if (curr == -1) {
            prefix = new String(STRING_FOR_NULL);
            postfix = new String(localString);
        } else {
            prefix = localString.substring(0, curr);
            postfix = localString.substring(curr, localString.length());
        }
        if (!this._containsValidNumberParts(localString)) {
            center = new StringBuffer(8);
            center.append("#,##0.##");
        } else {
            center = new StringBuffer(postfix.length());
            String tempStr = postfix;
            curr = tempStr.indexOf(postfix = this._deleteAllPartsOfNumbers(postfix));
            if (curr != -1) {
                if (curr > 0) {
                    center.append(tempStr.substring(0, curr));
                }
                center.append(tempStr.substring(curr + postfix.length(), tempStr.length()));
            } else {
                center.append(tempStr);
            }
        }
        int prev = 0;
        StringBuffer tempBuffer = new StringBuffer(postfix.length());
        while ((curr = postfix.indexOf(44, prev)) != -1) {
            tempBuffer.append(postfix.substring(prev, curr));
            prev = curr + 1;
        }
        tempBuffer.append(postfix.substring(prev, postfix.length()));
        postfix = new String(tempBuffer);
        this._addThousandSeparators(center, buffer);
        theString.setLength(0);
        theString.append(prefix);
        theString.append(center);
        theString.append(postfix);
        return String.valueOf(prefix) + "@" + postfix;
    }

    private int _findFirstPartOfNumber(String value) {
        char[] temp = value.toCharArray();
        int index = 0;
        int len = temp.length;
        while (index < len) {
            int result = PART_OF_NUMBER.indexOf(temp[index]);
            if (result != -1) break;
            ++index;
        }
        return index == len ? -1 : index;
    }

    private boolean _containsValidNumberParts(String value) {
        return this._findFirstPartOfNumber(value) != -1;
    }

    private String _deleteAllPartsOfNumbers(String value) {
        char[] temp = value.toCharArray();
        StringBuffer result = new StringBuffer(value.length());
        int index = 0;
        int len = temp.length;
        while (index < len) {
            int test = PART_OF_NUMBER.indexOf(temp[index]);
            if (test == -1) {
                result.append(temp[index]);
            }
            ++index;
        }
        return result.toString();
    }

    private String _stringWithSeparator(String value, char separator, int frequency) {
        int length = value.length();
        if (length == 0) {
            return STRING_FOR_NULL;
        }
        int newLen = length + (length - 1) / frequency;
        char[] formatted = new char[newLen];
        char[] unformatted = value.toCharArray();
        int uc = --length;
        int pos = 0;
        while (uc >= 0) {
            if (uc != length && (length - uc) % frequency == 0) {
                formatted[newLen - 1 - pos] = separator;
                ++pos;
            }
            formatted[newLen - 1 - pos] = unformatted[uc];
            --uc;
            ++pos;
        }
        String retValue = new String(formatted);
        return retValue;
    }

    @Override
    public StringBuffer format(Object obj, StringBuffer toAppendTo, FieldPosition pos) {
        return toAppendTo.append(this.stringForObjectValue(obj));
    }

    @Override
    public Object parseObject(String source, ParsePosition status) {
        Object result;
        String temp = source.substring(status.getIndex());
        try {
            result = this.objectValueForString(temp);
            status.setIndex(source.length());
        }
        catch (ParseException e) {
            log.debug("An exception occurred", (Throwable)e);
            result = null;
        }
        return result;
    }

    @Override
    public Object parseObject(String source) throws ParseException {
        return this.objectValueForString(source);
    }

    public static Locale[] availableLocales() {
        return NumberFormat.getAvailableLocales();
    }

    public static Locale defaultLocale() {
        if (globalDefaultLocale == null) {
            globalDefaultLocale = Locale.getDefault();
        }
        return globalDefaultLocale;
    }

    public static void setDefaultLocale(Locale newLocale) {
        if (newLocale == null) {
            throw new IllegalArgumentException("NSNumberFormatter.setDefaultLocale() : newLocale must not be null.");
        }
        globalDefaultLocale = newLocale;
    }

    public Locale locale() {
        if (this._currentLocale == null) {
            this._currentLocale = Locale.getDefault();
        }
        return this._currentLocale;
    }

    public void setLocale(Locale newLocale) {
        if (newLocale == null) {
            throw new IllegalArgumentException("NSNumberFormatter.setLocale() : newLocale must not be null.");
        }
        if (this._currentLocale == null || !this._currentLocale.equals(newLocale)) {
            this._currentLocale = newLocale;
            if (this.localizesPattern()) {
                this._updateLocalizedPatterns();
            }
        }
    }

    public static boolean defaultLocalizesPattern() {
        return globalDefaultLocalizesFormat;
    }

    public static void setDefaultLocalizesPattern(boolean newDefault) {
        globalDefaultLocalizesFormat = newDefault;
    }

    public boolean localizesPattern() {
        return this._localizesFormat;
    }

    public void setLocalizesPattern(boolean newDefault) {
        if (this._localizesFormat != newDefault) {
            this._localizesFormat = newDefault;
            this._updateLocalizedPatterns();
        }
    }

    public String currencySymbol() {
        return this._currencyString;
    }

    public void setCurrencySymbol(String newSymbol) {
        if (newSymbol == null) {
            throw new IllegalArgumentException("NSNumberFormatter.setCurrencySymbol() : newSymbol must not be null.");
        }
        if (this._currencyString.compareTo(newSymbol) != 0) {
            this._setCurrencyMark(newSymbol);
            this._updateCharSets();
        }
    }

    private void _setCurrencyMark(String newSymbol) {
        this._currencyString = newSymbol;
    }

    private void _updateLocalizedPatterns() {
        if (this.localizesPattern()) {
            DecimalFormatSymbols symbols = new DecimalFormatSymbols(this.locale());
            this.setDecimalSeparator(symbols.getDecimalSeparator());
            this.setThousandSeparator(symbols.getGroupingSeparator());
            this._setStringForZero(String.valueOf(symbols.getZeroDigit()));
            this.setStringForNotANumber(symbols.getNaN());
            this._setCurrencyMark(symbols.getCurrencySymbol());
        } else {
            this.setDecimalSeparator('.');
            this.setThousandSeparator(',');
            this._setStringForZero(STRING_FOR_ZERO);
            this.setStringForNotANumber(STRING_FOR_NOTANUMBER);
            this._setCurrencyMark(STRING_FOR_CURRENCY);
        }
        this._updateCharSets();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationPatternFieldKey, this.pattern());
        if (this._stringForZero != STRING_FOR_ZERO) {
            fields.put(SerializationStringForZeroFieldKey, this._stringForZero);
        }
        if (this._stringForNull != STRING_FOR_NULL) {
            fields.put(SerializationStringForNullFieldKey, this._stringForNull);
        }
        if (this._stringForNotANumber != STRING_FOR_NOTANUMBER) {
            fields.put(SerializationStringForNANFieldKey, this._stringForNotANumber);
        }
        if (this._minimum != NSDecimalNotANumber) {
            fields.put(SerializationMinimumFieldKey, this._minimum);
        }
        if (this._maximum != NSDecimalNotANumber) {
            fields.put(SerializationMaximumFieldKey, this._maximum);
        }
        fields.put(SerializationRoundingBehaviorFieldKey, this._roundingBehavior);
        if (this._decimalSeparator != '.') {
            fields.put(SerializationDecimalSeparatorFieldKey, String.valueOf(this._decimalSeparator));
        }
        if (this._thousandSeparator != ',') {
            fields.put(SerializationThousandsMarkFieldKey, String.valueOf(this._thousandSeparator));
        }
        fields.put(SerializationHasThousandsMarkFieldKey, this._hasThousandSeparator);
        fields.put(SerializationAllowsFloatingPointFieldKey, this._allowsFloats);
        if (this._currentLocale != null && this._currentLocale != NSNumberFormatter.defaultLocale()) {
            fields.put(SerializationLocaleFieldKey, this._currentLocale);
        }
        fields.put(SerializationLocalizedPatternFieldKey, this._localizesFormat);
        if (this._currencyString != STRING_FOR_CURRENCY) {
            fields.put(SerializationCurrencyMarkFieldKey, this._currencyString);
        }
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        String pattern = (String)fields.get(SerializationPatternFieldKey, "#,##0.##");
        if (pattern == null) {
            pattern = "#,##0.##";
        }
        this._stringForZero = (String)fields.get(SerializationStringForZeroFieldKey, STRING_FOR_ZERO);
        if (this._stringForZero == null) {
            this._stringForZero = STRING_FOR_ZERO;
        }
        this._stringForNull = (String)fields.get(SerializationStringForNullFieldKey, STRING_FOR_NULL);
        if (this._stringForNull == null) {
            this._stringForNull = STRING_FOR_NULL;
        }
        this._stringForNotANumber = (String)fields.get(SerializationStringForNANFieldKey, STRING_FOR_NOTANUMBER);
        if (this._stringForNotANumber == null) {
            this._stringForNotANumber = STRING_FOR_NOTANUMBER;
        }
        this._minimum = (BigDecimal)fields.get(SerializationMinimumFieldKey, NSDecimalNotANumber);
        if (this._minimum == null) {
            this._minimum = NSDecimalNotANumber;
        }
        this._maximum = (BigDecimal)fields.get(SerializationMaximumFieldKey, NSDecimalNotANumber);
        if (this._maximum == null) {
            this._maximum = NSDecimalNotANumber;
        }
        this._roundingBehavior = fields.get(SerializationRoundingBehaviorFieldKey, 4);
        this._decimalSeparator = ((String)fields.get(SerializationDecimalSeparatorFieldKey, DefaultDecimalSeparatorString)).charAt(0);
        if (this._thousandSeparator == '\u0000') {
            this._thousandSeparator = DefaultDecimalSeparatorString.charAt(0);
        }
        this._thousandSeparator = ((String)fields.get(SerializationThousandsMarkFieldKey, DefaultThousandSeparatorString)).charAt(0);
        if (this._thousandSeparator == '\u0000') {
            this._thousandSeparator = DefaultThousandSeparatorString.charAt(0);
        }
        this._hasThousandSeparator = fields.get(SerializationHasThousandsMarkFieldKey, true);
        this._allowsFloats = fields.get(SerializationAllowsFloatingPointFieldKey, true);
        Locale archivedLocale = (Locale)fields.get(SerializationLocaleFieldKey, null);
        boolean archivedlocalizesFormat = fields.get(SerializationLocalizedPatternFieldKey, false);
        this._currencyString = (String)fields.get(SerializationCurrencyMarkFieldKey, STRING_FOR_CURRENCY);
        if (this._currencyString == null) {
            this._currencyString = STRING_FOR_CURRENCY;
        }
        this.initializeDefaults();
        this.setPattern(pattern);
        this._localizesFormat = archivedlocalizesFormat;
        if (archivedLocale != null) {
            this.setLocale(archivedLocale);
        }
    }

    static class ConstructionBuffer
    implements Cloneable {
        public char[] mask;
        public int maskLen;
        public char[] integerPart;
        public int integerPartLen;
        public char[] fractionPart;
        public int fractionPartLen;

        ConstructionBuffer() {
        }

        public Object clone() {
            ConstructionBuffer result = new ConstructionBuffer();
            result.mask = _NSCollectionPrimitives.copyArray(this.mask);
            result.maskLen = this.maskLen;
            result.integerPart = _NSCollectionPrimitives.copyArray(this.integerPart);
            result.integerPartLen = this.integerPartLen;
            result.fractionPart = _NSCollectionPrimitives.copyArray(this.fractionPart);
            result.fractionPartLen = this.fractionPartLen;
            return result;
        }

        public String toString() {
            StringBuffer temp = new StringBuffer(64);
            char[] tempNull = "null".toCharArray();
            temp.append("mask = ");
            temp.append(this.mask == null ? tempNull : this.mask);
            temp.append("\nmaskLen = ");
            temp.append(this.maskLen);
            temp.append("\nintegerPart = ");
            temp.append(this.integerPart == null ? tempNull : this.integerPart);
            temp.append("\nintegerPartLen = ");
            temp.append(this.integerPartLen);
            temp.append("\nfractionPart = ");
            temp.append(this.fractionPart == null ? tempNull : this.fractionPart);
            temp.append("\nfractionPartLen = ");
            temp.append(this.fractionPartLen);
            return new String(temp);
        }
    }
}

