/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSMutableArray;
import com.webobjects.foundation.NSMutableDictionary;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSNotification;
import com.webobjects.foundation.NSNotifier;
import com.webobjects.foundation.NSSelector;
import com.webobjects.foundation._NSUtilities;
import com.webobjects.foundation._NSWeakMutableArray;
import com.webobjects.foundation._NSWeakMutableCollection;
import com.webobjects.foundation._NSWeakMutableSet;
import java.lang.ref.ReferenceQueue;
import java.lang.ref.WeakReference;
import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Set;
import java.util.WeakHashMap;

public class NSNotificationCenter {
    public static final Class<NSNotificationCenter> _CLASS = _NSUtilities._classWithClassLiteral(NSNotificationCenter.class);
    private static NSNotificationCenter _defaultCenter = new NSNotificationCenter();
    private static final WeakHashMap<?, ?> _byObjectPlaceholder = new WeakHashMap(0);
    private static final _NSWeakMutableArray<?, ?> _byNamePlaceholder = new _NSWeakMutableArray(0);
    private WeakHashMap<Object, _NSWeakMutableArray<Object, _Entry<?>>> _byObject;
    private _NSWeakMutableSet<Object, _Entry<?>> _omniscient;
    private NSMutableDictionary<String, NSMutableArray<Object>> _byName;

    public static NSNotificationCenter defaultCenter() {
        return _defaultCenter;
    }

    protected NSNotificationCenter() {
    }

    public String toString() {
        return String.valueOf(super.toString()) + "\n_omniscient=\n" + this._omniscient + "\n_byObject=\n" + this._byObject + "\n_byName=\n" + this._byName;
    }

    protected <E> _Entry<E> _getEntry(E observer, NSSelector<?> selector, ReferenceQueue<? super E> queue) {
        return new _SelectorEntry<E>(observer, selector, queue);
    }

    private final <E> _Entry<E> _getEntry(E observer, NSNotifier<? super E> notifier, ReferenceQueue<? super E> queue) {
        if (notifier instanceof _SelectorNotifier) {
            return this._getEntry(observer, ((_SelectorNotifier)notifier).selector(), queue);
        }
        return new _NotifierEntry<E>(observer, notifier, queue);
    }

    private void _checkObserverAndSelector(Object observer, NSSelector<?> sel) {
        if (observer == null || sel == null) {
            String exceptionString = "";
            exceptionString = observer == null && sel == null ? "NSNotificationCenter addObserver() requires non null observer and selector parameters" : (observer == null ? "NSNotificationCenter addObserver() requires non null observer parameter" : "NSNotificationCenter addObserver() requires non null selector parameter");
            throw new IllegalArgumentException(exceptionString);
        }
        Class<?>[] parameterTypes = sel.parameterTypes();
        boolean isBadSelector = false;
        if (parameterTypes == null || parameterTypes.length != 1) {
            isBadSelector = true;
        } else {
            Class<?> argument = parameterTypes[0];
            if (argument == null || !NSNotification.class.isAssignableFrom(argument)) {
                isBadSelector = true;
            }
        }
        if (isBadSelector) {
            throw new IllegalArgumentException("NSNotificationCenter addObserver() requires a selector taking a single NSNotification argument");
        }
    }

    private void _checkObserverAndNotifier(Object observer, NSNotifier<?> notifier) {
        if (observer == null || notifier == null) {
            String exceptionString = "";
            exceptionString = observer == null && notifier == null ? "NSNotificationCenter addObserver() requires non null observer and notifier parameters" : (observer == null ? "NSNotificationCenter addObserver() requires non null observer parameter" : "NSNotificationCenter addObserver() requires non null selector parameter");
            throw new IllegalArgumentException(exceptionString);
        }
    }

    @Deprecated
    public synchronized void addOmniscientObserver(Object observer, NSSelector<?> sel) {
        if (this._omniscient == null) {
            this._omniscient = new _NSWeakMutableSet(8);
        }
        this._checkObserverAndSelector(observer, sel);
        this._omniscient.addReference(this._getEntry(observer, sel, this._omniscient.queue));
    }

    public synchronized <E> void addOmniscientObserver(E observer, NSNotifier<? super E> sel) {
        if (this._omniscient == null) {
            this._omniscient = new _NSWeakMutableSet(8);
        }
        this._checkObserverAndNotifier(observer, sel);
        _Entry<? super E> entry = this._getEntry(observer, sel, this._omniscient.queue);
        this._omniscient.addReference(entry);
    }

    @Deprecated
    public synchronized void addObserver(Object observer, NSSelector<?> sel, String name, Object object) {
        this._checkObserverAndSelector(observer, sel);
        this._addObserver(observer, new _SelectorNotifier(sel), name, object);
    }

    public synchronized <E> void addObserver(E observer, NSNotifier<? super E> sel, String name, Object object) {
        this._checkObserverAndNotifier(observer, sel);
        this._addObserver(observer, sel, name, object);
    }

    private final <E> void _addObserver(E observer, NSNotifier<? super E> sel, String name, Object object) {
        if (name == null) {
            _NSWeakMutableArray<Object, _Entry<Object>> existingObservers;
            if (object == null) {
                throw new IllegalArgumentException("Use NSNotificationCenter.addOmniscientObserver(observer) to add omniscient observers");
            }
            if (this._byObject == null) {
                this._byObject = new WeakHashMap(128);
            }
            if ((existingObservers = this._byObject.get(object)) == null) {
                existingObservers = new _NSWeakMutableArray(8);
                this._byObject.put(object, existingObservers);
                existingObservers.addReference(this._getEntry(observer, sel, existingObservers.queue));
            } else {
                _Entry<? super E> entry = this._getEntry(observer, sel, existingObservers.queue);
                if (existingObservers.indexOfObject(entry) < 0) {
                    existingObservers.addReference(entry);
                }
            }
        } else {
            NSMutableArray<int> array;
            if (this._byName == null) {
                this._byName = new NSMutableDictionary(128);
            }
            if ((array = (NSMutableArray<int>)this._byName.objectForKey(name)) == null) {
                array = new NSMutableArray<int>(2);
                array.insertObjectAtIndex((int)_byObjectPlaceholder, 0);
                array.insertObjectAtIndex((int)_byNamePlaceholder, 1);
                this._byName.setObjectForKey(array, name);
            }
            if (object == null) {
                _Entry<? super E> entry;
                _NSWeakMutableArray weakRefs = (_NSWeakMutableArray)array.objectAtIndex(1);
                if (weakRefs == _byNamePlaceholder) {
                    weakRefs = new _NSWeakMutableArray(8);
                    array.replaceObjectAtIndex((int)weakRefs, 1);
                }
                if (weakRefs.indexOfObject(entry = this._getEntry(observer, sel, weakRefs.queue)) < 0) {
                    weakRefs.addReference(entry);
                }
            } else {
                _Entry<? super E> entry;
                _NSWeakMutableArray existingObservers;
                WeakHashMap byObj = (WeakHashMap)array.objectAtIndex(0);
                if (byObj == _byObjectPlaceholder) {
                    byObj = new WeakHashMap(8);
                    array.replaceObjectAtIndex((int)byObj, 0);
                }
                if ((existingObservers = (_NSWeakMutableArray)byObj.get(object)) == null) {
                    existingObservers = new _NSWeakMutableArray(8);
                    byObj.put(object, existingObservers);
                }
                if (existingObservers.indexOfObject(entry = this._getEntry(observer, sel, existingObservers.queue)) < 0) {
                    existingObservers.addReference(entry);
                }
            }
        }
    }

    private void _removeReferencesWithReferentFromByObjectDict(Object observer, WeakHashMap<Object, ? extends _NSWeakMutableArray<Object, ? extends _Entry<?>>> simpleDict) {
        Set<Object> keySet = simpleDict.keySet();
        Iterator<Object> keyIterator = keySet.iterator();
        while (keyIterator.hasNext()) {
            _NSWeakMutableArray<Object, ? extends _Entry<?>> weakArray = simpleDict.get(keyIterator.next());
            if (weakArray == null) continue;
            this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
        }
    }

    private void _removeReferencesWithReferentFromWeakArray(Object observer, _NSWeakMutableArray<Object, ? extends _Entry<?>> weakArray) {
        Object[] removeObjs = new Object[weakArray.count()];
        int j = 0;
        Enumeration<_Entry<?>> arrayEnum = weakArray.referenceEnumerator();
        while (arrayEnum.hasMoreElements()) {
            _Entry<?> entry = arrayEnum.nextElement();
            Object curObj = entry.get();
            if (curObj == null || !curObj.equals(observer)) continue;
            removeObjs[j] = entry;
            ++j;
        }
        int i = 0;
        while (i < j) {
            weakArray.removeReference(removeObjs[i]);
            ++i;
        }
    }

    public synchronized void removeOmniscientObserver(Object observer) {
        if (this._omniscient != null) {
            this._omniscient.removeReferencesWithReferent(observer);
        }
    }

    public void removeObserver(Object observer) {
        this.removeObserver(observer, null, null);
    }

    public synchronized void removeObserver(Object observer, String name, Object object) {
        if (observer == null && name == null && object == null) {
            throw new IllegalArgumentException("Can't remove entry with null observer, null name, and null object from NSNotificationCenter");
        }
        if (name == null && object == null) {
            this.removeOmniscientObserver(observer);
            if (this._byObject != null) {
                this._removeReferencesWithReferentFromByObjectDict(observer, this._byObject);
            }
            if (this._byName != null) {
                Enumeration nameEnum = this._byName.keyEnumerator();
                while (nameEnum.hasMoreElements()) {
                    Object key = nameEnum.nextElement();
                    NSMutableArray stub = (NSMutableArray)this._byName.objectForKey(key);
                    WeakHashMap byNameByObject = (WeakHashMap)stub.objectAtIndex(0);
                    _NSWeakMutableArray byNameArray = (_NSWeakMutableArray)stub.objectAtIndex(1);
                    if (byNameByObject == null || byNameArray == null) {
                        throw new IllegalStateException("NSNotificationCenter is in an illegal state.");
                    }
                    if (byNameByObject != _byObjectPlaceholder) {
                        this._removeReferencesWithReferentFromByObjectDict(observer, byNameByObject);
                    }
                    if (byNameArray == _byNamePlaceholder) continue;
                    this._removeReferencesWithReferentFromWeakArray(observer, byNameArray);
                }
            }
        } else if (observer == null && object == null) {
            this._byName.removeObjectForKey(name);
        } else if (observer == null && name == null) {
            if (this._byObject != null) {
                this._byObject.remove(object);
            }
            Enumeration byNameObjectEnum = this._byName.objectEnumerator();
            while (byNameObjectEnum.hasMoreElements()) {
                WeakHashMap map = (WeakHashMap)((NSMutableArray)byNameObjectEnum.nextElement()).objectAtIndex(0);
                map.remove(object);
            }
        } else if (object == null) {
            NSMutableArray array = (NSMutableArray)this._byName.objectForKey(name);
            if (array != null) {
                _NSWeakMutableArray weakArray;
                WeakHashMap map = (WeakHashMap)array.objectAtIndex(0);
                if (map != _byObjectPlaceholder) {
                    for (_NSWeakMutableArray weakArray2 : map.values()) {
                        if (weakArray2 == null) continue;
                        this._removeReferencesWithReferentFromWeakArray(observer, weakArray2);
                    }
                }
                if ((weakArray = (_NSWeakMutableArray)array.objectAtIndex(1)) != null) {
                    this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
                }
            }
        } else if (name == null) {
            _NSWeakMutableArray weakArray = this._byObject.get(object);
            if (weakArray != null) {
                this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
            }
            Enumeration _byNameEnumerator = this._byName.objectEnumerator();
            while (_byNameEnumerator.hasMoreElements()) {
                NSMutableArray array = (NSMutableArray)_byNameEnumerator.nextElement();
                WeakHashMap map = (WeakHashMap)array.objectAtIndex(0);
                weakArray = (_NSWeakMutableArray)map.get(object);
                if (weakArray == null) continue;
                this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
            }
        } else if (observer == null) {
            NSMutableArray array = (NSMutableArray)this._byName.objectForKey(name);
            if (array != null) {
                WeakHashMap map = (WeakHashMap)array.objectAtIndex(0);
                map.remove(object);
            }
        } else {
            _NSWeakMutableArray weakArray;
            WeakHashMap map;
            NSMutableArray array = (NSMutableArray)this._byName.objectForKey(name);
            if (array != null && (map = (WeakHashMap)array.objectAtIndex(0)) != _byObjectPlaceholder && (weakArray = (_NSWeakMutableArray)map.get(object)) != null) {
                this._removeReferencesWithReferentFromWeakArray(observer, weakArray);
            }
        }
    }

    private static <R extends WeakReference<?>> void _addObserversFromArrayToSet(_NSWeakMutableArray<?, ? extends R> array, NSMutableSet<R> observers) {
        if (array != null) {
            Enumeration<R> refEnum = array.referenceEnumerator();
            while (refEnum.hasMoreElements()) {
                WeakReference ref = (WeakReference)refEnum.nextElement();
                if (ref == null) {
                    throw new IllegalStateException("Enumeration in NSNotificationCenter returned a null element.  What gives?");
                }
                observers.addObject(ref);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void postNotification(NSNotification notification) {
        Object obj = notification.object();
        NSMutableSet<int> observers = new NSMutableSet<int>(16);
        NSNotificationCenter nSNotificationCenter = this;
        synchronized (nSNotificationCenter) {
            NSMutableArray array;
            if (this._omniscient != null) {
                Enumeration<_Entry<?>> enumeration = this._omniscient.referenceEnumerator();
                while (enumeration.hasMoreElements()) {
                    observers.addObject((int)enumeration.nextElement());
                }
            }
            if (this._byObject != null && obj != null) {
                NSNotificationCenter._addObserversFromArrayToSet(this._byObject.get(obj), observers);
            }
            if (this._byName != null && (array = (NSMutableArray)this._byName.objectForKey(notification.name())) != null) {
                WeakHashMap byObj;
                if (obj != null && (byObj = (WeakHashMap)array.objectAtIndex(0)) != _byObjectPlaceholder) {
                    NSNotificationCenter._addObserversFromArrayToSet((_NSWeakMutableArray)byObj.get(obj), observers);
                }
                NSNotificationCenter._addObserversFromArrayToSet((_NSWeakMutableArray)array.objectAtIndex(1), observers);
            }
        }
        Object[] targets = observers._allObjects();
        int i = 0;
        while (i < targets.length) {
            ((_Entry)targets[i]).invokeMethod(notification);
            ++i;
        }
    }

    public void postNotification(String notificationName, Object notificationObject) {
        this.postNotification(new NSNotification(notificationName, notificationObject, null));
    }

    public void postNotification(String notificationName, Object notificationObject, NSDictionary<?, ?> userInfo) {
        this.postNotification(new NSNotification(notificationName, notificationObject, userInfo));
    }

    private static abstract class _Entry<E>
    extends _NSWeakMutableCollection._NSWeakMutableCollectionReference<E> {
        public _Entry(E anObject, ReferenceQueue<? super E> refQueue) {
            super(anObject, refQueue);
        }

        public abstract void invokeMethod(NSNotification var1);
    }

    private static class _NotifierEntry<E>
    extends _Entry<E> {
        private final NSNotifier<? super E> _notifier;

        public _NotifierEntry(E observer, NSNotifier<? super E> notifier, ReferenceQueue<? super E> refQueue) {
            super(observer, refQueue);
            this._notifier = notifier;
        }

        @Override
        public void invokeMethod(NSNotification notification) {
            Object ref = this.get();
            if (ref != null) {
                this._notifier.notifyObjectOfNotification(ref, notification);
            }
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof _NotifierEntry) {
                Object myReferent = this.get();
                if (myReferent == null) {
                    return false;
                }
                Object otherReferent = ((_NotifierEntry)object).get();
                NSNotifier<? super E> otherNotifier = ((_NotifierEntry)object)._notifier;
                return !(myReferent != otherReferent && !myReferent.equals(otherReferent) || this._notifier != otherNotifier && !this._notifier.equals(otherNotifier));
            }
            return false;
        }

        @Override
        public String toString() {
            Object observer = this.get();
            return (observer == null ? "NULL_OBSERVER" : observer) + "." + (this._notifier == null ? "NULL_NOTIFIER" : this._notifier.getClass().getName());
        }
    }

    private static class _SelectorEntry<E>
    extends _Entry<E> {
        Method _method;

        public _SelectorEntry(E observer, NSSelector<?> sel, ReferenceQueue<? super E> queue) {
            super(observer, queue);
            try {
                this._method = observer instanceof Class ? sel.methodOnClass((Class)observer) : sel.methodOnObject(observer);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new IllegalArgumentException("observer <" + observer.getClass() + "> doesn't implement method named " + sel.name() + " or this method is not public");
            }
        }

        @Override
        public void invokeMethod(NSNotification notification) {
            Object ref = this.get();
            if (ref != null) {
                NSSelector._safeInvokeMethod(this._method, ref, notification);
            }
        }

        @Override
        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof _SelectorEntry) {
                Object myReferent = this.get();
                if (myReferent == null) {
                    return false;
                }
                Object otherReferent = ((_SelectorEntry)object).get();
                Method otherMethod = ((_SelectorEntry)object).method();
                return !(myReferent != otherReferent && !myReferent.equals(otherReferent) || this._method != otherMethod && !this._method.equals(otherMethod));
            }
            return false;
        }

        public Object observer() {
            return this.get();
        }

        public Method method() {
            return this._method;
        }

        @Override
        public String toString() {
            Object observer = this.get();
            return (observer == null ? "NULL_OBSERVER" : observer) + "." + (this._method == null ? "NULL_METHOD" : this._method.getName());
        }
    }

    static class _SelectorNotifier
    implements NSNotifier<Object> {
        final NSSelector<?> _selector;

        _SelectorNotifier(NSSelector<?> selector) {
            this._selector = selector;
        }

        @Override
        public void notifyObjectOfNotification(Object ref, NSNotification notification) {
            NSSelector._safeInvokeSelector(this._selector, ref, notification);
        }

        public final NSSelector<?> selector() {
            return this._selector;
        }

        public int hashCode() {
            return this._selector == null ? 0 : this._selector.hashCode();
        }

        public boolean equals(Object otherObject) {
            if (otherObject instanceof _SelectorNotifier) {
                _SelectorNotifier other = (_SelectorNotifier)otherObject;
                NSSelector<?> otherSelector = other._selector;
                return this._selector == otherSelector || this._selector != null && otherSelector != null && this._selector.equals(otherSelector);
            }
            return false;
        }
    }
}

