/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSCoder;
import com.webobjects.foundation.NSCoding;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation._NSUtilities;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamField;
import java.io.Serializable;

public class NSNotification
implements NSCoding,
Serializable {
    public static final Class<NSNotification> _CLASS = _NSUtilities._classWithClassLiteral(NSNotification.class);
    static final long serialVersionUID = 1087005641968243948L;
    private static final String SerializationNameFieldKey = "name";
    private static final String SerializationObjectFieldKey = "object";
    private static final String SerializationUserInfoFieldKey = "userInfo";
    private String _name;
    private Object _object;
    private NSDictionary<?, ?> _userInfo;
    private static final ObjectStreamField[] serialPersistentFields = new ObjectStreamField[]{new ObjectStreamField("name", String.class), new ObjectStreamField("object", Object.class), new ObjectStreamField("userInfo", NSDictionary.class)};

    public NSNotification(String name, Object object, NSDictionary<?, ?> userInfo) {
        if (name == null) {
            throw new IllegalArgumentException("attempt to create notification without a name");
        }
        this._name = name;
        this._object = object;
        this._userInfo = userInfo != null ? userInfo : NSDictionary.emptyDictionary();
    }

    public NSNotification(String name, Object object) {
        this(name, object, null);
    }

    public String name() {
        return this._name;
    }

    public Object object() {
        return this._object;
    }

    public NSDictionary<?, ?> userInfo() {
        return this._userInfo;
    }

    public String toString() {
        Object object = this.object();
        NSDictionary<?, ?> userInfo = this.userInfo();
        if (object == null && userInfo == null) {
            return "<" + this.getClass().toString() + "(name=" + this.name() + ")>";
        }
        if (object == null) {
            return "<" + this.getClass().toString() + "(name=" + this.name() + ", userInfo=" + userInfo + ")>";
        }
        if (userInfo == null) {
            return "<" + this.getClass().toString() + "(name=" + this.name() + ", object=" + object + ")>";
        }
        return "<" + this.getClass().toString() + "(name=" + this.name() + ", object=" + object + ", userInfo=" + userInfo + ")>";
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof NSNotification) {
            NSNotification otherNotification = (NSNotification)other;
            if (this.name().equals(otherNotification.name()) && this.object() == otherNotification.object()) {
                NSDictionary<?, ?> otherUserInfo;
                NSDictionary<?, ?> userInfo = this.userInfo();
                if (userInfo != (otherUserInfo = otherNotification.userInfo())) {
                    return userInfo == null || otherUserInfo == null ? false : userInfo.equals(otherUserInfo);
                }
                return true;
            }
        }
        return false;
    }

    @Override
    public Class<?> classForCoder() {
        return this.getClass();
    }

    public static Object decodeObject(NSCoder coder) {
        String name = (String)coder.decodeObject();
        Object object = coder.decodeObject();
        NSDictionary userInfo = (NSDictionary)coder.decodeObject();
        return new NSNotification(name, object, userInfo);
    }

    @Override
    public void encodeWithCoder(NSCoder coder) {
        coder.encodeObject(this.name());
        coder.encodeObject(this.object());
        coder.encodeObject(this.userInfo());
    }

    public int hashCode() {
        return this.name().hashCode();
    }

    private void writeObject(ObjectOutputStream s) throws IOException {
        ObjectOutputStream.PutField fields = s.putFields();
        fields.put(SerializationNameFieldKey, this.name());
        fields.put(SerializationObjectFieldKey, this.object());
        fields.put(SerializationUserInfoFieldKey, this.userInfo());
        s.writeFields();
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        ObjectInputStream.GetField fields = null;
        fields = s.readFields();
        String name = (String)fields.get(SerializationNameFieldKey, null);
        if (name == null) {
            throw new IllegalArgumentException("attempt to create notification without a name");
        }
        this._name = name;
        this._object = fields.get(SerializationObjectFieldKey, null);
        NSDictionary userInfo = (NSDictionary)fields.get(SerializationUserInfoFieldKey, NSDictionary.class);
        this._userInfo = userInfo == null ? NSDictionary.EmptyDictionary : userInfo;
    }
}

