/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilities;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;

public class NSMutableSet<E>
extends NSSet<E> {
    public static final Class<NSMutableSet> _CLASS = _NSUtilities._classWithClassLiteral(NSMutableSet.class);
    static final long serialVersionUID = -6054074706096120227L;

    public static <E> NSMutableSet<E> set() {
        return new NSMutableSet<E>();
    }

    public static <E> NSMutableSet<E> setWithCapacity(int capacity) {
        return new NSMutableSet<int>(capacity);
    }

    public static <E> NSMutableSet<E> setWithArray(NSArray<? extends E> array) {
        return new NSMutableSet<E>(array);
    }

    public static <E> NSMutableSet<E> setWithObject(E object) {
        return new NSMutableSet<E>(object);
    }

    public static <E> NSMutableSet<E> setWithObjects(E ... objects) {
        return new NSMutableSet<E>(objects);
    }

    public static <E> NSMutableSet<E> setWithSet(NSSet<? extends E> set) {
        return new NSMutableSet<E>(set);
    }

    public static <E> NSMutableSet<E> setWithCollection(Collection<? extends E> objects) {
        return new NSMutableSet<E>(objects);
    }

    public NSMutableSet() {
    }

    public NSMutableSet(int capacity) {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableSet(E object) {
        super(object);
    }

    public NSMutableSet(E[] objects) {
        super(objects);
    }

    public NSMutableSet(E object, E ... objects) {
        super(object, objects);
    }

    public NSMutableSet(NSArray<? extends E> objects) {
        super(objects);
    }

    public NSMutableSet(NSSet<? extends E> otherSet) {
        super(otherSet);
    }

    public NSMutableSet(Collection<? extends E> collection) {
        super(collection);
    }

    public NSMutableSet(Set<? extends E> set, boolean ignoreNull) {
        super(set, ignoreNull);
    }

    public void addObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        int capacity = this._capacity;
        int count = this._count;
        if (++count > capacity) {
            this._ensureCapacity(count);
        }
        if (_NSCollectionPrimitives.addValueToSet(object, this._objects, this._flags)) {
            this._count = count;
            this._objectsCache = null;
        }
    }

    public E removeObject(Object object) {
        Object result = null;
        if (object != null && this._count != 0 && (result = _NSCollectionPrimitives.removeValueInHashTable(object, this._objects, this._objects, this._flags)) != null) {
            --this._count;
            --this._deletionLimit;
            if (this._count == 0 || this._deletionLimit == 0) {
                this._clearDeletionsAndCollisions();
            }
            this._objectsCache = null;
        }
        return (E)result;
    }

    public void removeAllObjects() {
        if (this._count != 0) {
            this._objects = new Object[this._hashtableBuckets];
            this._flags = new short[this._hashtableBuckets];
            this._count = 0;
            this._objectsCache = null;
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
        }
    }

    public void setSet(NSSet<? extends E> otherSet) {
        if (otherSet != this) {
            this.removeAllObjects();
            if (otherSet != null) {
                Object[] objects = otherSet.objectsNoCopy();
                int i = 0;
                while (i < objects.length) {
                    this.addObject(objects[i]);
                    ++i;
                }
            }
        }
    }

    public void addObjectsFromArray(NSArray<? extends E> array) {
        if (array != null) {
            Object[] objects = array.objectsNoCopy();
            int i = 0;
            while (i < objects.length) {
                this.addObject(objects[i]);
                ++i;
            }
        }
    }

    public void intersectSet(NSSet<?> otherSet) {
        if (otherSet != this) {
            if (otherSet == null || otherSet.count() == 0) {
                this.removeAllObjects();
                return;
            }
            Object[] objects = this.objectsNoCopy();
            int i = 0;
            while (i < objects.length) {
                if (otherSet.member(objects[i]) == null) {
                    this.removeObject(objects[i]);
                }
                ++i;
            }
        }
    }

    public void subtractSet(NSSet<?> otherSet) {
        if (otherSet == null || otherSet.count() == 0) {
            return;
        }
        if (otherSet == this) {
            this.removeAllObjects();
            return;
        }
        Object[] objects = otherSet.objectsNoCopy();
        int i = 0;
        while (i < objects.length) {
            if (this.member(objects[i]) != null) {
                this.removeObject(objects[i]);
            }
            ++i;
        }
    }

    public void unionSet(NSSet<? extends E> otherSet) {
        if (otherSet == null || otherSet.count() == 0 || otherSet == this) {
            return;
        }
        Object[] objects = otherSet.objectsNoCopy();
        int i = 0;
        while (i < objects.length) {
            this.addObject(objects[i]);
            ++i;
        }
    }

    @Override
    public Object clone() {
        return new NSMutableSet<E>(this);
    }

    @Override
    public NSSet<E> immutableClone() {
        return new NSSet(this);
    }

    @Override
    public NSMutableSet<E> mutableClone() {
        return new NSMutableSet<E>(this);
    }

    @Override
    public boolean remove(Object element) {
        return this.removeObject(element) != null;
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        ArrayList toRemove = new ArrayList();
        Enumeration iter = this.objectEnumerator();
        while (iter.hasMoreElements()) {
            Object element = iter.nextElement();
            if (collection.contains(element)) continue;
            toRemove.add(element);
        }
        if (!toRemove.isEmpty()) {
            modified = true;
            for (Object element : toRemove) {
                this.removeObject(element);
            }
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (Object element : collection) {
            if (!this.contains(element)) continue;
            this.removeObject(element);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean add(E element) {
        boolean modified = false;
        if (!this.contains(element)) {
            this.addObject(element);
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean modified = false;
        for (E element : collection) {
            modified |= this.add(element);
        }
        return modified;
    }
}

