/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSUtilitiesExtra;

public class NSMutableRange
extends NSRange {
    public static final Class<NSMutableRange> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSMutableRange.class);
    static final long serialVersionUID = 5085989294260852272L;

    public NSMutableRange() {
    }

    public NSMutableRange(int location, int length) {
        super(location, length);
    }

    public NSMutableRange(NSRange range) {
        super(range);
    }

    public void setLocation(int location) {
        if (location < 0) {
            throw new IllegalArgumentException("Cannot set negative location (" + location + ")");
        }
        if (location - 1 > Integer.MAX_VALUE - this._length) {
            throw new IllegalArgumentException("Range endpoint greater than Integer.MAX_VALUE");
        }
        this._location = location;
    }

    public void setLength(int length) {
        if (length < 0) {
            throw new IllegalArgumentException("Cannot set negative length (" + length + ")");
        }
        if (this._location - 1 > Integer.MAX_VALUE - length) {
            throw new IllegalArgumentException("Range endpoint greater than Integer.MAX_VALUE");
        }
        this._length = length;
    }

    public void unionRange(NSRange otherRange) {
        if (otherRange != null) {
            int location = this.location();
            int maxRange = this.maxRange();
            int otherLocation = otherRange.location();
            int otherMaxRange = otherRange.maxRange();
            int newMaxRange = otherMaxRange < maxRange ? maxRange : otherMaxRange;
            int newLocation = location < otherLocation ? location : otherLocation;
            this.setLocation(newLocation);
            this.setLength(newMaxRange - newLocation);
        }
    }

    public void intersectRange(NSRange otherRange) {
        if (otherRange != null) {
            int minRange;
            int location = this.location();
            int maxRange = this.maxRange();
            int otherLocation = otherRange.location();
            int otherMaxRange = otherRange.maxRange();
            int n = minRange = maxRange < otherMaxRange ? maxRange : otherMaxRange;
            if (otherLocation <= location && location < otherMaxRange) {
                this.setLocation(location);
                this.setLength(minRange - location);
            } else if (location <= otherLocation && otherLocation < maxRange) {
                this.setLocation(otherLocation);
                this.setLength(minRange - otherLocation);
            } else {
                this.setLocation(0);
                this.setLength(0);
            }
        }
    }

    @Override
    public Object clone() {
        return new NSMutableRange(this);
    }
}

