/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSIndexSet;
import com.webobjects.foundation.NSRange;

public class NSMutableIndexSet
extends NSIndexSet {
    public NSMutableIndexSet() {
    }

    public NSMutableIndexSet(int value) {
        super(value);
    }

    public NSMutableIndexSet(NSRange range) {
        super(range);
    }

    public NSMutableIndexSet(NSIndexSet indexSet) {
        super(indexSet);
    }

    public NSMutableIndexSet(int[] indexes) {
        super(indexes);
    }

    @Override
    public Object clone() {
        return this.immutableClone();
    }

    @Override
    public NSIndexSet immutableClone() {
        return new NSIndexSet(this);
    }

    @Override
    public NSMutableIndexSet mutableClone() {
        return new NSMutableIndexSet(this);
    }

    protected void _ensureRangeCapacity(int capacity) {
        int currentCapacity = NSMutableIndexSet.GET_CAPACITY(this);
        if (capacity > currentCapacity) {
            if (capacity == 1) {
                this._hasSingleRange = true;
            } else {
                if (capacity < 4) {
                    capacity = 4;
                } else {
                    int testCapacity = 2 * currentCapacity;
                    if (testCapacity > capacity) {
                        capacity = testCapacity;
                    }
                }
                if (this._hasSingleRange) {
                    int rangeCount = NSMutableIndexSet.GET_RANGE_COUNT(this);
                    int integerCount = NSMutableIndexSet.GET_INTEGER_COUNT(this);
                    NSRange range = this._singleRange;
                    this._hasSingleRange = false;
                    this._ranges = new NSRange[capacity];
                    this._cacheOwner.set(null);
                    this._capacity = capacity;
                    this._rangeCount = rangeCount;
                    this._integerCount = integerCount;
                    this._ranges[0] = range;
                } else {
                    NSRange[] rangesBefore = this._ranges;
                    this._ranges = new NSRange[capacity];
                    this._capacity = capacity;
                    System.arraycopy(rangesBefore, 0, this._ranges, 0, rangesBefore.length);
                }
            }
        }
    }

    protected void _addRangeToArray(NSRange range) {
        this._ensureRangeCapacity(NSMutableIndexSet.GET_RANGE_COUNT(this) + 1);
        if (this._hasSingleRange) {
            this._singleRange = range;
        } else {
            this._cacheOwner.set(null);
            NSMutableIndexSet.RANGES((NSIndexSet)this)[this._rangeCount++] = range;
            this._integerCount += range.length();
        }
        this._isEmpty = false;
    }

    protected void _insertRangeInArrayAtIndex(NSRange range, int rangeIndex) {
        int count = NSMutableIndexSet.GET_RANGE_COUNT(this);
        if (rangeIndex <= count) {
            this._ensureRangeCapacity(count + 1);
            if (this._hasSingleRange) {
                this._singleRange = range;
            } else {
                NSRange[] ranges = NSMutableIndexSet.RANGES(this);
                int i = count;
                while (i > rangeIndex) {
                    ranges[i] = ranges[i - 1];
                    --i;
                }
                ranges[rangeIndex] = range;
                this._cacheOwner.set(null);
                ++this._rangeCount;
                this._integerCount += range.length();
            }
        } else {
            throw new IllegalArgumentException("Index " + rangeIndex + " out of range bounds [0..." + count + "]");
        }
        this._isEmpty = false;
    }

    protected void _removeRangeInArrayAtIndex(int rangeIndex) {
        int count = NSMutableIndexSet.GET_RANGE_COUNT(this);
        if (rangeIndex <= count) {
            NSRange[] ranges = NSMutableIndexSet.RANGES(this);
            NSRange removedRange = ranges[rangeIndex];
            int i = rangeIndex + 1;
            while (i < count) {
                ranges[i - 1] = ranges[i];
                ++i;
            }
            if (!this._hasSingleRange) {
                this._cacheOwner.set(null);
                --this._rangeCount;
                this._integerCount -= removedRange.length();
                this._isEmpty = this._rangeCount == 0;
            } else {
                this._isEmpty = true;
            }
        } else {
            throw new IllegalArgumentException("Index " + rangeIndex + " out of range bounds [0..." + count + "]");
        }
    }

    protected void _replaceRangeInArrayAtIndexWithRange(int rangeIndex, NSRange range) {
        int count = NSMutableIndexSet.GET_RANGE_COUNT(this);
        if (range.length() <= 0) {
            this._removeRangeInArrayAtIndex(rangeIndex);
        } else if (rangeIndex <= count) {
            if (this._hasSingleRange) {
                this._singleRange = range;
            } else {
                NSRange[] ranges = NSMutableIndexSet.RANGES(this);
                NSRange replacedRange = ranges[rangeIndex];
                ranges[rangeIndex] = range;
                this._cacheOwner.set(null);
                this._integerCount -= replacedRange.length();
                this._integerCount += range.length();
            }
        } else {
            throw new IllegalArgumentException("Index " + rangeIndex + " out of range bounds [0..." + count + "]");
        }
    }

    public void addIndexes(NSIndexSet indexSet) {
        block6: {
            if (indexSet == null || indexSet == this) break block6;
            if (NSMutableIndexSet.GET_RANGE_COUNT(this) == 0) {
                this.removeAllIndexes();
                this._setContentToContentFromIndexSet(indexSet);
            } else {
                Class<?> indexSetClass = indexSet.getClass();
                if (indexSetClass == NSIndexSet.class || indexSetClass == NSMutableIndexSet.class) {
                    int count = indexSet.rangeCount();
                    int i = 0;
                    while (i < count) {
                        this.addIndexesInRange(indexSet.rangeAtIndex(i));
                        ++i;
                    }
                } else {
                    int idx = indexSet.firstIndex();
                    while (idx != -1) {
                        this.addIndex(idx);
                        idx = indexSet.indexGreaterThanIndex(idx);
                    }
                }
            }
        }
    }

    protected void addIndexesFromIndexSet(NSIndexSet indexSet) {
        this.addIndexes(indexSet);
    }

    protected void addIndexes(int[] indexList) {
        NSArray<NSRange> ranges = NSMutableIndexSet._NSGroupIndexesIntoSimpleRanges(indexList);
        for (NSRange value : ranges) {
            this.addIndexesInRange(value);
        }
    }

    public void removeIndexes(NSIndexSet indexSet) {
        block6: {
            if (indexSet == null || NSMutableIndexSet.GET_RANGE_COUNT(this) <= 0) break block6;
            if (indexSet == this) {
                this.removeAllIndexes();
            } else {
                Class<?> indexSetClass = indexSet.getClass();
                if (indexSetClass == NSIndexSet.class || indexSetClass == NSMutableIndexSet.class) {
                    int count = indexSet.rangeCount();
                    int i = 0;
                    while (i < count) {
                        this.removeIndexesInRange(indexSet.rangeAtIndex(i));
                        ++i;
                    }
                } else {
                    int idx = indexSet.firstIndex();
                    while (idx != -1) {
                        this.removeIndex(idx);
                        idx = indexSet.indexGreaterThanIndex(idx);
                    }
                }
            }
        }
    }

    protected void removeIndexesFromIndexSet(NSIndexSet indexSet) {
        this.removeIndexes(indexSet);
    }

    protected void _mergeOverlappingRangesStartingAtIndex(int rangeIndex) {
        while (NSMutableIndexSet.GET_RANGE_COUNT(this) > 0 && rangeIndex < NSMutableIndexSet.GET_RANGE_COUNT(this) - 1) {
            NSRange currentRange = NSMutableIndexSet.RANGES(this)[rangeIndex];
            NSRange nextRange = NSMutableIndexSet.RANGES(this)[rangeIndex + 1];
            int currentEnd = currentRange.location() + currentRange.length();
            int nextEnd = nextRange.location() + nextRange.length();
            if (currentEnd < nextRange.location()) break;
            if (currentEnd >= nextEnd) {
                this._removeRangeInArrayAtIndex(rangeIndex + 1);
                continue;
            }
            currentRange = new NSRange(currentRange.location(), nextEnd - currentRange.location());
            this._replaceRangeInArrayAtIndexWithRange(rangeIndex, currentRange);
            this._removeRangeInArrayAtIndex(rangeIndex + 1);
            ++rangeIndex;
        }
    }

    public void addIndexesInRange(NSRange range) {
        if (range.length() != 0) {
            int addEnd = range.location() + range.length();
            int rangeIndex = this._indexOfRangeBeforeOrContainingIndex(range.location());
            if (rangeIndex == -1) {
                rangeIndex = 0;
            }
            while (rangeIndex < NSMutableIndexSet.GET_RANGE_COUNT(this)) {
                NSRange currentRange = NSMutableIndexSet.RANGES(this)[rangeIndex];
                int currentEnd = currentRange.location() + currentRange.length();
                if (addEnd < currentRange.location()) {
                    this._insertRangeInArrayAtIndex(range, rangeIndex);
                    return;
                }
                if (range.location() < currentRange.location() && addEnd >= currentRange.location()) {
                    if (addEnd > currentEnd) {
                        this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                        break;
                    }
                    range = new NSRange(range.location(), currentEnd - range.location());
                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                    break;
                }
                if (range.location() >= currentRange.location() && addEnd <= currentEnd) {
                    return;
                }
                if (range.location() >= currentRange.location() && range.location() <= currentEnd && addEnd > currentEnd) {
                    currentRange = new NSRange(currentRange.location(), addEnd - currentRange.location());
                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, currentRange);
                    break;
                }
                ++rangeIndex;
            }
            if (rangeIndex == NSMutableIndexSet.GET_RANGE_COUNT(this)) {
                this._addRangeToArray(range);
            }
            this._mergeOverlappingRangesStartingAtIndex(rangeIndex);
        }
    }

    public void addIndex(int value) {
        this.addIndexesInRange(new NSRange(value, 1));
    }

    public void removeIndexesInRange(NSRange range) {
        if (range.length() != 0) {
            int rangeIndex;
            int n = rangeIndex = range.location() > 0 ? this._indexOfRangeAfterOrContainingIndex(range.location()) : 0;
            if (rangeIndex == -1) {
                return;
            }
            int removeEnd = range.location() + range.length();
            while (rangeIndex < NSMutableIndexSet.GET_RANGE_COUNT(this)) {
                NSRange currentRange = NSMutableIndexSet.RANGES(this)[rangeIndex];
                int currentEnd = currentRange.location() + currentRange.length();
                if (removeEnd < currentRange.location()) {
                    return;
                }
                if (range.location() <= currentRange.location() && removeEnd >= currentRange.location()) {
                    if (removeEnd >= currentEnd) {
                        this._removeRangeInArrayAtIndex(rangeIndex);
                        continue;
                    }
                    currentRange = new NSRange(removeEnd, currentEnd - removeEnd);
                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, currentRange);
                    return;
                }
                if (range.location() > currentRange.location() && removeEnd < currentEnd) {
                    NSRange firstPiece = new NSRange(currentRange.location(), range.location() - currentRange.location());
                    NSRange secondPiece = new NSRange(removeEnd, currentEnd - removeEnd);
                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, secondPiece);
                    this._insertRangeInArrayAtIndex(firstPiece, rangeIndex);
                    return;
                }
                if (range.location() > currentRange.location() && range.location() < currentEnd && removeEnd >= currentEnd) {
                    currentRange = new NSRange(currentRange.location(), range.location() - currentRange.location());
                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, currentRange);
                }
                ++rangeIndex;
            }
        }
    }

    public void removeIndex(int value) {
        this.removeIndexesInRange(new NSRange(value, 1));
    }

    public void removeAllIndexes() {
        if (!this._hasSingleRange) {
            this._ranges = null;
        }
        this._isEmpty = true;
        this._hasSingleRange = true;
    }

    protected void _incrementByStartingAtIndex(int amount, int value) {
        NSRange newRange = null;
        if (amount > 0) {
            int rangeIndex;
            int count = NSMutableIndexSet.GET_RANGE_COUNT(this);
            if (value < -1 && count != 0) {
                NSRange nSRange = NSMutableIndexSet.RANGES(this)[count - 1];
            }
            if ((rangeIndex = this._indexOfRangeAfterOrContainingIndex(value)) != -1) {
                boolean rangeNeedsSplitup = false;
                NSRange range = NSMutableIndexSet.RANGES(this)[rangeIndex];
                if (value > range.location()) {
                    rangeNeedsSplitup = true;
                    int newLength = range.location() + range.length() - value;
                    int newLocation = value + amount;
                    newRange = new NSRange(newLocation, newLength);
                    range = new NSRange(range.location(), value - range.location());
                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                    ++rangeIndex;
                }
                while (rangeIndex < NSMutableIndexSet.GET_RANGE_COUNT(this)) {
                    range = NSMutableIndexSet.RANGES(this)[rangeIndex];
                    range = new NSRange(range.location() + amount, range.length());
                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                    ++rangeIndex;
                }
                if (rangeNeedsSplitup) {
                    this.addIndexesInRange(newRange);
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    protected void _removeAndDecrementByStartingAtIndex(int amount, int value) {
        int rangeIndex;
        if (amount > 0 && (rangeIndex = this._indexOfRangeAfterOrContainingIndex(value)) != -1) {
            int firstRangeToMerge = rangeIndex > 0 ? rangeIndex - 1 : rangeIndex;
            int removeEnd = value + amount - 1;
            while (rangeIndex < NSMutableIndexSet.GET_RANGE_COUNT(this)) {
                block11: {
                    NSRange range = NSMutableIndexSet.RANGES(this)[rangeIndex];
                    int rangeEnd = range.location() + range.length() - 1;
                    if (removeEnd < range.location()) {
                        range = new NSRange(range.location() - amount, range.length());
                        this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                    } else {
                        if (range.location() >= value && rangeEnd <= removeEnd) {
                            this._removeRangeInArrayAtIndex(rangeIndex);
                            continue;
                        }
                        if (value >= range.location() && removeEnd <= rangeEnd) {
                            range = new NSRange(range.location(), range.length() - amount);
                            this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                        } else {
                            int reduction;
                            if (removeEnd >= range.location() && removeEnd <= rangeEnd) {
                                reduction = removeEnd - range.location() + 1;
                                if ((range = new NSRange(range.location(), range.length() - reduction)).length() > 0) {
                                    range = new NSRange(range.location() - (amount - reduction), range.length());
                                    this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                                    break block11;
                                } else {
                                    this._removeRangeInArrayAtIndex(rangeIndex);
                                    continue;
                                }
                            }
                            if (value >= range.location() && value <= rangeEnd && (reduction = rangeEnd - value + 1) > 0) {
                                range = new NSRange(range.location(), range.length() - reduction);
                                this._replaceRangeInArrayAtIndexWithRange(rangeIndex, range);
                            }
                        }
                    }
                }
                ++rangeIndex;
            }
            this._mergeOverlappingRangesStartingAtIndex(firstRangeToMerge);
        }
    }

    public void shiftIndexesStartingAtIndexBy(int startIndex, int delta) {
        if (delta > 0) {
            this._incrementByStartingAtIndex(delta, startIndex);
        } else if (delta < 0) {
            int positiveDelta = -delta;
            if (positiveDelta > startIndex) {
                startIndex = positiveDelta;
            }
            this._removeAndDecrementByStartingAtIndex(positiveDelta, startIndex - positiveDelta);
        }
    }
}

