/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSDictionary;
import com.webobjects.foundation.NSSet;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.util.Dictionary;
import java.util.Map;
import java.util.Set;

public class NSMutableDictionary<K, V>
extends NSDictionary<K, V> {
    public static final Class<NSMutableDictionary> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSMutableDictionary.class);
    static final long serialVersionUID = 6690723083816355576L;

    public static <K, V> NSMutableDictionary<K, V> dictionary() {
        return new NSMutableDictionary<K, V>();
    }

    public static <K, V> NSMutableDictionary<K, V> dictionaryWithCapacity(int capacity) {
        return new NSMutableDictionary<K, V>(capacity);
    }

    public static <K, V> NSMutableDictionary<K, V> dictionaryWithDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        return new NSMutableDictionary<K, V>(otherDictionary);
    }

    public static <K, V> NSMutableDictionary<K, V> dictionaryWithMap(Map<? extends K, ? extends V> map) {
        return new NSMutableDictionary<K, V>(map);
    }

    public static <K, V> NSMutableDictionary<K, V> dictionaryWithObjectForKey(V object, K key) {
        return new NSMutableDictionary<K, V>(object, key);
    }

    public static <K, V> NSMutableDictionary<K, V> dictionaryWithObjectsForKeys(V[] objects, K[] keys) {
        return new NSMutableDictionary<K, V>(objects, keys);
    }

    public static <K, V> NSMutableDictionary<K, V> dictionaryWithObjectsForKeys(NSArray<? extends V> objects, NSArray<? extends K> keys) {
        return new NSMutableDictionary<K, V>(objects, keys);
    }

    public NSMutableDictionary() {
    }

    public NSMutableDictionary(int capacity) {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException(String.valueOf(this.getClass().getName()) + ": Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableDictionary(V object, K key) {
        super(object, key);
    }

    public NSMutableDictionary(V[] objects, K[] keys) {
        super(objects, keys);
    }

    public NSMutableDictionary(NSArray<? extends V> objects, NSArray<? extends K> keys) {
        super(objects, keys);
    }

    public NSMutableDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        this._copyMutableDictionary(otherDictionary);
    }

    @Deprecated
    public NSMutableDictionary(Dictionary<? extends K, ? extends V> dictionary, boolean ignoreNull) {
        super(dictionary, ignoreNull);
    }

    public NSMutableDictionary(Map<? extends K, ? extends V> map) {
        super(map);
    }

    public NSMutableDictionary(Map<? extends K, ? extends V> map, boolean ignoreNull) {
        super(map, ignoreNull);
    }

    public void setObjectForKey(V object, K key) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null object into an " + this.getClass().getName() + ".");
        }
        if (key == null) {
            throw new IllegalArgumentException("Attempt to insert null key into an " + this.getClass().getName() + ".");
        }
        int capacity = this._capacity;
        int count = this._count;
        if (++count > capacity) {
            this._ensureCapacity(count);
        }
        if (_NSCollectionPrimitives.addValueInHashTable(key, object, this._keys, this._objects, this._flags)) {
            this._count = count;
            this._keysCache = null;
        }
        this._objectsCache = null;
    }

    public V removeObjectForKey(Object key) {
        Object result = null;
        if (key == null) {
            throw new IllegalArgumentException("Attempt to remove null key from an " + this.getClass().getName() + ".");
        }
        if (this._count != 0 && (result = _NSCollectionPrimitives.removeValueInHashTable(key, this._keys, this._objects, this._flags)) != null) {
            --this._count;
            --this._deletionLimit;
            if (this._count == 0 || this._deletionLimit == 0) {
                this._clearDeletionsAndCollisions();
            }
            this._objectsCache = null;
            this._keysCache = null;
        }
        return (V)result;
    }

    public void removeAllObjects() {
        if (this._count != 0) {
            this._objects = new Object[this._hashtableBuckets];
            this._keys = new Object[this._hashtableBuckets];
            this._flags = new short[this._hashtableBuckets];
            this._count = 0;
            this._objectsCache = null;
            this._keysCache = null;
            this._deletionLimit = _NSCollectionPrimitives.deletionLimitForTableBuckets(this._hashtableBuckets);
        }
    }

    public void setDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary != this) {
            this.removeAllObjects();
            if (otherDictionary != null) {
                this.addEntriesFromDictionary(otherDictionary);
            }
        }
    }

    public void addEntriesFromDictionary(NSDictionary<? extends K, ? extends V> otherDictionary) {
        if (otherDictionary != null) {
            this.putAll(otherDictionary);
        }
    }

    public void removeObjectsForKeys(NSArray<? extends K> keys) {
        if (keys != null) {
            Object[] keysArray = keys.objectsNoCopy();
            int i = 0;
            while (i < keysArray.length) {
                this.removeObjectForKey(keysArray[i]);
                ++i;
            }
        }
    }

    @Override
    public void takeValueForKey(Object value, String key) {
        if (value != null) {
            this.setObjectForKey(value, key);
        } else {
            this.removeObjectForKey(key);
        }
    }

    @Override
    public Object clone() {
        return new NSMutableDictionary<K, V>(this);
    }

    @Override
    public NSDictionary<K, V> immutableClone() {
        return new NSDictionary(this);
    }

    @Override
    public NSMutableDictionary<K, V> mutableClone() {
        return new NSMutableDictionary<K, V>(this);
    }

    @Override
    public V put(K key, V value) {
        Object old = this.objectForKey(key);
        this.setObjectForKey(value, key);
        return old;
    }

    @Override
    public V remove(Object key) {
        return this.removeObjectForKey(key);
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> t) {
        for (Map.Entry<K, V> entry : t.entrySet()) {
            this.setObjectForKey(entry.getValue(), entry.getKey());
        }
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }

    @Override
    protected Set<Map.Entry<K, V>> _initMapEntrySet() {
        Object[] keys = this.keysNoCopy();
        return new NSDictionary._NSJavaMapEntrySet(keys, true);
    }

    @Override
    public Set<K> keySet() {
        Object[] currKeys = this.keysNoCopy();
        if (currKeys != null && currKeys.length > 0) {
            return new NSDictionary._NSJavaSet(currKeys, true);
        }
        return NSSet.emptySet();
    }
}

