/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSData;
import com.webobjects.foundation.NSMutableRange;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSStringUtilities;
import com.webobjects.foundation._NSUtilities;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.nio.ByteBuffer;

public class NSMutableData
extends NSData {
    public static final Class<NSMutableData> _CLASS = _NSUtilities._classWithClassLiteral(NSMutableData.class);
    static final long serialVersionUID = -1574835879605576157L;
    private static final int _DefaultInitialCapacity = 128;
    protected transient byte[] _immutableCopy;
    protected transient NSRange _range;

    public NSMutableData() {
        this(128);
    }

    public NSMutableData(int capacity) {
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._bytes = new byte[capacity];
        this._range = new NSMutableRange(0, 0);
    }

    public NSMutableData(byte[] bytes) {
        super(bytes);
        this._range = new NSMutableRange(0, super.length());
    }

    public NSMutableData(byte[] bytes, NSRange range) {
        super(bytes, range);
        this._range = new NSMutableRange(0, super.length());
    }

    public NSMutableData(byte[] bytes, NSRange range, boolean noCopy) {
        super(bytes, range, noCopy);
        this._range = new NSMutableRange(0, super.length());
    }

    public NSMutableData(NSData otherData) {
        super(otherData.immutableBytes(), otherData.immutableRange(), false);
        this._range = new NSMutableRange(0, super.length());
    }

    public NSMutableData(InputStream inputStream, int chunkSize) throws IOException {
        super(inputStream, chunkSize);
        this._range = new NSMutableRange(0, super.length());
    }

    public NSMutableData(ByteBuffer bytebuffer) {
        super(bytebuffer);
        this._range = new NSMutableRange(0, super.length());
    }

    public NSMutableData(File file) throws IOException {
        if (!file.exists()) {
            throw new IllegalArgumentException("file '" + file.getName() + "' does not exist");
        }
        this._createBytesFromInputStream(new FileInputStream(file), (int)file.length(), true);
    }

    @Deprecated
    public NSMutableData(URL url) throws IOException {
        URLConnection connection = url.openConnection();
        connection.connect();
        this._createBytesFromInputStream(connection.getInputStream(), connection.getContentLength(), true);
    }

    @Deprecated
    public NSMutableData(String value) {
        this(value, null);
    }

    public NSMutableData(String value, String encoding) {
        this(_NSStringUtilities.bytesForString(value, encoding));
    }

    @Override
    protected void _createBytesFromInputStream(InputStream inputStream, int length, boolean closeInputStream) throws IOException {
        this._range = new NSMutableRange(0, length);
        super._createBytesFromInputStream(inputStream, length, closeInputStream);
    }

    @Override
    protected byte[] bytesNoCopy() {
        return this._bytes != null ? this._bytes : _NSCollectionPrimitives.EmptyByteArray;
    }

    @Override
    protected NSRange rangeNoCopy() {
        return this._range;
    }

    @Override
    public int length() {
        return this.rangeNoCopy().length();
    }

    @Override
    public int _offset() {
        return this.rangeNoCopy().location();
    }

    @Override
    protected byte[] immutableBytes() {
        if (this._immutableCopy == null) {
            int length = this.length();
            this._immutableCopy = new byte[length];
            System.arraycopy(this.bytesNoCopy(), this._offset(), this._immutableCopy, 0, length);
        }
        return this._immutableCopy;
    }

    @Override
    protected NSRange immutableRange() {
        return new NSRange(0, this._range._length);
    }

    @Override
    public byte[] bytesNoCopy(NSMutableRange range) {
        byte[] returnValue = this.bytesNoCopy();
        if (range == null) {
            throw new IllegalArgumentException("must pass NSMutableRange to bytesNoCopy");
        }
        range.setLocation(this._range.location());
        range.setLength(this._range.length());
        return returnValue;
    }

    public void setLength(int length) {
        int capacity = (this._bytes != null ? this._bytes.length : 0) - this._range._location;
        if (this._bytes == null || length > capacity) {
            if (length > (capacity *= 2)) {
                capacity = length;
            }
            byte[] bytes = new byte[capacity];
            if (this._bytes != null) {
                System.arraycopy(this._bytes, this._range._location, bytes, 0, this._range._length);
            }
            this._bytes = bytes;
            this._range._location = 0;
        } else {
            int i = this._range._length;
            while (i < length) {
                this._bytes[this._range._location + i] = 0;
                ++i;
            }
        }
        this._range._length = length;
        this._immutableCopy = null;
        this._setMustRecomputeHash(true);
    }

    public void setData(NSData otherData) {
        int length = otherData.length();
        this.setLength(length);
        if (length > 0) {
            System.arraycopy(otherData.bytesNoCopy(), otherData._offset(), this._bytes, this._range._location, length);
        }
        this._setMustRecomputeHash(true);
    }

    public void resetBytesInRange(NSRange range) {
        int rangeLength;
        int rangeLocation = range.location();
        if (rangeLocation + (rangeLength = range.length()) > this._range._length) {
            throw new IllegalArgumentException("range out of bounds");
        }
        int i = 0;
        while (i < rangeLength) {
            this._bytes[i + this._range._location + rangeLocation] = 0;
            ++i;
        }
        this._immutableCopy = null;
        this._setMustRecomputeHash(true);
    }

    public void appendBytes(ByteBuffer byteBuffer) {
        if (byteBuffer == null) {
            return;
        }
        if (byteBuffer.hasArray()) {
            byte[] theBytes = byteBuffer.array();
            this.appendBytes(theBytes, new NSRange(0, theBytes.length));
            return;
        }
        byte[] buffer = new byte[byteBuffer.remaining()];
        byteBuffer.get(buffer);
        this.appendBytes(buffer, new NSRange(0, buffer.length));
    }

    public void appendByte(byte singleByte) {
        this.increaseLengthBy(1);
        this._bytes[this._range._location + this._range._length - 1] = singleByte;
        this._immutableCopy = null;
        this._setMustRecomputeHash(true);
    }

    public void appendBytes(byte[] bytes, NSRange range) {
        int length = range.length();
        int location = range.location();
        if (length > 0) {
            if (location + length > bytes.length) {
                throw new IllegalArgumentException("range out of bounds for bytes");
            }
            int oldLength = this._range._length;
            this.increaseLengthBy(length);
            System.arraycopy(bytes, location, this._bytes, this._range._location + oldLength, length);
            this._immutableCopy = null;
            this._setMustRecomputeHash(true);
        }
    }

    public void appendBytes(byte[] bytes) {
        this.appendBytes(bytes, new NSRange(0, bytes.length));
    }

    public void appendData(NSData otherData) {
        this.appendBytes(otherData.bytesNoCopy(), otherData.rangeNoCopy());
    }

    public void increaseLengthBy(int additionalLength) {
        this.setLength(this.length() + additionalLength);
    }

    @Override
    public Object clone() {
        return new NSMutableData(this);
    }
}

