/*
 * Decompiled with CFR 0.152.
 */
package com.webobjects.foundation;

import com.webobjects.foundation.NSArray;
import com.webobjects.foundation.NSComparator;
import com.webobjects.foundation.NSIndexSet;
import com.webobjects.foundation.NSMutableSet;
import com.webobjects.foundation.NSRange;
import com.webobjects.foundation.SubList;
import com.webobjects.foundation._NSCollectionPrimitives;
import com.webobjects.foundation._NSUtilitiesExtra;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class NSMutableArray<E>
extends NSArray<E> {
    public static final Class<NSMutableArray> _CLASS = _NSUtilitiesExtra._classWithClassLiteralPrime(NSMutableArray.class);
    static final long serialVersionUID = -3909373569895711876L;
    protected transient int _count;
    protected transient int _capacity;
    protected transient Object[] _objectsCache;

    public static <E> NSMutableArray<E> array() {
        return new NSMutableArray<E>();
    }

    public static <E> NSMutableArray<E> arrayWithObject(E object) {
        return new NSMutableArray<E>(object);
    }

    public static <E> NSMutableArray<E> arrayWithObjects(E ... objects) {
        return new NSMutableArray<E>(objects, 0, objects != null ? objects.length : 0, true, false);
    }

    public static <E> NSMutableArray<E> arrayWithObjectsIgnoringNulls(E ... objects) {
        return new NSMutableArray<E>(objects, 0, objects != null ? objects.length : 0, true, true);
    }

    public static <E> NSMutableArray<E> arrayWithArray(NSArray<? extends E> otherArray) {
        return new NSMutableArray<E>(otherArray);
    }

    public static <E> NSMutableArray<E> arrayWithCollection(Collection<? extends E> collection) {
        return new NSMutableArray<E>(collection);
    }

    public static <E> NSMutableArray<E> arrayWithCapacity(int capacity) {
        return new NSMutableArray<int>(capacity);
    }

    public NSMutableArray() {
    }

    public NSMutableArray(int capacity) {
        this();
        if (capacity < 0) {
            throw new IllegalArgumentException("Capacity cannot be less than 0");
        }
        this._ensureCapacity(capacity);
    }

    public NSMutableArray(E object) {
        super(object);
    }

    public NSMutableArray(E[] objects) {
        super(objects);
    }

    public NSMutableArray(E object, E ... objects) {
        super(object, objects);
    }

    public NSMutableArray(E[] objects, NSRange range) {
        super(objects, range);
    }

    public NSMutableArray(NSArray<? extends E> otherArray) {
        super(otherArray);
    }

    public NSMutableArray(List<? extends E> list, NSRange range, boolean ignoreNull) {
        super(list, range, ignoreNull);
    }

    public NSMutableArray(Collection<? extends E> collection) {
        super(collection);
    }

    protected NSMutableArray(Object[] objects, int rangeLocation, int rangeLength, boolean checkForNull, boolean ignoreNull) {
        super(objects, rangeLocation, rangeLength, checkForNull, ignoreNull);
    }

    @Override
    protected void _initializeWithCapacity(int capacity) {
        this._capacity = capacity;
        this._objectsCache = null;
        super._initializeWithCapacity(capacity);
    }

    protected void _ensureCapacity(int capacity) {
        int newCapactity = capacity;
        if (newCapactity > this._capacity) {
            if (newCapactity == 0) {
                this._setObjects(null);
            } else {
                if (newCapactity < 4) {
                    newCapactity = 4;
                } else {
                    int testCapacity = 2 * this._capacity;
                    if (testCapacity > newCapactity) {
                        newCapactity = testCapacity;
                    }
                }
                Object[] objects = this._objects();
                this._setObjects(objects == null ? new Object[newCapactity] : _NSCollectionPrimitives.copyArray(objects, newCapactity));
            }
            this._capacity = newCapactity;
        }
    }

    @Override
    protected Object[] objectsNoCopy() {
        if (this._objectsCache == null) {
            Object[] objects = this._objects();
            this._objectsCache = this._count() == 0 ? new Object[0] : (this._count() == this._capacity ? objects : _NSCollectionPrimitives.copyArray(objects, this._count()));
        }
        return this._objectsCache;
    }

    @Override
    protected int _count() {
        return this._count;
    }

    @Override
    protected void _setCount(int count) {
        this._count = count;
    }

    public void setArray(NSArray<? extends E> otherArray) {
        if (otherArray != this) {
            if (otherArray == null) {
                this._count = 0;
            } else {
                Object[] objects = otherArray.objectsNoCopy();
                this._ensureCapacity(objects.length);
                if (objects.length > 0) {
                    System.arraycopy(objects, 0, this._objects, 0, objects.length);
                }
                int i = objects.length;
                while (i < this._count) {
                    this._objects[i] = null;
                    ++i;
                }
                this._count = objects.length;
            }
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
        }
    }

    public void addObject(E object) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an " + this.getClass().getName() + ".");
        }
        this._ensureCapacity(this._count + 1);
        this._objects[this._count++] = object;
        this._objectsCache = null;
        this._setMustRecomputeHash(true);
    }

    public void addObjects(E ... objects) {
        if (objects != null && objects.length > 0) {
            int i = 0;
            while (i < objects.length) {
                if (objects[i] == null) {
                    throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
                }
                ++i;
            }
            this._ensureCapacity(this._count + objects.length);
            System.arraycopy(objects, 0, this._objects, this._count, objects.length);
            this._count += objects.length;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
        }
    }

    public Object replaceObjectAtIndex(E object, int index) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        if (index >= 0 && index < this._count) {
            Object result = this._objects[index];
            this._objects[index] = object;
            this._setMustRecomputeHash(true);
            if (this._objectsCache != null) {
                this._objectsCache[index] = object;
            }
            return result;
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count - 1) + "]");
    }

    @Deprecated
    public void replaceObjectAtIndex(int index, E object) {
        this.replaceObjectAtIndex(object, index);
    }

    public void insertObjectAtIndex(E object, int index) {
        if (object == null) {
            throw new IllegalArgumentException("Attempt to insert null into an  " + this.getClass().getName() + ".");
        }
        if (index >= 0 && index <= this._count) {
            this._ensureCapacity(this._count + 1);
            if (index < this._count) {
                System.arraycopy(this._objects, index, this._objects, index + 1, this._count - index);
            }
            this._objects[index] = object;
            ++this._count;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
            return;
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count - 1) + "]");
    }

    public E removeObjectAtIndex(int index) {
        if (index >= 0 && index < this._count) {
            --this._count;
            Object result = this._objects[index];
            if (index < this._count) {
                System.arraycopy(this._objects, index + 1, this._objects, index, this._count - index);
            }
            this._objects[this._count] = null;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
            return (E)result;
        }
        if (this._count == 0) {
            throw new IllegalArgumentException("Array is empty");
        }
        throw new IllegalArgumentException("Index (" + index + ") out of bounds [0, " + (this._count - 1) + "]");
    }

    public void removeObjectsAtIndexes(NSIndexSet iset) {
        if (iset == null) {
            throw new IllegalArgumentException("Index set is null");
        }
        int lastIndex = iset.lastIndex();
        int count = this.count();
        if (lastIndex != -1 && count <= lastIndex) {
            throw new IllegalArgumentException("Last index (" + lastIndex + ") of index set is out of bounds [0, " + (count - 1) + "]");
        }
        int rangeIdx = iset.rangeCount();
        while (rangeIdx-- != 0) {
            NSRange range = iset.rangeAtIndex(rangeIdx);
            this.removeObjectsInRange(range);
        }
    }

    public void removeAllObjects() {
        if (this._count > 0) {
            this._objects = new Object[this._capacity];
            this._count = 0;
            this._objectsCache = null;
            this._setMustRecomputeHash(true);
        }
    }

    public void sortUsingComparator(NSComparator comparator) throws NSComparator.ComparisonException {
        if (comparator == null) {
            throw new IllegalArgumentException("Comparator not specified");
        }
        if (this._count < 2) {
            return;
        }
        _NSCollectionPrimitives.K2SortArray(this._objects, this._count, comparator);
        this._objectsCache = null;
        this._setMustRecomputeHash(true);
    }

    public void addObjectsFromArray(NSArray<? extends E> otherArray) {
        if (otherArray != null) {
            this.addObjects(otherArray.objectsNoCopy());
        }
    }

    public void replaceObjectsInRange(NSRange range, NSArray<E> otherArray, NSRange otherRange) {
        if (range == null || otherRange == null) {
            throw new IllegalArgumentException("Both ranges cannot be null");
        }
        if (otherArray == null) {
            throw new IllegalArgumentException("Other array cannot be null");
        }
        int rangeLength = range.length();
        int rangeLocation = range.location();
        int otherRangeLength = otherRange.length();
        int otherRangeLocation = otherRange.location();
        while (rangeLength > 0 && otherRangeLength > 0) {
            this.replaceObjectAtIndex(otherArray.objectAtIndex(otherRangeLocation), rangeLocation);
            ++rangeLocation;
            --rangeLength;
            ++otherRangeLocation;
            --otherRangeLength;
        }
        while (otherRangeLength > 0) {
            this.insertObjectAtIndex(otherArray.objectAtIndex(otherRangeLocation), rangeLocation);
            ++rangeLocation;
            ++otherRangeLocation;
            --otherRangeLength;
        }
        while (rangeLength > 0) {
            this.removeObjectAtIndex(rangeLocation);
            --rangeLength;
        }
    }

    public E removeLastObject() {
        if (this.count() == 0) {
            return null;
        }
        return this.removeObjectAtIndex(this.count() - 1);
    }

    private boolean _removeObject(Object object, int index, int length, boolean identical) {
        boolean wasRemoved;
        block5: {
            int maxIndex;
            Object[] objects;
            block6: {
                wasRemoved = false;
                if (object == null) {
                    throw new IllegalArgumentException("Attempt to remove null from an  " + this.getClass().getName() + ".");
                }
                if (this.count() <= 0) break block5;
                objects = this.objectsNoCopy();
                maxIndex = index + length - 1;
                if (!identical) break block6;
                int i = maxIndex;
                while (i >= index) {
                    if (objects[i] == object) {
                        this.removeObjectAtIndex(i);
                        wasRemoved = true;
                    }
                    --i;
                }
                break block5;
            }
            if (identical) break block5;
            int i = maxIndex;
            while (i >= index) {
                if (objects[i] == object || object.equals(objects[i])) {
                    this.removeObjectAtIndex(i);
                    wasRemoved = true;
                }
                --i;
            }
        }
        return wasRemoved;
    }

    public boolean removeObject(Object object) {
        return this._removeObject(object, 0, this.count(), false);
    }

    public boolean removeObject(Object object, NSRange range) {
        boolean wasRemoved = false;
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
            }
            wasRemoved = this._removeObject(object, rangeLocation, rangeLength, false);
        }
        return wasRemoved;
    }

    public boolean removeIdenticalObject(Object object) {
        return this._removeObject(object, 0, this.count(), true);
    }

    public boolean removeIdenticalObject(Object object, NSRange range) {
        if (range != null) {
            int rangeLength;
            int count = this.count();
            int rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) > count || rangeLocation >= count) {
                throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
            }
            return this._removeObject(object, rangeLocation, rangeLength, true);
        }
        return false;
    }

    public void removeObjects(Object[] objects) {
        int count;
        if (objects != null && (count = this.count()) > 0) {
            int objectToRemoveCount = objects.length;
            if (count * objectToRemoveCount > 100) {
                if (objectToRemoveCount > 0) {
                    NSMutableSet<int> table = new NSMutableSet<int>(objectToRemoveCount);
                    int i = 0;
                    while (i < objectToRemoveCount) {
                        Object o = objects[i];
                        if (o != null) {
                            table.addObject((int)o);
                        }
                        ++i;
                    }
                    int offset = 0;
                    int i2 = 0;
                    while (i2 < count) {
                        Object o = this._objects[i2];
                        this._objects[i2] = null;
                        if (!table.containsObject(o)) {
                            this._objects[offset] = o;
                            ++offset;
                        }
                        ++i2;
                    }
                    this._count = offset;
                    this._objectsCache = null;
                    this._setMustRecomputeHash(true);
                }
            } else {
                int i = 0;
                while (i < objects.length) {
                    this.removeObject(objects[i]);
                    ++i;
                }
            }
        }
    }

    public void removeObjectsInArray(NSArray<?> otherArray) {
        if (otherArray != null) {
            this.removeObjects(otherArray.objectsNoCopy());
        }
    }

    /*
     * Unable to fully structure code
     */
    public void removeObjectsInRange(NSRange range) {
        block1: {
            if (range == null) break block1;
            count = this.count();
            rangeLocation = range.location();
            if (rangeLocation + (rangeLength = range.length()) <= count && rangeLocation < count) ** GOTO lbl8
            throw new IllegalArgumentException("Range [" + rangeLocation + "; " + rangeLength + "] out of bounds [0, " + (this._count - 1) + "]");
lbl-1000:
            // 1 sources

            {
                this.removeObjectAtIndex(rangeLocation);
lbl8:
                // 2 sources

                ** while (rangeLength-- > 0)
            }
        }
    }

    protected void removeRange(int fromIndex, int toIndex) {
        ListIterator<E> it = this.listIterator(fromIndex);
        int i = 0;
        int n = toIndex - fromIndex;
        while (i < n) {
            it.next();
            it.remove();
            ++i;
        }
    }

    @Override
    public Object clone() {
        return new NSMutableArray<E>(this);
    }

    @Override
    public NSArray<E> immutableClone() {
        return new NSArray(this);
    }

    @Override
    public NSMutableArray<E> mutableClone() {
        return new NSMutableArray<E>(this);
    }

    public void _moveObjectAtIndexToIndex(int sourceIndex, int destIndex) {
        if (sourceIndex == destIndex) {
            return;
        }
        if (sourceIndex < 0 || sourceIndex >= this._count || destIndex < 0 || destIndex >= this._count) {
            throw new IllegalArgumentException("Either source(" + sourceIndex + ") or destination(" + destIndex + ") is illegal.");
        }
        if (destIndex < sourceIndex) {
            Object sourceObj = this.objectAtIndex(sourceIndex);
            int i = sourceIndex - 1;
            while (i >= destIndex) {
                this.replaceObjectAtIndex(this.objectAtIndex(i), i + 1);
                --i;
            }
            this.replaceObjectAtIndex(sourceObj, destIndex);
        } else {
            Object sourceObj = this.objectAtIndex(sourceIndex);
            int i = sourceIndex;
            while (i < destIndex) {
                this.replaceObjectAtIndex(this.objectAtIndex(i + 1), i);
                ++i;
            }
            this.replaceObjectAtIndex(sourceObj, destIndex);
        }
    }

    @Override
    public E remove(int index) {
        return this.removeObjectAtIndex(index);
    }

    @Override
    public boolean remove(Object object) {
        boolean modified = false;
        int index = this.indexOf(object);
        if (-1 != index) {
            this.removeObjectAtIndex(index);
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.removeAllObjects();
    }

    @Override
    public boolean retainAll(Collection<?> collection) {
        boolean modified = false;
        ArrayList<E> toRemove = new ArrayList<E>();
        for (E element : this) {
            if (collection.contains(element)) continue;
            toRemove.add(element);
        }
        if (!toRemove.isEmpty()) {
            modified = true;
            for (E element : toRemove) {
                this.removeObject(element);
            }
        }
        return modified;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        boolean modified = false;
        for (Object element : collection) {
            modified |= this.remove(element);
        }
        return modified;
    }

    @Override
    public void add(int index, E element) {
        this.insertObjectAtIndex(element, index);
    }

    @Override
    public boolean add(E element) {
        this.addObject(element);
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> collection) {
        boolean modified = false;
        for (E element : collection) {
            modified |= this.add(element);
        }
        return modified;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> collection) {
        boolean modified = false;
        int localIndex = index;
        for (E element : collection) {
            this.insertObjectAtIndex(element, localIndex++);
            modified = true;
        }
        return modified;
    }

    @Override
    public E set(int index, E element) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Index " + index + " is out of bounds");
        }
        Object oldElement = this.objectAtIndex(index);
        this.replaceObjectAtIndex(element, index);
        return oldElement;
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        return new SubList(this, fromIndex, toIndex);
    }

    @Override
    public Iterator<E> iterator() {
        return new MutableArrayListIterator(this._objects, this._count);
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        return new MutableArrayListIterator(this._objects, this._count, index);
    }

    @Override
    public ListIterator<E> listIterator() {
        return new MutableArrayListIterator(this._objects, this._count);
    }

    public class MutableArrayListIterator
    implements ListIterator<E> {
        private int _nextIndex;
        private int _lastRet = -1;
        private boolean wasAddCalled = false;
        private boolean wasRemoveCalled = false;
        private boolean calledOnce = false;

        public MutableArrayListIterator(Object[] array, int count) {
            this(array, count, 0);
        }

        public MutableArrayListIterator(Object[] array, int count, int index) {
            this._nextIndex = index;
        }

        @Override
        public void add(E element) {
            if (!this.hasPrevious()) {
                NSMutableArray.this.addObject(element);
            } else {
                NSMutableArray.this.insertObjectAtIndex(element, this.previousIndex());
            }
            ++this._nextIndex;
            this.wasAddCalled = true;
            this._lastRet = -1;
        }

        @Override
        public void set(E element) {
            if (this._lastRet == -1) {
                throw new IllegalStateException();
            }
            if (this.wasAddCalled || this.wasRemoveCalled || !this.calledOnce) {
                throw new IllegalStateException("ListIterator set() failed.  Either next() nor previous() have been called, or remove() or add() have been called after the last call to next() or previous().");
            }
            try {
                NSMutableArray.this.replaceObjectAtIndex(element, this._lastRet);
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public void remove() {
            if (this._lastRet == -1) {
                throw new IllegalStateException();
            }
            if (!this.calledOnce) {
                throw new IllegalStateException("Neither next() nor previous() have been called before calling remove().");
            }
            if (this.wasAddCalled) {
                throw new IllegalStateException("Neither next() nor previous() after the last call to add().");
            }
            if (this.wasRemoveCalled) {
                throw new IllegalStateException("Neither next() nor previous() after the last call to remove().");
            }
            try {
                NSMutableArray.this.removeObjectAtIndex(this._lastRet);
                if (this._lastRet < this._nextIndex) {
                    --this._nextIndex;
                }
                this.wasRemoveCalled = true;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new ConcurrentModificationException();
            }
        }

        @Override
        public int previousIndex() {
            return this._nextIndex - 1;
        }

        @Override
        public int nextIndex() {
            return this._nextIndex;
        }

        private void _resetMarkers() {
            this.wasRemoveCalled = false;
            this.wasAddCalled = false;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("Iteration does not have a previous element");
            }
            try {
                int i = this._nextIndex - 1;
                Object previous = NSMutableArray.this._objects[i];
                this._lastRet = this._nextIndex = i;
                this.calledOnce = true;
                this._resetMarkers();
                return previous;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException("Iteration does not have a previous element");
            }
        }

        @Override
        public boolean hasPrevious() {
            return this._nextIndex != 0;
        }

        @Override
        public E next() {
            try {
                Object next = NSMutableArray.this._objects[this._nextIndex];
                this._lastRet = this._nextIndex++;
                this.calledOnce = true;
                this._resetMarkers();
                return next;
            }
            catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                throw new NoSuchElementException("Iteration does not have a next element");
            }
        }

        @Override
        public boolean hasNext() {
            return this._nextIndex < NSMutableArray.this.count();
        }
    }
}

